//========================================================================
//
// BuiltinFontTables.cc
//
// Copyright 2001-2017 Glyph & Cog, LLC
//
//========================================================================

#include <aconf.h>
#include <stdlib.h>
#include "gmempp.h"
#include "FontEncodingTables.h"
#include "BuiltinFontTables.h"

static BuiltinFontWidth courierWidthsTab[] = {
  { "odieresis",                         600, NULL },
  { "M",                                 600, NULL },
  { "Ograve",                            600, NULL },
  { "T",                                 600, NULL },
  { "amacron",                           600, NULL },
  { "Ncommaaccent",                      600, NULL },
  { "numbersign",                        600, NULL },
  { "emacron",                           600, NULL },
  { "divide",                            600, NULL },
  { "fl",                                600, NULL },
  { "E",                                 600, NULL },
  { "quotedblbase",                      600, NULL },
  { "guillemotleft",                     600, NULL },
  { "endash",                            600, NULL },
  { "w",                                 600, NULL },
  { "twosuperior",                       600, NULL },
  { "eth",                               600, NULL },
  { "space",                             600, NULL },
  { "Thorn",                             600, NULL },
  { "ecaron",                            600, NULL },
  { "brokenbar",                         600, NULL },
  { "Aogonek",                           600, NULL },
  { "commaaccent",                       600, NULL },
  { "W",                                 600, NULL },
  { "bracketright",                      600, NULL },
  { "germandbls",                        600, NULL },
  { "Ugrave",                            600, NULL },
  { "thorn",                             600, NULL },
  { "zero",                              600, NULL },
  { "udieresis",                         600, NULL },
  { "period",                            600, NULL },
  { "scedilla",                          600, NULL },
  { "Ccedilla",                          600, NULL },
  { "Igrave",                            600, NULL },
  { "Ocircumflex",                       600, NULL },
  { "F",                                 600, NULL },
  { "Uring",                             600, NULL },
  { "perthousand",                       600, NULL },
  { "Edotaccent",                        600, NULL },
  { "acircumflex",                       600, NULL },
  { "G",                                 600, NULL },
  { "circumflex",                        600, NULL },
  { "Zcaron",                            600, NULL },
  { "ogonek",                            600, NULL },
  { "idieresis",                         600, NULL },
  { "cent",                              600, NULL },
  { "ae",                                600, NULL },
  { "less",                              600, NULL },
  { "ocircumflex",                       600, NULL },
  { "minus",                             600, NULL },
  { "four",                              600, NULL },
  { "dollar",                            600, NULL },
  { "Tcommaaccent",                      600, NULL },
  { "dotaccent",                         600, NULL },
  { "Nacute",                            600, NULL },
  { "v",                                 600, NULL },
  { "Kcommaaccent",                      600, NULL },
  { "imacron",                           600, NULL },
  { "rcommaaccent",                      600, NULL },
  { "tilde",                             600, NULL },
  { "underscore",                        600, NULL },
  { "racute",                            600, NULL },
  { "mu",                                600, NULL },
  { "D",                                 600, NULL },
  { "Ccaron",                            600, NULL },
  { "j",                                 600, NULL },
  { "hungarumlaut",                      600, NULL },
  { "Y",                                 600, NULL },
  { "yen",                               600, NULL },
  { "ccaron",                            600, NULL },
  { "lessequal",                         600, NULL },
  { "Ucircumflex",                       600, NULL },
  { "Omacron",                           600, NULL },
  { "quotesinglbase",                    600, NULL },
  { "Scedilla",                          600, NULL },
  { "grave",                             600, NULL },
  { "parenleft",                         600, NULL },
  { "nine",                              600, NULL },
  { "currency",                          600, NULL },
  { "radical",                           600, NULL },
  { "Ntilde",                            600, NULL },
  { "p",                                 600, NULL },
  { "dotlessi",                          600, NULL },
  { "cedilla",                           600, NULL },
  { "Idotaccent",                        600, NULL },
  { "plusminus",                         600, NULL },
  { "Eth",                               600, NULL },
  { "quotedblright",                     600, NULL },
  { "ccedilla",                          600, NULL },
  { "colon",                             600, NULL },
  { "g",                                 600, NULL },
  { "oe",                                600, NULL },
  { "Odieresis",                         600, NULL },
  { "five",                              600, NULL },
  { "asciicircum",                       600, NULL },
  { "X",                                 600, NULL },
  { "emdash",                            600, NULL },
  { "Egrave",                            600, NULL },
  { "aogonek",                           600, NULL },
  { "ring",                              600, NULL },
  { "Dcaron",                            600, NULL },
  { "ecircumflex",                       600, NULL },
  { "Z",                                 600, NULL },
  { "breve",                             600, NULL },
  { "Amacron",                           600, NULL },
  { "zcaron",                            600, NULL },
  { "paragraph",                         600, NULL },
  { "lcaron",                            600, NULL },
  { "Ydieresis",                         600, NULL },
  { "aring",                             600, NULL },
  { "iogonek",                           600, NULL },
  { "florin",                            600, NULL },
  { "Euro",                              600, NULL },
  { "Scaron",                            600, NULL },
  { "degree",                            600, NULL },
  { "section",                           600, NULL },
  { "K",                                 600, NULL },
  { "Aacute",                            600, NULL },
  { "Scommaaccent",                      600, NULL },
  { "b",                                 600, NULL },
  { "greater",                           600, NULL },
  { "asterisk",                          600, NULL },
  { "scommaaccent",                      600, NULL },
  { "Emacron",                           600, NULL },
  { "onesuperior",                       600, NULL },
  { "percent",                           600, NULL },
  { "o",                                 600, NULL },
  { "icircumflex",                       600, NULL },
  { "iacute",                            600, NULL },
  { "e",                                 600, NULL },
  { "Imacron",                           600, NULL },
  { "abreve",                            600, NULL },
  { "N",                                 600, NULL },
  { "equal",                             600, NULL },
  { "dagger",                            600, NULL },
  { "u",                                 600, NULL },
  { "C",                                 600, NULL },
  { "l",                                 600, NULL },
  { "q",                                 600, NULL },
  { "quoteleft",                         600, NULL },
  { "registered",                        600, NULL },
  { "Gcommaaccent",                      600, NULL },
  { "Racute",                            600, NULL },
  { "k",                                 600, NULL },
  { "copyright",                         600, NULL },
  { "onehalf",                           600, NULL },
  { "lcommaaccent",                      600, NULL },
  { "uhungarumlaut",                     600, NULL },
  { "gbreve",                            600, NULL },
  { "n",                                 600, NULL },
  { "Ecaron",                            600, NULL },
  { "zdotaccent",                        600, NULL },
  { "threesuperior",                     600, NULL },
  { "Uacute",                            600, NULL },
  { "Zacute",                            600, NULL },
  { "atilde",                            600, NULL },
  { "fraction",                          600, NULL },
  { "Adieresis",                         600, NULL },
  { "Sacute",                            600, NULL },
  { "asciitilde",                        600, NULL },
  { "lacute",                            600, NULL },
  { "Uogonek",                           600, NULL },
  { "caron",                             600, NULL },
  { "Lslash",                            600, NULL },
  { "sterling",                          600, NULL },
  { "H",                                 600, NULL },
  { "at",                                600, NULL },
  { "greaterequal",                      600, NULL },
  { "J",                                 600, NULL },
  { "threequarters",                     600, NULL },
  { "ohungarumlaut",                     600, NULL },
  { "Ecircumflex",                       600, NULL },
  { "L",                                 600, NULL },
  { "Agrave",                            600, NULL },
  { "exclam",                            600, NULL },
  { "AE",                                600, NULL },
  { "notequal",                          600, NULL },
  { "oslash",                            600, NULL },
  { "Acircumflex",                       600, NULL },
  { "ograve",                            600, NULL },
  { "Rcommaaccent",                      600, NULL },
  { "Lacute",                            600, NULL },
  { "Idieresis",                         600, NULL },
  { "sacute",                            600, NULL },
  { "f",                                 600, NULL },
  { "gcommaaccent",                      600, NULL },
  { "bracketleft",                       600, NULL },
  { "Ohungarumlaut",                     600, NULL },
  { "otilde",                            600, NULL },
  { "parenright",                        600, NULL },
  { "questiondown",                      600, NULL },
  { "Lcaron",                            600, NULL },
  { "ordmasculine",                      600, NULL },
  { "backslash",                         600, NULL },
  { "Eogonek",                           600, NULL },
  { "macron",                            600, NULL },
  { "three",                             600, NULL },
  { "slash",                             600, NULL },
  { "r",                                 600, NULL },
  { "ucircumflex",                       600, NULL },
  { "zacute",                            600, NULL },
  { "Umacron",                           600, NULL },
  { "adieresis",                         600, NULL },
  { "ncaron",                            600, NULL },
  { "V",                                 600, NULL },
  { "lozenge",                           600, NULL },
  { "exclamdown",                        600, NULL },
  { "Q",                                 600, NULL },
  { "uogonek",                           600, NULL },
  { "quoteright",                        600, NULL },
  { "guilsinglright",                    600, NULL },
  { "semicolon",                         600, NULL },
  { "egrave",                            600, NULL },
  { "s",                                 600, NULL },
  { "uring",                             600, NULL },
  { "z",                                 600, NULL },
  { "Uhungarumlaut",                     600, NULL },
  { "I",                                 600, NULL },
  { "one",                               600, NULL },
  { "eight",                             600, NULL },
  { "periodcentered",                    600, NULL },
  { "d",                                 600, NULL },
  { "c",                                 600, NULL },
  { "agrave",                            600, NULL },
  { "ellipsis",                          600, NULL },
  { "Aring",                             600, NULL },
  { "t",                                 600, NULL },
  { "quotedbl",                          600, NULL },
  { "Oacute",                            600, NULL },
  { "edotaccent",                        600, NULL },
  { "six",                               600, NULL },
  { "lslash",                            600, NULL },
  { "P",                                 600, NULL },
  { "i",                                 600, NULL },
  { "multiply",                          600, NULL },
  { "bar",                               600, NULL },
  { "quotesingle",                       600, NULL },
  { "acute",                             600, NULL },
  { "braceright",                        600, NULL },
  { "braceleft",                         600, NULL },
  { "onequarter",                        600, NULL },
  { "Atilde",                            600, NULL },
  { "Edieresis",                         600, NULL },
  { "oacute",                            600, NULL },
  { "Yacute",                            600, NULL },
  { "daggerdbl",                         600, NULL },
  { "ncommaaccent",                      600, NULL },
  { "logicalnot",                        600, NULL },
  { "tcommaaccent",                      600, NULL },
  { "Dcroat",                            600, NULL },
  { "cacute",                            600, NULL },
  { "tcaron",                            600, NULL },
  { "rcaron",                            600, NULL },
  { "Iogonek",                           600, NULL },
  { "y",                                 600, NULL },
  { "edieresis",                         600, NULL },
  { "x",                                 600, NULL },
  { "Ncaron",                            600, NULL },
  { "OE",                                600, NULL },
  { "m",                                 600, NULL },
  { "U",                                 600, NULL },
  { "partialdiff",                       600, NULL },
  { "dcroat",                            600, NULL },
  { "igrave",                            600, NULL },
  { "summation",                         600, NULL },
  { "question",                          600, NULL },
  { "A",                                 600, NULL },
  { "Cacute",                            600, NULL },
  { "h",                                 600, NULL },
  { "guilsinglleft",                     600, NULL },
  { "plus",                              600, NULL },
  { "Otilde",                            600, NULL },
  { "umacron",                           600, NULL },
  { "Tcaron",                            600, NULL },
  { "aacute",                            600, NULL },
  { "B",                                 600, NULL },
  { "R",                                 600, NULL },
  { "ydieresis",                         600, NULL },
  { "Rcaron",                            600, NULL },
  { "kcommaaccent",                      600, NULL },
  { "yacute",                            600, NULL },
  { "dcaron",                            600, NULL },
  { "ugrave",                            600, NULL },
  { "a",                                 600, NULL },
  { "hyphen",                            600, NULL },
  { "Oslash",                            600, NULL },
  { "comma",                             600, NULL },
  { "Delta",                             600, NULL },
  { "omacron",                           600, NULL },
  { "Gbreve",                            600, NULL },
  { "S",                                 600, NULL },
  { "quotedblleft",                      600, NULL },
  { "ordfeminine",                       600, NULL },
  { "ampersand",                         600, NULL },
  { "trademark",                         600, NULL },
  { "Lcommaaccent",                      600, NULL },
  { "ntilde",                            600, NULL },
  { "fi",                                600, NULL },
  { "dieresis",                          600, NULL },
  { "Eacute",                            600, NULL },
  { "nacute",                            600, NULL },
  { "O",                                 600, NULL },
  { "Icircumflex",                       600, NULL },
  { "Udieresis",                         600, NULL },
  { "Abreve",                            600, NULL },
  { "Iacute",                            600, NULL },
  { "uacute",                            600, NULL },
  { "two",                               600, NULL },
  { "seven",                             600, NULL },
  { "scaron",                            600, NULL },
  { "guillemotright",                    600, NULL },
  { "bullet",                            600, NULL },
  { "eogonek",                           600, NULL },
  { "eacute",                            600, NULL },
  { "Zdotaccent",                        600, NULL }
};

static BuiltinFontWidth courierBoldWidthsTab[] = {
  { "t",                                 600, NULL },
  { "quotedbl",                          600, NULL },
  { "Oacute",                            600, NULL },
  { "agrave",                            600, NULL },
  { "ellipsis",                          600, NULL },
  { "Aring",                             600, NULL },
  { "eight",                             600, NULL },
  { "I",                                 600, NULL },
  { "one",                               600, NULL },
  { "periodcentered",                    600, NULL },
  { "c",                                 600, NULL },
  { "d",                                 600, NULL },
  { "egrave",                            600, NULL },
  { "uring",                             600, NULL },
  { "s",                                 600, NULL },
  { "z",                                 600, NULL },
  { "Uhungarumlaut",                     600, NULL },
  { "uogonek",                           600, NULL },
  { "quoteright",                        600, NULL },
  { "semicolon",                         600, NULL },
  { "guilsinglright",                    600, NULL },
  { "Umacron",                           600, NULL },
  { "zacute",                            600, NULL },
  { "ncaron",                            600, NULL },
  { "adieresis",                         600, NULL },
  { "lozenge",                           600, NULL },
  { "V",                                 600, NULL },
  { "Q",                                 600, NULL },
  { "exclamdown",                        600, NULL },
  { "three",                             600, NULL },
  { "slash",                             600, NULL },
  { "r",                                 600, NULL },
  { "ucircumflex",                       600, NULL },
  { "macron",                            600, NULL },
  { "Eogonek",                           600, NULL },
  { "Lcaron",                            600, NULL },
  { "ordmasculine",                      600, NULL },
  { "questiondown",                      600, NULL },
  { "backslash",                         600, NULL },
  { "gcommaaccent",                      600, NULL },
  { "Ohungarumlaut",                     600, NULL },
  { "bracketleft",                       600, NULL },
  { "otilde",                            600, NULL },
  { "parenright",                        600, NULL },
  { "f",                                 600, NULL },
  { "Lacute",                            600, NULL },
  { "Idieresis",                         600, NULL },
  { "sacute",                            600, NULL },
  { "Rcommaaccent",                      600, NULL },
  { "ograve",                            600, NULL },
  { "threequarters",                     600, NULL },
  { "J",                                 600, NULL },
  { "ohungarumlaut",                     600, NULL },
  { "Ecircumflex",                       600, NULL },
  { "L",                                 600, NULL },
  { "notequal",                          600, NULL },
  { "exclam",                            600, NULL },
  { "Agrave",                            600, NULL },
  { "AE",                                600, NULL },
  { "Acircumflex",                       600, NULL },
  { "oslash",                            600, NULL },
  { "Uogonek",                           600, NULL },
  { "caron",                             600, NULL },
  { "Lslash",                            600, NULL },
  { "lacute",                            600, NULL },
  { "sterling",                          600, NULL },
  { "H",                                 600, NULL },
  { "at",                                600, NULL },
  { "greaterequal",                      600, NULL },
  { "asciitilde",                        600, NULL },
  { "Uacute",                            600, NULL },
  { "atilde",                            600, NULL },
  { "Zacute",                            600, NULL },
  { "fraction",                          600, NULL },
  { "Adieresis",                         600, NULL },
  { "Sacute",                            600, NULL },
  { "scaron",                            600, NULL },
  { "guillemotright",                    600, NULL },
  { "bullet",                            600, NULL },
  { "eogonek",                           600, NULL },
  { "eacute",                            600, NULL },
  { "Zdotaccent",                        600, NULL },
  { "Abreve",                            600, NULL },
  { "Udieresis",                         600, NULL },
  { "Iacute",                            600, NULL },
  { "two",                               600, NULL },
  { "uacute",                            600, NULL },
  { "seven",                             600, NULL },
  { "dieresis",                          600, NULL },
  { "Eacute",                            600, NULL },
  { "O",                                 600, NULL },
  { "Icircumflex",                       600, NULL },
  { "nacute",                            600, NULL },
  { "trademark",                         600, NULL },
  { "ampersand",                         600, NULL },
  { "Lcommaaccent",                      600, NULL },
  { "ntilde",                            600, NULL },
  { "fi",                                600, NULL },
  { "quotedblleft",                      600, NULL },
  { "ordfeminine",                       600, NULL },
  { "omacron",                           600, NULL },
  { "comma",                             600, NULL },
  { "Delta",                             600, NULL },
  { "Gbreve",                            600, NULL },
  { "S",                                 600, NULL },
  { "B",                                 600, NULL },
  { "kcommaaccent",                      600, NULL },
  { "Rcaron",                            600, NULL },
  { "yacute",                            600, NULL },
  { "ydieresis",                         600, NULL },
  { "R",                                 600, NULL },
  { "ugrave",                            600, NULL },
  { "dcaron",                            600, NULL },
  { "Oslash",                            600, NULL },
  { "hyphen",                            600, NULL },
  { "a",                                 600, NULL },
  { "Otilde",                            600, NULL },
  { "umacron",                           600, NULL },
  { "Tcaron",                            600, NULL },
  { "aacute",                            600, NULL },
  { "guilsinglleft",                     600, NULL },
  { "Cacute",                            600, NULL },
  { "h",                                 600, NULL },
  { "plus",                              600, NULL },
  { "igrave",                            600, NULL },
  { "dcroat",                            600, NULL },
  { "question",                          600, NULL },
  { "summation",                         600, NULL },
  { "A",                                 600, NULL },
  { "x",                                 600, NULL },
  { "edieresis",                         600, NULL },
  { "Iogonek",                           600, NULL },
  { "y",                                 600, NULL },
  { "Ncaron",                            600, NULL },
  { "m",                                 600, NULL },
  { "OE",                                600, NULL },
  { "partialdiff",                       600, NULL },
  { "U",                                 600, NULL },
  { "ncommaaccent",                      600, NULL },
  { "tcommaaccent",                      600, NULL },
  { "logicalnot",                        600, NULL },
  { "cacute",                            600, NULL },
  { "Dcroat",                            600, NULL },
  { "tcaron",                            600, NULL },
  { "rcaron",                            600, NULL },
  { "Atilde",                            600, NULL },
  { "Edieresis",                         600, NULL },
  { "Yacute",                            600, NULL },
  { "oacute",                            600, NULL },
  { "daggerdbl",                         600, NULL },
  { "braceleft",                         600, NULL },
  { "braceright",                        600, NULL },
  { "acute",                             600, NULL },
  { "onequarter",                        600, NULL },
  { "i",                                 600, NULL },
  { "multiply",                          600, NULL },
  { "quotesingle",                       600, NULL },
  { "bar",                               600, NULL },
  { "six",                               600, NULL },
  { "edotaccent",                        600, NULL },
  { "lslash",                            600, NULL },
  { "P",                                 600, NULL },
  { "parenleft",                         600, NULL },
  { "currency",                          600, NULL },
  { "nine",                              600, NULL },
  { "quotesinglbase",                    600, NULL },
  { "grave",                             600, NULL },
  { "Scedilla",                          600, NULL },
  { "ccaron",                            600, NULL },
  { "Ucircumflex",                       600, NULL },
  { "lessequal",                         600, NULL },
  { "Omacron",                           600, NULL },
  { "hungarumlaut",                      600, NULL },
  { "Ccaron",                            600, NULL },
  { "j",                                 600, NULL },
  { "Y",                                 600, NULL },
  { "yen",                               600, NULL },
  { "rcommaaccent",                      600, NULL },
  { "Kcommaaccent",                      600, NULL },
  { "imacron",                           600, NULL },
  { "tilde",                             600, NULL },
  { "underscore",                        600, NULL },
  { "mu",                                600, NULL },
  { "D",                                 600, NULL },
  { "racute",                            600, NULL },
  { "Tcommaaccent",                      600, NULL },
  { "dollar",                            600, NULL },
  { "Nacute",                            600, NULL },
  { "v",                                 600, NULL },
  { "dotaccent",                         600, NULL },
  { "cent",                              600, NULL },
  { "ae",                                600, NULL },
  { "ocircumflex",                       600, NULL },
  { "less",                              600, NULL },
  { "minus",                             600, NULL },
  { "four",                              600, NULL },
  { "circumflex",                        600, NULL },
  { "Zcaron",                            600, NULL },
  { "ogonek",                            600, NULL },
  { "idieresis",                         600, NULL },
  { "G",                                 600, NULL },
  { "F",                                 600, NULL },
  { "Ocircumflex",                       600, NULL },
  { "Uring",                             600, NULL },
  { "perthousand",                       600, NULL },
  { "Edotaccent",                        600, NULL },
  { "acircumflex",                       600, NULL },
  { "zero",                              600, NULL },
  { "period",                            600, NULL },
  { "scedilla",                          600, NULL },
  { "udieresis",                         600, NULL },
  { "Ccedilla",                          600, NULL },
  { "Igrave",                            600, NULL },
  { "commaaccent",                       600, NULL },
  { "W",                                 600, NULL },
  { "bracketright",                      600, NULL },
  { "Ugrave",                            600, NULL },
  { "germandbls",                        600, NULL },
  { "thorn",                             600, NULL },
  { "w",                                 600, NULL },
  { "Thorn",                             600, NULL },
  { "space",                             600, NULL },
  { "eth",                               600, NULL },
  { "twosuperior",                       600, NULL },
  { "ecaron",                            600, NULL },
  { "Aogonek",                           600, NULL },
  { "brokenbar",                         600, NULL },
  { "fl",                                600, NULL },
  { "E",                                 600, NULL },
  { "quotedblbase",                      600, NULL },
  { "guillemotleft",                     600, NULL },
  { "endash",                            600, NULL },
  { "amacron",                           600, NULL },
  { "Ncommaaccent",                      600, NULL },
  { "numbersign",                        600, NULL },
  { "divide",                            600, NULL },
  { "emacron",                           600, NULL },
  { "M",                                 600, NULL },
  { "odieresis",                         600, NULL },
  { "Ograve",                            600, NULL },
  { "T",                                 600, NULL },
  { "n",                                 600, NULL },
  { "Ecaron",                            600, NULL },
  { "threesuperior",                     600, NULL },
  { "zdotaccent",                        600, NULL },
  { "lcommaaccent",                      600, NULL },
  { "onehalf",                           600, NULL },
  { "gbreve",                            600, NULL },
  { "uhungarumlaut",                     600, NULL },
  { "Racute",                            600, NULL },
  { "k",                                 600, NULL },
  { "copyright",                         600, NULL },
  { "quoteleft",                         600, NULL },
  { "registered",                        600, NULL },
  { "Gcommaaccent",                      600, NULL },
  { "equal",                             600, NULL },
  { "dagger",                            600, NULL },
  { "N",                                 600, NULL },
  { "C",                                 600, NULL },
  { "u",                                 600, NULL },
  { "q",                                 600, NULL },
  { "l",                                 600, NULL },
  { "icircumflex",                       600, NULL },
  { "Imacron",                           600, NULL },
  { "abreve",                            600, NULL },
  { "e",                                 600, NULL },
  { "iacute",                            600, NULL },
  { "percent",                           600, NULL },
  { "o",                                 600, NULL },
  { "greater",                           600, NULL },
  { "Emacron",                           600, NULL },
  { "asterisk",                          600, NULL },
  { "scommaaccent",                      600, NULL },
  { "onesuperior",                       600, NULL },
  { "K",                                 600, NULL },
  { "Scommaaccent",                      600, NULL },
  { "Aacute",                            600, NULL },
  { "b",                                 600, NULL },
  { "Euro",                              600, NULL },
  { "florin",                            600, NULL },
  { "iogonek",                           600, NULL },
  { "section",                           600, NULL },
  { "Scaron",                            600, NULL },
  { "degree",                            600, NULL },
  { "lcaron",                            600, NULL },
  { "paragraph",                         600, NULL },
  { "zcaron",                            600, NULL },
  { "aring",                             600, NULL },
  { "Ydieresis",                         600, NULL },
  { "Dcaron",                            600, NULL },
  { "Z",                                 600, NULL },
  { "ecircumflex",                       600, NULL },
  { "Amacron",                           600, NULL },
  { "breve",                             600, NULL },
  { "emdash",                            600, NULL },
  { "Egrave",                            600, NULL },
  { "aogonek",                           600, NULL },
  { "ring",                              600, NULL },
  { "Odieresis",                         600, NULL },
  { "oe",                                600, NULL },
  { "five",                              600, NULL },
  { "X",                                 600, NULL },
  { "asciicircum",                       600, NULL },
  { "plusminus",                         600, NULL },
  { "Idotaccent",                        600, NULL },
  { "cedilla",                           600, NULL },
  { "quotedblright",                     600, NULL },
  { "Eth",                               600, NULL },
  { "colon",                             600, NULL },
  { "g",                                 600, NULL },
  { "ccedilla",                          600, NULL },
  { "radical",                           600, NULL },
  { "Ntilde",                            600, NULL },
  { "dotlessi",                          600, NULL },
  { "p",                                 600, NULL }
};

static BuiltinFontWidth courierBoldObliqueWidthsTab[] = {
  { "greater",                           600, NULL },
  { "asterisk",                          600, NULL },
  { "Emacron",                           600, NULL },
  { "scommaaccent",                      600, NULL },
  { "onesuperior",                       600, NULL },
  { "percent",                           600, NULL },
  { "o",                                 600, NULL },
  { "icircumflex",                       600, NULL },
  { "iacute",                            600, NULL },
  { "e",                                 600, NULL },
  { "Imacron",                           600, NULL },
  { "abreve",                            600, NULL },
  { "N",                                 600, NULL },
  { "equal",                             600, NULL },
  { "dagger",                            600, NULL },
  { "u",                                 600, NULL },
  { "C",                                 600, NULL },
  { "l",                                 600, NULL },
  { "q",                                 600, NULL },
  { "quoteleft",                         600, NULL },
  { "registered",                        600, NULL },
  { "Gcommaaccent",                      600, NULL },
  { "Racute",                            600, NULL },
  { "k",                                 600, NULL },
  { "copyright",                         600, NULL },
  { "onehalf",                           600, NULL },
  { "lcommaaccent",                      600, NULL },
  { "uhungarumlaut",                     600, NULL },
  { "gbreve",                            600, NULL },
  { "n",                                 600, NULL },
  { "Ecaron",                            600, NULL },
  { "zdotaccent",                        600, NULL },
  { "threesuperior",                     600, NULL },
  { "radical",                           600, NULL },
  { "Ntilde",                            600, NULL },
  { "p",                                 600, NULL },
  { "dotlessi",                          600, NULL },
  { "cedilla",                           600, NULL },
  { "Idotaccent",                        600, NULL },
  { "plusminus",                         600, NULL },
  { "Eth",                               600, NULL },
  { "quotedblright",                     600, NULL },
  { "ccedilla",                          600, NULL },
  { "g",                                 600, NULL },
  { "colon",                             600, NULL },
  { "oe",                                600, NULL },
  { "Odieresis",                         600, NULL },
  { "five",                              600, NULL },
  { "asciicircum",                       600, NULL },
  { "X",                                 600, NULL },
  { "emdash",                            600, NULL },
  { "aogonek",                           600, NULL },
  { "Egrave",                            600, NULL },
  { "ring",                              600, NULL },
  { "Dcaron",                            600, NULL },
  { "ecircumflex",                       600, NULL },
  { "Z",                                 600, NULL },
  { "breve",                             600, NULL },
  { "Amacron",                           600, NULL },
  { "paragraph",                         600, NULL },
  { "zcaron",                            600, NULL },
  { "lcaron",                            600, NULL },
  { "Ydieresis",                         600, NULL },
  { "aring",                             600, NULL },
  { "iogonek",                           600, NULL },
  { "florin",                            600, NULL },
  { "Euro",                              600, NULL },
  { "Scaron",                            600, NULL },
  { "degree",                            600, NULL },
  { "section",                           600, NULL },
  { "K",                                 600, NULL },
  { "Aacute",                            600, NULL },
  { "Scommaaccent",                      600, NULL },
  { "b",                                 600, NULL },
  { "circumflex",                        600, NULL },
  { "Zcaron",                            600, NULL },
  { "ogonek",                            600, NULL },
  { "idieresis",                         600, NULL },
  { "ae",                                600, NULL },
  { "cent",                              600, NULL },
  { "less",                              600, NULL },
  { "ocircumflex",                       600, NULL },
  { "minus",                             600, NULL },
  { "four",                              600, NULL },
  { "Tcommaaccent",                      600, NULL },
  { "dollar",                            600, NULL },
  { "dotaccent",                         600, NULL },
  { "v",                                 600, NULL },
  { "Nacute",                            600, NULL },
  { "Kcommaaccent",                      600, NULL },
  { "imacron",                           600, NULL },
  { "rcommaaccent",                      600, NULL },
  { "tilde",                             600, NULL },
  { "underscore",                        600, NULL },
  { "racute",                            600, NULL },
  { "mu",                                600, NULL },
  { "D",                                 600, NULL },
  { "Ccaron",                            600, NULL },
  { "j",                                 600, NULL },
  { "hungarumlaut",                      600, NULL },
  { "Y",                                 600, NULL },
  { "yen",                               600, NULL },
  { "ccaron",                            600, NULL },
  { "Ucircumflex",                       600, NULL },
  { "lessequal",                         600, NULL },
  { "Omacron",                           600, NULL },
  { "quotesinglbase",                    600, NULL },
  { "Scedilla",                          600, NULL },
  { "grave",                             600, NULL },
  { "parenleft",                         600, NULL },
  { "nine",                              600, NULL },
  { "currency",                          600, NULL },
  { "odieresis",                         600, NULL },
  { "M",                                 600, NULL },
  { "Ograve",                            600, NULL },
  { "T",                                 600, NULL },
  { "amacron",                           600, NULL },
  { "Ncommaaccent",                      600, NULL },
  { "numbersign",                        600, NULL },
  { "emacron",                           600, NULL },
  { "divide",                            600, NULL },
  { "fl",                                600, NULL },
  { "quotedblbase",                      600, NULL },
  { "E",                                 600, NULL },
  { "guillemotleft",                     600, NULL },
  { "endash",                            600, NULL },
  { "w",                                 600, NULL },
  { "eth",                               600, NULL },
  { "twosuperior",                       600, NULL },
  { "space",                             600, NULL },
  { "Thorn",                             600, NULL },
  { "ecaron",                            600, NULL },
  { "brokenbar",                         600, NULL },
  { "Aogonek",                           600, NULL },
  { "commaaccent",                       600, NULL },
  { "bracketright",                      600, NULL },
  { "W",                                 600, NULL },
  { "germandbls",                        600, NULL },
  { "Ugrave",                            600, NULL },
  { "thorn",                             600, NULL },
  { "zero",                              600, NULL },
  { "udieresis",                         600, NULL },
  { "scedilla",                          600, NULL },
  { "period",                            600, NULL },
  { "Ccedilla",                          600, NULL },
  { "Igrave",                            600, NULL },
  { "F",                                 600, NULL },
  { "Ocircumflex",                       600, NULL },
  { "Uring",                             600, NULL },
  { "perthousand",                       600, NULL },
  { "Edotaccent",                        600, NULL },
  { "acircumflex",                       600, NULL },
  { "G",                                 600, NULL },
  { "Otilde",                            600, NULL },
  { "umacron",                           600, NULL },
  { "Tcaron",                            600, NULL },
  { "aacute",                            600, NULL },
  { "B",                                 600, NULL },
  { "ydieresis",                         600, NULL },
  { "R",                                 600, NULL },
  { "kcommaaccent",                      600, NULL },
  { "yacute",                            600, NULL },
  { "Rcaron",                            600, NULL },
  { "dcaron",                            600, NULL },
  { "ugrave",                            600, NULL },
  { "a",                                 600, NULL },
  { "hyphen",                            600, NULL },
  { "Oslash",                            600, NULL },
  { "comma",                             600, NULL },
  { "Delta",                             600, NULL },
  { "omacron",                           600, NULL },
  { "Gbreve",                            600, NULL },
  { "S",                                 600, NULL },
  { "quotedblleft",                      600, NULL },
  { "ordfeminine",                       600, NULL },
  { "ampersand",                         600, NULL },
  { "trademark",                         600, NULL },
  { "Lcommaaccent",                      600, NULL },
  { "ntilde",                            600, NULL },
  { "fi",                                600, NULL },
  { "dieresis",                          600, NULL },
  { "Eacute",                            600, NULL },
  { "nacute",                            600, NULL },
  { "O",                                 600, NULL },
  { "Icircumflex",                       600, NULL },
  { "Udieresis",                         600, NULL },
  { "Abreve",                            600, NULL },
  { "Iacute",                            600, NULL },
  { "uacute",                            600, NULL },
  { "two",                               600, NULL },
  { "seven",                             600, NULL },
  { "scaron",                            600, NULL },
  { "guillemotright",                    600, NULL },
  { "eogonek",                           600, NULL },
  { "eacute",                            600, NULL },
  { "bullet",                            600, NULL },
  { "Zdotaccent",                        600, NULL },
  { "edotaccent",                        600, NULL },
  { "six",                               600, NULL },
  { "lslash",                            600, NULL },
  { "P",                                 600, NULL },
  { "multiply",                          600, NULL },
  { "i",                                 600, NULL },
  { "bar",                               600, NULL },
  { "quotesingle",                       600, NULL },
  { "acute",                             600, NULL },
  { "braceright",                        600, NULL },
  { "braceleft",                         600, NULL },
  { "onequarter",                        600, NULL },
  { "Atilde",                            600, NULL },
  { "Edieresis",                         600, NULL },
  { "Yacute",                            600, NULL },
  { "oacute",                            600, NULL },
  { "daggerdbl",                         600, NULL },
  { "ncommaaccent",                      600, NULL },
  { "logicalnot",                        600, NULL },
  { "tcommaaccent",                      600, NULL },
  { "Dcroat",                            600, NULL },
  { "cacute",                            600, NULL },
  { "rcaron",                            600, NULL },
  { "tcaron",                            600, NULL },
  { "y",                                 600, NULL },
  { "Iogonek",                           600, NULL },
  { "edieresis",                         600, NULL },
  { "x",                                 600, NULL },
  { "Ncaron",                            600, NULL },
  { "OE",                                600, NULL },
  { "m",                                 600, NULL },
  { "U",                                 600, NULL },
  { "partialdiff",                       600, NULL },
  { "dcroat",                            600, NULL },
  { "igrave",                            600, NULL },
  { "summation",                         600, NULL },
  { "question",                          600, NULL },
  { "A",                                 600, NULL },
  { "h",                                 600, NULL },
  { "Cacute",                            600, NULL },
  { "guilsinglleft",                     600, NULL },
  { "plus",                              600, NULL },
  { "ordmasculine",                      600, NULL },
  { "Lcaron",                            600, NULL },
  { "backslash",                         600, NULL },
  { "questiondown",                      600, NULL },
  { "macron",                            600, NULL },
  { "Eogonek",                           600, NULL },
  { "three",                             600, NULL },
  { "slash",                             600, NULL },
  { "ucircumflex",                       600, NULL },
  { "r",                                 600, NULL },
  { "zacute",                            600, NULL },
  { "Umacron",                           600, NULL },
  { "adieresis",                         600, NULL },
  { "ncaron",                            600, NULL },
  { "V",                                 600, NULL },
  { "lozenge",                           600, NULL },
  { "exclamdown",                        600, NULL },
  { "Q",                                 600, NULL },
  { "quoteright",                        600, NULL },
  { "uogonek",                           600, NULL },
  { "guilsinglright",                    600, NULL },
  { "semicolon",                         600, NULL },
  { "egrave",                            600, NULL },
  { "s",                                 600, NULL },
  { "uring",                             600, NULL },
  { "Uhungarumlaut",                     600, NULL },
  { "z",                                 600, NULL },
  { "I",                                 600, NULL },
  { "one",                               600, NULL },
  { "eight",                             600, NULL },
  { "periodcentered",                    600, NULL },
  { "d",                                 600, NULL },
  { "c",                                 600, NULL },
  { "agrave",                            600, NULL },
  { "ellipsis",                          600, NULL },
  { "Aring",                             600, NULL },
  { "t",                                 600, NULL },
  { "quotedbl",                          600, NULL },
  { "Oacute",                            600, NULL },
  { "Uacute",                            600, NULL },
  { "Zacute",                            600, NULL },
  { "atilde",                            600, NULL },
  { "fraction",                          600, NULL },
  { "Adieresis",                         600, NULL },
  { "Sacute",                            600, NULL },
  { "asciitilde",                        600, NULL },
  { "lacute",                            600, NULL },
  { "Uogonek",                           600, NULL },
  { "Lslash",                            600, NULL },
  { "caron",                             600, NULL },
  { "sterling",                          600, NULL },
  { "H",                                 600, NULL },
  { "greaterequal",                      600, NULL },
  { "at",                                600, NULL },
  { "J",                                 600, NULL },
  { "threequarters",                     600, NULL },
  { "ohungarumlaut",                     600, NULL },
  { "Ecircumflex",                       600, NULL },
  { "L",                                 600, NULL },
  { "AE",                                600, NULL },
  { "Agrave",                            600, NULL },
  { "exclam",                            600, NULL },
  { "notequal",                          600, NULL },
  { "oslash",                            600, NULL },
  { "Acircumflex",                       600, NULL },
  { "Rcommaaccent",                      600, NULL },
  { "ograve",                            600, NULL },
  { "Lacute",                            600, NULL },
  { "Idieresis",                         600, NULL },
  { "sacute",                            600, NULL },
  { "f",                                 600, NULL },
  { "gcommaaccent",                      600, NULL },
  { "bracketleft",                       600, NULL },
  { "Ohungarumlaut",                     600, NULL },
  { "otilde",                            600, NULL },
  { "parenright",                        600, NULL }
};

static BuiltinFontWidth courierObliqueWidthsTab[] = {
  { "ecaron",                            600, NULL },
  { "brokenbar",                         600, NULL },
  { "Aogonek",                           600, NULL },
  { "w",                                 600, NULL },
  { "Thorn",                             600, NULL },
  { "space",                             600, NULL },
  { "eth",                               600, NULL },
  { "twosuperior",                       600, NULL },
  { "guillemotleft",                     600, NULL },
  { "endash",                            600, NULL },
  { "fl",                                600, NULL },
  { "E",                                 600, NULL },
  { "quotedblbase",                      600, NULL },
  { "numbersign",                        600, NULL },
  { "divide",                            600, NULL },
  { "emacron",                           600, NULL },
  { "amacron",                           600, NULL },
  { "Ncommaaccent",                      600, NULL },
  { "T",                                 600, NULL },
  { "M",                                 600, NULL },
  { "odieresis",                         600, NULL },
  { "Ograve",                            600, NULL },
  { "G",                                 600, NULL },
  { "perthousand",                       600, NULL },
  { "Edotaccent",                        600, NULL },
  { "acircumflex",                       600, NULL },
  { "Ocircumflex",                       600, NULL },
  { "F",                                 600, NULL },
  { "Uring",                             600, NULL },
  { "Ccedilla",                          600, NULL },
  { "Igrave",                            600, NULL },
  { "zero",                              600, NULL },
  { "scedilla",                          600, NULL },
  { "period",                            600, NULL },
  { "udieresis",                         600, NULL },
  { "Ugrave",                            600, NULL },
  { "germandbls",                        600, NULL },
  { "thorn",                             600, NULL },
  { "commaaccent",                       600, NULL },
  { "W",                                 600, NULL },
  { "bracketright",                      600, NULL },
  { "underscore",                        600, NULL },
  { "D",                                 600, NULL },
  { "mu",                                600, NULL },
  { "racute",                            600, NULL },
  { "rcommaaccent",                      600, NULL },
  { "imacron",                           600, NULL },
  { "Kcommaaccent",                      600, NULL },
  { "tilde",                             600, NULL },
  { "Tcommaaccent",                      600, NULL },
  { "dollar",                            600, NULL },
  { "v",                                 600, NULL },
  { "Nacute",                            600, NULL },
  { "dotaccent",                         600, NULL },
  { "ocircumflex",                       600, NULL },
  { "less",                              600, NULL },
  { "minus",                             600, NULL },
  { "four",                              600, NULL },
  { "ae",                                600, NULL },
  { "cent",                              600, NULL },
  { "ogonek",                            600, NULL },
  { "idieresis",                         600, NULL },
  { "circumflex",                        600, NULL },
  { "Zcaron",                            600, NULL },
  { "currency",                          600, NULL },
  { "nine",                              600, NULL },
  { "parenleft",                         600, NULL },
  { "grave",                             600, NULL },
  { "Scedilla",                          600, NULL },
  { "quotesinglbase",                    600, NULL },
  { "lessequal",                         600, NULL },
  { "Omacron",                           600, NULL },
  { "Ucircumflex",                       600, NULL },
  { "ccaron",                            600, NULL },
  { "yen",                               600, NULL },
  { "Y",                                 600, NULL },
  { "hungarumlaut",                      600, NULL },
  { "Ccaron",                            600, NULL },
  { "j",                                 600, NULL },
  { "aogonek",                           600, NULL },
  { "Egrave",                            600, NULL },
  { "ring",                              600, NULL },
  { "emdash",                            600, NULL },
  { "five",                              600, NULL },
  { "X",                                 600, NULL },
  { "asciicircum",                       600, NULL },
  { "Odieresis",                         600, NULL },
  { "oe",                                600, NULL },
  { "colon",                             600, NULL },
  { "g",                                 600, NULL },
  { "ccedilla",                          600, NULL },
  { "plusminus",                         600, NULL },
  { "cedilla",                           600, NULL },
  { "Idotaccent",                        600, NULL },
  { "quotedblright",                     600, NULL },
  { "Eth",                               600, NULL },
  { "dotlessi",                          600, NULL },
  { "p",                                 600, NULL },
  { "radical",                           600, NULL },
  { "Ntilde",                            600, NULL },
  { "Scommaaccent",                      600, NULL },
  { "Aacute",                            600, NULL },
  { "b",                                 600, NULL },
  { "K",                                 600, NULL },
  { "section",                           600, NULL },
  { "degree",                            600, NULL },
  { "Scaron",                            600, NULL },
  { "Euro",                              600, NULL },
  { "florin",                            600, NULL },
  { "iogonek",                           600, NULL },
  { "lcaron",                            600, NULL },
  { "paragraph",                         600, NULL },
  { "zcaron",                            600, NULL },
  { "aring",                             600, NULL },
  { "Ydieresis",                         600, NULL },
  { "Amacron",                           600, NULL },
  { "breve",                             600, NULL },
  { "Dcaron",                            600, NULL },
  { "Z",                                 600, NULL },
  { "ecircumflex",                       600, NULL },
  { "q",                                 600, NULL },
  { "l",                                 600, NULL },
  { "dagger",                            600, NULL },
  { "equal",                             600, NULL },
  { "N",                                 600, NULL },
  { "C",                                 600, NULL },
  { "u",                                 600, NULL },
  { "abreve",                            600, NULL },
  { "Imacron",                           600, NULL },
  { "iacute",                            600, NULL },
  { "e",                                 600, NULL },
  { "icircumflex",                       600, NULL },
  { "percent",                           600, NULL },
  { "o",                                 600, NULL },
  { "asterisk",                          600, NULL },
  { "Emacron",                           600, NULL },
  { "scommaaccent",                      600, NULL },
  { "onesuperior",                       600, NULL },
  { "greater",                           600, NULL },
  { "Ecaron",                            600, NULL },
  { "threesuperior",                     600, NULL },
  { "zdotaccent",                        600, NULL },
  { "n",                                 600, NULL },
  { "lcommaaccent",                      600, NULL },
  { "onehalf",                           600, NULL },
  { "gbreve",                            600, NULL },
  { "uhungarumlaut",                     600, NULL },
  { "k",                                 600, NULL },
  { "copyright",                         600, NULL },
  { "Racute",                            600, NULL },
  { "Gcommaaccent",                      600, NULL },
  { "quoteleft",                         600, NULL },
  { "registered",                        600, NULL },
  { "notequal",                          600, NULL },
  { "Agrave",                            600, NULL },
  { "AE",                                600, NULL },
  { "exclam",                            600, NULL },
  { "Acircumflex",                       600, NULL },
  { "oslash",                            600, NULL },
  { "threequarters",                     600, NULL },
  { "J",                                 600, NULL },
  { "Ecircumflex",                       600, NULL },
  { "ohungarumlaut",                     600, NULL },
  { "L",                                 600, NULL },
  { "H",                                 600, NULL },
  { "sterling",                          600, NULL },
  { "greaterequal",                      600, NULL },
  { "at",                                600, NULL },
  { "caron",                             600, NULL },
  { "Uogonek",                           600, NULL },
  { "Lslash",                            600, NULL },
  { "lacute",                            600, NULL },
  { "asciitilde",                        600, NULL },
  { "fraction",                          600, NULL },
  { "Sacute",                            600, NULL },
  { "Adieresis",                         600, NULL },
  { "Uacute",                            600, NULL },
  { "atilde",                            600, NULL },
  { "Zacute",                            600, NULL },
  { "otilde",                            600, NULL },
  { "parenright",                        600, NULL },
  { "gcommaaccent",                      600, NULL },
  { "Ohungarumlaut",                     600, NULL },
  { "bracketleft",                       600, NULL },
  { "f",                                 600, NULL },
  { "Lacute",                            600, NULL },
  { "Idieresis",                         600, NULL },
  { "sacute",                            600, NULL },
  { "Rcommaaccent",                      600, NULL },
  { "ograve",                            600, NULL },
  { "quoteright",                        600, NULL },
  { "uogonek",                           600, NULL },
  { "semicolon",                         600, NULL },
  { "guilsinglright",                    600, NULL },
  { "lozenge",                           600, NULL },
  { "V",                                 600, NULL },
  { "Q",                                 600, NULL },
  { "exclamdown",                        600, NULL },
  { "Umacron",                           600, NULL },
  { "zacute",                            600, NULL },
  { "ncaron",                            600, NULL },
  { "adieresis",                         600, NULL },
  { "slash",                             600, NULL },
  { "ucircumflex",                       600, NULL },
  { "r",                                 600, NULL },
  { "three",                             600, NULL },
  { "Eogonek",                           600, NULL },
  { "macron",                            600, NULL },
  { "Lcaron",                            600, NULL },
  { "ordmasculine",                      600, NULL },
  { "backslash",                         600, NULL },
  { "questiondown",                      600, NULL },
  { "Oacute",                            600, NULL },
  { "t",                                 600, NULL },
  { "quotedbl",                          600, NULL },
  { "ellipsis",                          600, NULL },
  { "Aring",                             600, NULL },
  { "agrave",                            600, NULL },
  { "c",                                 600, NULL },
  { "d",                                 600, NULL },
  { "one",                               600, NULL },
  { "I",                                 600, NULL },
  { "eight",                             600, NULL },
  { "periodcentered",                    600, NULL },
  { "z",                                 600, NULL },
  { "Uhungarumlaut",                     600, NULL },
  { "egrave",                            600, NULL },
  { "uring",                             600, NULL },
  { "s",                                 600, NULL },
  { "oacute",                            600, NULL },
  { "Yacute",                            600, NULL },
  { "daggerdbl",                         600, NULL },
  { "Atilde",                            600, NULL },
  { "Edieresis",                         600, NULL },
  { "onequarter",                        600, NULL },
  { "braceleft",                         600, NULL },
  { "braceright",                        600, NULL },
  { "acute",                             600, NULL },
  { "quotesingle",                       600, NULL },
  { "bar",                               600, NULL },
  { "i",                                 600, NULL },
  { "multiply",                          600, NULL },
  { "lslash",                            600, NULL },
  { "P",                                 600, NULL },
  { "six",                               600, NULL },
  { "edotaccent",                        600, NULL },
  { "guilsinglleft",                     600, NULL },
  { "h",                                 600, NULL },
  { "Cacute",                            600, NULL },
  { "plus",                              600, NULL },
  { "question",                          600, NULL },
  { "summation",                         600, NULL },
  { "A",                                 600, NULL },
  { "igrave",                            600, NULL },
  { "dcroat",                            600, NULL },
  { "m",                                 600, NULL },
  { "OE",                                600, NULL },
  { "partialdiff",                       600, NULL },
  { "U",                                 600, NULL },
  { "x",                                 600, NULL },
  { "y",                                 600, NULL },
  { "Iogonek",                           600, NULL },
  { "edieresis",                         600, NULL },
  { "Ncaron",                            600, NULL },
  { "cacute",                            600, NULL },
  { "Dcroat",                            600, NULL },
  { "rcaron",                            600, NULL },
  { "tcaron",                            600, NULL },
  { "ncommaaccent",                      600, NULL },
  { "tcommaaccent",                      600, NULL },
  { "logicalnot",                        600, NULL },
  { "ordfeminine",                       600, NULL },
  { "quotedblleft",                      600, NULL },
  { "S",                                 600, NULL },
  { "omacron",                           600, NULL },
  { "Delta",                             600, NULL },
  { "comma",                             600, NULL },
  { "Gbreve",                            600, NULL },
  { "ugrave",                            600, NULL },
  { "dcaron",                            600, NULL },
  { "hyphen",                            600, NULL },
  { "Oslash",                            600, NULL },
  { "a",                                 600, NULL },
  { "B",                                 600, NULL },
  { "Rcaron",                            600, NULL },
  { "kcommaaccent",                      600, NULL },
  { "yacute",                            600, NULL },
  { "ydieresis",                         600, NULL },
  { "R",                                 600, NULL },
  { "aacute",                            600, NULL },
  { "umacron",                           600, NULL },
  { "Otilde",                            600, NULL },
  { "Tcaron",                            600, NULL },
  { "eogonek",                           600, NULL },
  { "bullet",                            600, NULL },
  { "eacute",                            600, NULL },
  { "Zdotaccent",                        600, NULL },
  { "scaron",                            600, NULL },
  { "guillemotright",                    600, NULL },
  { "two",                               600, NULL },
  { "uacute",                            600, NULL },
  { "seven",                             600, NULL },
  { "Abreve",                            600, NULL },
  { "Udieresis",                         600, NULL },
  { "Iacute",                            600, NULL },
  { "Icircumflex",                       600, NULL },
  { "O",                                 600, NULL },
  { "nacute",                            600, NULL },
  { "dieresis",                          600, NULL },
  { "Eacute",                            600, NULL },
  { "ntilde",                            600, NULL },
  { "fi",                                600, NULL },
  { "trademark",                         600, NULL },
  { "ampersand",                         600, NULL },
  { "Lcommaaccent",                      600, NULL }
};

static BuiltinFontWidth helveticaWidthsTab[] = {
  { "lcommaaccent",                      222, NULL },
  { "onehalf",                           834, NULL },
  { "uhungarumlaut",                     556, NULL },
  { "gbreve",                            556, NULL },
  { "n",                                 556, NULL },
  { "Ecaron",                            667, NULL },
  { "threesuperior",                     333, NULL },
  { "zdotaccent",                        500, NULL },
  { "quoteleft",                         222, NULL },
  { "registered",                        737, NULL },
  { "Gcommaaccent",                      778, NULL },
  { "Racute",                            722, NULL },
  { "k",                                 500, NULL },
  { "copyright",                         737, NULL },
  { "icircumflex",                       278, NULL },
  { "abreve",                            556, NULL },
  { "Imacron",                           278, NULL },
  { "iacute",                            278, NULL },
  { "e",                                 556, NULL },
  { "equal",                             584, NULL },
  { "dagger",                            556, NULL },
  { "N",                                 722, NULL },
  { "C",                                 722, NULL },
  { "u",                                 556, NULL },
  { "q",                                 556, NULL },
  { "l",                                 222, NULL },
  { "greater",                           584, NULL },
  { "asterisk",                          389, NULL },
  { "Emacron",                           667, NULL },
  { "scommaaccent",                      500, NULL },
  { "onesuperior",                       333, NULL },
  { "percent",                           889, NULL },
  { "o",                                 556, NULL },
  { "Euro",                              556, NULL },
  { "florin",                            556, NULL },
  { "iogonek",                           222, NULL },
  { "section",                           556, NULL },
  { "Scaron",                            667, NULL },
  { "degree",                            400, NULL },
  { "K",                                 667, NULL },
  { "Scommaaccent",                      667, NULL },
  { "Aacute",                            667, NULL },
  { "b",                                 556, NULL },
  { "Dcaron",                            722, NULL },
  { "Z",                                 611, NULL },
  { "ecircumflex",                       556, NULL },
  { "Amacron",                           667, NULL },
  { "breve",                             333, NULL },
  { "lcaron",                            299, NULL },
  { "paragraph",                         537, NULL },
  { "zcaron",                            500, NULL },
  { "aring",                             556, NULL },
  { "Ydieresis",                         667, NULL },
  { "Odieresis",                         778, NULL },
  { "oe",                                944, NULL },
  { "five",                              556, NULL },
  { "X",                                 667, NULL },
  { "asciicircum",                       469, NULL },
  { "emdash",                           1000, NULL },
  { "Egrave",                            667, NULL },
  { "aogonek",                           556, NULL },
  { "ring",                              333, NULL },
  { "Ntilde",                            722, NULL },
  { "radical",                           453, NULL },
  { "dotlessi",                          278, NULL },
  { "p",                                 556, NULL },
  { "plusminus",                         584, NULL },
  { "cedilla",                           333, NULL },
  { "Idotaccent",                        278, NULL },
  { "quotedblright",                     333, NULL },
  { "Eth",                               722, NULL },
  { "g",                                 556, NULL },
  { "colon",                             278, NULL },
  { "ccedilla",                          500, NULL },
  { "quotesinglbase",                    222, NULL },
  { "grave",                             333, NULL },
  { "Scedilla",                          667, NULL },
  { "parenleft",                         333, NULL },
  { "currency",                          556, NULL },
  { "nine",                              556, NULL },
  { "hungarumlaut",                      333, NULL },
  { "Ccaron",                            722, NULL },
  { "j",                                 222, NULL },
  { "yen",                               556, NULL },
  { "Y",                                 667, NULL },
  { "ccaron",                            500, NULL },
  { "Omacron",                           778, NULL },
  { "lessequal",                         549, NULL },
  { "Ucircumflex",                       722, NULL },
  { "dollar",                            556, NULL },
  { "Tcommaaccent",                      611, NULL },
  { "Nacute",                            722, NULL },
  { "v",                                 500, NULL },
  { "dotaccent",                         333, NULL },
  { "rcommaaccent",                      333, NULL },
  { "Kcommaaccent",                      667, NULL },
  { "imacron",                           278, NULL },
  { "tilde",                             333, NULL },
  { "underscore",                        556, NULL },
  { "mu",                                556, NULL },
  { "D",                                 722, NULL },
  { "racute",                            333, NULL },
  { "circumflex",                        333, NULL },
  { "Zcaron",                            611, NULL },
  { "ogonek",                            333, NULL },
  { "idieresis",                         278, NULL },
  { "cent",                              556, NULL },
  { "ae",                                889, NULL },
  { "ocircumflex",                       556, NULL },
  { "less",                              584, NULL },
  { "minus",                             584, NULL },
  { "four",                              556, NULL },
  { "F",                                 611, NULL },
  { "Ocircumflex",                       778, NULL },
  { "Uring",                             722, NULL },
  { "Edotaccent",                        667, NULL },
  { "perthousand",                      1000, NULL },
  { "acircumflex",                       556, NULL },
  { "G",                                 778, NULL },
  { "commaaccent",                       250, NULL },
  { "W",                                 944, NULL },
  { "bracketright",                      278, NULL },
  { "Ugrave",                            722, NULL },
  { "germandbls",                        611, NULL },
  { "thorn",                             556, NULL },
  { "zero",                              556, NULL },
  { "period",                            278, NULL },
  { "scedilla",                          500, NULL },
  { "udieresis",                         556, NULL },
  { "Ccedilla",                          722, NULL },
  { "Igrave",                            278, NULL },
  { "fl",                                500, NULL },
  { "quotedblbase",                      333, NULL },
  { "E",                                 667, NULL },
  { "endash",                            556, NULL },
  { "guillemotleft",                     556, NULL },
  { "w",                                 722, NULL },
  { "space",                             278, NULL },
  { "Thorn",                             667, NULL },
  { "eth",                               556, NULL },
  { "twosuperior",                       333, NULL },
  { "ecaron",                            556, NULL },
  { "brokenbar",                         260, NULL },
  { "Aogonek",                           667, NULL },
  { "M",                                 833, NULL },
  { "odieresis",                         556, NULL },
  { "Ograve",                            778, NULL },
  { "T",                                 611, NULL },
  { "amacron",                           556, NULL },
  { "Ncommaaccent",                      722, NULL },
  { "numbersign",                        556, NULL },
  { "divide",                            584, NULL },
  { "emacron",                           556, NULL },
  { "Abreve",                            667, NULL },
  { "Udieresis",                         722, NULL },
  { "Iacute",                            278, NULL },
  { "two",                               556, NULL },
  { "uacute",                            556, NULL },
  { "seven",                             556, NULL },
  { "scaron",                            500, NULL },
  { "guillemotright",                    556, NULL },
  { "bullet",                            350, NULL },
  { "eogonek",                           556, NULL },
  { "eacute",                            556, NULL },
  { "Zdotaccent",                        611, NULL },
  { "trademark",                        1000, NULL },
  { "ampersand",                         667, NULL },
  { "Lcommaaccent",                      556, NULL },
  { "ntilde",                            556, NULL },
  { "fi",                                500, NULL },
  { "dieresis",                          333, NULL },
  { "Eacute",                            667, NULL },
  { "O",                                 778, NULL },
  { "Icircumflex",                       278, NULL },
  { "nacute",                            556, NULL },
  { "omacron",                           556, NULL },
  { "comma",                             278, NULL },
  { "Delta",                             612, NULL },
  { "Gbreve",                            778, NULL },
  { "S",                                 667, NULL },
  { "quotedblleft",                      333, NULL },
  { "ordfeminine",                       370, NULL },
  { "Otilde",                            778, NULL },
  { "umacron",                           556, NULL },
  { "Tcaron",                            611, NULL },
  { "aacute",                            556, NULL },
  { "B",                                 667, NULL },
  { "kcommaaccent",                      500, NULL },
  { "Rcaron",                            722, NULL },
  { "yacute",                            500, NULL },
  { "ydieresis",                         500, NULL },
  { "R",                                 722, NULL },
  { "ugrave",                            556, NULL },
  { "dcaron",                            643, NULL },
  { "hyphen",                            333, NULL },
  { "Oslash",                            778, NULL },
  { "a",                                 556, NULL },
  { "igrave",                            278, NULL },
  { "dcroat",                            556, NULL },
  { "question",                          556, NULL },
  { "summation",                         600, NULL },
  { "A",                                 667, NULL },
  { "guilsinglleft",                     333, NULL },
  { "h",                                 556, NULL },
  { "Cacute",                            722, NULL },
  { "plus",                              584, NULL },
  { "ncommaaccent",                      556, NULL },
  { "tcommaaccent",                      278, NULL },
  { "logicalnot",                        584, NULL },
  { "cacute",                            500, NULL },
  { "Dcroat",                            722, NULL },
  { "tcaron",                            317, NULL },
  { "rcaron",                            333, NULL },
  { "x",                                 500, NULL },
  { "Iogonek",                           278, NULL },
  { "y",                                 500, NULL },
  { "edieresis",                         556, NULL },
  { "Ncaron",                            722, NULL },
  { "m",                                 833, NULL },
  { "OE",                               1000, NULL },
  { "U",                                 722, NULL },
  { "partialdiff",                       476, NULL },
  { "braceright",                        334, NULL },
  { "braceleft",                         334, NULL },
  { "acute",                             333, NULL },
  { "onequarter",                        834, NULL },
  { "Atilde",                            667, NULL },
  { "Edieresis",                         667, NULL },
  { "Yacute",                            667, NULL },
  { "oacute",                            556, NULL },
  { "daggerdbl",                         556, NULL },
  { "six",                               556, NULL },
  { "edotaccent",                        556, NULL },
  { "P",                                 667, NULL },
  { "lslash",                            222, NULL },
  { "multiply",                          584, NULL },
  { "i",                                 222, NULL },
  { "quotesingle",                       191, NULL },
  { "bar",                               260, NULL },
  { "agrave",                            556, NULL },
  { "ellipsis",                         1000, NULL },
  { "Aring",                             667, NULL },
  { "t",                                 278, NULL },
  { "quotedbl",                          355, NULL },
  { "Oacute",                            778, NULL },
  { "egrave",                            556, NULL },
  { "uring",                             556, NULL },
  { "s",                                 500, NULL },
  { "Uhungarumlaut",                     722, NULL },
  { "z",                                 500, NULL },
  { "eight",                             556, NULL },
  { "I",                                 278, NULL },
  { "one",                               556, NULL },
  { "periodcentered",                    278, NULL },
  { "c",                                 500, NULL },
  { "d",                                 556, NULL },
  { "zacute",                            500, NULL },
  { "Umacron",                           722, NULL },
  { "ncaron",                            556, NULL },
  { "adieresis",                         556, NULL },
  { "lozenge",                           471, NULL },
  { "V",                                 667, NULL },
  { "Q",                                 778, NULL },
  { "exclamdown",                        333, NULL },
  { "quoteright",                        222, NULL },
  { "uogonek",                           556, NULL },
  { "semicolon",                         278, NULL },
  { "guilsinglright",                    333, NULL },
  { "Eogonek",                           667, NULL },
  { "macron",                            333, NULL },
  { "ordmasculine",                      365, NULL },
  { "Lcaron",                            556, NULL },
  { "backslash",                         278, NULL },
  { "questiondown",                      611, NULL },
  { "three",                             556, NULL },
  { "slash",                             278, NULL },
  { "ucircumflex",                       556, NULL },
  { "r",                                 333, NULL },
  { "f",                                 278, NULL },
  { "gcommaaccent",                      556, NULL },
  { "Ohungarumlaut",                     778, NULL },
  { "bracketleft",                       278, NULL },
  { "otilde",                            556, NULL },
  { "parenright",                        333, NULL },
  { "Rcommaaccent",                      722, NULL },
  { "ograve",                            556, NULL },
  { "Lacute",                            556, NULL },
  { "sacute",                            500, NULL },
  { "Idieresis",                         278, NULL },
  { "Uogonek",                           722, NULL },
  { "Lslash",                            556, NULL },
  { "caron",                             333, NULL },
  { "lacute",                            222, NULL },
  { "sterling",                          556, NULL },
  { "H",                                 722, NULL },
  { "at",                               1015, NULL },
  { "greaterequal",                      549, NULL },
  { "threequarters",                     834, NULL },
  { "J",                                 500, NULL },
  { "L",                                 556, NULL },
  { "ohungarumlaut",                     556, NULL },
  { "Ecircumflex",                       667, NULL },
  { "notequal",                          549, NULL },
  { "exclam",                            278, NULL },
  { "Agrave",                            667, NULL },
  { "AE",                               1000, NULL },
  { "Acircumflex",                       667, NULL },
  { "oslash",                            611, NULL },
  { "Uacute",                            722, NULL },
  { "atilde",                            556, NULL },
  { "Zacute",                            611, NULL },
  { "fraction",                          167, NULL },
  { "Sacute",                            667, NULL },
  { "Adieresis",                         667, NULL },
  { "asciitilde",                        584, NULL }
};

static BuiltinFontWidth helveticaBoldWidthsTab[] = {
  { "uogonek",                           611, NULL },
  { "quoteright",                        278, NULL },
  { "guilsinglright",                    333, NULL },
  { "semicolon",                         333, NULL },
  { "V",                                 667, NULL },
  { "lozenge",                           494, NULL },
  { "exclamdown",                        333, NULL },
  { "Q",                                 778, NULL },
  { "zacute",                            500, NULL },
  { "Umacron",                           722, NULL },
  { "adieresis",                         556, NULL },
  { "ncaron",                            611, NULL },
  { "slash",                             278, NULL },
  { "r",                                 389, NULL },
  { "ucircumflex",                       611, NULL },
  { "three",                             556, NULL },
  { "ordmasculine",                      365, NULL },
  { "Lcaron",                            611, NULL },
  { "backslash",                         278, NULL },
  { "questiondown",                      611, NULL },
  { "macron",                            333, NULL },
  { "Eogonek",                           667, NULL },
  { "Oacute",                            778, NULL },
  { "t",                                 333, NULL },
  { "quotedbl",                          474, NULL },
  { "ellipsis",                         1000, NULL },
  { "Aring",                             722, NULL },
  { "agrave",                            556, NULL },
  { "d",                                 611, NULL },
  { "c",                                 556, NULL },
  { "I",                                 278, NULL },
  { "one",                               556, NULL },
  { "eight",                             556, NULL },
  { "periodcentered",                    278, NULL },
  { "z",                                 500, NULL },
  { "Uhungarumlaut",                     722, NULL },
  { "egrave",                            556, NULL },
  { "s",                                 556, NULL },
  { "uring",                             611, NULL },
  { "Agrave",                            722, NULL },
  { "AE",                               1000, NULL },
  { "exclam",                            333, NULL },
  { "notequal",                          549, NULL },
  { "oslash",                            611, NULL },
  { "Acircumflex",                       722, NULL },
  { "J",                                 556, NULL },
  { "threequarters",                     834, NULL },
  { "ohungarumlaut",                     611, NULL },
  { "L",                                 611, NULL },
  { "Ecircumflex",                       667, NULL },
  { "H",                                 722, NULL },
  { "sterling",                          556, NULL },
  { "greaterequal",                      549, NULL },
  { "at",                                975, NULL },
  { "lacute",                            278, NULL },
  { "Uogonek",                           722, NULL },
  { "caron",                             333, NULL },
  { "Lslash",                            611, NULL },
  { "asciitilde",                        584, NULL },
  { "fraction",                          167, NULL },
  { "Adieresis",                         722, NULL },
  { "Sacute",                            667, NULL },
  { "Uacute",                            722, NULL },
  { "Zacute",                            611, NULL },
  { "atilde",                            556, NULL },
  { "otilde",                            611, NULL },
  { "parenright",                        333, NULL },
  { "gcommaaccent",                      611, NULL },
  { "bracketleft",                       333, NULL },
  { "Ohungarumlaut",                     778, NULL },
  { "f",                                 333, NULL },
  { "Lacute",                            611, NULL },
  { "sacute",                            556, NULL },
  { "Idieresis",                         278, NULL },
  { "ograve",                            611, NULL },
  { "Rcommaaccent",                      722, NULL },
  { "ordfeminine",                       370, NULL },
  { "quotedblleft",                      500, NULL },
  { "S",                                 667, NULL },
  { "comma",                             278, NULL },
  { "Delta",                             612, NULL },
  { "omacron",                           611, NULL },
  { "Gbreve",                            778, NULL },
  { "dcaron",                            743, NULL },
  { "ugrave",                            611, NULL },
  { "a",                                 556, NULL },
  { "hyphen",                            333, NULL },
  { "Oslash",                            778, NULL },
  { "B",                                 722, NULL },
  { "R",                                 722, NULL },
  { "ydieresis",                         556, NULL },
  { "yacute",                            556, NULL },
  { "kcommaaccent",                      556, NULL },
  { "Rcaron",                            722, NULL },
  { "aacute",                            556, NULL },
  { "Otilde",                            778, NULL },
  { "umacron",                           611, NULL },
  { "Tcaron",                            611, NULL },
  { "bullet",                            350, NULL },
  { "eogonek",                           556, NULL },
  { "eacute",                            556, NULL },
  { "Zdotaccent",                        611, NULL },
  { "scaron",                            556, NULL },
  { "guillemotright",                    556, NULL },
  { "uacute",                            611, NULL },
  { "two",                               556, NULL },
  { "seven",                             556, NULL },
  { "Abreve",                            722, NULL },
  { "Udieresis",                         722, NULL },
  { "Iacute",                            278, NULL },
  { "nacute",                            611, NULL },
  { "O",                                 778, NULL },
  { "Icircumflex",                       278, NULL },
  { "dieresis",                          333, NULL },
  { "Eacute",                            667, NULL },
  { "ntilde",                            611, NULL },
  { "fi",                                611, NULL },
  { "ampersand",                         722, NULL },
  { "trademark",                        1000, NULL },
  { "Lcommaaccent",                      611, NULL },
  { "Yacute",                            667, NULL },
  { "oacute",                            611, NULL },
  { "daggerdbl",                         556, NULL },
  { "Atilde",                            722, NULL },
  { "Edieresis",                         667, NULL },
  { "onequarter",                        834, NULL },
  { "acute",                             333, NULL },
  { "braceright",                        389, NULL },
  { "braceleft",                         389, NULL },
  { "quotesingle",                       238, NULL },
  { "bar",                               280, NULL },
  { "i",                                 278, NULL },
  { "multiply",                          584, NULL },
  { "lslash",                            278, NULL },
  { "P",                                 667, NULL },
  { "edotaccent",                        556, NULL },
  { "six",                               556, NULL },
  { "Cacute",                            722, NULL },
  { "h",                                 611, NULL },
  { "guilsinglleft",                     333, NULL },
  { "plus",                              584, NULL },
  { "summation",                         600, NULL },
  { "question",                          611, NULL },
  { "A",                                 722, NULL },
  { "dcroat",                            611, NULL },
  { "igrave",                            278, NULL },
  { "OE",                               1000, NULL },
  { "m",                                 889, NULL },
  { "U",                                 722, NULL },
  { "partialdiff",                       494, NULL },
  { "y",                                 556, NULL },
  { "Iogonek",                           278, NULL },
  { "edieresis",                         556, NULL },
  { "x",                                 556, NULL },
  { "Ncaron",                            722, NULL },
  { "Dcroat",                            722, NULL },
  { "cacute",                            556, NULL },
  { "tcaron",                            389, NULL },
  { "rcaron",                            389, NULL },
  { "ncommaaccent",                      611, NULL },
  { "logicalnot",                        584, NULL },
  { "tcommaaccent",                      333, NULL },
  { "underscore",                        556, NULL },
  { "racute",                            389, NULL },
  { "D",                                 722, NULL },
  { "mu",                                611, NULL },
  { "Kcommaaccent",                      722, NULL },
  { "imacron",                           278, NULL },
  { "rcommaaccent",                      389, NULL },
  { "tilde",                             333, NULL },
  { "dollar",                            556, NULL },
  { "Tcommaaccent",                      611, NULL },
  { "dotaccent",                         333, NULL },
  { "Nacute",                            722, NULL },
  { "v",                                 556, NULL },
  { "less",                              584, NULL },
  { "ocircumflex",                       611, NULL },
  { "four",                              556, NULL },
  { "minus",                             584, NULL },
  { "ae",                                889, NULL },
  { "cent",                              556, NULL },
  { "ogonek",                            333, NULL },
  { "idieresis",                         278, NULL },
  { "circumflex",                        333, NULL },
  { "Zcaron",                            611, NULL },
  { "nine",                              556, NULL },
  { "currency",                          556, NULL },
  { "parenleft",                         333, NULL },
  { "Scedilla",                          667, NULL },
  { "grave",                             333, NULL },
  { "quotesinglbase",                    278, NULL },
  { "Ucircumflex",                       722, NULL },
  { "lessequal",                         549, NULL },
  { "Omacron",                           778, NULL },
  { "ccaron",                            556, NULL },
  { "Y",                                 667, NULL },
  { "yen",                               556, NULL },
  { "Ccaron",                            722, NULL },
  { "j",                                 278, NULL },
  { "hungarumlaut",                      333, NULL },
  { "ecaron",                            556, NULL },
  { "brokenbar",                         280, NULL },
  { "Aogonek",                           722, NULL },
  { "w",                                 778, NULL },
  { "twosuperior",                       333, NULL },
  { "eth",                               611, NULL },
  { "Thorn",                             667, NULL },
  { "space",                             278, NULL },
  { "guillemotleft",                     556, NULL },
  { "endash",                            556, NULL },
  { "fl",                                611, NULL },
  { "E",                                 667, NULL },
  { "quotedblbase",                      500, NULL },
  { "numbersign",                        556, NULL },
  { "emacron",                           556, NULL },
  { "divide",                            584, NULL },
  { "amacron",                           556, NULL },
  { "Ncommaaccent",                      722, NULL },
  { "T",                                 611, NULL },
  { "odieresis",                         611, NULL },
  { "M",                                 833, NULL },
  { "Ograve",                            778, NULL },
  { "G",                                 778, NULL },
  { "perthousand",                      1000, NULL },
  { "Edotaccent",                        667, NULL },
  { "acircumflex",                       556, NULL },
  { "F",                                 611, NULL },
  { "Ocircumflex",                       778, NULL },
  { "Uring",                             722, NULL },
  { "Ccedilla",                          722, NULL },
  { "Igrave",                            278, NULL },
  { "zero",                              556, NULL },
  { "udieresis",                         611, NULL },
  { "period",                            278, NULL },
  { "scedilla",                          556, NULL },
  { "germandbls",                        611, NULL },
  { "Ugrave",                            722, NULL },
  { "thorn",                             611, NULL },
  { "commaaccent",                       250, NULL },
  { "W",                                 944, NULL },
  { "bracketright",                      333, NULL },
  { "l",                                 278, NULL },
  { "q",                                 611, NULL },
  { "N",                                 722, NULL },
  { "dagger",                            556, NULL },
  { "equal",                             584, NULL },
  { "u",                                 611, NULL },
  { "C",                                 722, NULL },
  { "iacute",                            278, NULL },
  { "e",                                 556, NULL },
  { "Imacron",                           278, NULL },
  { "abreve",                            556, NULL },
  { "icircumflex",                       278, NULL },
  { "percent",                           889, NULL },
  { "o",                                 611, NULL },
  { "asterisk",                          389, NULL },
  { "Emacron",                           667, NULL },
  { "scommaaccent",                      556, NULL },
  { "onesuperior",                       333, NULL },
  { "greater",                           584, NULL },
  { "Ecaron",                            667, NULL },
  { "zdotaccent",                        500, NULL },
  { "threesuperior",                     333, NULL },
  { "n",                                 611, NULL },
  { "dbldaggerumlaut",                   556, NULL },
  { "onehalf",                           834, NULL },
  { "lcommaaccent",                      278, NULL },
  { "uhungarumlaut",                     611, NULL },
  { "gbreve",                            611, NULL },
  { "k",                                 556, NULL },
  { "copyright",                         737, NULL },
  { "Racute",                            722, NULL },
  { "Gcommaaccent",                      778, NULL },
  { "quoteleft",                         278, NULL },
  { "registered",                        737, NULL },
  { "aogonek",                           556, NULL },
  { "Egrave",                            667, NULL },
  { "ring",                              333, NULL },
  { "emdash",                           1000, NULL },
  { "five",                              556, NULL },
  { "asciicircum",                       584, NULL },
  { "X",                                 667, NULL },
  { "oe",                                944, NULL },
  { "Odieresis",                         778, NULL },
  { "ccedilla",                          556, NULL },
  { "g",                                 611, NULL },
  { "colon",                             333, NULL },
  { "Idotaccent",                        278, NULL },
  { "cedilla",                           333, NULL },
  { "plusminus",                         584, NULL },
  { "Eth",                               722, NULL },
  { "quotedblright",                     500, NULL },
  { "p",                                 611, NULL },
  { "dotlessi",                          278, NULL },
  { "radical",                           549, NULL },
  { "Ntilde",                            722, NULL },
  { "Aacute",                            722, NULL },
  { "Scommaaccent",                      667, NULL },
  { "b",                                 611, NULL },
  { "K",                                 722, NULL },
  { "Scaron",                            667, NULL },
  { "degree",                            400, NULL },
  { "section",                           556, NULL },
  { "florin",                            556, NULL },
  { "iogonek",                           278, NULL },
  { "Euro",                              556, NULL },
  { "paragraph",                         556, NULL },
  { "zcaron",                            500, NULL },
  { "lcaron",                            400, NULL },
  { "Ydieresis",                         667, NULL },
  { "aring",                             556, NULL },
  { "breve",                             333, NULL },
  { "Amacron",                           722, NULL },
  { "Dcaron",                            722, NULL },
  { "ecircumflex",                       556, NULL },
  { "Z",                                 611, NULL }
};

static BuiltinFontWidth helveticaBoldObliqueWidthsTab[] = {
  { "divide",                            584, NULL },
  { "emacron",                           556, NULL },
  { "numbersign",                        556, NULL },
  { "Ncommaaccent",                      722, NULL },
  { "amacron",                           556, NULL },
  { "T",                                 611, NULL },
  { "Ograve",                            778, NULL },
  { "M",                                 833, NULL },
  { "odieresis",                         611, NULL },
  { "Aogonek",                           722, NULL },
  { "brokenbar",                         280, NULL },
  { "ecaron",                            556, NULL },
  { "Thorn",                             667, NULL },
  { "space",                             278, NULL },
  { "twosuperior",                       333, NULL },
  { "eth",                               611, NULL },
  { "w",                                 778, NULL },
  { "endash",                            556, NULL },
  { "guillemotleft",                     556, NULL },
  { "E",                                 667, NULL },
  { "quotedblbase",                      500, NULL },
  { "fl",                                611, NULL },
  { "Igrave",                            278, NULL },
  { "Ccedilla",                          722, NULL },
  { "period",                            278, NULL },
  { "scedilla",                          556, NULL },
  { "udieresis",                         611, NULL },
  { "zero",                              556, NULL },
  { "thorn",                             611, NULL },
  { "Ugrave",                            722, NULL },
  { "germandbls",                        611, NULL },
  { "bracketright",                      333, NULL },
  { "W",                                 944, NULL },
  { "commaaccent",                       250, NULL },
  { "G",                                 778, NULL },
  { "acircumflex",                       556, NULL },
  { "Edotaccent",                        667, NULL },
  { "perthousand",                      1000, NULL },
  { "Uring",                             722, NULL },
  { "F",                                 611, NULL },
  { "Ocircumflex",                       778, NULL },
  { "minus",                             584, NULL },
  { "four",                              556, NULL },
  { "ocircumflex",                       611, NULL },
  { "less",                              584, NULL },
  { "ae",                                889, NULL },
  { "cent",                              556, NULL },
  { "idieresis",                         278, NULL },
  { "ogonek",                            333, NULL },
  { "Zcaron",                            611, NULL },
  { "circumflex",                        333, NULL },
  { "D",                                 722, NULL },
  { "mu",                                611, NULL },
  { "racute",                            389, NULL },
  { "underscore",                        556, NULL },
  { "tilde",                             333, NULL },
  { "rcommaaccent",                      389, NULL },
  { "Kcommaaccent",                      722, NULL },
  { "imacron",                           278, NULL },
  { "Nacute",                            722, NULL },
  { "v",                                 556, NULL },
  { "dotaccent",                         333, NULL },
  { "Tcommaaccent",                      611, NULL },
  { "dollar",                            556, NULL },
  { "lessequal",                         549, NULL },
  { "Ucircumflex",                       722, NULL },
  { "Omacron",                           778, NULL },
  { "ccaron",                            556, NULL },
  { "yen",                               556, NULL },
  { "Y",                                 667, NULL },
  { "hungarumlaut",                      333, NULL },
  { "Ccaron",                            722, NULL },
  { "j",                                 278, NULL },
  { "currency",                          556, NULL },
  { "nine",                              556, NULL },
  { "parenleft",                         333, NULL },
  { "grave",                             333, NULL },
  { "Scedilla",                          667, NULL },
  { "quotesinglbase",                    278, NULL },
  { "g",                                 611, NULL },
  { "colon",                             333, NULL },
  { "ccedilla",                          556, NULL },
  { "quotedblright",                     500, NULL },
  { "Eth",                               722, NULL },
  { "plusminus",                         584, NULL },
  { "cedilla",                           333, NULL },
  { "Idotaccent",                        278, NULL },
  { "dotlessi",                          278, NULL },
  { "p",                                 611, NULL },
  { "Ntilde",                            722, NULL },
  { "radical",                           549, NULL },
  { "ring",                              333, NULL },
  { "Egrave",                            667, NULL },
  { "aogonek",                           556, NULL },
  { "emdash",                           1000, NULL },
  { "X",                                 667, NULL },
  { "asciicircum",                       584, NULL },
  { "five",                              556, NULL },
  { "Odieresis",                         778, NULL },
  { "oe",                                944, NULL },
  { "aring",                             556, NULL },
  { "Ydieresis",                         667, NULL },
  { "lcaron",                            400, NULL },
  { "zcaron",                            500, NULL },
  { "paragraph",                         556, NULL },
  { "Amacron",                           722, NULL },
  { "breve",                             333, NULL },
  { "Z",                                 611, NULL },
  { "ecircumflex",                       556, NULL },
  { "Dcaron",                            722, NULL },
  { "b",                                 611, NULL },
  { "Scommaaccent",                      667, NULL },
  { "Aacute",                            722, NULL },
  { "K",                                 722, NULL },
  { "section",                           556, NULL },
  { "Scaron",                            667, NULL },
  { "degree",                            400, NULL },
  { "Euro",                              556, NULL },
  { "florin",                            556, NULL },
  { "iogonek",                           278, NULL },
  { "o",                                 611, NULL },
  { "percent",                           889, NULL },
  { "onesuperior",                       333, NULL },
  { "scommaaccent",                      556, NULL },
  { "Emacron",                           667, NULL },
  { "asterisk",                          389, NULL },
  { "greater",                           584, NULL },
  { "q",                                 611, NULL },
  { "l",                                 278, NULL },
  { "C",                                 722, NULL },
  { "u",                                 611, NULL },
  { "dagger",                            556, NULL },
  { "equal",                             584, NULL },
  { "N",                                 722, NULL },
  { "Imacron",                           278, NULL },
  { "abreve",                            556, NULL },
  { "iacute",                            278, NULL },
  { "e",                                 556, NULL },
  { "icircumflex",                       278, NULL },
  { "copyright",                         737, NULL },
  { "k",                                 556, NULL },
  { "Racute",                            722, NULL },
  { "Gcommaaccent",                      778, NULL },
  { "registered",                        737, NULL },
  { "quoteleft",                         278, NULL },
  { "threesuperior",                     333, NULL },
  { "zdotaccent",                        500, NULL },
  { "Ecaron",                            667, NULL },
  { "n",                                 611, NULL },
  { "gbreve",                            611, NULL },
  { "uhungarumlaut",                     611, NULL },
  { "lcommaaccent",                      278, NULL },
  { "onehalf",                           834, NULL },
  { "asciitilde",                        584, NULL },
  { "Adieresis",                         722, NULL },
  { "Sacute",                            667, NULL },
  { "fraction",                          167, NULL },
  { "atilde",                            556, NULL },
  { "Zacute",                            611, NULL },
  { "Uacute",                            722, NULL },
  { "Acircumflex",                       722, NULL },
  { "oslash",                            611, NULL },
  { "notequal",                          549, NULL },
  { "AE",                               1000, NULL },
  { "Agrave",                            722, NULL },
  { "exclam",                            333, NULL },
  { "L",                                 611, NULL },
  { "ohungarumlaut",                     611, NULL },
  { "Ecircumflex",                       667, NULL },
  { "threequarters",                     834, NULL },
  { "J",                                 556, NULL },
  { "greaterequal",                      549, NULL },
  { "at",                                975, NULL },
  { "sterling",                          556, NULL },
  { "H",                                 722, NULL },
  { "Lslash",                            611, NULL },
  { "Uogonek",                           722, NULL },
  { "caron",                             333, NULL },
  { "lacute",                            278, NULL },
  { "sacute",                            556, NULL },
  { "Idieresis",                         278, NULL },
  { "Lacute",                            611, NULL },
  { "Rcommaaccent",                      722, NULL },
  { "ograve",                            611, NULL },
  { "parenright",                        333, NULL },
  { "otilde",                            611, NULL },
  { "Ohungarumlaut",                     778, NULL },
  { "bracketleft",                       333, NULL },
  { "gcommaaccent",                      611, NULL },
  { "f",                                 333, NULL },
  { "r",                                 389, NULL },
  { "ucircumflex",                       611, NULL },
  { "slash",                             278, NULL },
  { "three",                             556, NULL },
  { "Eogonek",                           667, NULL },
  { "macron",                            333, NULL },
  { "Lcaron",                            611, NULL },
  { "ordmasculine",                      365, NULL },
  { "backslash",                         278, NULL },
  { "questiondown",                      611, NULL },
  { "semicolon",                         333, NULL },
  { "guilsinglright",                    333, NULL },
  { "uogonek",                           611, NULL },
  { "quoteright",                        278, NULL },
  { "Q",                                 778, NULL },
  { "exclamdown",                        333, NULL },
  { "lozenge",                           494, NULL },
  { "V",                                 667, NULL },
  { "ncaron",                            611, NULL },
  { "adieresis",                         556, NULL },
  { "zacute",                            500, NULL },
  { "Umacron",                           722, NULL },
  { "c",                                 556, NULL },
  { "d",                                 611, NULL },
  { "periodcentered",                    278, NULL },
  { "eight",                             556, NULL },
  { "I",                                 278, NULL },
  { "one",                               556, NULL },
  { "Uhungarumlaut",                     722, NULL },
  { "z",                                 500, NULL },
  { "uring",                             611, NULL },
  { "s",                                 556, NULL },
  { "egrave",                            556, NULL },
  { "Oacute",                            778, NULL },
  { "quotedbl",                          474, NULL },
  { "t",                                 333, NULL },
  { "Aring",                             722, NULL },
  { "ellipsis",                         1000, NULL },
  { "agrave",                            556, NULL },
  { "bar",                               280, NULL },
  { "quotesingle",                       238, NULL },
  { "multiply",                          584, NULL },
  { "i",                                 278, NULL },
  { "P",                                 667, NULL },
  { "lslash",                            278, NULL },
  { "six",                               556, NULL },
  { "edotaccent",                        556, NULL },
  { "daggerdbl",                         556, NULL },
  { "Yacute",                            667, NULL },
  { "oacute",                            611, NULL },
  { "Edieresis",                         667, NULL },
  { "Atilde",                            722, NULL },
  { "onequarter",                        834, NULL },
  { "braceright",                        389, NULL },
  { "braceleft",                         389, NULL },
  { "acute",                             333, NULL },
  { "partialdiff",                       494, NULL },
  { "U",                                 722, NULL },
  { "m",                                 889, NULL },
  { "OE",                               1000, NULL },
  { "Ncaron",                            722, NULL },
  { "x",                                 556, NULL },
  { "edieresis",                         556, NULL },
  { "Iogonek",                           278, NULL },
  { "y",                                 556, NULL },
  { "tcaron",                            389, NULL },
  { "rcaron",                            389, NULL },
  { "cacute",                            556, NULL },
  { "Dcroat",                            722, NULL },
  { "tcommaaccent",                      333, NULL },
  { "logicalnot",                        584, NULL },
  { "ncommaaccent",                      611, NULL },
  { "plus",                              584, NULL },
  { "guilsinglleft",                     333, NULL },
  { "h",                                 611, NULL },
  { "Cacute",                            722, NULL },
  { "A",                                 722, NULL },
  { "question",                          611, NULL },
  { "summation",                         600, NULL },
  { "igrave",                            278, NULL },
  { "dcroat",                            611, NULL },
  { "Oslash",                            778, NULL },
  { "hyphen",                            333, NULL },
  { "a",                                 556, NULL },
  { "ugrave",                            611, NULL },
  { "dcaron",                            743, NULL },
  { "Rcaron",                            722, NULL },
  { "kcommaaccent",                      556, NULL },
  { "yacute",                            556, NULL },
  { "ydieresis",                         556, NULL },
  { "R",                                 722, NULL },
  { "B",                                 722, NULL },
  { "aacute",                            556, NULL },
  { "Tcaron",                            611, NULL },
  { "Otilde",                            778, NULL },
  { "umacron",                           611, NULL },
  { "ordfeminine",                       370, NULL },
  { "quotedblleft",                      500, NULL },
  { "S",                                 667, NULL },
  { "Gbreve",                            778, NULL },
  { "omacron",                           611, NULL },
  { "Delta",                             612, NULL },
  { "comma",                             278, NULL },
  { "O",                                 778, NULL },
  { "Icircumflex",                       278, NULL },
  { "nacute",                            611, NULL },
  { "Eacute",                            667, NULL },
  { "dieresis",                          333, NULL },
  { "fi",                                611, NULL },
  { "ntilde",                            611, NULL },
  { "Lcommaaccent",                      611, NULL },
  { "trademark",                        1000, NULL },
  { "ampersand",                         722, NULL },
  { "Zdotaccent",                        611, NULL },
  { "bullet",                            350, NULL },
  { "eogonek",                           556, NULL },
  { "eacute",                            556, NULL },
  { "guillemotright",                    556, NULL },
  { "scaron",                            556, NULL },
  { "seven",                             556, NULL },
  { "two",                               556, NULL },
  { "uacute",                            611, NULL },
  { "Iacute",                            278, NULL },
  { "Udieresis",                         722, NULL },
  { "Abreve",                            722, NULL }
};

static BuiltinFontWidth helveticaObliqueWidthsTab[] = {
  { "dieresis",                          333, NULL },
  { "Eacute",                            667, NULL },
  { "Icircumflex",                       278, NULL },
  { "O",                                 778, NULL },
  { "nacute",                            556, NULL },
  { "trademark",                        1000, NULL },
  { "ampersand",                         667, NULL },
  { "Lcommaaccent",                      556, NULL },
  { "ntilde",                            556, NULL },
  { "fi",                                500, NULL },
  { "scaron",                            500, NULL },
  { "guillemotright",                    556, NULL },
  { "eacute",                            556, NULL },
  { "eogonek",                           556, NULL },
  { "bullet",                            350, NULL },
  { "Zdotaccent",                        611, NULL },
  { "Abreve",                            667, NULL },
  { "Udieresis",                         722, NULL },
  { "Iacute",                            278, NULL },
  { "two",                               556, NULL },
  { "uacute",                            556, NULL },
  { "seven",                             556, NULL },
  { "B",                                 667, NULL },
  { "Rcaron",                            722, NULL },
  { "kcommaaccent",                      500, NULL },
  { "yacute",                            500, NULL },
  { "R",                                 722, NULL },
  { "ydieresis",                         500, NULL },
  { "ugrave",                            556, NULL },
  { "dcaron",                            643, NULL },
  { "Oslash",                            778, NULL },
  { "hyphen",                            333, NULL },
  { "a",                                 556, NULL },
  { "umacron",                           556, NULL },
  { "Otilde",                            778, NULL },
  { "Tcaron",                            611, NULL },
  { "aacute",                            556, NULL },
  { "quotedblleft",                      333, NULL },
  { "ordfeminine",                       370, NULL },
  { "omacron",                           556, NULL },
  { "Delta",                             612, NULL },
  { "comma",                             278, NULL },
  { "Gbreve",                            778, NULL },
  { "S",                                 667, NULL },
  { "x",                                 500, NULL },
  { "y",                                 500, NULL },
  { "Iogonek",                           278, NULL },
  { "edieresis",                         556, NULL },
  { "Ncaron",                            722, NULL },
  { "m",                                 833, NULL },
  { "OE",                               1000, NULL },
  { "partialdiff",                       476, NULL },
  { "U",                                 722, NULL },
  { "ncommaaccent",                      556, NULL },
  { "tcommaaccent",                      278, NULL },
  { "logicalnot",                        584, NULL },
  { "cacute",                            500, NULL },
  { "Dcroat",                            722, NULL },
  { "tcaron",                            317, NULL },
  { "rcaron",                            333, NULL },
  { "guilsinglleft",                     333, NULL },
  { "Cacute",                            722, NULL },
  { "h",                                 556, NULL },
  { "plus",                              584, NULL },
  { "igrave",                            278, NULL },
  { "dcroat",                            556, NULL },
  { "question",                          556, NULL },
  { "summation",                         600, NULL },
  { "A",                                 667, NULL },
  { "multiply",                          584, NULL },
  { "i",                                 222, NULL },
  { "quotesingle",                       191, NULL },
  { "bar",                               260, NULL },
  { "six",                               556, NULL },
  { "edotaccent",                        556, NULL },
  { "lslash",                            222, NULL },
  { "P",                                 667, NULL },
  { "Atilde",                            667, NULL },
  { "Edieresis",                         667, NULL },
  { "oacute",                            556, NULL },
  { "Yacute",                            667, NULL },
  { "daggerdbl",                         556, NULL },
  { "braceleft",                         334, NULL },
  { "braceright",                        334, NULL },
  { "acute",                             333, NULL },
  { "onequarter",                        834, NULL },
  { "one",                               556, NULL },
  { "I",                                 278, NULL },
  { "eight",                             556, NULL },
  { "periodcentered",                    278, NULL },
  { "c",                                 500, NULL },
  { "d",                                 556, NULL },
  { "egrave",                            556, NULL },
  { "uring",                             556, NULL },
  { "s",                                 500, NULL },
  { "Uhungarumlaut",                     722, NULL },
  { "z",                                 500, NULL },
  { "t",                                 278, NULL },
  { "quotedbl",                          355, NULL },
  { "Oacute",                            778, NULL },
  { "agrave",                            556, NULL },
  { "ellipsis",                         1000, NULL },
  { "Aring",                             667, NULL },
  { "three",                             556, NULL },
  { "slash",                             278, NULL },
  { "ucircumflex",                       556, NULL },
  { "r",                                 333, NULL },
  { "macron",                            333, NULL },
  { "Eogonek",                           667, NULL },
  { "Lcaron",                            556, NULL },
  { "questiondown",                      611, NULL },
  { "ordmasculine",                      365, NULL },
  { "backslash",                         278, NULL },
  { "uogonek",                           556, NULL },
  { "quoteright",                        222, NULL },
  { "semicolon",                         278, NULL },
  { "guilsinglright",                    333, NULL },
  { "Umacron",                           722, NULL },
  { "zacute",                            500, NULL },
  { "ncaron",                            556, NULL },
  { "adieresis",                         556, NULL },
  { "lozenge",                           471, NULL },
  { "V",                                 667, NULL },
  { "Q",                                 778, NULL },
  { "exclamdown",                        333, NULL },
  { "Lacute",                            556, NULL },
  { "sacute",                            500, NULL },
  { "Idieresis",                         278, NULL },
  { "ograve",                            556, NULL },
  { "Rcommaaccent",                      722, NULL },
  { "gcommaaccent",                      556, NULL },
  { "Ohungarumlaut",                     778, NULL },
  { "bracketleft",                       278, NULL },
  { "otilde",                            556, NULL },
  { "parenright",                        333, NULL },
  { "f",                                 278, NULL },
  { "asciitilde",                        584, NULL },
  { "Uacute",                            722, NULL },
  { "atilde",                            556, NULL },
  { "Zacute",                            611, NULL },
  { "fraction",                          167, NULL },
  { "Sacute",                            667, NULL },
  { "Adieresis",                         667, NULL },
  { "threequarters",                     834, NULL },
  { "J",                                 500, NULL },
  { "ohungarumlaut",                     556, NULL },
  { "Ecircumflex",                       667, NULL },
  { "L",                                 556, NULL },
  { "notequal",                          549, NULL },
  { "exclam",                            278, NULL },
  { "Agrave",                            667, NULL },
  { "AE",                               1000, NULL },
  { "Acircumflex",                       667, NULL },
  { "oslash",                            611, NULL },
  { "Uogonek",                           722, NULL },
  { "caron",                             333, NULL },
  { "Lslash",                            556, NULL },
  { "lacute",                            222, NULL },
  { "sterling",                          556, NULL },
  { "H",                                 722, NULL },
  { "at",                               1015, NULL },
  { "greaterequal",                      549, NULL },
  { "Racute",                            722, NULL },
  { "k",                                 500, NULL },
  { "copyright",                         737, NULL },
  { "quoteleft",                         222, NULL },
  { "registered",                        737, NULL },
  { "Gcommaaccent",                      778, NULL },
  { "n",                                 556, NULL },
  { "Ecaron",                            667, NULL },
  { "threesuperior",                     333, NULL },
  { "zdotaccent",                        500, NULL },
  { "lcommaaccent",                      222, NULL },
  { "onehalf",                           834, NULL },
  { "gbreve",                            556, NULL },
  { "uhungarumlaut",                     556, NULL },
  { "percent",                           889, NULL },
  { "o",                                 556, NULL },
  { "greater",                           584, NULL },
  { "asterisk",                          389, NULL },
  { "Emacron",                           667, NULL },
  { "scommaaccent",                      500, NULL },
  { "onesuperior",                       333, NULL },
  { "dagger",                            556, NULL },
  { "equal",                             584, NULL },
  { "N",                                 722, NULL },
  { "C",                                 722, NULL },
  { "u",                                 556, NULL },
  { "q",                                 556, NULL },
  { "l",                                 222, NULL },
  { "icircumflex",                       278, NULL },
  { "Imacron",                           278, NULL },
  { "abreve",                            556, NULL },
  { "iacute",                            278, NULL },
  { "e",                                 556, NULL },
  { "lcaron",                            299, NULL },
  { "paragraph",                         537, NULL },
  { "zcaron",                            500, NULL },
  { "aring",                             556, NULL },
  { "Ydieresis",                         667, NULL },
  { "Dcaron",                            722, NULL },
  { "Z",                                 611, NULL },
  { "ecircumflex",                       556, NULL },
  { "Amacron",                           667, NULL },
  { "breve",                             333, NULL },
  { "K",                                 667, NULL },
  { "Scommaaccent",                      667, NULL },
  { "Aacute",                            667, NULL },
  { "b",                                 556, NULL },
  { "Euro",                              556, NULL },
  { "iogonek",                           222, NULL },
  { "florin",                            556, NULL },
  { "section",                           556, NULL },
  { "Scaron",                            667, NULL },
  { "degree",                            400, NULL },
  { "plusminus",                         584, NULL },
  { "cedilla",                           333, NULL },
  { "Idotaccent",                        278, NULL },
  { "quotedblright",                     333, NULL },
  { "Eth",                               722, NULL },
  { "colon",                             278, NULL },
  { "g",                                 556, NULL },
  { "ccedilla",                          500, NULL },
  { "Ntilde",                            722, NULL },
  { "radical",                           453, NULL },
  { "dotlessi",                          278, NULL },
  { "p",                                 556, NULL },
  { "emdash",                           1000, NULL },
  { "aogonek",                           556, NULL },
  { "Egrave",                            667, NULL },
  { "ring",                              333, NULL },
  { "Odieresis",                         778, NULL },
  { "oe",                                944, NULL },
  { "five",                              556, NULL },
  { "X",                                 667, NULL },
  { "asciicircum",                       469, NULL },
  { "ccaron",                            500, NULL },
  { "Omacron",                           778, NULL },
  { "lessequal",                         549, NULL },
  { "Ucircumflex",                       722, NULL },
  { "hungarumlaut",                      333, NULL },
  { "j",                                 222, NULL },
  { "Ccaron",                            722, NULL },
  { "yen",                               556, NULL },
  { "Y",                                 667, NULL },
  { "parenleft",                         333, NULL },
  { "currency",                          556, NULL },
  { "nine",                              556, NULL },
  { "quotesinglbase",                    222, NULL },
  { "grave",                             333, NULL },
  { "Scedilla",                          667, NULL },
  { "ae",                                889, NULL },
  { "cent",                              556, NULL },
  { "ocircumflex",                       556, NULL },
  { "less",                              584, NULL },
  { "minus",                             584, NULL },
  { "four",                              556, NULL },
  { "circumflex",                        333, NULL },
  { "Zcaron",                            611, NULL },
  { "ogonek",                            333, NULL },
  { "idieresis",                         278, NULL },
  { "rcommaaccent",                      333, NULL },
  { "Kcommaaccent",                      667, NULL },
  { "imacron",                           278, NULL },
  { "tilde",                             333, NULL },
  { "underscore",                        556, NULL },
  { "D",                                 722, NULL },
  { "mu",                                556, NULL },
  { "racute",                            333, NULL },
  { "Tcommaaccent",                      611, NULL },
  { "dollar",                            556, NULL },
  { "v",                                 500, NULL },
  { "Nacute",                            722, NULL },
  { "dotaccent",                         333, NULL },
  { "zero",                              556, NULL },
  { "scedilla",                          500, NULL },
  { "period",                            278, NULL },
  { "udieresis",                         556, NULL },
  { "Ccedilla",                          722, NULL },
  { "Igrave",                            278, NULL },
  { "commaaccent",                       250, NULL },
  { "W",                                 944, NULL },
  { "bracketright",                      278, NULL },
  { "Ugrave",                            722, NULL },
  { "germandbls",                        611, NULL },
  { "thorn",                             556, NULL },
  { "G",                                 778, NULL },
  { "Ocircumflex",                       778, NULL },
  { "F",                                 611, NULL },
  { "Uring",                             722, NULL },
  { "perthousand",                      1000, NULL },
  { "Edotaccent",                        667, NULL },
  { "acircumflex",                       556, NULL },
  { "amacron",                           556, NULL },
  { "Ncommaaccent",                      722, NULL },
  { "numbersign",                        556, NULL },
  { "divide",                            584, NULL },
  { "emacron",                           556, NULL },
  { "M",                                 833, NULL },
  { "odieresis",                         556, NULL },
  { "Ograve",                            778, NULL },
  { "T",                                 611, NULL },
  { "w",                                 722, NULL },
  { "Thorn",                             667, NULL },
  { "space",                             278, NULL },
  { "twosuperior",                       333, NULL },
  { "eth",                               556, NULL },
  { "ecaron",                            556, NULL },
  { "brokenbar",                         260, NULL },
  { "Aogonek",                           667, NULL },
  { "fl",                                500, NULL },
  { "E",                                 667, NULL },
  { "quotedblbase",                      333, NULL },
  { "guillemotleft",                     556, NULL },
  { "endash",                            556, NULL }
};

static BuiltinFontWidth symbolWidthsTab[] = {
  { "copyrightsans",                     790, NULL },
  { "Upsilon",                           690, NULL },
  { "sigma",                             603, NULL },
  { "kappa",                             549, NULL },
  { "circleplus",                        768, NULL },
  { "degree",                            400, NULL },
  { "florin",                            500, NULL },
  { "Euro",                              750, NULL },
  { "phi1",                              603, NULL },
  { "club",                              753, NULL },
  { "radicalex",                         500, NULL },
  { "theta",                             521, NULL },
  { "Upsilon1",                          620, NULL },
  { "radical",                           549, NULL },
  { "angle",                             768, NULL },
  { "colon",                             278, NULL },
  { "plusminus",                         549, NULL },
  { "five",                              500, NULL },
  { "weierstrass",                       987, NULL },
  { "gamma",                             411, NULL },
  { "theta1",                            631, NULL },
  { "Zeta",                              611, NULL },
  { "angleleft",                         329, NULL },
  { "copyrightserif",                    790, NULL },
  { "logicaland",                        603, NULL },
  { "arrowvertex",                       603, NULL },
  { "arrowleft",                         987, NULL },
  { "Omicron",                           722, NULL },
  { "propersubset",                      713, NULL },
  { "equivalence",                       549, NULL },
  { "circlemultiply",                    768, NULL },
  { "greater",                           549, NULL },
  { "minute",                            247, NULL },
  { "integral",                          274, NULL },
  { "percent",                           833, NULL },
  { "omega",                             686, NULL },
  { "Beta",                              667, NULL },
  { "equal",                             549, NULL },
  { "therefore",                         863, NULL },
  { "braceleftmid",                      494, NULL },
  { "parenrighttp",                      384, NULL },
  { "bracketright",                      333, NULL },
  { "omicron",                           549, NULL },
  { "Epsilon",                           611, NULL },
  { "Nu",                                722, NULL },
  { "zero",                              500, NULL },
  { "period",                            250, NULL },
  { "Gamma",                             603, NULL },
  { "product",                           823, NULL },
  { "arrowboth",                        1042, NULL },
  { "Ifraktur",                          686, NULL },
  { "infinity",                          713, NULL },
  { "heart",                             753, NULL },
  { "parenrightex",                      384, NULL },
  { "arrowdown",                         603, NULL },
  { "bracketleftbt",                     384, NULL },
  { "logicalor",                         603, NULL },
  { "numbersign",                        500, NULL },
  { "divide",                            549, NULL },
  { "nu",                                521, NULL },
  { "spade",                             753, NULL },
  { "rho",                               549, NULL },
  { "Sigma",                             592, NULL },
  { "integralex",                        686, NULL },
  { "space",                             250, NULL },
  { "reflexsuperset",                    713, NULL },
  { "alpha",                             631, NULL },
  { "parenleftex",                       384, NULL },
  { "lessequal",                         549, NULL },
  { "second",                            411, NULL },
  { "integraltp",                        686, NULL },
  { "approxequal",                       549, NULL },
  { "existential",                       549, NULL },
  { "diamond",                           753, NULL },
  { "phi",                               521, NULL },
  { "nine",                              500, NULL },
  { "Iota",                              333, NULL },
  { "parenleft",                         333, NULL },
  { "tau",                               439, NULL },
  { "Tau",                               611, NULL },
  { "less",                              549, NULL },
  { "Eta",                               722, NULL },
  { "minus",                             549, NULL },
  { "four",                              500, NULL },
  { "bracketleftex",                     384, NULL },
  { "arrowdblboth",                     1042, NULL },
  { "arrowup",                           603, NULL },
  { "arrowright",                        987, NULL },
  { "integralbt",                        686, NULL },
  { "similar",                           549, NULL },
  { "underscore",                        500, NULL },
  { "dotmath",                           250, NULL },
  { "mu",                                576, NULL },
  { "trademarkserif",                    890, NULL },
  { "Chi",                               722, NULL },
  { "angleright",                        329, NULL },
  { "logicalnot",                        713, NULL },
  { "parenlefttp",                       384, NULL },
  { "partialdiff",                       494, NULL },
  { "arrowdblright",                     987, NULL },
  { "summation",                         713, NULL },
  { "question",                          444, NULL },
  { "apple",                             790, NULL },
  { "plus",                              549, NULL },
  { "epsilon",                           439, NULL },
  { "reflexsubset",                      713, NULL },
  { "six",                               500, NULL },
  { "arrowdbldown",                      603, NULL },
  { "Omega",                             768, NULL },
  { "bar",                               200, NULL },
  { "multiply",                          549, NULL },
  { "braceright",                        480, NULL },
  { "braceleft",                         480, NULL },
  { "braceleftbt",                       494, NULL },
  { "delta",                             494, NULL },
  { "arrowdblleft",                      987, NULL },
  { "ampersand",                         778, NULL },
  { "arrowdblup",                        603, NULL },
  { "aleph",                             823, NULL },
  { "two",                               500, NULL },
  { "bracerighttp",                      494, NULL },
  { "seven",                             500, NULL },
  { "propersuperset",                    713, NULL },
  { "bullet",                            460, NULL },
  { "perpendicular",                     658, NULL },
  { "Lambda",                            686, NULL },
  { "parenrightbt",                      384, NULL },
  { "bracerightmid",                     494, NULL },
  { "comma",                             250, NULL },
  { "Delta",                             612, NULL },
  { "bracerightbt",                      494, NULL },
  { "union",                             768, NULL },
  { "arrowhorizex",                     1000, NULL },
  { "omega1",                            713, NULL },
  { "proportional",                      713, NULL },
  { "sigma1",                            439, NULL },
  { "carriagereturn",                    658, NULL },
  { "suchthat",                          439, NULL },
  { "notelement",                        713, NULL },
  { "beta",                              549, NULL },
  { "parenright",                        333, NULL },
  { "bracketleft",                       333, NULL },
  { "fraction",                          167, NULL },
  { "Xi",                                645, NULL },
  { "pi",                                549, NULL },
  { "braceex",                           494, NULL },
  { "bracketlefttp",                     384, NULL },
  { "notsubset",                         713, NULL },
  { "asteriskmath",                      500, NULL },
  { "greaterequal",                      549, NULL },
  { "emptyset",                          823, NULL },
  { "bracketrightex",                    384, NULL },
  { "gradient",                          713, NULL },
  { "exclam",                            333, NULL },
  { "notequal",                          549, NULL },
  { "congruent",                         549, NULL },
  { "Pi",                                768, NULL },
  { "Theta",                             741, NULL },
  { "Rfraktur",                          795, NULL },
  { "bracketrighttp",                    384, NULL },
  { "parenleftbt",                       384, NULL },
  { "universal",                         713, NULL },
  { "upsilon",                           576, NULL },
  { "psi",                               686, NULL },
  { "eight",                             500, NULL },
  { "one",                               500, NULL },
  { "Kappa",                             722, NULL },
  { "ellipsis",                         1000, NULL },
  { "chi",                               549, NULL },
  { "trademarksans",                     786, NULL },
  { "Rho",                               556, NULL },
  { "Alpha",                             722, NULL },
  { "bracketrightbt",                    384, NULL },
  { "intersection",                      768, NULL },
  { "xi",                                493, NULL },
  { "slash",                             278, NULL },
  { "registerserif",                     790, NULL },
  { "iota",                              329, NULL },
  { "Psi",                               795, NULL },
  { "three",                             500, NULL },
  { "lozenge",                           494, NULL },
  { "Phi",                               763, NULL },
  { "zeta",                              494, NULL },
  { "lambda",                            549, NULL },
  { "Mu",                                889, NULL },
  { "bracelefttp",                       494, NULL },
  { "eta",                               603, NULL },
  { "registersans",                      790, NULL },
  { "element",                           713, NULL },
  { "semicolon",                         278, NULL }
};

static BuiltinFontWidth timesBoldWidthsTab[] = {
  { "cacute",                            444, NULL },
  { "Dcroat",                            722, NULL },
  { "tcaron",                            416, NULL },
  { "rcaron",                            444, NULL },
  { "ncommaaccent",                      556, NULL },
  { "tcommaaccent",                      333, NULL },
  { "logicalnot",                        570, NULL },
  { "m",                                 833, NULL },
  { "OE",                               1000, NULL },
  { "partialdiff",                       494, NULL },
  { "U",                                 722, NULL },
  { "x",                                 500, NULL },
  { "y",                                 500, NULL },
  { "Iogonek",                           389, NULL },
  { "edieresis",                         444, NULL },
  { "Ncaron",                            722, NULL },
  { "question",                          500, NULL },
  { "summation",                         600, NULL },
  { "A",                                 722, NULL },
  { "igrave",                            278, NULL },
  { "dcroat",                            556, NULL },
  { "guilsinglleft",                     333, NULL },
  { "h",                                 556, NULL },
  { "Cacute",                            722, NULL },
  { "plus",                              570, NULL },
  { "P",                                 611, NULL },
  { "lslash",                            278, NULL },
  { "six",                               500, NULL },
  { "edotaccent",                        444, NULL },
  { "bar",                               220, NULL },
  { "quotesingle",                       278, NULL },
  { "multiply",                          570, NULL },
  { "i",                                 278, NULL },
  { "onequarter",                        750, NULL },
  { "braceright",                        394, NULL },
  { "braceleft",                         394, NULL },
  { "acute",                             333, NULL },
  { "oacute",                            500, NULL },
  { "Yacute",                            722, NULL },
  { "daggerdbl",                         500, NULL },
  { "Atilde",                            722, NULL },
  { "Edieresis",                         667, NULL },
  { "ntilde",                            556, NULL },
  { "fi",                                556, NULL },
  { "trademark",                        1000, NULL },
  { "ampersand",                         833, NULL },
  { "Lcommaaccent",                      667, NULL },
  { "O",                                 778, NULL },
  { "Icircumflex",                       389, NULL },
  { "nacute",                            556, NULL },
  { "dieresis",                          333, NULL },
  { "Eacute",                            667, NULL },
  { "two",                               500, NULL },
  { "uacute",                            556, NULL },
  { "seven",                             500, NULL },
  { "Udieresis",                         722, NULL },
  { "Abreve",                            722, NULL },
  { "Iacute",                            389, NULL },
  { "bullet",                            350, NULL },
  { "eogonek",                           444, NULL },
  { "eacute",                            444, NULL },
  { "Zdotaccent",                        667, NULL },
  { "scaron",                            389, NULL },
  { "guillemotright",                    500, NULL },
  { "aacute",                            500, NULL },
  { "Otilde",                            778, NULL },
  { "umacron",                           556, NULL },
  { "Tcaron",                            667, NULL },
  { "ugrave",                            556, NULL },
  { "dcaron",                            672, NULL },
  { "hyphen",                            333, NULL },
  { "Oslash",                            778, NULL },
  { "a",                                 500, NULL },
  { "B",                                 667, NULL },
  { "yacute",                            500, NULL },
  { "kcommaaccent",                      556, NULL },
  { "Rcaron",                            722, NULL },
  { "R",                                 722, NULL },
  { "ydieresis",                         500, NULL },
  { "S",                                 556, NULL },
  { "omacron",                           500, NULL },
  { "comma",                             250, NULL },
  { "Delta",                             612, NULL },
  { "Gbreve",                            778, NULL },
  { "ordfeminine",                       300, NULL },
  { "quotedblleft",                      500, NULL },
  { "Rcommaaccent",                      722, NULL },
  { "ograve",                            500, NULL },
  { "Lacute",                            667, NULL },
  { "Idieresis",                         389, NULL },
  { "sacute",                            389, NULL },
  { "f",                                 333, NULL },
  { "otilde",                            500, NULL },
  { "parenright",                        333, NULL },
  { "gcommaaccent",                      500, NULL },
  { "Ohungarumlaut",                     778, NULL },
  { "bracketleft",                       333, NULL },
  { "fraction",                          167, NULL },
  { "Sacute",                            556, NULL },
  { "Adieresis",                         722, NULL },
  { "Uacute",                            722, NULL },
  { "atilde",                            500, NULL },
  { "Zacute",                            667, NULL },
  { "asciitilde",                        520, NULL },
  { "H",                                 778, NULL },
  { "sterling",                          500, NULL },
  { "greaterequal",                      549, NULL },
  { "at",                                930, NULL },
  { "Lslash",                            667, NULL },
  { "Uogonek",                           722, NULL },
  { "caron",                             333, NULL },
  { "lacute",                            278, NULL },
  { "notequal",                          549, NULL },
  { "Agrave",                            722, NULL },
  { "AE",                               1000, NULL },
  { "exclam",                            333, NULL },
  { "Acircumflex",                       722, NULL },
  { "oslash",                            500, NULL },
  { "threequarters",                     750, NULL },
  { "J",                                 500, NULL },
  { "ohungarumlaut",                     500, NULL },
  { "Ecircumflex",                       667, NULL },
  { "L",                                 667, NULL },
  { "z",                                 444, NULL },
  { "Uhungarumlaut",                     722, NULL },
  { "egrave",                            444, NULL },
  { "uring",                             556, NULL },
  { "s",                                 389, NULL },
  { "c",                                 444, NULL },
  { "d",                                 556, NULL },
  { "eight",                             500, NULL },
  { "I",                                 389, NULL },
  { "one",                               500, NULL },
  { "periodcentered",                    250, NULL },
  { "ellipsis",                         1000, NULL },
  { "Aring",                             722, NULL },
  { "agrave",                            500, NULL },
  { "Oacute",                            778, NULL },
  { "t",                                 333, NULL },
  { "quotedbl",                          555, NULL },
  { "Eogonek",                           667, NULL },
  { "macron",                            333, NULL },
  { "Lcaron",                            667, NULL },
  { "ordmasculine",                      330, NULL },
  { "questiondown",                      500, NULL },
  { "backslash",                         278, NULL },
  { "slash",                             278, NULL },
  { "r",                                 444, NULL },
  { "ucircumflex",                       556, NULL },
  { "three",                             500, NULL },
  { "lozenge",                           494, NULL },
  { "V",                                 722, NULL },
  { "Q",                                 778, NULL },
  { "exclamdown",                        333, NULL },
  { "Umacron",                           722, NULL },
  { "zacute",                            444, NULL },
  { "ncaron",                            556, NULL },
  { "adieresis",                         500, NULL },
  { "quoteright",                        333, NULL },
  { "uogonek",                           556, NULL },
  { "semicolon",                         333, NULL },
  { "guilsinglright",                    333, NULL },
  { "Amacron",                           722, NULL },
  { "breve",                             333, NULL },
  { "Dcaron",                            722, NULL },
  { "Z",                                 667, NULL },
  { "ecircumflex",                       444, NULL },
  { "lcaron",                            394, NULL },
  { "paragraph",                         540, NULL },
  { "zcaron",                            444, NULL },
  { "aring",                             500, NULL },
  { "Ydieresis",                         722, NULL },
  { "section",                           500, NULL },
  { "Scaron",                            556, NULL },
  { "degree",                            400, NULL },
  { "Euro",                              500, NULL },
  { "florin",                            500, NULL },
  { "iogonek",                           278, NULL },
  { "Scommaaccent",                      556, NULL },
  { "Aacute",                            722, NULL },
  { "b",                                 556, NULL },
  { "K",                                 778, NULL },
  { "dotlessi",                          278, NULL },
  { "p",                                 556, NULL },
  { "Ntilde",                            722, NULL },
  { "radical",                           549, NULL },
  { "g",                                 500, NULL },
  { "colon",                             333, NULL },
  { "ccedilla",                          444, NULL },
  { "plusminus",                         570, NULL },
  { "cedilla",                           333, NULL },
  { "Idotaccent",                        389, NULL },
  { "quotedblright",                     500, NULL },
  { "Eth",                               722, NULL },
  { "five",                              500, NULL },
  { "X",                                 722, NULL },
  { "asciicircum",                       581, NULL },
  { "Odieresis",                         778, NULL },
  { "oe",                                722, NULL },
  { "aogonek",                           500, NULL },
  { "Egrave",                            667, NULL },
  { "ring",                              333, NULL },
  { "emdash",                           1000, NULL },
  { "Gcommaaccent",                      778, NULL },
  { "quoteleft",                         333, NULL },
  { "registered",                        747, NULL },
  { "k",                                 556, NULL },
  { "copyright",                         747, NULL },
  { "Racute",                            722, NULL },
  { "lcommaaccent",                      278, NULL },
  { "onehalf",                           750, NULL },
  { "uhungarumlaut",                     556, NULL },
  { "gbreve",                            500, NULL },
  { "Ecaron",                            667, NULL },
  { "threesuperior",                     300, NULL },
  { "zdotaccent",                        444, NULL },
  { "n",                                 556, NULL },
  { "Emacron",                           667, NULL },
  { "asterisk",                          500, NULL },
  { "scommaaccent",                      389, NULL },
  { "onesuperior",                       300, NULL },
  { "greater",                           570, NULL },
  { "percent",                          1000, NULL },
  { "o",                                 500, NULL },
  { "abreve",                            500, NULL },
  { "Imacron",                           389, NULL },
  { "iacute",                            278, NULL },
  { "e",                                 444, NULL },
  { "icircumflex",                       278, NULL },
  { "q",                                 556, NULL },
  { "l",                                 278, NULL },
  { "dagger",                            500, NULL },
  { "equal",                             570, NULL },
  { "N",                                 722, NULL },
  { "C",                                 722, NULL },
  { "u",                                 556, NULL },
  { "Ugrave",                            722, NULL },
  { "germandbls",                        556, NULL },
  { "thorn",                             556, NULL },
  { "commaaccent",                       250, NULL },
  { "bracketright",                      333, NULL },
  { "W",                                1000, NULL },
  { "Ccedilla",                          722, NULL },
  { "Igrave",                            389, NULL },
  { "zero",                              500, NULL },
  { "period",                            250, NULL },
  { "scedilla",                          389, NULL },
  { "udieresis",                         556, NULL },
  { "perthousand",                      1000, NULL },
  { "Edotaccent",                        667, NULL },
  { "acircumflex",                       500, NULL },
  { "Ocircumflex",                       778, NULL },
  { "F",                                 611, NULL },
  { "Uring",                             722, NULL },
  { "G",                                 778, NULL },
  { "T",                                 667, NULL },
  { "M",                                 944, NULL },
  { "odieresis",                         500, NULL },
  { "Ograve",                            778, NULL },
  { "numbersign",                        500, NULL },
  { "divide",                            570, NULL },
  { "emacron",                           444, NULL },
  { "amacron",                           500, NULL },
  { "Ncommaaccent",                      722, NULL },
  { "endash",                            500, NULL },
  { "guillemotleft",                     500, NULL },
  { "fl",                                556, NULL },
  { "E",                                 667, NULL },
  { "quotedblbase",                      500, NULL },
  { "ecaron",                            444, NULL },
  { "Aogonek",                           722, NULL },
  { "brokenbar",                         220, NULL },
  { "w",                                 722, NULL },
  { "Thorn",                             611, NULL },
  { "space",                             250, NULL },
  { "eth",                               500, NULL },
  { "twosuperior",                       300, NULL },
  { "Y",                                 722, NULL },
  { "yen",                               500, NULL },
  { "hungarumlaut",                      333, NULL },
  { "Ccaron",                            722, NULL },
  { "j",                                 333, NULL },
  { "Omacron",                           778, NULL },
  { "lessequal",                         549, NULL },
  { "Ucircumflex",                       722, NULL },
  { "ccaron",                            444, NULL },
  { "grave",                             333, NULL },
  { "Scedilla",                          556, NULL },
  { "quotesinglbase",                    333, NULL },
  { "currency",                          500, NULL },
  { "nine",                              500, NULL },
  { "parenleft",                         333, NULL },
  { "ogonek",                            333, NULL },
  { "idieresis",                         278, NULL },
  { "circumflex",                        333, NULL },
  { "Zcaron",                            667, NULL },
  { "ocircumflex",                       500, NULL },
  { "less",                              570, NULL },
  { "minus",                             570, NULL },
  { "four",                              500, NULL },
  { "ae",                                722, NULL },
  { "cent",                              500, NULL },
  { "Tcommaaccent",                      667, NULL },
  { "dollar",                            500, NULL },
  { "v",                                 500, NULL },
  { "Nacute",                            722, NULL },
  { "dotaccent",                         333, NULL },
  { "underscore",                        500, NULL },
  { "D",                                 722, NULL },
  { "mu",                                556, NULL },
  { "racute",                            444, NULL },
  { "rcommaaccent",                      444, NULL },
  { "imacron",                           278, NULL },
  { "Kcommaaccent",                      778, NULL },
  { "tilde",                             333, NULL }
};

static BuiltinFontWidth timesBoldItalicWidthsTab[] = {
  { "M",                                 889, NULL },
  { "odieresis",                         500, NULL },
  { "Ograve",                            722, NULL },
  { "T",                                 611, NULL },
  { "amacron",                           500, NULL },
  { "Ncommaaccent",                      722, NULL },
  { "numbersign",                        500, NULL },
  { "divide",                            570, NULL },
  { "emacron",                           444, NULL },
  { "fl",                                556, NULL },
  { "E",                                 667, NULL },
  { "quotedblbase",                      500, NULL },
  { "endash",                            500, NULL },
  { "guillemotleft",                     500, NULL },
  { "w",                                 667, NULL },
  { "Thorn",                             611, NULL },
  { "space",                             250, NULL },
  { "eth",                               500, NULL },
  { "twosuperior",                       300, NULL },
  { "ecaron",                            444, NULL },
  { "Aogonek",                           667, NULL },
  { "brokenbar",                         220, NULL },
  { "commaaccent",                       250, NULL },
  { "bracketright",                      333, NULL },
  { "W",                                 889, NULL },
  { "Ugrave",                            722, NULL },
  { "germandbls",                        500, NULL },
  { "thorn",                             500, NULL },
  { "zero",                              500, NULL },
  { "period",                            250, NULL },
  { "scedilla",                          389, NULL },
  { "udieresis",                         556, NULL },
  { "Ccedilla",                          667, NULL },
  { "Igrave",                            389, NULL },
  { "Ocircumflex",                       722, NULL },
  { "F",                                 667, NULL },
  { "Uring",                             722, NULL },
  { "Edotaccent",                        667, NULL },
  { "perthousand",                      1000, NULL },
  { "acircumflex",                       500, NULL },
  { "G",                                 722, NULL },
  { "circumflex",                        333, NULL },
  { "Zcaron",                            611, NULL },
  { "ogonek",                            333, NULL },
  { "idieresis",                         278, NULL },
  { "ae",                                722, NULL },
  { "cent",                              500, NULL },
  { "ocircumflex",                       500, NULL },
  { "less",                              570, NULL },
  { "minus",                             606, NULL },
  { "four",                              500, NULL },
  { "dollar",                            500, NULL },
  { "Tcommaaccent",                      611, NULL },
  { "v",                                 444, NULL },
  { "Nacute",                            722, NULL },
  { "dotaccent",                         333, NULL },
  { "rcommaaccent",                      389, NULL },
  { "Kcommaaccent",                      667, NULL },
  { "imacron",                           278, NULL },
  { "tilde",                             333, NULL },
  { "underscore",                        500, NULL },
  { "mu",                                576, NULL },
  { "D",                                 722, NULL },
  { "racute",                            389, NULL },
  { "hungarumlaut",                      333, NULL },
  { "j",                                 278, NULL },
  { "Ccaron",                            667, NULL },
  { "yen",                               500, NULL },
  { "Y",                                 611, NULL },
  { "ccaron",                            444, NULL },
  { "lessequal",                         549, NULL },
  { "Ucircumflex",                       722, NULL },
  { "Omacron",                           722, NULL },
  { "quotesinglbase",                    333, NULL },
  { "grave",                             333, NULL },
  { "Scedilla",                          556, NULL },
  { "parenleft",                         333, NULL },
  { "currency",                          500, NULL },
  { "nine",                              500, NULL },
  { "Ntilde",                            722, NULL },
  { "radical",                           549, NULL },
  { "dotlessi",                          278, NULL },
  { "p",                                 500, NULL },
  { "plusminus",                         570, NULL },
  { "Idotaccent",                        389, NULL },
  { "cedilla",                           333, NULL },
  { "quotedblright",                     500, NULL },
  { "Eth",                               722, NULL },
  { "colon",                             333, NULL },
  { "g",                                 500, NULL },
  { "ccedilla",                          444, NULL },
  { "Odieresis",                         722, NULL },
  { "oe",                                722, NULL },
  { "five",                              500, NULL },
  { "X",                                 667, NULL },
  { "asciicircum",                       570, NULL },
  { "emdash",                           1000, NULL },
  { "aogonek",                           500, NULL },
  { "Egrave",                            667, NULL },
  { "ring",                              333, NULL },
  { "Dcaron",                            722, NULL },
  { "Z",                                 611, NULL },
  { "ecircumflex",                       444, NULL },
  { "Amacron",                           667, NULL },
  { "breve",                             333, NULL },
  { "lcaron",                            382, NULL },
  { "paragraph",                         500, NULL },
  { "zcaron",                            389, NULL },
  { "aring",                             500, NULL },
  { "Ydieresis",                         611, NULL },
  { "Euro",                              500, NULL },
  { "iogonek",                           278, NULL },
  { "florin",                            500, NULL },
  { "section",                           500, NULL },
  { "Scaron",                            556, NULL },
  { "degree",                            400, NULL },
  { "K",                                 667, NULL },
  { "Scommaaccent",                      556, NULL },
  { "Aacute",                            667, NULL },
  { "b",                                 500, NULL },
  { "greater",                           570, NULL },
  { "asterisk",                          500, NULL },
  { "Emacron",                           667, NULL },
  { "scommaaccent",                      389, NULL },
  { "onesuperior",                       300, NULL },
  { "percent",                           833, NULL },
  { "o",                                 500, NULL },
  { "icircumflex",                       278, NULL },
  { "abreve",                            500, NULL },
  { "Imacron",                           389, NULL },
  { "e",                                 444, NULL },
  { "iacute",                            278, NULL },
  { "dagger",                            500, NULL },
  { "equal",                             570, NULL },
  { "N",                                 722, NULL },
  { "C",                                 667, NULL },
  { "u",                                 556, NULL },
  { "q",                                 500, NULL },
  { "l",                                 278, NULL },
  { "quoteleft",                         333, NULL },
  { "registered",                        747, NULL },
  { "Gcommaaccent",                      722, NULL },
  { "Racute",                            667, NULL },
  { "k",                                 500, NULL },
  { "copyright",                         747, NULL },
  { "lcommaaccent",                      278, NULL },
  { "onehalf",                           750, NULL },
  { "gbreve",                            500, NULL },
  { "uhungarumlaut",                     556, NULL },
  { "n",                                 556, NULL },
  { "Ecaron",                            667, NULL },
  { "threesuperior",                     300, NULL },
  { "zdotaccent",                        389, NULL },
  { "Uacute",                            722, NULL },
  { "atilde",                            500, NULL },
  { "Zacute",                            611, NULL },
  { "fraction",                          167, NULL },
  { "Sacute",                            556, NULL },
  { "Adieresis",                         667, NULL },
  { "asciitilde",                        570, NULL },
  { "Uogonek",                           722, NULL },
  { "Lslash",                            611, NULL },
  { "caron",                             333, NULL },
  { "lacute",                            278, NULL },
  { "H",                                 778, NULL },
  { "sterling",                          500, NULL },
  { "greaterequal",                      549, NULL },
  { "at",                                832, NULL },
  { "threequarters",                     750, NULL },
  { "J",                                 500, NULL },
  { "ohungarumlaut",                     500, NULL },
  { "Ecircumflex",                       667, NULL },
  { "L",                                 611, NULL },
  { "notequal",                          549, NULL },
  { "Agrave",                            667, NULL },
  { "exclam",                            389, NULL },
  { "AE",                                944, NULL },
  { "Acircumflex",                       667, NULL },
  { "oslash",                            500, NULL },
  { "ograve",                            500, NULL },
  { "Rcommaaccent",                      667, NULL },
  { "Lacute",                            611, NULL },
  { "sacute",                            389, NULL },
  { "Idieresis",                         389, NULL },
  { "f",                                 333, NULL },
  { "gcommaaccent",                      500, NULL },
  { "Ohungarumlaut",                     722, NULL },
  { "bracketleft",                       333, NULL },
  { "otilde",                            500, NULL },
  { "parenright",                        333, NULL },
  { "Eogonek",                           667, NULL },
  { "macron",                            333, NULL },
  { "backslash",                         278, NULL },
  { "Lcaron",                            611, NULL },
  { "ordmasculine",                      300, NULL },
  { "questiondown",                      500, NULL },
  { "three",                             500, NULL },
  { "slash",                             278, NULL },
  { "r",                                 389, NULL },
  { "ucircumflex",                       556, NULL },
  { "zacute",                            389, NULL },
  { "Umacron",                           722, NULL },
  { "ncaron",                            556, NULL },
  { "adieresis",                         500, NULL },
  { "lozenge",                           494, NULL },
  { "V",                                 667, NULL },
  { "Q",                                 722, NULL },
  { "exclamdown",                        389, NULL },
  { "quoteright",                        333, NULL },
  { "uogonek",                           556, NULL },
  { "semicolon",                         333, NULL },
  { "guilsinglright",                    333, NULL },
  { "egrave",                            444, NULL },
  { "uring",                             556, NULL },
  { "s",                                 389, NULL },
  { "z",                                 389, NULL },
  { "Uhungarumlaut",                     722, NULL },
  { "one",                               500, NULL },
  { "I",                                 389, NULL },
  { "eight",                             500, NULL },
  { "periodcentered",                    250, NULL },
  { "c",                                 444, NULL },
  { "d",                                 500, NULL },
  { "agrave",                            500, NULL },
  { "ellipsis",                         1000, NULL },
  { "Aring",                             667, NULL },
  { "t",                                 278, NULL },
  { "quotedbl",                          555, NULL },
  { "Oacute",                            722, NULL },
  { "six",                               500, NULL },
  { "edotaccent",                        444, NULL },
  { "lslash",                            278, NULL },
  { "P",                                 611, NULL },
  { "i",                                 278, NULL },
  { "multiply",                          570, NULL },
  { "bar",                               220, NULL },
  { "quotesingle",                       278, NULL },
  { "braceleft",                         348, NULL },
  { "braceright",                        348, NULL },
  { "acute",                             333, NULL },
  { "onequarter",                        750, NULL },
  { "Atilde",                            667, NULL },
  { "Edieresis",                         667, NULL },
  { "oacute",                            500, NULL },
  { "Yacute",                            611, NULL },
  { "daggerdbl",                         500, NULL },
  { "ncommaaccent",                      556, NULL },
  { "tcommaaccent",                      278, NULL },
  { "logicalnot",                        606, NULL },
  { "cacute",                            444, NULL },
  { "Dcroat",                            722, NULL },
  { "tcaron",                            366, NULL },
  { "rcaron",                            389, NULL },
  { "x",                                 500, NULL },
  { "Iogonek",                           389, NULL },
  { "edieresis",                         444, NULL },
  { "y",                                 444, NULL },
  { "Ncaron",                            722, NULL },
  { "m",                                 778, NULL },
  { "OE",                                944, NULL },
  { "U",                                 722, NULL },
  { "partialdiff",                       494, NULL },
  { "igrave",                            278, NULL },
  { "dcroat",                            500, NULL },
  { "question",                          500, NULL },
  { "summation",                         600, NULL },
  { "A",                                 667, NULL },
  { "guilsinglleft",                     333, NULL },
  { "Cacute",                            667, NULL },
  { "h",                                 556, NULL },
  { "plus",                              570, NULL },
  { "Otilde",                            722, NULL },
  { "umacron",                           556, NULL },
  { "Tcaron",                            611, NULL },
  { "aacute",                            500, NULL },
  { "B",                                 667, NULL },
  { "kcommaaccent",                      500, NULL },
  { "Rcaron",                            667, NULL },
  { "yacute",                            444, NULL },
  { "ydieresis",                         444, NULL },
  { "R",                                 667, NULL },
  { "ugrave",                            556, NULL },
  { "dcaron",                            608, NULL },
  { "Oslash",                            722, NULL },
  { "hyphen",                            333, NULL },
  { "a",                                 500, NULL },
  { "omacron",                           500, NULL },
  { "Delta",                             612, NULL },
  { "comma",                             250, NULL },
  { "Gbreve",                            722, NULL },
  { "S",                                 556, NULL },
  { "quotedblleft",                      500, NULL },
  { "ordfeminine",                       266, NULL },
  { "trademark",                        1000, NULL },
  { "ampersand",                         778, NULL },
  { "Lcommaaccent",                      611, NULL },
  { "ntilde",                            556, NULL },
  { "fi",                                556, NULL },
  { "dieresis",                          333, NULL },
  { "Eacute",                            667, NULL },
  { "O",                                 722, NULL },
  { "Icircumflex",                       389, NULL },
  { "nacute",                            556, NULL },
  { "Abreve",                            667, NULL },
  { "Udieresis",                         722, NULL },
  { "Iacute",                            389, NULL },
  { "two",                               500, NULL },
  { "uacute",                            556, NULL },
  { "seven",                             500, NULL },
  { "scaron",                            389, NULL },
  { "guillemotright",                    500, NULL },
  { "bullet",                            350, NULL },
  { "eogonek",                           444, NULL },
  { "eacute",                            444, NULL },
  { "Zdotaccent",                        611, NULL }
};

static BuiltinFontWidth timesItalicWidthsTab[] = {
  { "quoteright",                        333, NULL },
  { "uogonek",                           500, NULL },
  { "semicolon",                         333, NULL },
  { "guilsinglright",                    333, NULL },
  { "Umacron",                           722, NULL },
  { "zacute",                            389, NULL },
  { "ncaron",                            500, NULL },
  { "adieresis",                         500, NULL },
  { "lozenge",                           471, NULL },
  { "V",                                 611, NULL },
  { "Q",                                 722, NULL },
  { "exclamdown",                        389, NULL },
  { "three",                             500, NULL },
  { "slash",                             278, NULL },
  { "r",                                 389, NULL },
  { "ucircumflex",                       500, NULL },
  { "Eogonek",                           611, NULL },
  { "macron",                            333, NULL },
  { "ordmasculine",                      310, NULL },
  { "Lcaron",                            611, NULL },
  { "questiondown",                      500, NULL },
  { "backslash",                         278, NULL },
  { "t",                                 278, NULL },
  { "quotedbl",                          420, NULL },
  { "Oacute",                            722, NULL },
  { "agrave",                            500, NULL },
  { "ellipsis",                          889, NULL },
  { "Aring",                             611, NULL },
  { "I",                                 333, NULL },
  { "one",                               500, NULL },
  { "eight",                             500, NULL },
  { "periodcentered",                    250, NULL },
  { "c",                                 444, NULL },
  { "d",                                 500, NULL },
  { "egrave",                            444, NULL },
  { "uring",                             500, NULL },
  { "s",                                 389, NULL },
  { "Uhungarumlaut",                     722, NULL },
  { "z",                                 389, NULL },
  { "threequarters",                     750, NULL },
  { "J",                                 444, NULL },
  { "ohungarumlaut",                     500, NULL },
  { "Ecircumflex",                       611, NULL },
  { "L",                                 556, NULL },
  { "notequal",                          549, NULL },
  { "Agrave",                            611, NULL },
  { "AE",                                889, NULL },
  { "exclam",                            333, NULL },
  { "Acircumflex",                       611, NULL },
  { "oslash",                            500, NULL },
  { "caron",                             333, NULL },
  { "Uogonek",                           722, NULL },
  { "Lslash",                            556, NULL },
  { "lacute",                            278, NULL },
  { "H",                                 722, NULL },
  { "sterling",                          500, NULL },
  { "at",                                920, NULL },
  { "greaterequal",                      549, NULL },
  { "asciitilde",                        541, NULL },
  { "Uacute",                            722, NULL },
  { "atilde",                            500, NULL },
  { "Zacute",                            556, NULL },
  { "fraction",                          167, NULL },
  { "Adieresis",                         611, NULL },
  { "Sacute",                            500, NULL },
  { "gcommaaccent",                      500, NULL },
  { "Ohungarumlaut",                     722, NULL },
  { "bracketleft",                       389, NULL },
  { "otilde",                            500, NULL },
  { "parenright",                        333, NULL },
  { "f",                                 278, NULL },
  { "Lacute",                            556, NULL },
  { "sacute",                            389, NULL },
  { "Idieresis",                         333, NULL },
  { "ograve",                            500, NULL },
  { "Rcommaaccent",                      611, NULL },
  { "quotedblleft",                      556, NULL },
  { "ordfeminine",                       276, NULL },
  { "omacron",                           500, NULL },
  { "Delta",                             612, NULL },
  { "comma",                             250, NULL },
  { "Gbreve",                            722, NULL },
  { "S",                                 500, NULL },
  { "B",                                 611, NULL },
  { "kcommaaccent",                      444, NULL },
  { "yacute",                            444, NULL },
  { "Rcaron",                            611, NULL },
  { "R",                                 611, NULL },
  { "ydieresis",                         444, NULL },
  { "ugrave",                            500, NULL },
  { "dcaron",                            544, NULL },
  { "Oslash",                            722, NULL },
  { "hyphen",                            333, NULL },
  { "a",                                 500, NULL },
  { "umacron",                           500, NULL },
  { "Otilde",                            722, NULL },
  { "Tcaron",                            556, NULL },
  { "aacute",                            500, NULL },
  { "scaron",                            389, NULL },
  { "guillemotright",                    500, NULL },
  { "eogonek",                           444, NULL },
  { "bullet",                            350, NULL },
  { "eacute",                            444, NULL },
  { "Zdotaccent",                        556, NULL },
  { "Udieresis",                         722, NULL },
  { "Abreve",                            611, NULL },
  { "Iacute",                            333, NULL },
  { "two",                               500, NULL },
  { "uacute",                            500, NULL },
  { "seven",                             500, NULL },
  { "dieresis",                          333, NULL },
  { "Eacute",                            611, NULL },
  { "O",                                 722, NULL },
  { "Icircumflex",                       333, NULL },
  { "nacute",                            500, NULL },
  { "trademark",                         980, NULL },
  { "ampersand",                         778, NULL },
  { "Lcommaaccent",                      556, NULL },
  { "ntilde",                            500, NULL },
  { "fi",                                500, NULL },
  { "Atilde",                            611, NULL },
  { "Edieresis",                         611, NULL },
  { "Yacute",                            556, NULL },
  { "oacute",                            500, NULL },
  { "daggerdbl",                         500, NULL },
  { "braceleft",                         400, NULL },
  { "braceright",                        400, NULL },
  { "acute",                             333, NULL },
  { "onequarter",                        750, NULL },
  { "multiply",                          675, NULL },
  { "i",                                 278, NULL },
  { "bar",                               275, NULL },
  { "quotesingle",                       214, NULL },
  { "six",                               500, NULL },
  { "edotaccent",                        444, NULL },
  { "P",                                 611, NULL },
  { "lslash",                            278, NULL },
  { "guilsinglleft",                     333, NULL },
  { "h",                                 500, NULL },
  { "Cacute",                            667, NULL },
  { "plus",                              675, NULL },
  { "igrave",                            278, NULL },
  { "dcroat",                            500, NULL },
  { "question",                          500, NULL },
  { "summation",                         600, NULL },
  { "A",                                 611, NULL },
  { "x",                                 444, NULL },
  { "Iogonek",                           333, NULL },
  { "y",                                 444, NULL },
  { "edieresis",                         444, NULL },
  { "Ncaron",                            667, NULL },
  { "m",                                 722, NULL },
  { "OE",                                944, NULL },
  { "U",                                 722, NULL },
  { "partialdiff",                       476, NULL },
  { "ncommaaccent",                      500, NULL },
  { "tcommaaccent",                      278, NULL },
  { "logicalnot",                        675, NULL },
  { "cacute",                            444, NULL },
  { "Dcroat",                            722, NULL },
  { "tcaron",                            300, NULL },
  { "rcaron",                            389, NULL },
  { "rcommaaccent",                      389, NULL },
  { "Kcommaaccent",                      667, NULL },
  { "imacron",                           278, NULL },
  { "tilde",                             333, NULL },
  { "underscore",                        500, NULL },
  { "mu",                                500, NULL },
  { "D",                                 722, NULL },
  { "racute",                            389, NULL },
  { "Tcommaaccent",                      556, NULL },
  { "dollar",                            500, NULL },
  { "v",                                 444, NULL },
  { "Nacute",                            667, NULL },
  { "dotaccent",                         333, NULL },
  { "ae",                                667, NULL },
  { "cent",                              500, NULL },
  { "ocircumflex",                       500, NULL },
  { "less",                              675, NULL },
  { "four",                              500, NULL },
  { "minus",                             675, NULL },
  { "circumflex",                        333, NULL },
  { "Zcaron",                            556, NULL },
  { "ogonek",                            333, NULL },
  { "idieresis",                         278, NULL },
  { "parenleft",                         333, NULL },
  { "currency",                          500, NULL },
  { "nine",                              500, NULL },
  { "quotesinglbase",                    333, NULL },
  { "grave",                             333, NULL },
  { "Scedilla",                          500, NULL },
  { "ccaron",                            444, NULL },
  { "lessequal",                         549, NULL },
  { "Omacron",                           722, NULL },
  { "Ucircumflex",                       722, NULL },
  { "hungarumlaut",                      333, NULL },
  { "j",                                 278, NULL },
  { "Ccaron",                            667, NULL },
  { "Y",                                 556, NULL },
  { "yen",                               500, NULL },
  { "w",                                 667, NULL },
  { "space",                             250, NULL },
  { "Thorn",                             611, NULL },
  { "eth",                               500, NULL },
  { "twosuperior",                       300, NULL },
  { "ecaron",                            444, NULL },
  { "brokenbar",                         275, NULL },
  { "Aogonek",                           611, NULL },
  { "fl",                                500, NULL },
  { "quotedblbase",                      556, NULL },
  { "E",                                 611, NULL },
  { "endash",                            500, NULL },
  { "guillemotleft",                     500, NULL },
  { "amacron",                           500, NULL },
  { "Ncommaaccent",                      667, NULL },
  { "numbersign",                        500, NULL },
  { "divide",                            675, NULL },
  { "emacron",                           444, NULL },
  { "M",                                 833, NULL },
  { "odieresis",                         500, NULL },
  { "Ograve",                            722, NULL },
  { "T",                                 556, NULL },
  { "G",                                 722, NULL },
  { "F",                                 611, NULL },
  { "Ocircumflex",                       722, NULL },
  { "Uring",                             722, NULL },
  { "Edotaccent",                        611, NULL },
  { "perthousand",                      1000, NULL },
  { "acircumflex",                       500, NULL },
  { "zero",                              500, NULL },
  { "period",                            250, NULL },
  { "scedilla",                          389, NULL },
  { "udieresis",                         500, NULL },
  { "Ccedilla",                          667, NULL },
  { "Igrave",                            333, NULL },
  { "commaaccent",                       250, NULL },
  { "bracketright",                      389, NULL },
  { "W",                                 833, NULL },
  { "Ugrave",                            722, NULL },
  { "germandbls",                        500, NULL },
  { "thorn",                             500, NULL },
  { "dagger",                            500, NULL },
  { "equal",                             675, NULL },
  { "N",                                 667, NULL },
  { "C",                                 667, NULL },
  { "u",                                 500, NULL },
  { "q",                                 500, NULL },
  { "l",                                 278, NULL },
  { "icircumflex",                       278, NULL },
  { "abreve",                            500, NULL },
  { "Imacron",                           333, NULL },
  { "iacute",                            278, NULL },
  { "e",                                 444, NULL },
  { "percent",                           833, NULL },
  { "o",                                 500, NULL },
  { "greater",                           675, NULL },
  { "Emacron",                           611, NULL },
  { "scommaaccent",                      389, NULL },
  { "asterisk",                          500, NULL },
  { "onesuperior",                       300, NULL },
  { "n",                                 500, NULL },
  { "Ecaron",                            611, NULL },
  { "threesuperior",                     300, NULL },
  { "zdotaccent",                        389, NULL },
  { "lcommaaccent",                      278, NULL },
  { "onehalf",                           750, NULL },
  { "gbreve",                            500, NULL },
  { "uhungarumlaut",                     500, NULL },
  { "Racute",                            611, NULL },
  { "k",                                 444, NULL },
  { "copyright",                         760, NULL },
  { "quoteleft",                         333, NULL },
  { "registered",                        760, NULL },
  { "Gcommaaccent",                      722, NULL },
  { "emdash",                            889, NULL },
  { "aogonek",                           500, NULL },
  { "Egrave",                            611, NULL },
  { "ring",                              333, NULL },
  { "Odieresis",                         722, NULL },
  { "oe",                                667, NULL },
  { "five",                              500, NULL },
  { "X",                                 611, NULL },
  { "asciicircum",                       422, NULL },
  { "plusminus",                         675, NULL },
  { "Idotaccent",                        333, NULL },
  { "cedilla",                           333, NULL },
  { "quotedblright",                     556, NULL },
  { "Eth",                               722, NULL },
  { "g",                                 500, NULL },
  { "colon",                             333, NULL },
  { "ccedilla",                          444, NULL },
  { "Ntilde",                            667, NULL },
  { "radical",                           453, NULL },
  { "dotlessi",                          278, NULL },
  { "p",                                 500, NULL },
  { "K",                                 667, NULL },
  { "Scommaaccent",                      500, NULL },
  { "Aacute",                            611, NULL },
  { "b",                                 500, NULL },
  { "Euro",                              500, NULL },
  { "iogonek",                           278, NULL },
  { "florin",                            500, NULL },
  { "section",                           500, NULL },
  { "Scaron",                            500, NULL },
  { "degree",                            400, NULL },
  { "lcaron",                            300, NULL },
  { "paragraph",                         523, NULL },
  { "zcaron",                            389, NULL },
  { "aring",                             500, NULL },
  { "Ydieresis",                         556, NULL },
  { "Dcaron",                            722, NULL },
  { "Z",                                 556, NULL },
  { "ecircumflex",                       444, NULL },
  { "Amacron",                           611, NULL },
  { "breve",                             333, NULL }
};

static BuiltinFontWidth timesRomanWidthsTab[] = {
  { "greaterequal",                      549, NULL },
  { "at",                                921, NULL },
  { "sterling",                          500, NULL },
  { "H",                                 722, NULL },
  { "caron",                             333, NULL },
  { "Uogonek",                           722, NULL },
  { "Lslash",                            611, NULL },
  { "lacute",                            278, NULL },
  { "Acircumflex",                       722, NULL },
  { "oslash",                            500, NULL },
  { "notequal",                          549, NULL },
  { "Agrave",                            722, NULL },
  { "AE",                                889, NULL },
  { "exclam",                            333, NULL },
  { "ohungarumlaut",                     500, NULL },
  { "L",                                 611, NULL },
  { "Ecircumflex",                       611, NULL },
  { "threequarters",                     750, NULL },
  { "J",                                 389, NULL },
  { "Sacute",                            556, NULL },
  { "Adieresis",                         722, NULL },
  { "fraction",                          167, NULL },
  { "atilde",                            444, NULL },
  { "Zacute",                            611, NULL },
  { "Uacute",                            722, NULL },
  { "asciitilde",                        541, NULL },
  { "f",                                 333, NULL },
  { "parenright",                        333, NULL },
  { "otilde",                            500, NULL },
  { "Ohungarumlaut",                     722, NULL },
  { "bracketleft",                       333, NULL },
  { "gcommaaccent",                      500, NULL },
  { "Rcommaaccent",                      667, NULL },
  { "ograve",                            500, NULL },
  { "sacute",                            389, NULL },
  { "Idieresis",                         333, NULL },
  { "Lacute",                            611, NULL },
  { "Q",                                 722, NULL },
  { "exclamdown",                        333, NULL },
  { "lozenge",                           471, NULL },
  { "V",                                 722, NULL },
  { "ncaron",                            500, NULL },
  { "adieresis",                         444, NULL },
  { "zacute",                            444, NULL },
  { "Umacron",                           722, NULL },
  { "semicolon",                         278, NULL },
  { "guilsinglright",                    333, NULL },
  { "quoteright",                        333, NULL },
  { "uogonek",                           500, NULL },
  { "Eogonek",                           611, NULL },
  { "macron",                            333, NULL },
  { "ordmasculine",                      310, NULL },
  { "Lcaron",                            611, NULL },
  { "backslash",                         278, NULL },
  { "questiondown",                      444, NULL },
  { "ucircumflex",                       500, NULL },
  { "r",                                 333, NULL },
  { "slash",                             278, NULL },
  { "three",                             500, NULL },
  { "Aring",                             722, NULL },
  { "ellipsis",                         1000, NULL },
  { "agrave",                            444, NULL },
  { "Oacute",                            722, NULL },
  { "quotedbl",                          408, NULL },
  { "t",                                 278, NULL },
  { "Uhungarumlaut",                     722, NULL },
  { "z",                                 444, NULL },
  { "uring",                             500, NULL },
  { "s",                                 389, NULL },
  { "egrave",                            444, NULL },
  { "c",                                 444, NULL },
  { "d",                                 500, NULL },
  { "periodcentered",                    250, NULL },
  { "I",                                 333, NULL },
  { "eight",                             500, NULL },
  { "one",                               500, NULL },
  { "onequarter",                        750, NULL },
  { "braceright",                        480, NULL },
  { "braceleft",                         480, NULL },
  { "acute",                             333, NULL },
  { "daggerdbl",                         500, NULL },
  { "oacute",                            500, NULL },
  { "Yacute",                            722, NULL },
  { "Edieresis",                         611, NULL },
  { "Atilde",                            722, NULL },
  { "P",                                 556, NULL },
  { "lslash",                            278, NULL },
  { "six",                               500, NULL },
  { "edotaccent",                        444, NULL },
  { "quotesingle",                       180, NULL },
  { "bar",                               200, NULL },
  { "i",                                 278, NULL },
  { "multiply",                          564, NULL },
  { "A",                                 722, NULL },
  { "question",                          444, NULL },
  { "summation",                         600, NULL },
  { "igrave",                            278, NULL },
  { "dcroat",                            500, NULL },
  { "plus",                              564, NULL },
  { "guilsinglleft",                     333, NULL },
  { "h",                                 500, NULL },
  { "Cacute",                            667, NULL },
  { "rcaron",                            333, NULL },
  { "tcaron",                            326, NULL },
  { "cacute",                            444, NULL },
  { "Dcroat",                            722, NULL },
  { "tcommaaccent",                      278, NULL },
  { "logicalnot",                        564, NULL },
  { "ncommaaccent",                      500, NULL },
  { "partialdiff",                       476, NULL },
  { "U",                                 722, NULL },
  { "m",                                 778, NULL },
  { "OE",                                889, NULL },
  { "Ncaron",                            722, NULL },
  { "x",                                 500, NULL },
  { "edieresis",                         444, NULL },
  { "Iogonek",                           333, NULL },
  { "y",                                 500, NULL },
  { "S",                                 556, NULL },
  { "Gbreve",                            722, NULL },
  { "omacron",                           500, NULL },
  { "comma",                             250, NULL },
  { "Delta",                             612, NULL },
  { "ordfeminine",                       276, NULL },
  { "quotedblleft",                      444, NULL },
  { "aacute",                            444, NULL },
  { "Tcaron",                            611, NULL },
  { "Otilde",                            722, NULL },
  { "umacron",                           500, NULL },
  { "Oslash",                            722, NULL },
  { "hyphen",                            333, NULL },
  { "a",                                 444, NULL },
  { "ugrave",                            500, NULL },
  { "dcaron",                            588, NULL },
  { "yacute",                            500, NULL },
  { "kcommaaccent",                      500, NULL },
  { "Rcaron",                            667, NULL },
  { "R",                                 667, NULL },
  { "ydieresis",                         500, NULL },
  { "B",                                 667, NULL },
  { "seven",                             500, NULL },
  { "two",                               500, NULL },
  { "uacute",                            500, NULL },
  { "Iacute",                            333, NULL },
  { "Abreve",                            722, NULL },
  { "Udieresis",                         722, NULL },
  { "Zdotaccent",                        611, NULL },
  { "eacute",                            444, NULL },
  { "eogonek",                           444, NULL },
  { "bullet",                            350, NULL },
  { "guillemotright",                    500, NULL },
  { "scaron",                            389, NULL },
  { "fi",                                556, NULL },
  { "ntilde",                            500, NULL },
  { "Lcommaaccent",                      611, NULL },
  { "trademark",                         980, NULL },
  { "ampersand",                         778, NULL },
  { "O",                                 722, NULL },
  { "Icircumflex",                       333, NULL },
  { "nacute",                            500, NULL },
  { "Eacute",                            611, NULL },
  { "dieresis",                          333, NULL },
  { "endash",                            500, NULL },
  { "guillemotleft",                     500, NULL },
  { "E",                                 611, NULL },
  { "quotedblbase",                      444, NULL },
  { "fl",                                556, NULL },
  { "brokenbar",                         200, NULL },
  { "Aogonek",                           722, NULL },
  { "ecaron",                            444, NULL },
  { "Thorn",                             556, NULL },
  { "space",                             250, NULL },
  { "twosuperior",                       300, NULL },
  { "eth",                               500, NULL },
  { "w",                                 722, NULL },
  { "T",                                 611, NULL },
  { "Ograve",                            722, NULL },
  { "M",                                 889, NULL },
  { "odieresis",                         500, NULL },
  { "divide",                            564, NULL },
  { "emacron",                           444, NULL },
  { "numbersign",                        500, NULL },
  { "Ncommaaccent",                      722, NULL },
  { "amacron",                           444, NULL },
  { "acircumflex",                       444, NULL },
  { "Edotaccent",                        611, NULL },
  { "perthousand",                      1000, NULL },
  { "Uring",                             722, NULL },
  { "Ocircumflex",                       722, NULL },
  { "F",                                 556, NULL },
  { "G",                                 722, NULL },
  { "thorn",                             500, NULL },
  { "Ugrave",                            722, NULL },
  { "germandbls",                        500, NULL },
  { "bracketright",                      333, NULL },
  { "W",                                 944, NULL },
  { "commaaccent",                       250, NULL },
  { "Igrave",                            333, NULL },
  { "Ccedilla",                          667, NULL },
  { "period",                            250, NULL },
  { "scedilla",                          389, NULL },
  { "udieresis",                         500, NULL },
  { "zero",                              500, NULL },
  { "v",                                 500, NULL },
  { "Nacute",                            722, NULL },
  { "dotaccent",                         333, NULL },
  { "Tcommaaccent",                      611, NULL },
  { "dollar",                            500, NULL },
  { "mu",                                500, NULL },
  { "D",                                 722, NULL },
  { "racute",                            333, NULL },
  { "underscore",                        500, NULL },
  { "tilde",                             333, NULL },
  { "rcommaaccent",                      333, NULL },
  { "Kcommaaccent",                      722, NULL },
  { "imacron",                           278, NULL },
  { "idieresis",                         278, NULL },
  { "ogonek",                            333, NULL },
  { "Zcaron",                            611, NULL },
  { "circumflex",                        333, NULL },
  { "four",                              500, NULL },
  { "minus",                             564, NULL },
  { "ocircumflex",                       500, NULL },
  { "less",                              564, NULL },
  { "cent",                              500, NULL },
  { "ae",                                667, NULL },
  { "grave",                             333, NULL },
  { "Scedilla",                          556, NULL },
  { "quotesinglbase",                    333, NULL },
  { "currency",                          500, NULL },
  { "nine",                              500, NULL },
  { "parenleft",                         333, NULL },
  { "yen",                               500, NULL },
  { "Y",                                 722, NULL },
  { "hungarumlaut",                      333, NULL },
  { "Ccaron",                            667, NULL },
  { "j",                                 278, NULL },
  { "lessequal",                         549, NULL },
  { "Ucircumflex",                       722, NULL },
  { "Omacron",                           722, NULL },
  { "ccaron",                            444, NULL },
  { "X",                                 722, NULL },
  { "asciicircum",                       469, NULL },
  { "five",                              500, NULL },
  { "Odieresis",                         722, NULL },
  { "oe",                                722, NULL },
  { "ring",                              333, NULL },
  { "Egrave",                            611, NULL },
  { "aogonek",                           444, NULL },
  { "emdash",                           1000, NULL },
  { "dotlessi",                          278, NULL },
  { "p",                                 500, NULL },
  { "radical",                           453, NULL },
  { "Ntilde",                            722, NULL },
  { "g",                                 500, NULL },
  { "colon",                             278, NULL },
  { "ccedilla",                          444, NULL },
  { "quotedblright",                     444, NULL },
  { "Eth",                               722, NULL },
  { "plusminus",                         564, NULL },
  { "Idotaccent",                        333, NULL },
  { "cedilla",                           333, NULL },
  { "section",                           500, NULL },
  { "Scaron",                            556, NULL },
  { "degree",                            400, NULL },
  { "Euro",                              500, NULL },
  { "florin",                            500, NULL },
  { "iogonek",                           278, NULL },
  { "b",                                 500, NULL },
  { "Scommaaccent",                      556, NULL },
  { "Aacute",                            722, NULL },
  { "K",                                 722, NULL },
  { "Amacron",                           722, NULL },
  { "breve",                             333, NULL },
  { "Z",                                 611, NULL },
  { "ecircumflex",                       444, NULL },
  { "Dcaron",                            722, NULL },
  { "aring",                             444, NULL },
  { "Ydieresis",                         722, NULL },
  { "lcaron",                            344, NULL },
  { "paragraph",                         453, NULL },
  { "zcaron",                            444, NULL },
  { "Imacron",                           333, NULL },
  { "abreve",                            444, NULL },
  { "e",                                 444, NULL },
  { "iacute",                            278, NULL },
  { "icircumflex",                       278, NULL },
  { "q",                                 500, NULL },
  { "l",                                 278, NULL },
  { "C",                                 667, NULL },
  { "u",                                 500, NULL },
  { "dagger",                            500, NULL },
  { "equal",                             564, NULL },
  { "N",                                 722, NULL },
  { "onesuperior",                       300, NULL },
  { "asterisk",                          500, NULL },
  { "Emacron",                           611, NULL },
  { "scommaaccent",                      389, NULL },
  { "greater",                           564, NULL },
  { "o",                                 500, NULL },
  { "percent",                           833, NULL },
  { "gbreve",                            500, NULL },
  { "uhungarumlaut",                     500, NULL },
  { "lcommaaccent",                      278, NULL },
  { "onehalf",                           750, NULL },
  { "threesuperior",                     300, NULL },
  { "zdotaccent",                        444, NULL },
  { "Ecaron",                            611, NULL },
  { "n",                                 500, NULL },
  { "Gcommaaccent",                      722, NULL },
  { "registered",                        760, NULL },
  { "quoteleft",                         333, NULL },
  { "copyright",                         760, NULL },
  { "k",                                 500, NULL },
  { "Racute",                            667, NULL }
};

static BuiltinFontWidth zapfDingbatsWidthsTab[] = {
  { "a198",                              888, NULL },
  { "a107",                              760, NULL },
  { "a167",                              927, NULL },
  { "a97",                               392, NULL },
  { "a137",                              788, NULL },
  { "a175",                              930, NULL },
  { "a55",                               708, NULL },
  { "a206",                              410, NULL },
  { "a146",                              788, NULL },
  { "a27",                               759, NULL },
  { "a71",                               791, NULL },
  { "a79",                               784, NULL },
  { "a136",                              788, NULL },
  { "a43",                               923, NULL },
  { "a131",                              788, NULL },
  { "a154",                              788, NULL },
  { "a123",                              788, NULL },
  { "a8",                                537, NULL },
  { "a87",                               234, NULL },
  { "a72",                               873, NULL },
  { "a199",                              867, NULL },
  { "a151",                              788, NULL },
  { "a99",                               668, NULL },
  { "a126",                              788, NULL },
  { "a46",                               749, NULL },
  { "a34",                               794, NULL },
  { "a186",                              967, NULL },
  { "a102",                              544, NULL },
  { "a205",                              509, NULL },
  { "a62",                               707, NULL },
  { "a140",                              788, NULL },
  { "a90",                               390, NULL },
  { "a98",                               392, NULL },
  { "a9",                                577, NULL },
  { "a178",                              883, NULL },
  { "a26",                               760, NULL },
  { "a40",                               833, NULL },
  { "a125",                              788, NULL },
  { "a101",                              732, NULL },
  { "a103",                              544, NULL },
  { "a150",                              788, NULL },
  { "a57",                               701, NULL },
  { "a18",                               974, NULL },
  { "a184",                              946, NULL },
  { "space",                             278, NULL },
  { "a74",                               762, NULL },
  { "a168",                              928, NULL },
  { "a147",                              788, NULL },
  { "a187",                              831, NULL },
  { "a110",                              694, NULL },
  { "a143",                              788, NULL },
  { "a36",                               823, NULL },
  { "a41",                               816, NULL },
  { "a86",                               410, NULL },
  { "a164",                              458, NULL },
  { "a152",                              788, NULL },
  { "a163",                             1016, NULL },
  { "a3",                                980, NULL },
  { "a160",                              894, NULL },
  { "a166",                              918, NULL },
  { "a117",                              690, NULL },
  { "a83",                               277, NULL },
  { "a29",                               786, NULL },
  { "a22",                               761, NULL },
  { "a112",                              776, NULL },
  { "a133",                              788, NULL },
  { "a156",                              788, NULL },
  { "a200",                              696, NULL },
  { "a81",                               438, NULL },
  { "a106",                              667, NULL },
  { "a100",                              668, NULL },
  { "a132",                              788, NULL },
  { "a95",                               334, NULL },
  { "a37",                               789, NULL },
  { "a58",                               826, NULL },
  { "a191",                              918, NULL },
  { "a56",                               682, NULL },
  { "a70",                               785, NULL },
  { "a157",                              788, NULL },
  { "a171",                              873, NULL },
  { "a188",                              873, NULL },
  { "a47",                               790, NULL },
  { "a14",                               855, NULL },
  { "a23",                               571, NULL },
  { "a2",                                961, NULL },
  { "a77",                               892, NULL },
  { "a105",                              911, NULL },
  { "a25",                               763, NULL },
  { "a202",                              974, NULL },
  { "a61",                               789, NULL },
  { "a10",                               692, NULL },
  { "a44",                               744, NULL },
  { "a159",                              788, NULL },
  { "a48",                               792, NULL },
  { "a124",                              788, NULL },
  { "a190",                              970, NULL },
  { "a20",                               846, NULL },
  { "a185",                              865, NULL },
  { "a16",                               933, NULL },
  { "a11",                               960, NULL },
  { "a134",                              788, NULL },
  { "a108",                              760, NULL },
  { "a28",                               754, NULL },
  { "a149",                              788, NULL },
  { "a172",                              828, NULL },
  { "a1",                                974, NULL },
  { "a144",                              788, NULL },
  { "a92",                               276, NULL },
  { "a66",                               786, NULL },
  { "a189",                              927, NULL },
  { "a54",                               707, NULL },
  { "a59",                               815, NULL },
  { "a13",                               549, NULL },
  { "a4",                                719, NULL },
  { "a82",                               138, NULL },
  { "a109",                              626, NULL },
  { "a170",                              834, NULL },
  { "a201",                              874, NULL },
  { "a204",                              759, NULL },
  { "a39",                               823, NULL },
  { "a197",                              771, NULL },
  { "a49",                               695, NULL },
  { "a139",                              788, NULL },
  { "a96",                               334, NULL },
  { "a7",                                552, NULL },
  { "a183",                              760, NULL },
  { "a118",                              791, NULL },
  { "a155",                              788, NULL },
  { "a148",                              788, NULL },
  { "a73",                               761, NULL },
  { "a75",                               759, NULL },
  { "a76",                               892, NULL },
  { "a135",                              788, NULL },
  { "a177",                              463, NULL },
  { "a104",                              910, NULL },
  { "a88",                               234, NULL },
  { "a142",                              788, NULL },
  { "a179",                              836, NULL },
  { "a17",                               945, NULL },
  { "a203",                              762, NULL },
  { "a141",                              788, NULL },
  { "a31",                               788, NULL },
  { "a129",                              788, NULL },
  { "a35",                               816, NULL },
  { "a182",                              874, NULL },
  { "a15",                               911, NULL },
  { "a38",                               841, NULL },
  { "a169",                              928, NULL },
  { "a67",                               787, NULL },
  { "a45",                               723, NULL },
  { "a93",                               317, NULL },
  { "a195",                              888, NULL },
  { "a68",                               713, NULL },
  { "a6",                                494, NULL },
  { "a24",                               677, NULL },
  { "a21",                               762, NULL },
  { "a192",                              748, NULL },
  { "a138",                              788, NULL },
  { "a65",                               689, NULL },
  { "a84",                               415, NULL },
  { "a52",                               792, NULL },
  { "a32",                               790, NULL },
  { "a33",                               793, NULL },
  { "a60",                               789, NULL },
  { "a130",                              788, NULL },
  { "a180",                              867, NULL },
  { "a78",                               788, NULL },
  { "a42",                               831, NULL },
  { "a196",                              748, NULL },
  { "a111",                              595, NULL },
  { "a53",                               759, NULL },
  { "a161",                              838, NULL },
  { "a94",                               317, NULL },
  { "a85",                               509, NULL },
  { "a51",                               768, NULL },
  { "a181",                              696, NULL },
  { "a176",                              931, NULL },
  { "a50",                               776, NULL },
  { "a173",                              924, NULL },
  { "a153",                              788, NULL },
  { "a120",                              788, NULL },
  { "a122",                              788, NULL },
  { "a193",                              836, NULL },
  { "a165",                              924, NULL },
  { "a19",                               755, NULL },
  { "a30",                               788, NULL },
  { "a89",                               390, NULL },
  { "a158",                              788, NULL },
  { "a145",                              788, NULL },
  { "a121",                              788, NULL },
  { "a194",                              771, NULL },
  { "a64",                               696, NULL },
  { "a127",                              788, NULL },
  { "a174",                              917, NULL },
  { "a69",                               791, NULL },
  { "a128",                              788, NULL },
  { "a91",                               276, NULL },
  { "a63",                               687, NULL },
  { "a5",                                789, NULL },
  { "a119",                              790, NULL },
  { "a12",                               939, NULL },
  { "a162",                              924, NULL }
};

BuiltinFont builtinFonts[] = {
  { "Courier",               standardEncoding,            600,  629, -157, { -23, -250,  715,  805}, NULL },
  { "Courier-Bold",          standardEncoding,            600,  629, -157, {-113, -250,  749,  801}, NULL },
  { "Courier-BoldOblique",   standardEncoding,            600,  629, -157, { -57, -250,  869,  801}, NULL },
  { "Courier-Oblique",       standardEncoding,            600,  629, -157, { -27, -250,  849,  805}, NULL },
  { "Helvetica",             standardEncoding,              0,  718, -207, {-166, -225, 1000,  931}, NULL },
  { "Helvetica-Bold",        standardEncoding,              0,  718, -207, {-170, -228, 1003,  962}, NULL },
  { "Helvetica-BoldOblique", standardEncoding,              0,  718, -207, {-174, -228, 1114,  962}, NULL },
  { "Helvetica-Oblique",     standardEncoding,              0,  718, -207, {-170, -225, 1116,  931}, NULL },
  { "Symbol",                symbolEncoding,                0, 1010, -293, {-180, -293, 1090, 1010}, NULL },
  { "Times-Bold",            standardEncoding,              0,  683, -217, {-168, -218, 1000,  935}, NULL },
  { "Times-BoldItalic",      standardEncoding,              0,  683, -217, {-200, -218,  996,  921}, NULL },
  { "Times-Italic",          standardEncoding,              0,  683, -217, {-169, -217, 1010,  883}, NULL },
  { "Times-Roman",           standardEncoding,              0,  683, -217, {-168, -218, 1000,  898}, NULL },
  { "ZapfDingbats",          zapfDingbatsEncoding,          0,  820, -143, {  -1, -143,  981,  820}, NULL }
};

BuiltinFont *builtinFontSubst[] = {
  &builtinFonts[0],
  &builtinFonts[3],
  &builtinFonts[1],
  &builtinFonts[2],
  &builtinFonts[4],
  &builtinFonts[7],
  &builtinFonts[5],
  &builtinFonts[6],
  &builtinFonts[12],
  &builtinFonts[11],
  &builtinFonts[9],
  &builtinFonts[10]
};

void initBuiltinFontTables() {
  builtinFonts[0].widths = new BuiltinFontWidths(courierWidthsTab, 315);
  builtinFonts[1].widths = new BuiltinFontWidths(courierBoldWidthsTab, 315);
  builtinFonts[2].widths = new BuiltinFontWidths(courierBoldObliqueWidthsTab, 315);
  builtinFonts[3].widths = new BuiltinFontWidths(courierObliqueWidthsTab, 315);
  builtinFonts[4].widths = new BuiltinFontWidths(helveticaWidthsTab, 315);
  builtinFonts[5].widths = new BuiltinFontWidths(helveticaBoldWidthsTab, 316);
  builtinFonts[6].widths = new BuiltinFontWidths(helveticaBoldObliqueWidthsTab, 315);
  builtinFonts[7].widths = new BuiltinFontWidths(helveticaObliqueWidthsTab, 315);
  builtinFonts[8].widths = new BuiltinFontWidths(symbolWidthsTab, 190);
  builtinFonts[9].widths = new BuiltinFontWidths(timesBoldWidthsTab, 315);
  builtinFonts[10].widths = new BuiltinFontWidths(timesBoldItalicWidthsTab, 315);
  builtinFonts[11].widths = new BuiltinFontWidths(timesItalicWidthsTab, 315);
  builtinFonts[12].widths = new BuiltinFontWidths(timesRomanWidthsTab, 315);
  builtinFonts[13].widths = new BuiltinFontWidths(zapfDingbatsWidthsTab, 202);
}

void freeBuiltinFontTables() {
  int i;

  for (i = 0; i < 14; ++i) {
    delete builtinFonts[i].widths;
  }
}
