#!/bin/sh
#
# Remove ./mp.w from the result: depend.mk
#
SRC1="dvi/dvigen.c font/dofont.c font/luafont.c font/mapfile.c \
font/pkin.c font/sfnt.c font/texfont.c font/tfmofm.c \
font/tounicode.c font/tt_glyf.c font/tt_table.c font/vfovf.c \
font/vfpacket.c font/writecff.c font/writeenc.c font/writefont.c \
font/writet1.c font/writet3.c font/writettf.c font/writetype0.c \
font/writetype2.c image/pdftoepdf.c image/writeimg.c image/writejbig2.c \
image/writejp2.c image/writejpg.c image/writepng.c"

SRC2="lua/helpers.c lua/lcallbacklib.c lua/lfontlib.c lua/limglib.c \
lua/liolibext.c lua/lkpselib.c lua/lpdfelib.c \
lua/llanglib.c \
lua/llualib.c lua/lnodelib.c lua/loslibext.c \
lua/lpdflib.c lua/lpdfscannerlib.c lua/lstrlibext.c lua/lstatslib.c \
lua/ltexiolib.c lua/ltexlib.c lua/lnewtokenlib.c lua/luainit.c \
lua/luanode.c lua/luastuff.c lua/luatoken.c lua/luatex-core.c \
lua/mplibstuff.c lua/texluac.c \
lang/hnjalloc.c lang/hyphen.c lang/texlang.c \
pdf/pdfaction.c pdf/pdfannot.c pdf/pdfcolorstack.c pdf/pdfdest.c pdf/pdffont.c \
pdf/pdfgen.c pdf/pdfglyph.c pdf/pdfimage.c pdf/pdflink.c pdf/pdflistout.c \
pdf/pdfliteral.c pdf/pdfobj.c pdf/pdfoutline.c \
pdf/pdfpage.c pdf/pdfrule.c pdf/pdfsaverestore.c pdf/pdfsetmatrix.c \
pdf/pdfshipout.c pdf/pdftables.c pdf/pdfthread.c pdf/pdfxform.c \
pdf/pdfpagetree.c tex/align.c tex/arithmetic.c tex/backend.c \
tex/buildpage.c \
tex/commands.c tex/conditional.c tex/dumpdata.c tex/directions.c \
tex/equivalents.c tex/errors.c tex/expand.c tex/extensions.c \
tex/inputstack.c tex/texfileio.c tex/filename.c tex/linebreak.c \
tex/mainbody.c tex/maincontrol.c tex/texmath.c tex/mathcodes.c \
tex/memoryword.c tex/mlist.c tex/nesting.c tex/packaging.c \
tex/postlinebreak.c tex/primitive.c tex/printing.c tex/scanning.c \
tex/stringpool.c tex/texdeffont.c tex/texnodes.c tex/textcodes.c \
tex/textoken.c utils/avl.c utils/avlstuff.c \
utils/managed-sa.c \
synctex.c utils/unistring.c utils/utils.c"

rm -f depend.mk
touch depend.mk
makedepend -fdepend.mk -o.obj -pluabin/ --cpp=vc --cpp-bin=cl --newline=unix \
 -DSYNCTEX_ENGINE_H='"synctex-luatex.h"' -DpdfTeX -DWIN32=1 -DHAVE_CONFIG_H=1 \
 -I. -I.. -I../mplibdir -I../.. -I../../kpathsea \
 -I../../../libs/zlib -I../../../libs/libpng \
 -I../libmd5 -I../lualibs -I../synctexdir \
 -I../../../libs/pplib/src/util \
 -I../../../libs/pplib/src \
 -I../../../libs -I../lualibs/lua53 -Ifake $SRC1 $SRC2
sed -e 's#\./mp\.w##g' depend.mk >depend.mkt
sed -e 's#mp\.w##g' depend.mkt >depend.mk
rm depend.mkt
