/* showlang.c: show all languages written in language.dat.

   Copyright 2013 Akira Kakuto.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this library; if not, see <http://www.gnu.org/licenses/>.  */

#include <kpathsea/kpathsea.h>

#define LANGUAGE_DAT "language.dat"
#define BUFLEN       2048
#define PRBUFLEN     128

int main (int argc, char *argv[])
{
  char *p;
  FILE *f;
  int  lang = -1;
  char *buff, *printbuff;

  if (argc != 1) {
    fprintf (stderr, "Show all languages written in " LANGUAGE_DAT ".\n");
    fprintf (stderr, "Usage: showlang\n");
    fprintf (stderr, "       without arguments.\n");
    return 0;
  }

  kpse_set_program_name (argv[0], "showlang");
  p = kpse_find_file (LANGUAGE_DAT, kpse_tex_format, 0);

  if (p == NULL) {
    fprintf (stderr, "I cannot find " LANGUAGE_DAT ".\n");
    return 1;
  }

  f = fopen (p, "r");
  free (p);
  buff = xmalloc (BUFLEN);
  printbuff = xmalloc (PRBUFLEN);

  while (fgets (buff, BUFLEN - 1, f)) {
    if (*buff == '\n' || *buff == '%')
      continue;
    p = buff;
    while (*p != '\t' && *p != ' ' && *p != '\n')
      p++;
    *p = '\0';
    if (*buff != '=') {
      lang++;
      strcpy (printbuff, buff);
    } else {
      strcpy (printbuff, "(");
      strcat (printbuff, buff);
      strcat (printbuff, ")");
    }
    fprintf (stdout, "%3d %s\n", lang, printbuff);
  }

  free (printbuff);
  free (buff);
  fclose (f);
  return 0;
}
