/* cid.h */
#ifndef _CID_H_
#define _CID_H_
#include "pdfobj.h"
/*
  Adobe Predefined CMaps
  Only CC_JAPANESE is supprted.
*/
#define CC_SIMPLIFIED_CHINESE 0
#define CC_TRADITIONAL_CHINESE 1
#define CC_JAPANESE 2
#define CC_KOREAN 3

/* Flags */
#define FIXEDWIDTH (1 << 0) /* Fixed-width font */
#define SERIF (1 << 1) /* Serif font */
#define SYMBOLIC (1 << 2) /* Symbolic font */
#define SCRIPT (1 << 3) /* Script font */
#define STANDARD (1 << 5) /* Uses the Adobe Standard Roman Character Set */
#define ITALIC (1 << 6) /* Italic */
#define ALLCAP (1 << 16) /* All-cap font */
#define SMALLCAP (1 << 17)  /* Small-cap font */
#define FOCEBOLD (1 << 18) /* Force bold at small text sizes */

#define CID_MAX_PARENT 8
struct a_cid_font
{
  char *fontname; /* PostScript font name */
  char *cid_name; /* this is mapname */
  pdf_obj *direct, *indirect, *descriptor, *fontfile; /* fixme */
  int base_id; /* identifier of predefined CID font, see cid_basefont.h */
  int parent[CID_MAX_PARENT]; /* parent type0 font */
  int num_parents;
  int cc; /* character collection */
};

extern void cid_set_verbose(void);
extern void cid_add_system_info(pdf_obj *dict, int cc);
extern struct a_cid_font *new_cid_font(void);
extern int cid_is_known_font (const char *map_name);
extern int cid_find_parent(const char *map_name, char *encoding);
extern pdf_obj *cid_call_descendant(int type0_id, int cid_id);
extern int cid_get_id (const char *map_name);
extern char *cid_fontname (int cid_id);
extern void cid_flush_all (void);
#endif /* _CID_H_ */
