/* TeXfmt.cmd
Copyright (C) Z. Wagner -- Ice Bear Soft, 27 Dec 1995 

This batch assigns a format to a specified TeX file

Usage:
TeXfmt <file_name>  <format>

The ".tex" extension may be omitted
*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
parse arg file fmt rest
if (fmt=='') | (rest\='') then do
  say 'Usage:'
  say 'TeXfmt <file_name>  <format>'
  exit 1
end

/* Splitting file name */

bspos = lastpos('\', file)
dotpos = lastpos('.', file)
colpos = 0
if substr(file, 2, 1)==':' then colpos = 2
if (dotpos < bspos) | (dotpos < colpos) then dotpos = 0
fullname = queryfile(file)
if fullname=='' then fullname = queryfile(file || '.tex')
if fullname=='' then do
  say 'Error: cannot find either' file 'or' file || '.tex'
  exit 1
end

/* Putting the Subject EA */
sub = 'FORMAT=' || fmt
subj = 'FDFF'x || d2c(length(sub)) || '00'x || sub
rc = SysPutEA(fullname, '.subject', subj)
if rc\=0 then say 'Error' rc 'when putting EA'
exit rc

/* Procedure for querying the file name */
queryfile: procedure
parse arg fn
res = stream(fn, 'C', 'QUERY EXISTS')
if res \= '' then call stream res, 'C', 'CLOSE'
return res
