/* symlink/stat.h -- this file is part of the SYMLINK Library.

   Copyright (C) 1994, 1995 Ralph Schleicher  */

/* This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef _SYMLINK_STAT_H
#define _SYMLINK_STAT_H


#include <symlink/cdefs.h>

#include <sys/types.h>
#include <sys/stat.h>


__BEGIN_DECLS

int symlink_stat __PROTO ((const char *name, struct stat *info));
int symlink_lstat __PROTO ((const char *name, struct stat *info));

__END_DECLS


#ifdef USE_SYMLINK_STAT

#undef stat
#undef lstat

#define stat(n, i)	symlink_stat((n), (i))
#define lstat(n, i)	symlink_lstat((n), (i))

#endif /* USE_SYMLINK_STAT */


#endif /* not _SYMLINK_STAT_H */
