/* pmTeXit.cmd: according to                                   */
/* texit.cmd -- Copyright (c) 1992, 1994 by Eberhard Mattes    */

/*   
  Changed by Petr Mikulik (3.11.1995 and 29.2.1996) in order to 
  accept  Format:  and  Master:  notation of CSTeX for EPM. 

   Example: you have the first line of your tex document mytext.tex:
      % Format: latex209 Master: a.tex
   Thus the command   
      pmtexit mytext.tex   
   runs
      latex209.cmd a.tex 
   If  % Format:  is not specified, then the environmental variable 
   TEXFORMATDEFAULT is substituted, and even this does not exist, then
   latex is used                           

   Bugs: Format is taken from 'slave' file, not from Master. This is 
     contrary to CSTeX for EPM package. I use only latex (or cslatex) 
     so I do not bother about it. If someone needs to change the code 
     in order to read the first line of Master, send me the corrected file
*/

/* Original note by Eberhard Mattes:                           */
/* Choose TeX format according to first line of TeX input file */
/* Call editor if TeX has been left by answering `E'.          */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
format = ''; options = ''
parse arg arg1 rest
do while (length( arg1) >= 2) & ((substr( arg1, 1, 1) = '-') |,
                                 (substr( arg1, 1, 1) = '/'))
  options = options arg1
  parse var rest arg1 rest
end
if (length( arg1) >= 2) & ((substr( arg1, 1, 1) = '&') |,
                           (substr( arg1, 1, 2) = '^&')) then
do
  format = arg1
  parse var rest arg1 rest
end
if (format = '') & (length( arg1) >= 1) & \ (substr( arg1, 1, 1) = '\') then
do
  input = arg1
  master = arg1
  fname = filespec( 'name', input)
  parse var fname base '.' ext
  if ext = '' then
    input = input'.tex'
  fname = stream( input, 'C', 'QUERY EXISTS')
  if fname = '' then
    fname = SysSearchPath( 'TEXINPUT', input)
  if \ (fname = '') then
  do
    /* read Master */
    line = linein( fname)
    uline = translate(line)
    call stream fname, 'C', 'CLOSE'
    /* say 'First line =' line */
    /*    parse var line '%' 'MASTER:' master . */
    w=words(line); 
    i=wordpos('MASTER:',uline)
    if (i>0) & (i<w) then master=word(line,i+1)
    i=wordpos('MASTER',uline)
    if (i>0) & (i<w) then master=word(line,i+1)
    if (master = '') then master = arg1
    /* read Format */
    if (format='') then do
      i=wordpos('FORMAT:',uline) 
      if (i>0) & (i<w) then format=word(line,i+1)
      end
    if (format='') then do
      i=wordpos('FORMAT',uline) 
      if (i>0) & (i<w) then format=word(line,i+1)
      end
    if (format='') then format=value('TEXFORMATDEFAULT',, 'OS2ENVIRONMENT')
    if (format='') then format='latex'
  end
end
tmpfile = SysTempFileName('texit???.cmd')
cmd.exe '/c' format master rest
if \ (stream( tmpfile, 'C', 'QUERY EXISTS') = '') then
do
  '@call' tmpfile
  '@del' tmpfile
end

/* End of pmtexit.cmd */
