/* -*-C++-*-
 * ###################################################################
 *	Cpptcl - Integrating C++ with Tcl
 * 
 *	FILE: "tcl_args_t.cc"
 *									  created: 29/4/96 {9:10:23 pm}	
 *								  last update: 16/12/97 {11:25:00 am}	
 *	Author:	Vince Darley
 *	E-mail:	<darley@fas.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www:	<http://www.fas.harvard.edu/~darley/>
 *	
 *	Template Definitions:   See	header file	for	further	information
 * ###################################################################
 */

#ifdef DEFINE_TEMPLATES

#include "tcl_args.h"
// to be replaced by RTTI eventually.
const char* GETTYPE(int&);
const char* GETTYPE(bool&);
const char* GETTYPE(long&);
const char* GETTYPE(float&);
const char* GETTYPE(double&);
const char* GETTYPE(char&);
const char* GETTYPE(Tcl_Obj*&);


/*template <class T> void operator>> (tcl_args_reader& a, T*& into) {
	strstream s;
	s << a.arg;
	s >> into;
	a.state = (tcl_args_reader::_state)s.rdstate();
}
*/
template <class T> tcl_args& operator>> (tcl_args& arg, T& into);

template <class T> 
tcl_args& operator>> (tcl_args& arg, T& into){
	arg.set_conversion_type(GETTYPE(into));
	if(arg.is_optional_arg() && !arg.args_left()) {
		arg.pretend_read_from_me();
	} else {
		arg.check_read() >> into;
		arg.check_after();
		arg.parsed_so_far << into;
		arg.read_done();
	}
	
	return arg;
}

#endif

