#******************************************************************************
#***
#*** This file is part of XTeXShell; see file xtexsh for details
#*** Version 0.91 (21.2.94)
#***
#******************************************************************************

#******************************************************************************
#*** Message Windows **********************************************************
#******************************************************************************           

proc DisplayMsg {msg font} {

#*** Displays message until next GotoXY command. Don't show buttons     

        global      msg_win  msg_name  msg_geo
        global      goto_command

        update

#*** Open a window

        set         msg_win [CreateTopWin dialog "CREATE"]

        wm title    $msg_win ""
        wm iconname $msg_win "Message"

#*** Create frame for Text

        frame $msg_win.top -relief raised -border 1
        pack  $msg_win.top -side top -fill both -expand yes

#*** Fill in text

        message $msg_win.top.msg -justify center -text "$msg" -font "$font" -aspect 200
        pack $msg_win.top.msg -side top -expand yes -padx 3m -pady 1m
        update

        lvarcat goto_command "destroy $msg_win;"
}                                 


proc DisplayInfo {msg font {but1 "OK"}} {

#*** Displays msg in a new window and waits until user klicks
#*** on the button

        DialogWin "$msg" "$font" [list $but1 {DialogEnd}] 
}


proc DisplayQuest {msg font args} {

#*****************************************************************************
#*** Displays msg in a new top window. Create Buttons at the bottom of
#*** the window and wait until one of them is pressed. Return the number
#*** of the button, the leftmost is 1
#***    args - contains the names of the buttons
#*****************************************************************************

        set i 1

        set buf {DialogWin "$msg" "$font"}
        foreach arg [lrange $args 0 end] {
                lappend buf [list "$arg" "set DialogRet $i; DialogEnd"]
                incr i                                                                                                  
        }

        set retval [eval $buf]
}

proc DialogWin {msg font args} {

#*****************************************************************************
#*** Create a new top window and display a message. Create buttons at the
#*** bottom of the window and wait until one of them is pressed
#***
#***    msg  -  Message to be displayed
#***    list -  A two-element list that describes one of the buttons that
#***            will appear at the bottom of the dialog.  The first element
#***            gives the text to be displayed in the button and the second
#***            gives the command to be invoked when the button is invoked.
#***
#*** Returns the value of the variable DialogRet, wich is initially "" and
#*** may be modified by the key bindings. Key bindings should call DialogEnd
#*** which terminates the dialog
#*****************************************************************************

        global      dia_win  dialog_name  dialog_geo
        global      DialogRet 

        set         DialogRet ""

        update

#*** Open a window

        set         dia_win [CreateTopWin dialog "CREATE"]

        wm title    $dia_win ""
        wm iconname $dia_win "Dialog Box"

#*** Create frames for Text and Buttons

        frame $dia_win.top -relief raised -border 1
        frame $dia_win.bot -relief raised -border 1
        pack  $dia_win.top $dia_win.bot -side top -fill both -expand yes

#*** Fill in text

        message $dia_win.top.msg -justify center -text "$msg" -font "$font" -aspect 200
        pack $dia_win.top.msg -side top -expand yes -padx 3m -pady 1m

#*** Create Buttons

        for {set i 0} {$i < [llength $args]} {incr i} {
                set arg [lindex $args $i]
                if {$i == 0 } {
                        frame   $dia_win.bot.0 -relief sunken -border 1
                        pack    $dia_win.bot.0 -side left -expand yes -padx 3m -pady 2m
                        button  $dia_win.bot.0.button -text [lindex $arg 0] -command "[lindex $arg 1]"
                        pack    $dia_win.bot.0.button -expand yes -padx 1.5m -pady 1.5m -ipadx 1m
                        bind    $dia_win <Return> "[lindex $arg 1]"
                } else {
                        button  $dia_win.bot.$i -text [lindex $arg 0] -command "[lindex $arg 1]"
                        pack    $dia_win.bot.$i -side left -expand yes -padx 3m -pady 1m -ipadx 1m
                }
        }
    
        bind $dia_win <Any-Enter> [list focus $dia_win]

        tkwait visibility $dia_win
        grab $dia_win
        focus $dia_win
        tkwait window $dia_win
        return $DialogRet
}

proc DialogEnd {} {

#*** Terminates the Dialog. May be called from key bindings.

        global dia_win

        destroy $dia_win
}


proc CreateTopWin {wname mode} {

#*** Create a new toplevel window.
#***    $($name_name) - name of toplevel window
#***    $($name_geo)  - geometry of toplevel window
#***    $($name_min)  - minimal size of new window. Not required
#***    mode          : "" return if window already exists. "CREATE" : destroy old window
#***    return value  : Name of window on success, "" if operation was not completed

#*** Get the real window names

        set  win_name "$wname\_name"
        set  win_geo  "$wname\_geo"
        set  win_min  "$wname\_min"     

        global $win_name $win_geo $win_min
                
        eval set win_name "\$$win_name"
        eval set win_geo  "\$$win_geo"

#*** Check if mode != CREATE and window exists

        if {![cequal $mode "CREATE"]} {
                if {[info exists win_name] && [winfo exists $win_name]} {
                        return ""
                }
        }

#*** Ok, we can create the new window. Get size of Main Window

        if {![cequal "." $win_name]} { 
                catch     {destroy $win_name}
                toplevel  $win_name
                set       geo     [winfo geometry "."];         #*** Get geometry of main window
        } else {
                set       geo     "10x10+0+0"
        }       

#*** Calculate geometry relative to main window

        if {[string first "x" $geo] >= 0} {set tmp [ctoken geo "+"]}
        set       mxpos   [ctoken geo "+"]
        set       mypos   [ctoken geo "+"]

        set       geo     "$win_geo";                           #*** Get geometry of new window
        if {[string first "x" $geo] >= 0} {
                set tmp [ctoken geo "+"]
        } else {
                set tmp ""
        }                       
        set       nxpos   [ctoken geo "+"]      
        set       nypos   [ctoken geo "+"]

        if {[cequal $nypos ""]} {
                set geo $tmp 
        } else { 
                set       geo     [format "%s+%d+%d" $tmp [expr $mxpos+$nxpos] [expr $mypos+$nypos]]
        }

#*** Set window geometry 

        wm        geometry $win_name $geo

#*** Set Window minsize

        if {[info exists $win_min]} {
                eval eval wm minsize $win_name "\$$win_min"
        }

        return    $win_name
}


proc InsertWithTags {w text args} {

#*** InsertWithTags inserts text into a given text widget and
#*** applies one or more tags to that text.  The arguments are:
#***
#*** w             Window in which to insert
#*** text          Text to insert (it's inserted at the "insert" mark)
#*** args          One or more tags to apply to text.  If this is empty
#***               then all tags are removed from the text.

        set start [$w index insert]
        $w insert insert $text
        foreach tag [$w tag names $start] {
                $w tag remove $tag $start insert
        }
        foreach i $args {
                $w tag add $i $start insert
        }
}

proc strip_extension {filename} {

#*** Strip of extension of filename

        set pos  [expr [string last "." "$filename"] - 1]
        set pos1 [expr [string last "/" "$filename"] - 1] 

        if {$pos >= 0 && $pos > $pos1} {
                return [crange "$filename" 0 "$pos" ]
        } 

        return $filename
}


proc SelNewMain {fname} {

#*** Set fname as the new main file. If fname=="", ask user for a file

        global mainflag

        if {[cequal "" $fname]} {
                set fname [FileSelBox OPEN]
                if {![string compare $fname ""]} {return}
        }
        .menu.main.m add radio -label "$fname" -variable mainname
        .menu.main.m invoke last
        if {![info exists mainflag] || !$mainflag} {
                .menu.main.m invoke 0
        }
}


proc PurgeFiles {} {

#*** Deletes all temporary files in a directory

        global boldl_font

        DisplayQuest "Ready to delete all files\n*~ *.aux *.lis *.toc *.dvi *.lof *.lot\n in current directory?" \
                "$boldl_font" " GO " "Subdirs also" "Show Files"  "Quit"
}


proc ChangeDir {} {

#*** Set a new directory

        set newdir [FileSelBox "CD"]
        if {![cequal $newdir ""]} {
                pushd $newdir
        }
}



