# file selection menu 
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen
# Copyright (C) 1996  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University

proc fileselect {} {


proc fssel1 {d} {# dir selected
 global Wf
 if [winfo exists $Wf.c.d] {$Wf.c.d.f.f.li delete 0 end}; $Wf.c.m.f.f.li delete 0 end
 fsfocus $Wf.d.tt; update; dirselected $d ""
}

proc fssel1a {s} {# main sort selected
 global Wf vv mdatsort
 if {$s=="$vv(c2af0)"} {set mdatsort 0} else {set mdatsort 1}
 fsfuellen main
}

proc fssel2 {s} {# main suffix selected
 global Wf vv texsuffix main_file tsuff efile esuff
 $Wf.c.m.i delete 0 end
 if {$texsuffix!=$s} \
	{set texsuffix $s; set main_file ""; set tsuff ""; set efile ""; set esuff $texsuffix}
 if {$esuff=="*"} {set esuff ""}
 fsfuellen main; fsfuellen edit
 writescr0 $Wf.d.tt "$vv(evt3): $texsuffix\n\n"; fsanzeige $Wf
}

proc fssel2a {s} {# edit sort selected
 global Wf vv edatsort
 if {$s=="$vv(c2af0)"} {set edatsort 0} else {set edatsort 1}
 fsfuellen edit
}

proc fssel3 {f} {# main file selected
 global Wf vv texsuffix main_file tsuff efile esuff qdliste
 fsfocus $Wf.d.tt
 if {[string first "/" $f]>0} {fssel1 [string range $f 0 [expr [string length $f]-2]]} \
 elseif [file exists $f] {
   if [winfo exists $Wf.c.m.i] {$Wf.c.m.i delete 0 end}
   regsub "$texsuffix\$" $f "" main_file;  set tsuff "$texsuffix"
   set efile $main_file;  set esuff $tsuff
   setInUnlockListe ".c.1.ed .c.1.pr"
   if {[processActive qdliste]!=0} {foreach pi $qdliste {killprocess $pi}; set qdliste ""}
   writescr0 $Wf.d.tt "$vv(aus2) $main_file$tsuff\n"
   fsvstlook; fsanzeige $Wf
 }
}

proc fssel4 {s} {# edit suffix selected
 global Wf vv esuff efile
 $Wf.c.e.i delete 0 end
 if {$s=="*"} then {set ns ""} else {set ns $s}
 if {$esuff!=$ns} {set efile "[filePrefix $efile]"; set esuff $ns}
 fsfuellen edit
 writescr0 $Wf.d.tt "$vv(evt3): *$esuff\n\n"; fsanzeige $Wf
}

proc fssel5 {f} {# edit file selected
 global Wf vv efile esuff
 fsfocus $Wf.d.tt
 if {[string last "/" $f]>0} {# selected item is directory
   if {$f=="\$$vv(fs5)/"} {set efile ""} \
   else {set efile [fsdirCheckClear "[filePrefix $efile]$f"]}
   if [winfo exists $Wf.c.e.i] {$Wf.c.e.i delete 0 end}
   if {$efile==""} {writescr0 $Wf.d.tt "$vv(fs19) $vv(fs5)\n"} \
   else {writescr0 $Wf.d.tt "$vv(fs19) $efile\n"}
   fsfuellen edit
   fsanzeige $Wf
 } else {# selected item is file
   if {[string last / $efile]+1==[string length $efile]} {set efile $efile$f} {set efile $f}
   if [winfo exists $Wf.c.e.i] {$Wf.c.e.i delete 0 end}
   if {$esuff!=""} {regsub "$esuff\$" $efile "" efile}
   writescr0 $Wf.d.tt "$vv(aus7) $efile$esuff\n"
   fsSetEF2MF
   fsanzeige $Wf
 }
}

proc fsdirCheckClear {dnm} {# checks efile 
 global vv
 set diralt [pwd]
 if {[string last / $dnm]==[string length $dnm]-1} \
	{set dnm [string range $dnm 0 [expr [string length $dnm]-2]]}
 if {$dnm=="\$$vv(fs5)"} {set dnm [pwd]}
 cd $dnm
 if {[pwd]=="$diralt"} {set ret ""} elseif {[pwd]=="/"} {set ret "/"} else {set ret "[pwd]/"}
 cd $diralt; return $ret
}

proc fsfocus {w} {#
 global Wf fsFoc fsFocLast
 set fsFocLast $fsFoc
 if     {$fsFoc==0} {set r 0} \
 elseif {$fsFoc==1} {set r [fsedn]} \
 elseif {$fsFoc==2} {set r [fsemfn]} \
 elseif {$fsFoc==3} {set r [fseefn]}
 if {($w=="")&&[winfo exists $Wf]} {Focus $Wf; return $r} elseif [winfo exists $w] {focus $w}
}

proc fsedn {} {# enter directory name
 global vv env Wf fsFoc
 set fsFoc 0
 set d [string trim [$Wf.c.d.i get]]; $Wf.c.d.i delete 0 end; writescr0 $Wf.d.tt ""
 if {$d==""} {return 0}
 if {$d=="\$HOME"} {set sd $env(HOME)} else {set sd $d}; set sf ""
 if {![file isdirectory $sd]&&![file exists $sd]} {mkdcdfill $sd $sf main} \
 else {dirselected $sd $sf; fsanzeige $Wf}
 return 1
}

proc fsemfn {} {# enter main file name
 global vv Wf texsuffix main_file tsuff efile esuff fsFoc qdliste
 set fsFoc 0
 set f [string trim [$Wf.c.m.i get]]; $Wf.c.m.i delete 0 end; writescr0 $Wf.d.tt ""
 if {$f=="$texsuffix"} {set f ""; writescr $Wf.d.tt "$vv(fs22)\n"}
 regsub "$texsuffix$" $f "" h; if {"$h$texsuffix"=="$f"} {set f "$h"}
 testfilename $f $Wf.d.tt $texsuffix;  if {$f==""} {return 0}
 set odir [pwd]; set omf $main_file; set ots $tsuff; set oef $efile; set oes $esuff
 set main_file [lindex $f 0]; set tsuff $texsuffix; set efile $main_file; set esuff $tsuff
 if {([dirMainFile]==1)&&([pwd]==$odir)} {# main)file prefixed by dir, but no change-dir
   set main_file $omf; set tsuff $ots; set efile $oef; set esuff $oes
 } else {
   writescr $Wf.d.tt "$vv(fs16) $main_file$tsuff\n\n" 
   setInUnlockListe ".c.1.ed .c.1.pr"
   if {[processActive qdliste]!=0} {foreach pi $qdliste {killprocess $pi}; set qdliste ""}
   fsvstlook
 }
 fsanzeige $Wf
 return 1
}

proc fseefn {} {# enter edit file name
 global vv Wf esuff efile fsFoc fsmenucols
 set fsFoc 0
 set f [string trim [$Wf.c.e.i get]]; $Wf.c.e.i delete 0 end; writescr0 $Wf.d.tt ""
 if {[fileName $f]=="$esuff"} {set f ""; writescr $Wf.d.tt "$vv(fs22)\n"}
 regsub "${esuff}$" $f "" h; if {"$h$esuff"=="$f"} {set f "$h"}
 if {$f==""} {return 0}
 testfilename [fileName $f] $Wf.d.tt $esuff
 set oldefile $efile
 if {$fsmenucols==3} {
   if {[string range $f 0 0]=="/"}   {writescr $Wf.d.tt "$vv(fs23)\n$vv(fs24) `$vv(fs3)'"} \
   elseif {([filePrefix $f]!="")&&(![file isdirectory [filePrefix $f]])} \
				{writescr $Wf.d.tt "$vv(fs20) [filePrefix $f] $vv(ea4)"} \
   else {set efile "[lindex $f 0]"}
 } elseif {$fsmenucols==2} {
   if {[filePrefix $f]==""} {
     set efile "[filePrefix $efile][lindex $f 0]"
   } elseif {([filePrefix $f]!="")&&![file isdirectory [filePrefix $f]]} {
     testfilename [filePrefix $f] $Wf.d.tt ""
     mkdcdfill [filePrefix $f] [fileName $f] edit
   } else {
     set efile "[lindex $f 0]"
   }
 }
 if {[fileName $efile]==""} {set e "$efile$esuff"} else {set e "$efile"}
 if {"$oldefile"!="$efile"} {writescr $Wf.d.tt "$vv(fs17) $e\n"}
 fsfuellen edit
 fsSetEF2MF
 fsanzeige $Wf
 return 1
}

proc fsanzeige {w} {# update display
 global vv dir main_file texsuffix tsuff efile esuff esuffl fsmenucols
 if ![winfo exists $w] {return}
 if {$dir=="/"} {$w.b.dm.t configure -text "/"} else {$w.b.dm.t configure -text "$dir/"}
 if {$fsmenucols==2} {
   if {[string last "/" $efile]<0} {
     pack forget $w.b.de.l $w.b.de.t
   } else {
     pack configure $w.b.de.l -side left; $w.b.de.l configure -text "$vv(fs4):"
     pack configure $w.b.de.t -side left; $w.b.de.t configure -text "[filePrefix $efile]"
   }
 }
 $w.c.m.li configure -text "$vv(fs14) ($texsuffix):"
 $w.c.e.li configure -text "$vv(fs15) ([alternative $esuff * $esuff]):"
 if {$main_file==""} {set m "$vv(fs8)"} else {set m "$main_file$tsuff"}
 if {[fileName $efile]==""} {set e "$vv(bad1)"} \
 elseif {$fsmenucols==2} {set e "[fileName $efile]$esuff"} \
 else {set e "$efile$esuff"}
 if {$esuff==""} {set esuffl "*"} else {set esuffl $esuff}
 $w.b.m.t configure -text "$m"; $w.b.e.t configure -text "$e"
 $w.c.m.1.1.f.l configure -text "$vv(c2al) ($texsuffix):" -anchor w
 $w.c.e.1.1.f.l configure -text "$vv(c2al) ($esuffl):" -anchor w
 knoepfe
}

proc fsfuellen {type} {# fill filelist of type
 global Wf vv sub texsuffix mdatsort esuff edatsort fsmenucols efile
 set subalt $sub; set diralt [pwd]
 update idletasks
 if {$type=="main"} {set w $Wf.c.m.f.f.li; set sf $texsuffix; set ds $mdatsort} \
 else {set w $Wf.c.e.f.f.li; set sf $esuff; set ds $edatsort}
 $w delete 0 end
 if {($type=="edit")&&([filePrefix $efile]!="")&&($fsmenucols==2)} \
	{catch "cd [filePrefix $efile]"}
 if {$ds==0} {set liste [lsort [glob -nocomplain -- *]]} \
 else {SigChldB; set liste [exec ls -t]; SigChldU; update; update idletasks}
 if {$fsmenucols==2} {
   if {$type=="main"} {$w insert end "\$HOME/"} else {$w insert end "\$$vv(fs5)/"}
   if {[pwd]!="/"} {$w insert end "../"}
   foreach i $liste {if {[file isdirectory $i]} {$w insert end $i/}}
 }
 foreach i $liste {if [file isfile $i]&&[string match *$sf $i] {$w insert end $i}}
 lock; set sub $subalt; cd $diralt
}

proc fsSetEF2MF {} {# efile -> main_file (if suffix OK and main_file empty)
 global Wf vv efile esuff main_file tsuff texsuffix
 if {($efile!="")&&($main_file=="")} {
   set s $esuff; set f $efile
   if {$esuff==""} {
     set p [string last "." $efile]
     if {$p>0} {set f [string range $efile 0 [expr $p-1]]; set s [string range $efile $p end]}
   }
   set foid [open_vst texsuffix.vst]
   while {[getscl $foid ein]>0} {
     if {[string trim $ein]==$s} {
	set main_file $f; set texsuffix $s; set tsuff $texsuffix
	writescr $Wf.d.tt "$vv(aus2) $main_file$tsuff\n"
	fsvstlook; fsanzeige $Wf
     }
   }
 }
}

proc fsvstlook {} {# looks for (and reads) main-file specific vst file
 global Wf vv mfold language main_file vstdat fsmenucols efile esuff tsuff
 if {($mfold!=$main_file)&&([file exists "${main_file}_$language.vst"])} {
   set fsmco $fsmenucols
   vstReadDriver
   set mfold "$main_file"
   writescr $Wf.d.tt "$vv(xt28) $vstdat\n"
   if {![file exists $efile$esuff]} \
	{if {"$esuff"=="$tsuff"} {set efile "$main_file"} else {set efile ""}}
   if {$fsmenucols!=$fsmco} {destros $Wf; fileselect} else {fsfuellen edit; fsanzeige $Wf}
 }
}

proc fsWfae {} {# terminate_menu (also by: select with middle mouse click [expert mode])
 global vv Wf efile main_file fsWfEndEnable
 if $fsWfEndEnable {
   if [fsfocus ""] {writescr $Wf.d.tt "$vv(aef) \"$vv(ae)\""} \
   else {fsSetEF2MF; fsvstlook; destros $Wf; unlock_list; knoepfe}
 }
}

proc fsWfcmi {w} {
 global main_file tsuff fsFoc fsFocLast fsEntryWasEmpty
 if {$fsFocLast==$fsFoc} {set fsEntryWasEmpty 0} else {set fsEntryWasEmpty 1}
 $w delete 0 end; if {$main_file!=""} {$w insert end $main_file$tsuff}
}

proc fsWfcei {w} {
 global efile esuff fsFoc fsFocLast fsEntryWasEmpty
 if {$fsFocLast==$fsFoc} {set fsEntryWasEmpty 0} else {set fsEntryWasEmpty 1}
 $w delete 0 end; if {[fileName $efile]!=""} {$w insert end [fileName $efile]$esuff}
}


global vv Wf dir fsFoc main_file texsuffix tsuff efile esuff mfold
global fssel1a_v fssel2a_v fsmenucols fsWfEndEnable

toplevel_init $Wf "$vv(fs0)" 0 0;   set tyh 14;   set dir [pwd];   set mfold "$main_file"

if {$fsmenucols==3} {set wfeb 30; set ldist 0} else {set wfeb 38; set ldist 30}


# top buttons

frame $Wf.a; pack configure $Wf.a -anchor w -fill x
frame $Wf.a.b; pack configure $Wf.a.b -side right -ipadx 20

insertTopButtons $Wf.a fs_h$fsmenucols fsWfae $Wf.d.tt
$Wf.a.a.e configure -state disabled; update; set fsWfEndEnable 0

button $Wf.a.b.c -text "$vv(fs3)" -command \
	{destros $Wf; if {$fsmenucols==2} {set fsmenucols 3} {set fsmenucols 2}; fileselect}
pack configure $Wf.a.b.c
Bind3HF $Wf.a.b.c fs_chgmenu$fsmenucols $Wf.d.tt


# frame b for display

frame $Wf.b; pack configure $Wf.b -anchor w -pady 8
frame $Wf.b.dm; pack configure $Wf.b.dm -anchor w
frame $Wf.b.m;  pack configure $Wf.b.m -anchor w
if {$fsmenucols==2} \
  {frame $Wf.b.dummy -height 3; frame $Wf.b.de; pack configure $Wf.b.dummy $Wf.b.de -anchor w}
frame $Wf.b.e;  pack configure $Wf.b.e -anchor w

label $Wf.b.dm.l -width 25 -text $vv(bdv) -anchor e
label $Wf.b.dm.t -anchor w
pack configure $Wf.b.dm.l $Wf.b.dm.t -side left
Bind3HF $Wf.b.dm.l fs_dirdisp$fsmenucols $Wf.d.tt
Bind3HF $Wf.b.dm.t fs_dirdisp$fsmenucols $Wf.d.tt

label $Wf.b.m.l -width 25 -text "$vv(fs11)" -anchor e
label $Wf.b.m.t -anchor w
pack configure $Wf.b.m.l $Wf.b.m.t -side left
Bind3HF $Wf.b.m.l fs_maindisp $Wf.d.tt
Bind3HF $Wf.b.m.t fs_maindisp $Wf.d.tt

if {$fsmenucols==2} {
 label $Wf.b.de.l -width 25 -anchor e
 label $Wf.b.de.t -anchor w
 pack configure $Wf.b.de.l $Wf.b.de.t -side left
 if {[string first "/" $efile]<0} {pack forget $Wf.b.de.l; pack forget $Wf.b.de.t}
 Bind3HF $Wf.b.de.l fs_edirdisp2 $Wf.d.tt
 Bind3HF $Wf.b.de.t fs_edirdisp2 $Wf.d.tt
}

label $Wf.b.e.l -width 25 -text "$vv(fs12)" -anchor e
label $Wf.b.e.t -anchor w
pack configure $Wf.b.e.l $Wf.b.e.t -side left
Bind3HF $Wf.b.e.l fs_editdisp$fsmenucols $Wf.d.tt
Bind3HF $Wf.b.e.t fs_editdisp$fsmenucols $Wf.d.tt


# frame c for modification: d - directory, m - main-file, e - edit-file

frame $Wf.c; pack configure $Wf.c -anchor w

if {$fsmenucols==3} {frame $Wf.c.d; pack configure $Wf.c.d -side left -anchor se -ipadx 3}
frame $Wf.c.m; frame $Wf.c.e; pack configure $Wf.c.m $Wf.c.e -side left -anchor s

if {$fsmenucols==3} {
 # directory: .c.d

 # directory selection box
 CreateLSBox $Wf.c.d $vv(fs9) top 18 21 2 fs_dirsel3 $Wf.d.tt "" "" fssel1 sel ""
 $Wf.c.d.f.f.li insert end "\$HOME" ".."
 foreach i [lsort [glob -nocomplain -- *]] \
	{if [file isdirectory $i] {$Wf.c.d.f.f.li insert end $i}}

 # new directory insert
 label $Wf.c.d.li -anchor w -text "$vv(fs10)"
 entry $Wf.c.d.i -width [expr $wfeb-3] -relief sunken
 pack configure $Wf.c.d.li $Wf.c.d.i -side top -anchor w
 Bind3HF $Wf.c.d.li fs_diredi3 $Wf.d.tt
 bind  $Wf.c.d.i <Button-1> {fsfocus $Wf.c.d.i; set fsFoc 1; $Wf.c.d.i delete 0 end; Bend}
 bind  $Wf.c.d.i <Button-2> {Bend}
 Bind3HF $Wf.c.d.i fs_diredi3 $Wf.d.tt
 bind  $Wf.c.d.i <Return> {fsedn; fsfocus $Wf.d.tt; Bend}
}

# main-file: c.m

if {$fsmenucols==3} {# label for 3-select-boxes-window
 label $Wf.c.m.l -text "$vv(fs1)" -anchor w; pack configure $Wf.c.m.l -side top -anchor w
 Bind3HTF $Wf.c.m.l "$vv(btclk1):\n" fs_filesel3 $Wf.d.tt
}

# label, suffix-box and file-ordering-buttons
frame $Wf.c.m.1; pack configure $Wf.c.m.1 -side top -anchor w -pady 2 -fill x

frame $Wf.c.m.1.1; frame $Wf.c.m.1.2
pack configure $Wf.c.m.1.1 -side left -anchor nw -ipady 3
pack configure $Wf.c.m.1.2 -side right -anchor ne -ipady 3 -padx 10

if {$fsmenucols==2} {# label for 2-select-boxes-window
 label $Wf.c.m.1.1.l -text "$vv(fs1)" -anchor w; pack configure $Wf.c.m.1.1.l -side top
 Bind3HTF $Wf.c.m.1.1.l "$vv(btclk1):\n" fs_filesel2 $Wf.d.tt
}

if ![info exists fssel1a_v] {set fssel1a_v "$vv(c2af0)"}
CreateLSBox $Wf.c.m.1.1 " " top 11 3 0 fs_filesel$fsmenucols $Wf.d.tt \
	"" "\{$vv(c2af0)\} \{$vv(c2af1)\}" fssel1a "" "" "ldist $ldist"

# suffix selection box
CreateLSBox $Wf.c.m.1.2 $vv(fs13) top 9 3 2 fs_filesuff $Wf.d.tt \
	"" [vst2list texsuffix.vst 0 "" "" fssel2_v] fssel2 sel ""

# file name selection box
CreateLSBox $Wf.c.m "" "" 18 16 2 fs_filesel$fsmenucols $Wf.d.tt "" "" fssel3 sel fsWfae

# insert new file name
label $Wf.c.m.li
entry $Wf.c.m.i -width $wfeb -relief sunken
pack configure $Wf.c.m.li $Wf.c.m.i -side top -anchor w
Bind3HF $Wf.c.m.li fs_fileedi$fsmenucols $Wf.d.tt
bind  $Wf.c.m.i <Button-1> \
	{fsfocus $Wf.c.m.i; set fsFoc 2; fsWfcmi $Wf.c.m.i; if $fsEntryWasEmpty Bend}
bind  $Wf.c.m.i <Button-2> {Bend}
Bind3HF $Wf.c.m.i fs_fileedi$fsmenucols $Wf.d.tt
bind  $Wf.c.m.i <Return> {fsemfn; fsfocus $Wf.d.tt; Bend}


# editor-file: c.e

if {$fsmenucols==3} {# label for 3-select-boxes-window
 label $Wf.c.e.l -text "$vv(fs2)" -anchor w; pack configure $Wf.c.e.l -side top -anchor w
 Bind3HTF $Wf.c.e.l "$vv(btclk1):\n" fs_filesel3 $Wf.d.tt
}

# suffix-box and file-ordering-buttons
frame $Wf.c.e.1; pack configure $Wf.c.e.1 -side top -anchor w -pady 2 -fill x

frame $Wf.c.e.1.1; frame $Wf.c.e.1.2
pack configure $Wf.c.e.1.1 -side left -anchor nw -ipady 3
pack configure $Wf.c.e.1.2 -side right -anchor ne -ipady 3 -padx 10

if {$fsmenucols==2} {# label for 2-select-boxes-window
 label $Wf.c.e.1.1.l -text "$vv(fs2)" -anchor w; pack configure $Wf.c.e.1.1.l -side top
 Bind3HTF $Wf.c.e.1.1.l "$vv(btclk1):\n" fs_filesel2 $Wf.d.tt
}

if ![info exists fssel2a_v] {set fssel2a_v "$vv(c2af0)"}
CreateLSBox $Wf.c.e.1.1 " " top 11 3 0 fs_filesel$fsmenucols $Wf.d.tt \
	"" "\{$vv(c2af0)\} \{$vv(c2af1)\}" fssel2a "" "" "ldist $ldist"

# suffix selection box
CreateLSBox $Wf.c.e.1.2 $vv(fs13) top 9 3 2 fs_filesuff $Wf.d.tt \
	"" [vst2list suffix.vst 0 "" "" fssel4_v] fssel4 sel ""

# file name selection box
CreateLSBox $Wf.c.e "" "" 18 16 2 fs_filesel$fsmenucols $Wf.d.tt "" "" fssel5 sel fsWfae

# insert new file name
label $Wf.c.e.li
entry $Wf.c.e.i -width $wfeb -relief sunken
pack configure $Wf.c.e.li $Wf.c.e.i -side top -anchor w
Bind3HF $Wf.c.e.li fs_fileedi$fsmenucols $Wf.d.tt
bind  $Wf.c.e.i <Button-1> \
	{fsfocus $Wf.c.e.i; set fsFoc 3; fsWfcei $Wf.c.e.i;if $fsEntryWasEmpty Bend}
bind  $Wf.c.e.i <Button-2> {Bend}
Bind3HF $Wf.c.e.i fs_fileedi$fsmenucols $Wf.d.tt
bind  $Wf.c.e.i <Return> {fseefn; fsfocus $Wf.d.tt; Bend}


InsertTextFrame $Wf $tyh "" "" ""

# initialisation, focus etc.

set fsFoc 0

fsfuellen main;  fsfuellen edit;  fsanzeige $Wf
$Wf.a.a.e configure -state normal; update; update idletasks; set fsWfEndEnable 1
}
