# common procedures for xtem_TeXMenu installation
#
# Copyright (C) 2004  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University
#
#########################################################################################################################


proc XiInit {} {# set some initialisations
 global copyright email www testPut bell_level RequestActive env whichcheck XiInstallationRuns
 set copyright "Copyright 2004  G.Lamprecht, W.Lotz, R.Weibezahn; IWD, Bremen University"
 set email     "e-mail: Roland.Weibezahn@web.de"
 set www       ""
 set testPut 0;# 0: no testoutput at all; 1: testoutput according to bell_level 0 (much output) | 1 | ... | 4 (no putput)
 set bell_level 0
 set RequestActive 0
 if [info exists env(PATH)] {set whichcheck "yes"} else {set whichcheck "no"}

 source ut.tcl; source xV.tcl; set XiInstallationRuns 1
 proc mybell {level} {global bell_level; if {$level>=$bell_level} {puts -nonewline stdout "\x7"}}
}

proc XiExit {text} {
  puts stdout "\n*****Error: ${text}\nSee Installation Guide; installation aborted!\n"; flush stdout;  mybell 4;  exit 4
}

proc XiProtokoll {text} {global XiFIDerr; puts stdout "$text"; puts $XiFIDerr "$text"; flush stdout}
proc XiProtokollEnd2 {text} {global XiProtEndText2; XiProtokoll "$text"; set XiProtEndText2 "${XiProtEndText2}$text\n"}
proc XiProtokollEnd4 {text} {global XiProtEndText4; XiProtokoll "$text"; set XiProtEndText4 "${XiProtEndText4}$text\n"}

proc XiGetArgsAndOpenLog {text} {# get arguments passed, opens Logfile
 global argv XiFIDerr NEWV NEW LOGFILE INSTPATH BINPATH MANPATH WISHCALL TCLCALL
 global PRINTCOM XTERMCALL XTEMVERSION LANGUAGES DEFLANGUAGE XiMaxBoxWidth newPrintingVst

 TestPut 4 "Arguments before split=<$argv>"
 set argv [split $argv "\#"]
 TestPut 3 "Arguments after  split=<$argv>"
 set LOGFILE         "[string trim [lindex $argv  0]]"
 set INSTPATH        "[string trim [lindex $argv  1]]"
 set BINPATH         "[string trim [lindex $argv  2]]"
 set MANPATH         "[string trim [lindex $argv  3]]"
 set WISHCALL        "[string trim [lindex $argv  4]]"
 set TCLCALL         "[string trim [lindex $argv  5]]"
 set PRINTCOM        "[string trim [lindex $argv  6]]"
 set XTERMCALL       "[string trim [lindex $argv  7]]"
 set XTEMVERSION     "[string trim [lindex $argv  8]]"
 set LANGUAGES       "[string trim [lindex $argv  9]]"
 set DEFLANGUAGE     "[string trim [lindex $argv 10]]"
 set XiMaxBoxWidth   "[string trim [lindex $argv 11]]"
 set newPrintingVst  "[string trim [lindex $argv 12]]"

 TestPut 2 "LANGUAGES:<$LANGUAGES>"
 regsub -all "\\\\" $LANGUAGES {} LANGUAGES
 regsub -all "\{\{" $LANGUAGES "\{" LANGUAGES
 regsub -all "\}\}" $LANGUAGES "\}" LANGUAGES
 TestPut 3 "LANGUAGES:<$LANGUAGES><[lindex $LANGUAGES 0]><[lindex $LANGUAGES 1]><[lindex $LANGUAGES 2]>"

 if {![file exists $LOGFILE]} {XiExit "something's going wrong: expected to find LOGFILE `$LOGFILE'"}
 set XiFIDerr [open $LOGFILE a]

 XiProtokoll "\n$text\n"
 XiProtokoll "\tLOGFILE         : \"$LOGFILE\""
 XiProtokoll "\tINSTPATH        : \"$INSTPATH\"\n\t\t\t\t(directory for installation of xtem_TeXMenu)"
 XiProtokoll "\tBINPATH         : \"$BINPATH\"\n\t\t\t\t(directory for executeables and shell scripts)"
 XiProtokoll "\tMANPATH         : \"$MANPATH\"\n\t\t\t\t(directory for man pages)"
 XiProtokoll "\tWISHCALL        : \"$WISHCALL\"\n\t\t\t\t(command to call wish (Tcl and Tk))"
 XiProtokoll "\tTCLCALL         : \"$TCLCALL\"\n\t\t\t\t(command to call tcl (pure Tcl without Tk))"
 XiProtokoll "\tPRINTCOM        : \"$PRINTCOM\""
 XiProtokoll "\tXTERMCALL       : \"$XTERMCALL\""
 XiProtokoll "\tXTEMVERSION     : \"$XTEMVERSION\""
 XiProtokoll "\tLANGUAGES       : \"$LANGUAGES\""
 XiProtokoll "\tDEFLANGUAGE     : \"$DEFLANGUAGE\""
 XiProtokoll "\tXiMaxBoxWidth   : \"$XiMaxBoxWidth\""
 XiProtokoll "\tnewPrintingVst  : \"$newPrintingVst\""
 XiProtokoll "\tcurrent dir     : \"[pwd]\""
 XiProtokoll ""

 if {"$INSTPATH"=="$BINPATH"} {XiExit "BINPATH cannot be set to $INSTPATH (file `xteminstall')"}

 if {[lsearch [Languages] $DEFLANGUAGE]<0} \
	{XiExit "DEFLANGUAGE must be one of `[Languages]' (languages defind in LANGUAGES) -- modify file `xteminstall'"}

 set n 0; set lang [lindex [lindex $LANGUAGES $n] 0]; while {$lang!=""} {
   set dir locals_$lang.LRW;	if ![file exists "$dir"] {XiExit "directory $dir doesn't exist!"}
   set dir help_$lang;		if ![file exists "$dir"] {XiExit "directory $dir doesn't exist!"}
   incr n; set lang [lindex [lindex $LANGUAGES $n] 0]
 }

 set NEWV "$XTEMVERSION"; set NEW "xtem-$NEWV"
}

proc XiPlatform {log} {
 global tcl_version tcl_patchLevel tcl_platform OSystem INSTPATH InstDir
 
 set InstDir $INSTPATH/locals_*
 setTclVersions install

 set s [array get tcl_platform]; set i [lsearch $s os]; if {$i>=0} {set OSystem [lindex $s [expr $i+1]]} {set OSystem ""}

 if {$log=="log"} {
   XiProtokoll "platform used:"
   XiProtokoll "\tinfo tclversion: <[info tclversion]>"
   XiProtokoll "\tinfo patchlevel: <[info patchlevel]>"
   if [info exists tcl_version] {XiProtokoll "\tset tcl_version: <[set tcl_version]>"}
   if [info exists tcl_patchLevel] {XiProtokoll "\tset tcl_patchLevel: <[set tcl_patchLevel]>"}
   XiProtokoll "\tarray get tcl_platform: <[array get tcl_platform]>"
   XiProtokoll ""
 }

 if {$log=="log"} {
   XiProtokoll "directory: [pwd]"
   XiProtokoll "ls -l: [exec ls -l]"
   XiProtokoll "\n"
 }
}

proc Languages {} {# Languages <-- all Languages defines in LANGUAGES. but without synonyms!
 global LANGUAGES LAnguages
 if ![info exists LAnguages] {
   set lstr "$LANGUAGES"; set LAnguages ""
   while {[lindex $lstr 0]!=""} {set LAnguages "$LAnguages [lindex [lindex $lstr 0] 0]"; set lstr [lrange $lstr 1 end]}
   set LAnguages [string trim $LAnguages]
   TestPut 4 "Languages=LAnguages=<$LAnguages>"
 }
 return "$LAnguages"
}

proc xiVstCallsWhich {} {

 proc xiVstCalls {file par} {# look for programs specified as parameter number par in file
   global XiVstActive XiVstSep XiCurLanguage
   set ret ""
   XiVst2Lists $file "" new
   TestPut 4 "<locals_$XiCurLanguage/$file><$XiVstSep><$par>\n\t\t\t<$XiVstActive>"
   for {set e 0} {$e<[llength $XiVstActive]} {incr e} \
	{lappend ret "\{[getvalue [lindex $XiVstActive $e] $par $XiVstSep]\} $file $e $par"}
   return $ret
 }

 proc xiTclCalls {cmd} {# look for programs in files prt_dvi*.tcl
   set ret ""
   TestPut 4 "<[pwd]><[glob prt_dvi*.tcl]>\t\t<$cmd>"
   set gres [catch "exec grep -n $cmd [glob prt_dvi*.tcl]" grest]
   if {($gres==0)&&($grest!="")} {
     set list [split "$grest" \n]
     foreach le $list {
       set le [split [string trimright "$le" \\] :]
       set file [lindex "$le" 0]; set ln [lindex "$le" 1]
       set t [string trim [string trim [lrange "$le" 2 end] \{\}]]
       if {[string first \# $t]!=0} {lappend ret "$cmd $file $ln"}
     }
   }
   return $ret
 }

 proc xiInstCalls {var} {# look for programs specified in variable var in file .../install.vst
   global XiCurLanguage
   set ret ""
   TestPut 4 "<[pwd]><locals_$XiCurLanguage/install.vst>\t\t<$var>"
   set f [open locals_$XiCurLanguage/install.vst]; set l 0
   while {[getscl $f e]>0} {
     incr l
     if {([string compare [lindex $e 0] "$var"]==0)&&([string compare [lindex $e 1] ""]!=0)} \
	{set ret "\{[lindex $e 1] install.vst $l/$var 1\}"}
   }
   close $f
   return $ret
 }

 global INSTPATH NEW XiProtEndText2 LANGUAGES XiCurLanguage language

 if ![info exists  XiProtEndText2] {set XiProtEndText2 ""}

 XiProtokoll "\n\nCheck whether the programs callable via the setting files are installed or not:"
 XiProtokoll "   (in directories \t\"$INSTPATH/$NEW/\",\n \t\t\t\"$INSTPATH/$NEW/locals_*/\")\n"

 set InstalledProgs ""
 set NotInstalledProgs ""
 set textnf "program not found, yet can be called via"
 set pln ""; set pln "$pln [xiTclCalls dvidvi]"; set pln "$pln [xiTclCalls dvips]"
 TestPut 3 " pln=<$pln>"
 for {set n 0} {$n<[llength $pln]} {incr n} {
   set program "[string trimright [lindex [lindex $pln $n] 0] &]"
   set file  "[lindex [lindex $pln $n] 1]";  set line "(line [lindex [lindex $pln $n] 2])"
   set not_installed [catch "which $program" m1]
   if {$program!=""} {
     if $not_installed {
       XiProtokoll "[XiFillString $program 20] : $textnf  $file $line"
       if {[lsearch $NotInstalledProgs $program]<0} {lappend NotInstalledProgs $program}
     } else {
       if {[lsearch $InstalledProgs $program]<0} {lappend InstalledProgs $program}
     }
   }
 }
 TestPut 3 "\n\n*****2\n<<$InstalledProgs>>\n\n<<$NotInstalledProgs>>\n\n"
 XiProtokoll     ""
 foreach XiCurLanguage [Languages] {
   set language $XiCurLanguage; # needed for proc "open_vst"
   set ProgramList(quickprevstd)    "[xiInstCalls quickprevstd]"
   set ProgramList(editor)          "[xiVstCalls editor.vst 2]"
   set ProgramList(editorxterm)     "[xiVstCalls editor.vst 1]"
   set ProgramList(texfmt)          "[xiVstCalls texfmt.vst 1]"
   set ProgramList(hyphenprog)      "[xiVstCalls hyphen.vst 2]"
   set ProgramList(previewer)       "[xiVstCalls preview.vst 1]"
   set ProgramList(printingdriver)  "[xiVstCalls printing.vst 3]"
   set ProgramList(printinglp)      "[xiVstCalls printing.vst 6]"
   set ProgramList(spellcheck)      "[xiVstCalls spellcheck.vst 1]"
   set ProgramList(syntax)          "[xiVstCalls syntax.vst 1]"
   set ProgramList(index)           "[xiVstCalls index.vst 1]"
   set ProgramList(bibtex)          "[xiVstCalls bibtex.vst 1]"
   set ProgramList(logform)         "[xiVstCalls logform.vst 2]"
   set ProgramList(utility)         "[xiVstCalls utility.vst 1]"
   set ProgramList(prt_dvips4)      "[xiVstCalls prt_dvips.vst 4]"
   set ProgramList(prt_dvips5)      "[xiVstCalls prt_dvips.vst 5]"
   set ProgramList(prt_dvips6)      "[xiVstCalls prt_dvips.vst 6]"
   set ProgramList(prt_dvips7)      "[xiVstCalls prt_dvips.vst 7]"
   set ProgramList(prt_dvijep4)     "[xiVstCalls prt_dvijep.vst 4]"
   set ProgramList(prt_dvijep5)     "[xiVstCalls prt_dvijep.vst 5]"
   set ProgramList(prt_dvijep6)     "[xiVstCalls prt_dvijep.vst 6]"
   set ProgramList(prt_dvijep7)     "[xiVstCalls prt_dvijep.vst 7]"
   set ProgramList(prt_dvilj4)      "[xiVstCalls prt_dvilj.vst 4]"
   set ProgramList(prt_dvilj5)      "[xiVstCalls prt_dvilj.vst 5]"
   set ProgramList(prt_dvilj6)      "[xiVstCalls prt_dvilj.vst 6]"
   set ProgramList(prt_dvilj7)      "[xiVstCalls prt_dvilj.vst 7]"
   foreach pln [lsort [array names ProgramList]] {
     TestPut 3 " pln=<$pln>  <$ProgramList($pln)>"
     for {set n 0} {$n<[llength $ProgramList($pln)]} {incr n} {
       set program "[string trimright [lindex [lindex [lindex $ProgramList($pln) $n] 0] 0] &]"
       set file  "locals_$language/[lindex [lindex $ProgramList($pln) $n] 1]"
       set lpar "(entry [lindex [lindex $ProgramList($pln) $n] 2],"
       set lpar "$lpar parameter [lindex [lindex $ProgramList($pln) $n] 3])"
       if {($pln=="logform")&&($program=="tla")} {
	 set lookfor 1; set not_installed 0
       } elseif {($pln=="logform")&&($program=="\$editor")} {
	 set lookfor 0
       } else {
	 set lookfor 1; set not_installed [catch "which $program" m1]
       }
       if {$lookfor&&($program!="")} {
	 if $not_installed {
	   XiProtokoll "[XiFillString $program 20] : $textnf  $file $lpar"
	   if {[lsearch $NotInstalledProgs $program]<0} {lappend NotInstalledProgs $program}
	 } else {
	   if {[lsearch $InstalledProgs $program]<0} {lappend InstalledProgs $program}
	 }
       }
     }
     TestPut 3 "\n\n*****4\n<<$InstalledProgs>>\n\n<<$NotInstalledProgs>>\n\n"
   }
   XiProtokoll     ""
 }
 TestPut 3 "\n\n*****5\n<<$InstalledProgs>>\n\n<<$NotInstalledProgs>>\n\n"
 if {$InstalledProgs!=""} {
   set InstalledProgs [lsort $InstalledProgs]
   XiProtokoll "Programs checked and found:"; set nf "\t"
   for {set n 0} {$n<[llength $InstalledProgs]} {incr n 5} {
     set nf "$nf[XiFillString [lindex $InstalledProgs       $n]     12] "
     set nf "$nf[XiFillString [lindex $InstalledProgs [expr $n+1]]  12] "
     set nf "$nf[XiFillString [lindex $InstalledProgs [expr $n+2]]  12] "
     set nf "$nf[XiFillString [lindex $InstalledProgs [expr $n+3]]  12] "
     set nf "$nf[XiFillString [lindex $InstalledProgs [expr $n+4]]  12] "
     set nf "$nf\n\t"
   }
   XiProtokoll "$nf"
 }
 if {$NotInstalledProgs!=""} {
   set NotInstalledProgs [lsort $NotInstalledProgs]
   set pt "\n  The following programs could not be found (`which ...'),\n"
   set pt "${pt}  yet they are callable via the setting files:"
   for {set n 0} {$n<[llength $NotInstalledProgs]} {incr n 5} {
     set pt "${pt}\n\t"
     set pt "$pt[XiFillString [lindex $NotInstalledProgs       $n]     12] "
     set pt "$pt[XiFillString [lindex $NotInstalledProgs [expr $n+1]]  12] "
     set pt "$pt[XiFillString [lindex $NotInstalledProgs [expr $n+2]]  12] "
     set pt "$pt[XiFillString [lindex $NotInstalledProgs [expr $n+3]]  12] "
     set pt "$pt[XiFillString [lindex $NotInstalledProgs [expr $n+4]]  12] "
   }
   set pt "${pt}\nreasons may be:"
   set pt "${pt}\n - program installed, yet cannot be found by `which' currently (PATH variable?)"
   set pt "${pt}\n - program installed with other command name (e.g. `tar' <---> `gtar'),"
   set pt "${pt}\n   install symbolic link or modify setting file concerned"
   set pt "${pt}\n - program not availabe: modify setting file concerned"
   set pt "${pt}\n  (for details see display above and `Installation Guide')"
   set XiProtEndText2 "${XiProtEndText2}$pt"
 }
}

proc XiFillString {string length} {# fills string up to lenght with trailing blanks
 TestPut 2 ""
 while {[string length $string]<$length} {set string "$string "}; return "$string"
}

proc Xigetscl0 {foid e} {# like getscl, but blanks at begin-of-continuation-line deleted
 upvar 1 $e ein
 TestPut 1 ""
 set ret [gets $foid z];  set z [string trimright $z]
 set ein "$z"
 set lm1 [expr [string length $z]-1]
 while {($lm1>=0)&&([string last \\ $z]==$lm1)} { 
   set ein [string range $ein 0 [expr [string length $ein]-2]]
   set ret [gets $foid z];  set z [string trimright $z]
   set lm1 [expr [string length $z]-1]
   set ein "$ein[string trimleft $z]"
 }
 if {$ret>=0} {set ret [string length "$ein"]}
 TestPut 1 "<$ret>"
 return $ret
}

proc SetXiVstOriginalParameters {LRWfil} {# check for same parameters in first line, set XiVstOriginalParameters
 global XiVstOriginalParameters XiVstFL XiVstSep XV
 set f [open $LRWfil r]; Xigetscl0 $f flLRW; close $f
 regsub -all " " $flLRW "" sflLRW;				regsub -all "$XiVstSep" "$sflLRW" "" sflLRW; 
 regsub -all " " "$XiVstFL" "" sfl;				regsub -all "$XiVstSep" "$sfl"    "" sfl; 
 if {"$sfl"=="$sflLRW"} {set XiVstOriginalParameters 1} {set XiVstOriginalParameters 0}
 TestPut 2 "\n<$XiVstFL>\n\n<$sfl>\n<$sflLRW>\n<$XiVstOriginalParameters>"
}

proc XiVst2Lists {file tmp newadd} {# read vst-file, store as new lists in XiVstActive/Inactive or append to Inactive
 global XV XiCurLanguage XiVstActive XiVstInactive XiVstSep XiNoSepVstFiles XiVstHasSep XiVstFL XiVstDefLine XiVstParAnz
 global tclversion xtem_path language XiVstOriginalParameters INSTPATH NEW Wevst XiVstVersion
 TestPut 4 "<$file><$tmp><$newadd>"
 if [regexp {prt_.+\.vst$} $file] {set XV(XSettVF$file) $XV(XSettVFprt_dvi2xyz.vst)}
 set LRWfil $INSTPATH/$NEW/locals_$XiCurLanguage.LRW/$file
 set XiVstHasSep [lindex $XV(XSettVF$file) 0]
 if {$newadd=="new"} {set XiVstActive "";  set XiVstInactive ""; set XiVstFL ""; set XiVstSL ""}
 if {"$file"=="mkcommand.vst"} \
     {global MkcmdTclVColNr; if [info exists MkcmdTclVColNr] {unset MkcmdTclVColNr}; set mkcmdcol [MkcmdTclVCol no-exit]}
 if {$newadd=="new"} {
   if {$tmp=="tmp"} {set f [open_vst "${file}.tmp"]} else {set f [open_vst "$file"]}
   if $XiVstHasSep {
     Xigetscl0 $f e; set XiVstFL "$e"; set XiVstSep [string index [string trim $e] 0]
     if {([lindex $XV(XSettVF$file) 1]==0)&&("$file"!="mkcommand.vst")} \
	{set XiVstVersion [lindex [string range [string trim $e] 1 end] 0]}
   } else {set XiVstSep ""; set XiVstVersion ""}
   if $XiVstHasSep {TestPut 3 "1a<$XiVstSep><$XiVstVersion>  <$e>"}
 } elseif {$newadd=="add"} {
   set errt "File not found: `$LRWfil'; why did you delete this file?"
   if ![file exists $LRWfil] {$Wevst.e.t configure -text "$errt"; XiProtokoll "\n$errt\n"; mybell 4; return}
   lappend XiVstInactive "---------- appended from file $LRWfil: ----------"
   set f [open "$LRWfil" r];# Xigetscl0 $f e
   if $XiVstHasSep {Xigetscl0 $f e; set XiVstSepLRW [string index [string trim $e] 0]} {set XiVstSepLRW ""}
   if $XiVstHasSep {TestPut 1 "1b<$XiVstSep><$XiVstSepLRW>  <$e>"}
 }
 if {[lindex $XV(XSettVF$file) 3]==0} {# user cannot define parameters in this file
   set XiVstParAnz [lindex $XV(XSettVF$file) 2]
   set XiVstOriginalParameters 1
 } else {			       # user can define parameters in this file
   set XiVstParAnz [expr [llength [split $XiVstFL $XiVstSep]]-1]
   if {[lindex [split $XiVstFL $XiVstSep] $XiVstParAnz]==""} {incr XiVstParAnz -1}
   set liste [split $XiVstFL $XiVstSep]; set XiVstFL "[lindex $liste 0]"
   for {set n 1} {$n<=$XiVstParAnz} {incr n} \
	{regsub -all " " [string trim [lindex $liste $n]] "_" zz;  set XiVstFL "$XiVstFL$XiVstSep $zz "}
   if {$newadd=="new"} {SetXiVstOriginalParameters $LRWfil}
 }
 if {[lindex $XV(XSettVF$file) 1]==1} {# criteria line expected in this file
   Xigetscl0 $f e
   TestPut 1 "2<$e>"
   if {$newadd=="new"} {
     set XiVstSL "$e"
     if {[string trim [lindex [split $e $XiVstSep] 0]]!=""} {# no default criteria line (in printing.vst) found
       set XiVstSL "          "; set liste [split $XiVstFL $XiVstSep]
       for {set n 1} {$n<=$XiVstParAnz} {incr n} {
	 set XiVstSL "$XiVstSL$XiVstSep"
	 if {[string trim [lindex $liste $n]]!=""} {set XiVstSL "${XiVstSL} * "} \
	 else					   {set XiVstSL "${XiVstSL}[lindex $liste $n]"}
       }
       lappend XiVstActive $XiVstSL
     }
     lappend XiVstActive $e
   }
 }
 if {("$file"=="mkcommand.vst")&&($mkcmdcol==0)} {set XiVstFL "$XiVstFL $XiVstSep Tcl_$tclversion"; incr XiVstParAnz}
 set ln 0; set active 1
 while {[Xigetscl0 $f e]>=0} {incr ln
   TestPut 1 "3<$ln><$e>"
   set l [string length $e]; set p [string first "$XV(XSettVCom$XiCurLanguage)" $e]
   if {("$file"=="mkcommand.vst")&&($mkcmdcol==0)} {set e "$e $XiVstSep"; if {$ln==1} {set e "$e mkcommand.9"}}
   if     {($l> 0)&&($active)} {if {$newadd=="new"} {lappend XiVstActive $e} {lappend XiVstInactive $e}} \
   elseif {($l==0)&&($active)} {set active 0} \
   elseif {($l> 0)&&($p<0)}    {lappend XiVstInactive $e}
 }
 close $f
 set XV(XSettVF$file) [lreplace $XV(XSettVF$file) 7 7 $XiVstParAnz]
 set XiVstDefLine ""; for {set n 1} {$n<=$XiVstParAnz} {incr n} {set XiVstDefLine "$XiVstDefLine $XiVstSep"}
}

proc XiSaveVstfile {FileSuffix protocol} {
 global XV INSTPATH NEW XiCurLanguage XiVstActive XiVstInactive XiVstHasSep XiVstFL
 TestPut 2 ""
 set file $INSTPATH/$NEW/locals_$XiCurLanguage/$FileSuffix
 set f [open $file w]
 if {$XiVstHasSep} {puts $f "$XiVstFL"}
 if {$XiVstHasSep} {set pnl " \\\n"} else {set pnl ""}
 foreach l $XiVstActive {puts $f "$l$pnl"}
 puts $f "\n$XV(XSettVCom$XiCurLanguage)\n"
 foreach l $XiVstInactive {puts $f "$l$pnl"}
 flush $f;  close $f
 if $protocol {XiProtokoll "\tsave file \"$file\""}
}

proc XiGet_vv_XV {} {
 global vv XV DEFLANGUAGE XiVstLO

 # now set array vv with texts for this xtem release
 set f [open "help_$DEFLANGUAGE/button.texts" r]
 while {[gets $f z]>=0} {
	set z "[string trim $z] "; set p [string first " " $z]
	set vv([string range $z 0 [expr $p-1]]) [string trim [string range $z $p end]]
 }
 close $f

 set XV(AAsteriks) "********************************************************************************"
 set XV(anever)    "String which never should occur normally!"
 set XV(anoact)    "the selected entry is not an active one ---"
 set XV(anoact)     "$XV(anoact) select an active entry or `make_active' or `copy_to_active' first!"
 set XV(anocopy)   "the selected entry cannot be copied!"
 set XV(anodelete) "this entry cannot be deleted!"
 set XV(anoentry)  "no entry selected --- select entry first!"
 set XV(anoinact)  "the selected entry is not a comment --- select an entry from the comment list!"
 set XV(anomove)   "the selected entry cannot be moved!"
 set XV(anomovedo) "the selected entry cannot be moved downwards within this list any more!"
 set XV(anomoveup) "the selected entry cannot be moved upwards within this list any more!"
 set XV(MkCmdNCol1) "New column generated for Tcl version"
 set XV(MkCmdNCol2) "complete all lines (starting with the 2nd line) according to your system!"
 set XV(Xeebabrt)  "abort"
 set XV(Xeebends)  "end"
 set XV(Xeebnext)  "down"
 set XV(Xeebprev)  "up"
 set XV(Xeebpdel)  "delete_parameter"
 set XV(Xeebpadd)  "add_parameter"
 set XV(Xeetabrt)  "abort this window"
 set XV(Xeetends)  "ends this window (saving changes done in this window!)"
 set XV(Xeetnext)  "switch to the next entry in the entry list (saving changes done in this window!)"
 set XV(Xeetprev)  "switch to the previous entry  in the entry list (saving changes done in this window!)"
 set XV(Xeetpdel)  "after clicking this button you can specify the parameter to be deleted (from each entry)"
 set XV(Xeetpadd)  "after clicking this button you can specify a new parameter to be added (to each entry)"
 set XV(XSettVButtons) "1 2 3 4 5 6 7 8 9 10 11 12"
 set XV(XSettVBut1)  "edit_all_entries XiSettVBEditBuff  {edit all entries in a text edit widget} {}"
 set XV(XSettVBut2)  "append_new_entry XiSettVBAppdNewE  {create a new active entry and edit this entry} {}"
 set XV(XSettVBut3)  "copy_to_active   XiSettVBCopyAct   \
	{copy the selected inactive entry to the active entries (Shift modifier for successive copies)} \
							{selected entry is copied}"
 set XV(XSettVBut4)  "copy_to_inactive XiSettVBCopyInact \
	{copy the selected active entry to the comment lines (Shift modifier for successive copies)} \
							{selected entry is copied}"
 set XV(XSettVBut5)  "edit_one_entry   XiSettVBEditEntry {edit the selected active entry} {}"
 set XV(XSettVBut6)  "delete_entry     XiSettVBDeltEntry {delete selected entry (Shift modifier for successive delete)} \
							{selected entry is deleted}"
 set XV(XSettVBut7)  "move_to_active   XiSettVBMakeActiv \
	{move the selected comment line to the active entries (Shift modifier for successive moves)} \
							{selected entry is moved to active entries}"
 set XV(XSettVBut8)  "move_to_inactive XiSettVBMakeInact \
	{move the selected active entry to the comment lines (Shift modifier for successive moves)} \
							{selected entry is moved to comments}"
 set XV(XSettVBut9)  "copy&edit_entry  XiSettVBCpEdEntry {copy the selected active entry and edit the copy} {}"
 set XV(XSettVBut10) "move_to_default  XiSettVBMoveDeflt {move the selected entry to default position} \
							{moved to default position}"
 set XV(XSettVBut11) "move_1_up        XiSettVBMove1Up   {move the selected entry 1 line up} \
							{selected entry moved up}"
 set XV(XSettVBut12) "move_1_down      XiSettVBMove1Down {move the selected entry 1 line down} \
							{selected entry moved down}"
 set XV(XSettVBut13) "$XV(Xeebpdel)    XiSettVBParDel    {$XV(Xeetpdel)} {}"
 set XV(XSettVBut14) "$XV(Xeebpadd)    XiSettVBParAdd    {$XV(Xeetpadd)} {}"
 set XV(XSettVComgerman)  "*** ab hier \"Kommentar\" (Leerzeile beendet den ausgewerteten Teil der Datei!)"
 set XV(XSettVComenglish) "*** the preceding empty line ends the setting file, the following is \"comment\""
 set XiVstLO 10; # Vst-List-Offset for the following specifications in XV(XSettVF...)
 # [lindex (XV(XSettVF...)  0] : file has separator (1) or not (0)
 # [lindex (XV(XSettVF...)  1] : criteria line (1) or no criteria line (0)
 # [lindex (XV(XSettVF...)  2] : number of parameters (without user added parameters, see printing.vst)
 # [lindex (XV(XSettVF...)  3] : user may specify new parameters. eg. printing.vst (1) or not (0)
 # [lindex (XV(XSettVF...)  4] : width for entry/text widgets in vst-entry-change window
 # [lindex (XV(XSettVF...)  5] : width for labels in vst-entry-change window
 # [lindex (XV(XSettVF...)  6] : position for label relative to entry/text widgets in vst-entry-change window
 # [lindex (XV(XSettVF...)  7] : current number of parameters (will be set by xi.tcl, procedure XiSettEditVst)
 # [lindex (XV(XSettVF...)  8] : if != "" : minimum width for parameter p0 if no file separator
 # [lindex (XV(XSettVF...)  9] : 
 # [lindex (XV(XSettVF...) 10] : list:  p0 | {p0 [p1 [p2 p3]]}
 #                                   p0: parameter_name (_ if unused, e.g. printing.vst)
 #                                   p1: =1 if_parameter_must_be_nonempty; blank or 0 otherwise
 #                                   p2: blank if no "suboptions", otherwise 
 #                                       number of lines for text edit widget for this parameter (see printing.vst)
 set XV(XSettVFbibtex.vst)     "1 0  2 0 45 30 top  {} {} {} {bitext 1} {bibtex 1} bioptions"
 set XV(XSettVFcleanup.vst)    "1 0  1 0 10 30 top  {} {} {} {aufsuff 1} {auftoggle 1}"
 set XV(XSettVFeditor.vst)     "1 0  3 0 50 30 top  {} {} {} {edtext 1} edxterm {editor 1} edoptions"
 set XV(XSettVFhyphen.vst)     "1 0  4 0 30 20 top  {} {} {} {hyphentext 1} {texposthyph 1} hyphenprog hyphenopts"
 set XV(XSettVFhyphen.vst)   "$XV(XSettVFhyphen.vst) hyphenchk"
 set XV(XSettVFindex.vst)      "1 0  2 0 55 30 top  {} {} {} {intext 1} index inoptions"
 set XV(XSettVFinstall.vst)    "0 0  1 0 60 30 top  {} 20 {} {variable_name 1} variable_value"
 set XV(XSettVFletter.vst)     "1 0  4 0 70 30 top  {} {} {} {lettext 1} letter letbackalw letback letoptions"
 set XV(XSettVFloganalyze.vst) "1 0  2 0 24 30 top  {} {} {} {texlogatext 1} {texloganalyze 1} texlogopts";# obsolete!
 set XV(XSettVFlogform.vst)    "1 0  3 0 45 30 top  {} {} {} {logtext 1} logterm {logform 1} logoptions"
 set XV(XSettVFlogsuffix.vst)  "0 0  1 0 45 30 top  {}  6 {} lsuff text_describing_the_logfile"
 set XV(XSettVFmkcommand.vst)  "1 0  0 1 60 30 top  {} {} {} {text 1}"
 set XV(XSettVFpreview.vst)    "1 0  4 0 52 30 top  {} {} {} {prtext 1} {preview 1} {prsuffix 1} proptions {prvformat 1}"
 set XV(XSettVFprinting.vst)   "1 1 11 1 60 15 left {} {} {} {text 1} {printer 1} {emulation 1} {prtdriver 1} {prtsuf 1}"
 set XV(XSettVFprinting.vst) "$XV(XSettVFprinting.vst) prtoptions {lpcmd 1} lpopt _ _ _ {prformat 1 4}"
 set XV(XSettVFprt_dvi2xyz.vst) "1 0  7 0 85 30 top  {} {} {} {prmtext 1} prmrelabs {prmsel 1} _"
 set XV(XSettVFprt_dvi2xyz.vst) "$XV(XSettVFprt_dvi2xyz.vst) prtcmd(1) prtcmd(2) prtcmd(3) prtcmd(4)"
 set XV(XSettVFspellcheck.vst)  "1 0  5 0 80 30 top  {} {} {} {sptext 1} {spcmd 1} splang spcorr spselect spoptions"
 set XV(XSettVFsuffix.vst)      "0 0  0 0 20 30 top  {}  6 {} esuff"
 set XV(XSettVFsyntax.vst)      "1 0  2 0 55 30 top  {} {} {} {sytext 1} {syntax 1} syoptions"
 set XV(XSettVFtexfmt.vst)      "1 0 10 0 50 30 top  {} {} {} {text 1} {texfmt 1} quickenable quickverbatim quickprereq"
 set XV(XSettVFtexfmt.vst)   "$XV(XSettVFtexfmt.vst) quickpreform quicksuffix quickpreamble quickendpre quickenddoc"
 set XV(XSettVFtexfmt.vst)   "$XV(XSettVFtexfmt.vst) mainfilgrep"
 set XV(XSettVFtexmax.vst)      "0 0  0 0 10 30 top  {} {} {} texmax";# obsolete; only for backward compatibility!
 set XV(XSettVFtexopts.vst)     "1 0  1 0 24 30 top  {} {} {} {texopttext 1} texopts"
 set XV(XSettVFtexsiz.vst)      "1 0  1 0 12 30 top  {} {} {} {texmtext 1} texmem"
 set XV(XSettVFtexsuffix.vst)   "0 0  0 0 10 30 top  {}  6 {} texsuffix"
 set XV(XSettVFutility.vst)     "1 0  7 0 50 30 top  {} {} {} {text 1} {command 1} options file_requested default_suffix"
 set XV(XSettVFutility.vst)  "$XV(XSettVFutility.vst)  suffix_list cd_dir (no)backup"
}

#________________________________________________________________________________________________________________________
