(******************************************************************************
 * program:     wp2latex                                                      *
 * function:    convert WordPerfect 6.0 files into LaTeX               *
 * modul:       wp2lfir.c                                                     *
 * description: This modul contains functions for first pass. In the first    *
 *              pass information of the WP binary file will splitted in two   *
 *              parts:                                                        *
 *              1) A text file containing the whole text. The special WP      *
 *                 characters are translated.                                 *
 *              2) A binary file which contains information about             *
 *                 environments, tabbings, line endings                       *
 ******************************************************************************)
unit Pass1_6;

interface
uses pass1,common,strings,charactr,formulas;


Procedure Convert_first_pass60(var FileIn,Tabel:bin;var StripOut:text;LogFile:Ptext);


Procedure ProcessKey(var cq:TconvertedPass1);

const NormalText=0;
      HeaderText=1;
      CharsOnly=2;
      Nothing=3;

implementation



const filter:Array[0..3] of set of byte=(
                   [0..$FF],
		   [0..$BF,$C0,$D1,$D2,$D4..$FF],
                   [$20..$7F,$A9,$C0],
		   []);
      EqSeparator=['^','_','*','/','+','-',' ','~','\'];

      SizesC0:array[$C0..$CF] of Byte=
      	{	(3,8,10,2,2,4,5,6,0,0,0,0,0,0,0,0);}
        	(4,9,11,3,3,5,6,7,0,0,0,0,0,0,0,0);


{this procedure isn't called now. It can be used for exploration of new objects}
Procedure CrackObject(var cq:TconvertedPass1;end_of_code:longint);
var txt:text;
    i:word;
    a:array[0..1000] of byte;
    pos:longint;
    len:word;
const ss:string[8]='00__.txt';
Begin                           { less length }
  pos:=Filepos(cq.wpd^);

  fillchar(a,sizeof(a),0);
  len:=end_of_code-Filepos(cq.wpd^);
  blockread(file(cq.wpd^),a,len);

  if ss[2]>'9' then
     begin
     ss[2]:='0';
     inc(ss[1]);
     end;
  assign(txt,ss);
  rewrite(txt);
    for i:=0 to len do
	begin
	write(txt,i:2,' ');
	writeXbyte(a[i],txt);
        if chr(a[i]) in [' '..'z'] then write(txt,' ',chr(a[i]));
	writeln(txt);
	end;

  close(txt);
  inc(ss[2]); {}

  seek(cq.wpd^,pos);
end;


Function CheckConzistency6(var cq:TconvertedPass1; NewPos:Longint):Boolean;
var TestedBy:byte;
    Pos:longint;
begin
 CheckConzistency6:=True;
 Pos:=filepos(cq.wpd^);

 seek(cq.wpd^,NewPos-1);
 read(cq.wpd^,TestedBy);
 if TestedBy<>cq.By then
        begin
        if cq.log<>nil then
		begin
		writeln(cq.log^);
                write(cq.log^,'Error: Object consistency failed. Trying to ignore.');
                end;
        CheckConzistency6:=False;
 	asm int 3; end;
        end;

 seek(cq.wpd^,Pos);
end;



{This is main procedure for processing one key. It is recursivelly called.}
Procedure ProcessKey(var cq:TconvertedPass1);
var w:Word;
    NewPos:Longint;
    by,subby:byte;

    chr_code,chr_set,b: Byte;
    ch:string;

Label ObjectError;
begin
NewPos:=0;
if cq.by=0 then Read(cq.wpd^,cq.by);


Case cq.by of
        $D0..$DF:begin
                 Read(cq.wpd^,cq.subby);
                 Rd_word(cq.wpd^,w);
                 NewPos:=cq.ActualPos+w;
                 cq.LineBegin:=False;
                 end;
             $F1:NewPos:=cq.ActualPos+5;
	end;

if ExtendedCheck and (NewPos<>0) then
	if not(CheckConzistency6(cq,NewPos)) then
        	begin
                NewPos:=0;
                Goto ObjectError;
                end;




case cq.by of
	$20..$7F:begin
        	 ch := StrPas((addr(lat[cq.by])));	{ Normal_char  }
                 if cq.Font<>0 then
                    	begin
                        if not(chr(cq.by) in [' '..';','?']) then
                        	begin
                                cq.Font:=0;
                                write(cq.strip^,'\em ');
                                end;
                        end;
                 write(cq.strip^,ch);
                 end;
             $80:write(cq.strip^,' ');	{soft space}
             $CC:Terminate_Line(cq,'h'); {[hrt]  Hard line }
             $CF:Terminate_Line(cq,'r');
             $F0:begin
                 Read(cq.wpd^,chr_code);
		 Read(cq.wpd^,chr_set);


		 ch:=StrPas(ext_chr_str(chr_set,chr_code,cq));


                 if cq.Font<>0 then
                     begin
                     if chr_set<>10 then
                             begin
                             cq.Font:=0;
                             write(cq.strip^,'\em ');
                             end;
                     end;

                 if chr_set=10 then
                   begin
                   if cq.Font=0 then
                       begin
                       cq.Font:=1;
                       write(cq.strip^,'\bukvy ');
                       end;

                   end;

                 write(cq.strip^,ch);

		 Read(cq.wpd^,b);
	         End;
             $D0:begin
                 if cq.subby=6 then Terminate_Line(cq,'p'); { Soft page }
                 if cq.subby=9 then Terminate_Line(cq,'P'); { Hard page }
                 end;
        end;


ObjectError:
cq.ActualPos:=FilePos(cq.wpd^);
if (NewPos<>0) then
  if (NewPos<>cq.ActualPos) then
           begin
           seek(cq.wpd^,newpos);
           cq.ActualPos:=NewPos;
           NewPos:=0;
           end;

end;



{*************************************}
{ This procedure provides all needed processing for the first pass}
Procedure Convert_first_pass60(var FileIn,Tabel:bin;var StripOut:text;LogFile:Ptext);
Var wo : Word;
   convperc,lastconvperc,i: Integer;
   srtdocpos,fsize: longint;

   cq:TconvertedPass1;
Begin
   Table_Init(Lat);

   Reset_attr_rij(0,cq);
   Reset_attr_rij(1,cq);

   cq.wpd:=addr(FileIn);
   cq.tabel:=addr(Tabel);
   cq.Strip:=addr(StripOut);
   cq.Log:=LogFile;

   cq.font:=0;
   cq.depth := 0;
   cq.FirstSection:=120;
   cq.Recursion := 0;
   cq.Flag:=NormalText;

   WP_default(cq);

   cq.latex_tabpos:=0;
   cq.right_tab := False;
   cq.align_tab := False;
   cq.center_tab := False;

   cq.indenting:=0;
   cq.indent_end:=False;
   cq.ind_text1:=False;
   cq.ind_text2:=False;
   cq.ind_leftmargin:=0;

   cq.envir:=' ';

   cq.nomore_valid_tabs := False;

   if Verbosing>=1 then
   	begin
	Writeln('First pass :');
	Write('Converting-percentage :     ');
        end;

   srtdocpos:=filepos(cq.wpd^);
   fsize:=FileSize(cq.wpd^);

   cq.rownum := 0;

   Make_tabelentry_attr(cq);           { attribuut instelling }

   Make_tabelentry_tabset(cq);         { Geef the defaulttabinstelling door }
				   { tied the 2e pass }

   
   cq.ActualPos:=FilePos(cq.wpd^);
   lastconvperc:=200;
   While (cq.ActualPos<fsize) Do
        Begin
        convperc:=round((cq.ActualPos-srtdocpos)/(fsize-srtdocpos)*100);
        if (lastconvperc<>convperc)and(Verbosing>=1) then
            begin
            Write(chr(8),chr(8),chr(8),chr(8),convperc:3,'%');
            lastconvperc:=convperc;
            end;

        cq.by:=0;
        ProcessKey(cq);
        End;

   Writeln;
   Make_tabelentry_envir_extra_end(cq);

   num_of_lines_stripfile := cq.rownum;

End;


end.
{--------------------End of PASS1--------------------}


