/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.bibeditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.bibeditor.BibEditor;
import net.sourceforge.texlipse.bibeditor.BibProjectionAnnotation;
import net.sourceforge.texlipse.model.ReferenceEntry;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;

public class BibCodeFolder {
    private BibEditor editor;
    private ProjectionAnnotationModel model;
    private ArrayList oldNodes;
    private boolean firstRun;

    public BibCodeFolder(BibEditor editor) {
        this.editor = editor;
        this.firstRun = true;
    }

    public void update(List outline) {
        this.model = (ProjectionAnnotationModel)this.editor.getAdapter(ProjectionAnnotationModel.class);
        if (this.model != null) {
            this.addMarks(outline);
        }
    }

    private void addMarks(List outline) {
        if (this.firstRun) {
            HashMap map = new HashMap();
            this.fillAnnotationMap(outline, map, TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("bibFoldInitial"));
            this.model.modifyAnnotations(null, map, null);
            this.firstRun = false;
        } else {
            this.oldNodes = new ArrayList();
            Iterator iter = this.model.getAnnotationIterator();
            while (iter.hasNext()) {
                this.oldNodes.add((BibProjectionAnnotation)((Object)iter.next()));
            }
            this.markTreeNodes(outline);
            BibProjectionAnnotation[] deletes = new BibProjectionAnnotation[this.oldNodes.size()];
            this.oldNodes.toArray(deletes);
            this.model.modifyAnnotations((Annotation[])deletes, null, null);
        }
    }

    private void markTreeNodes(List outline) {
        ListIterator iter = outline.listIterator();
        block0: while (iter.hasNext()) {
            ReferenceEntry re = (ReferenceEntry)iter.next();
            Position pos = re.position;
            ListIterator li2 = this.oldNodes.listIterator();
            while (li2.hasNext()) {
                BibProjectionAnnotation cAnnotation = (BibProjectionAnnotation)((Object)li2.next());
                if (!cAnnotation.isSame(re)) continue;
                this.oldNodes.remove((Object)cAnnotation);
                continue block0;
            }
            this.model.addAnnotation((Annotation)new BibProjectionAnnotation(re), pos);
        }
    }

    private void fillAnnotationMap(List documentTree, Map map, boolean fold) {
        ListIterator iter = documentTree.listIterator();
        while (iter.hasNext()) {
            ReferenceEntry node = (ReferenceEntry)iter.next();
            Position pos = node.position;
            BibProjectionAnnotation tpa = new BibProjectionAnnotation(node, fold);
            map.put(tpa, pos);
        }
    }
}

