/* change.c: changes one Plain command by the LaTeX equivalent
   Copyright (C) 1998 Pedro Fortuny.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file readme.t2l to know how to use this program. And how you
    can support me :-)

    Pedro Fortuny. Dpto. Algebra. Universidad de Valladolid. Spain.
    pfortuny@vax631.cpd.uva.es
*/

#include <stdio.h>
#include <string.h>
#include "t2l.h"
/* REMEMBER: 64 IS THE MAXIMUM COMMAND-WORD LENGTH */

int rplace(FILE *new_file,FILE *replace,char str[]);
/* rplace:
   this function reads the file 'replace.txt' and writes in 'new_file'
   the new LaTeX command instead of the Plain one.
   IMPORTANT: the structure of replace.txt
   is as follows (beginning stright away like this):
   %comments
   ...
   %comments
   word (newline) word (newline)(newline)

   where the first 'word' is the Plain command to be changed and the second is the
   one that will replace the other. the maximum length is set to 64 (i think no one
   will use names of operators with more than those characters)

   replace returns several values: 0,1,2,3,4,5,6,7,9999,9998. they are explained
   below.
   */


int rplace(FILE *new_file,FILE *replace,char str[]){
   char new_word[64];
   char red_word[64];    /* red stands for the p.p. of "read" */
   char comment;         /* there are special symbols in the first place
                            of some LaTeX words in replace.txt. this var
                            is to read them */
   rewind(replace);      /* necessary */

   /* do not read the comments at the beginning of replace.txt */
   fread(&comment,1,1,replace);
   while(comment=='%'){for(;comment!='\n';fread(&comment,1,1,replace));
                       fread(&comment,1,1,replace);}
   fseek(replace,-1,SEEK_CUR);

   /* and now read the whole Plain word until it is found (or eof)
      in replace.txt. see how the structure of replace.txt is very
      important.
   */
   fgets(red_word,64,replace);
   while(compare(red_word,str)==0 && !feof(replace)){
   fgets(red_word,64,replace);
   fgets(red_word,64,replace);
   fgets(red_word,64,replace);
   }
   /* in any case -even eof- read the LaTeX command or 'eof' */
   fgets(new_word,64,replace);
/*   fflush(stdin);*/
   /* if feof, then write the Plain word in the destination file and
   tell principal to do nothing -this is return(0)- */
   if(feof(replace)){fwrite(str,1,strlen(str)-1,new_file); return(0);}
   if(new_word[1]==']') return BEGIN_BIBLIO; /* begin  compiling the bibliography */
   if(new_word[1]=='"') return END_BIBLIO; /* end compiling the bibliography */

   /*if the command read in replace.txt begins by '\\', erase the '\\'
     of the destination file and change new_word by the same string
     one char to the right. Do not return yet for there may be
     more information. Example:
          \proclaim

     must be changed by
          {\bf ...

     so the slash is to be erased
   */
   if(new_word[0]=='\\'){
     fseek(new_file,-1,SEEK_CUR);
     strcpy(&new_word[0],&new_word[1]);
     }

   /*if the command read in replace.txt has a '&' or a '!' inside,
     it means -see that
     file- that we have to look for something after the Plain command and
     put it between braces. the differences between the '&' and the '!' are
     explained in replace.txt. tell principal to do so (this is return 5)
   */
   if(strchr(new_word,'&')!=NULL
      || strchr(new_word,'!')!=NULL
      || new_word[0]=='0'){
     strcpy(str,new_word);
     return SPECIAL;
     }

   /*compare is as strcmp but inverted -i got tired of strcmp. So !=0
     means that the strings are equal.
     if the (LaTeX) command read is ||, tell principal to put a % before the LaTeX
     command for it is useless but may give information to the user. this
     is the meaning of return 1.
   */
   if(compare(new_word,"||\n")!=0){
      return INSERT_COMMENT;
     }

   /* as before, but if it is |, tell principal (return 2)
      to eliminate it completely
      for the Plain command is useless and may be in the middle of a
      line (so it is not worthy putting a % before, we could make LaTeX
      override useful commands)
   */
   if(compare(new_word,"|\n")!=0){
      fseek(new_file,-1,SEEK_CUR);
      return ERASE_LINE;
     }
   /*this case means: we have to look
     for a number which is not in braces
     example \hskip 1pt and may be followed by a string -up to date only
     pt, cm, ...- return 3 to tell principal to look for this thing
   */
   if(strlen(new_word)>2 &&
      *(new_word+strlen(new_word)-2)=='|'){
      new_word[strlen(new_word)-2]='\n';
      fwrite(new_word,1,strlen(new_word)-2,new_file);
      return TEXTandNUMBER;
     }
   /*the same as before but the thing to look for is a word or a word.sth
     like in inputs. this is return 4
   */
   if(strlen(new_word)>2 &&
      *(new_word+strlen(new_word)-2)=='?'){
      new_word[strlen(new_word)-2]='\n';
      fwrite(new_word,1,strlen(new_word)-2,new_file);
      return TEXTNUMBER;
     }

   /*if the word contains a '#', we have to put between braces something
     that is already between them or that is a word (by end-of-word we mean
     any character of those appearing in funcion redword(see there); tell
     principal to do so: return 6.
   */
   if(new_word[strlen(new_word)-2]=='#'){
      new_word[strlen(new_word)-2]='\n';
      fwrite(new_word,1,strlen(new_word)-2,new_file);
      return noTEXT;
     }

   /* this case is completely explained in principal */
   if(new_word[0]=='*'){
     strcpy(str,new_word);
     return STAR;
     }

   /* if no return before this means the change is direct, so make it
      and tell principal to do nothing: return 0
   */
   fwrite(new_word,1,strlen(new_word)-1,new_file);
   return 0;

}
