/*
	rtf.h - RTF document processing stuff.  Distribution 1.06a3.
*/


/*
	Twentieths of a point (twips) per inch (Many RTF measurements
	are in twips per inch (tpi) units).  Assumes 72 points/inch.
*/

# define	rtfTpi		1440

/*
	RTF buffer size (avoids BUFSIZ, which differs across systems)
*/

# define  rtfBufSiz 2048

/*
	Tokens are associated with up to three classification numbers:

	Class number: Broadest (least detailed) breakdown.  For programs
		that only care about gross token distinctions.
	Major/minor numbers: Within their class, tokens have a major
		number, and may also have a minor number to further
		distinquish tokens with the same major number.

	*** Class, major and minor token numbers are all >= 0 ***

	Tokens that can't be classified are put in the "unknown" class.
	For such, the major and minor numbers are meaningless, although
	rtfTextBuf may be of interest then.

	Text tokens are a single character, and the major number indicates
	the character value (note: can be non-ascii, i.e., greater than 127).
	There is no minor number.

	Control symbols may have a parameter value, which will be found in
	rtfParam.  If no parameter was given, rtfParam = rtfNoParam.

	RTFGetToken() return value is the class number, but it sets all the
	global token vars.

	rtfEOF is a fake token used by the reader; the writer never sees
	it (except in the token reader hook, if it installs one).
*/


/*
	Information pertaining to last token read by RTFToken.  The
	text is exactly as it occurs in the input file, e.g., "\{"
	will be found in rtfTextBuf as "\{", even though it means "{".
	These variables are also set when styles are reprocessed.
*/

extern char	rtfTextBuf[rtfBufSiz];	/* text of token */
extern int	rtfTextLen;		/* length of token in rtfTextBuf */
extern int	rtfClass;		/* token class */
extern int	rtfMajor;		/* token major number */
extern int	rtfMinor;		/* token minor number */
extern int	rtfParam;		/* control symbol parameter */


# define  rtfNoParam  (-32000)


/*
	Token classes (must be zero-based and sequential)
*/

# define	rtfUnknown	0
# define	rtfGroup	1
# define	rtfText		2
# define	rtfControl	3
# define	rtfEOF		4
# define	rtfMaxClass	5	/* highest class + 1 */

/*
	Group class major numbers
*/

# define	rtfBeginGroup	0
# define	rtfEndGroup	1

/*
	Control class major and minor numbers.
*/

# define	rtfVersion	0

# define	rtfDefFont	1

# define	rtfCharSet	2
# define		rtfAnsiCharSet		0
# define		rtfMacCharSet		1
# define		rtfPcCharSet		2
# define		rtfPcaCharSet		3


/*	destination minor numbers should be zero-based, sequential */

# define	rtfDestination	3
# define		rtfPict			0
# define		rtfNeXTGraphic		1
# define		rtfFootnote		2
# define		rtfHeader		3
# define		rtfHeaderLeft		4
# define		rtfHeaderRight		5
# define		rtfHeaderFirst		6
# define		rtfFooter		7
# define		rtfFooterLeft		8
# define		rtfFooterRight		9
# define		rtfFooterFirst		10
# define		rtfFNSep		11
# define		rtfFNContSep		12
# define		rtfFNContNotice		13
# define		rtfInfo			14
# define		rtfStyleSheet		15
# define		rtfFontTbl		16
# define		rtfColorTbl		17
# define		rtfField		18
# define		rtfFieldInst		19
# define		rtfFieldResult		20
# define		rtfIndex		21
# define		rtfIndexBold		22
# define		rtfIndexItalic		23
# define		rtfIndexText		24
# define		rtfIndexRange		25
# define		rtfTOC			26
# define		rtfBookmarkStart	27
# define		rtfBookmarkEnd		28
# define		rtfITitle		29
# define		rtfISubject		30
# define		rtfIAuthor		31
# define		rtfIOperator		32
# define		rtfIKeywords		33
# define		rtfIComment		34
# define		rtfIVersion		35
# define		rtfIDoccomm		36
# define		rtfIVerscomm		37	/* new */
# define		rtfKeyCode		38	/* new */
# define		rtfMaxDestination	39	/* highest dest + 1 */

# define	rtfFontFamily	4
# define		rtfFFNil		0
# define		rtfFFRoman		1
# define		rtfFFSwiss		2
# define		rtfFFModern		3
# define		rtfFFScript		4
# define		rtfFFDecor		5
# define		rtfFFTech		6

# define	rtfColorName	5
# define		rtfRed			0
# define		rtfGreen		1
# define		rtfBlue			2

# define	rtfSpecialChar	6
# define		rtfCurHeadPage		0
# define		rtfCurFNote		1
# define		rtfCurHeadPict		2	/* valid? */
# define		rtfCurHeadDate		3
# define		rtfCurHeadTime		4
# define		rtfFormula		5
# define		rtfNoBrkSpace		6
# define		rtfNoReqHyphen		7
# define		rtfNoBrkHyphen		8
# define		rtfPage			9
# define		rtfLine			10
# define		rtfPar			11
# define		rtfSect			12
# define		rtfTab			13
# define		rtfCell			14
# define		rtfRow			15
# define		rtfCurAnnot		16
# define		rtfAnnotation		17
# define		rtfAnnotID		18
# define		rtfCurAnnotRef		19
# define		rtfFNoteSep		20
# define		rtfFNoteCont		21
# define		rtfColumn		22
# define		rtfOptDest		23
# define		rtfIIntVersion		24
# define		rtfICreateTime		25
# define		rtfIRevisionTime	26
# define		rtfIPrintTime		27
# define		rtfIBackupTime		28
# define		rtfIEditTime		29
# define		rtfIYear		30
# define		rtfIMonth		31
# define		rtfIDay			32
# define		rtfIHour		33
# define		rtfIMinute		34
# define		rtfINPages		35
# define		rtfINWords		36
# define		rtfINChars		37
# define		rtfIIntID		38
# define		rtfBullet		39
# define		rtfEmDash		40
# define		rtfEnDash		41
# define		rtfLQuote		42
# define		rtfRQuote		43
# define		rtfLDblQuote		44
# define		rtfRDblQuote		45

# define	rtfStyleAttr	7
# define		rtfBasedOn		0
# define		rtfNext			1

# define	rtfDocAttr	8
# define		rtfPaperWidth		0
# define		rtfPaperHeight		1
# define		rtfLeftMargin		2
# define		rtfRightMargin		3
# define		rtfTopMargin		4
# define		rtfBottomMargin		5
# define		rtfFacingPage		6
# define		rtfGutterWid		7
# define		rtfDefTab		8
# define		rtfWidowCtrl		9
# define		rtfHyphHotZone		10
# define		rtfFNoteEndSect		11
# define		rtfFNoteEndDoc		12
# define		rtfFNoteText		13
# define		rtfFNoteBottom		14
# define		rtfFNoteStart		15
# define		rtfFNoteRestart		16
# define		rtfPageStart		17
# define		rtfLineStart		18
# define		rtfLandscape		19
# define		rtfFracWidth		20
# define		rtfNextFile		21
# define		rtfTemplate		22
# define		rtfMakeBackup		23
# define		rtfRTFDefault		24
# define		rtfRevisions		25
# define		rtfMirrorMargin		26
# define		rtfRevDisplay		27
# define		rtfRevBar		28
# define		rtfDefLanguage		29	/* new */

# define	rtfSectAttr	9
# define		rtfSectDef		0
# define		rtfNoBreak		1
# define		rtfColBreak		2
# define		rtfPageBreak		3
# define		rtfEvenBreak		4
# define		rtfOddBreak		5
# define		rtfPageStarts		6
# define		rtfPageCont		7
# define		rtfPageRestart		8
# define		rtfPageDecimal		9
# define		rtfPageURoman		10
# define		rtfPageLRoman		11
# define		rtfPageULetter		12
# define		rtfPageLLetter		13
# define		rtfPageNumLeft		14
# define		rtfPageNumTop		15
# define		rtfHeaderY		16
# define		rtfFooterY		17
# define		rtfLineModulus		18
# define		rtfLineDist		19
# define		rtfLineStarts		20
# define		rtfLineRestart		21
# define		rtfLineRestartPg	22
# define		rtfLineCont		23
# define		rtfTopVAlign		24
# define		rtfBottomVAlign		25
# define		rtfCenterVAlign		26
# define		rtfJustVAlign		27
# define		rtfColumns		28
# define		rtfColumnSpace		29
# define		rtfColumnLine		30
# define		rtfENoteHere		31
# define		rtfTitleSpecial		32
# define		rtfPrtBinFirst		33	/* new */
# define		rtfPrtBin		34	/* new */

# define	rtfTblAttr	10
# define		rtfCellBordBottom	0
# define		rtfCellBordTop		1
# define		rtfCellBordLeft		2
# define		rtfCellBordRight	3
# define		rtfRowDef		4
# define		rtfRowLeft		5
# define		rtfRowRight		6
# define		rtfRowCenter		7
# define		rtfRowGapH		8
# define		rtfRowHt		9
# define		rtfRowLeftEdge		10
# define		rtfCellPos		11
# define		rtfMergeRngFirst	12
# define		rtfMergePrevious	13
# define		rtfCellShading		14	/* new */

# define	rtfParAttr	11
# define		rtfParDef		0
# define		rtfStyleNum		1
# define		rtfQuadLeft		2
# define		rtfQuadRight		3
# define		rtfQuadJust		4
# define		rtfQuadCenter		5
# define		rtfFirstIndent		6
# define		rtfLeftIndent		7
# define		rtfRightIndent		8
# define		rtfSpaceBefore		9
# define		rtfSpaceAfter		10
# define		rtfSpaceBetween		11
# define		rtfInTable		12
# define		rtfKeep			13
# define		rtfKeepNext		14
# define		rtfSideBySide		15
# define		rtfPBBefore		16
# define		rtfNoLineNum		17
# define		rtfTabPos		18
# define		rtfTabRight		19
# define		rtfTabCenter		20
# define		rtfTabDecimal		21
# define		rtfTabBar		22
# define		rtfBorderTop		23
# define		rtfBorderBottom		24
# define		rtfBorderLeft		25
# define		rtfBorderRight		26
# define		rtfBorderBox		27
# define		rtfBorderBar		28
# define		rtfBorderBetween	29
# define		rtfBorderSingle		30
# define		rtfBorderThick		31
# define		rtfBorderShadow		32
# define		rtfBorderDouble		33
# define		rtfBorderDot		34
# define		rtfBorderHair		35
# define		rtfBorderWidth		36	/* new */
# define		rtfBorderColor		37	/* new */
# define		rtfBorderSpace		38
# define		rtfLeaderDot		39
# define		rtfLeaderHyphen		40
# define		rtfLeaderUnder		41
# define		rtfLeaderThick		42

# define	rtfCharAttr	12
# define		rtfPlain		0
# define		rtfBold			1
# define		rtfItalic		2
# define		rtfStrikeThru		3
# define		rtfOutline		4
# define		rtfShadow		5
# define		rtfSmallCaps		6
# define		rtfAllCaps		7
# define		rtfInvisible		8
# define		rtfFontNum		9
# define		rtfFontSize		10
# define		rtfExpand		11
# define		rtfUnderline		12
# define		rtfWUnderline		13
# define		rtfDUnderline		14
# define		rtfDbUnderline		15
# define		rtfNoUnderline		16
# define		rtfSuperScript		17
# define		rtfSubScript		18
# define		rtfRevised		19
# define		rtfForeColor		20
# define		rtfBackColor		21
# define		rtfGray			22
# define		rtfLanguage		23	/* new */

# define	rtfPictAttr	13
# define		rtfMacQD		0
# define		rtfWinMetafile		1
# define		rtfWinBitmap		2
# define		rtfPicWid		3
# define		rtfPicHt		4
# define		rtfPicGoalWid		5
# define		rtfPicGoalHt		6
# define		rtfPicScaleX		7
# define		rtfPicScaleY		8
# define		rtfPicScaled		9
# define		rtfPicCropTop		10
# define		rtfPicCropBottom	11
# define		rtfPicCropLeft		12
# define		rtfPicCropRight		13
# define		rtfPixelBits		14
# define		rtfBitmapPlanes		15
# define		rtfBitmapWid		16
# define		rtfPicBinary		17

# define	rtfNeXTGrAttr	14
# define		rtfNeXTGWidth		0
# define		rtfNeXTGHeight		1

# define	rtfFieldAttr	15
# define		rtfFieldDirty		0
# define		rtfFieldEdited		1
# define		rtfFieldLocked		2
# define		rtfFieldPrivate		3

# define	rtfTOCAttr	16
# define		rtfTOCType		0
# define		rtfTOCLevel		1

# define	rtfPosAttr	17
# define		rtfPosX			0
# define		rtfPosXCenter		1
# define		rtfPosXInside		2
# define		rtfPosXLeft		3
# define		rtfPosXOutSide		4
# define		rtfPosXRight		5
# define		rtfPosY			6
# define		rtfPosYInline		7
# define		rtfPosYTop		8
# define		rtfPosYCenter		9
# define		rtfPosYBottom		10
# define		rtfAbsWid		11
# define		rtfTextDist		12
# define		rtfRPosMargV		13
# define		rtfRPosPageV		14
# define		rtfRPosMargH		15
# define		rtfRPosPageH		16
# define		rtfRPosColH		17



/*
	RTF font, color and style structures.  Used for font table,
	color table, and stylesheet processing.
*/

typedef struct RTFFont		RTFFont;
typedef struct RTFColor		RTFColor;
typedef struct RTFStyle		RTFStyle;
typedef struct RTFStyleElt	RTFStyleElt;


struct RTFFont
{
	char	*rtfFName;		/* font name */
	int	rtfFNum;		/* font number */
	int	rtfFFamily;		/* font family */
	RTFFont	*rtfNextFont;		/* next font in list */
};


/*
	Color values are -1 if the default color for the the color
	number should be used.  The default color is writer-dependent.
*/

struct RTFColor
{
	int		rtfCNum;	/* color number */
	int		rtfCRed;	/* red value */
	int		rtfCGreen;	/* green value */
	int		rtfCBlue;	/* blue value */
	RTFColor	*rtfNextColor;	/* next color in list */
};


struct RTFStyle
{
	char		*rtfSName;	/* style name */
	int		rtfSNum;	/* style number */
	int		rtfSBasedOn;	/* style this one's based on */
	int		rtfSNextPar;	/* style next paragraph style */
	RTFStyleElt	*rtfSSEList;	/* list of style words */
	int		rtfExpanding;	/* non-zero = being expanded */
	RTFStyle	*rtfNextStyle;	/* next style in style list */
};

# define	rtfBasedOnNone	222	/* "no based-on style" */


struct RTFStyleElt
{
	int		rtfSEClass;	/* token class */
	int		rtfSEMajor;	/* token major number */
	int		rtfSEMinor;	/* token minor number */
	int		rtfSEParam;	/* control symbol parameter */
	char		*rtfSEText;	/* text of symbol */
	RTFStyleElt	*rtfNextSE;	/* next element in style */
};


# ifdef __STDC__
typedef void (*RTFFuncPtr) (void);      /* generic function pointer */
# else /* !__STDC__ */
typedef	void (*RTFFuncPtr) ();		/* generic function pointer */
# endif /* !__STDC__ */


/*
	Public RTF reader routines
*/

# ifdef __STDC__
void		RTFInit (void);
void		RTFSetStream (FILE*);
void		RTFSetClassCallback(int, RTFFuncPtr);
RTFFuncPtr	RTFGetClassCallback (int);
void		RTFSetDestinationCallback(int, RTFFuncPtr);
RTFFuncPtr	RTFGetDestinationCallback (int);
void		RTFRead (void);
int		RTFGetToken (void);     /* writer should rarely need this */
void		RTFUngetToken (void);
int		RTFPeekToken (void);
void		RTFSetToken (int,int,int,int,char*);
void		RTFSetReadHook (RTFFuncPtr);
RTFFuncPtr	RTFGetReadHook (void);
void		RTFRouteToken (void);
void		RTFSkipGroup (void);
void		RTFExpandStyle (int);
int		RTFCheckCM (int,int);
int		RTFCheckCMM (int,int,int);
int		RTFCheckMM (int,int);
RTFFont		*RTFGetFont (int);
RTFColor	*RTFGetColor (int);
RTFStyle	*RTFGetStyle (int);
char		*RTFAlloc (int);
char		*RTFStrSave (char*);
void		RTFFree (char*);
# else /* !__STDC__ */
extern void		RTFInit ();
extern void		RTFSetStream ();
extern void		RTFSetClassCallback ();
extern RTFFuncPtr	RTFGetClassCallback ();
extern void		RTFSetDestinationCallback ();
extern RTFFuncPtr	RTFGetDestinationCallback ();
extern void		RTFRead ();
extern int		RTFGetToken ();	/* writer should rarely need this */
extern void		RTFUngetToken ();
extern int		RTFPeekToken ();
extern void		RTFSetToken ();
extern void		RTFSetReadHook ();
extern RTFFuncPtr	RTFGetReadHook ();
extern void		RTFRouteToken ();
extern void		RTFSkipGroup ();
extern void		RTFExpandStyle ();
extern int		RTFCheckCM ();
extern int		RTFCheckCMM ();
extern int		RTFCheckMM ();
extern RTFFont		*RTFGetFont ();
extern RTFColor		*RTFGetColor ();
extern RTFStyle		*RTFGetStyle ();
extern char		*RTFAlloc ();
extern char		*RTFStrSave ();
extern void		RTFFree ();
# endif /* !__STDC__ */
