/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
   list_kj.c: Listen der KEYWORDS und JOURNAL NAMES erstellen
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "fl_ut.h"
#include "str_fun.h"
#include "ix02_fun.h"
#include "ix03_fun.h"
#include "interf.h"

 extern config_set one_config_set;

 extern quellpix_rec ix02rec;
 extern quell_rec one_quell_rec;
 extern keylistpix_rec ix03rec;
 extern keylist_rec one_stichw_rec;


 extern FILE * ix02file;
 extern FILE * ix03file;
 static FILE * fptextj;
 static FILE * fptextk;
 extern FILE * fpquell;
 extern FILE * fpstichw;

 extern char wrtxtbu[WRTXTBU_LEN + 1];

 extern char textpfad[PFAD_LEN+1];
 extern char rdbpfad[PFAD_LEN+1];
 
 static char textj_name[PFAD_LEN + 1];
 static char textk_name[PFAD_LEN + 1];

 extern char quell_pix_name[PFAD_LEN];
 extern char quell_name[PFAD_LEN];
 extern char stichw_name[PFAD_LEN];
 extern char stichw_pix_name[PFAD_LEN];

 static void dateien_oeffnen_kj(void);
 static void dateien_schliessen_kj(void);
 static void schreiben(void);



int list_kj_main(void)
{
     strlimcpy(textj_name,textpfad,PFAD_LEN);
     strlimcat(textj_name,"__jour__.txt",PFAD_LEN);
     strlimcpy(textk_name,textpfad,PFAD_LEN);
     strlimcat(textk_name,"__keyw__.txt",PFAD_LEN);

     if (isfile(textk_name) || isfile(textj_name))
     {
        if (!do_overwrite_yn())
        {
           wrtxt("\n(aborted)\n");
           return 0;
        }
     }
     dateien_oeffnen_kj();
     schreiben();
     dateien_schliessen_kj();
     
     load_file_yn(textj_name);
     load_file_yn(textk_name);
     
     return 1;
}


static void dateien_oeffnen_kj(void)
{
  if (!read_ix02(quell_pix_name))
  {
     fprintf(stderr,"\nERROR: Cannot read %s\n",quell_pix_name);
     exit(1);
  }
  if (!read_ix03(stichw_pix_name))
  {
     fprintf(stderr,"\nERROR: Cannot read %s\n",stichw_pix_name);
     exit(1);
  }
  if ((fptextk=fopen(textk_name,"w"))==NULL)
  {
     fprintf(stderr,"\nERROR: Cannot create/write into %s\n",textk_name);
     exit(1);
  }
  if ((fptextj=fopen(textj_name,"w"))==NULL)
  {
     fprintf(stderr,"\nERROR: Cannot create/write into %s\n",textj_name);
     exit(1);
  }

  if ((fpquell=fopen(quell_name,"rb"))==NULL)
  {
     fprintf(stderr,"\nERROR: Cannot read %s\n",quell_name);
     exit(1);
  }

  if ((fpstichw=fopen(stichw_name,"rb"))==NULL)
  {
     fprintf(stderr,"\nERROR: Cannot read %s\n",stichw_name);
     exit(1);
  }
}

static void dateien_schliessen_kj(void)
{
   close_ix02();
   close_ix03();
   fclose(fptextk);
   fclose(fptextj);
   fclose(fpquell);
   fclose(fpstichw);
}

static void schreiben(void)
{
   long i, anzahl_records, byte_zeiger;

   sprintf(wrtxtbu,"\n(Writing %s)\n",textj_name);
   wrtxt(wrtxtbu);
   fseek(ix02file,0L,SEEK_END);
   byte_zeiger = ftell(ix02file);
   rewind(ix02file);
   anzahl_records = byte_zeiger/sizeof(ix02rec);
   anzahl_records--;
   fprintf(fptextj,"JOURNAL NAMES:\n\n");
   for (i=0;i<=anzahl_records;i++)
   {
      fread(&ix02rec,sizeof(ix02rec),1,ix02file);
      byte_zeiger = ix02rec.quell_rptr * sizeof(one_quell_rec);
      fseek(fpquell,byte_zeiger,SEEK_SET);
      fread(&one_quell_rec,sizeof(one_quell_rec),1,fpquell);

      fprintf(fptextj,"[%s]:\n  %s\n  %s\n  %s\n\n",
         one_quell_rec.quell_kuerzel,
         one_quell_rec.quell_issn,
         one_quell_rec.quell_zeitschrift,
         one_quell_rec.quell_kurzform
              );
   }
   fprintf(fptextj,"\nEND OF LIST JOURNAL NAMES\n");

   sprintf(wrtxtbu,"(Writing %s)\n",textk_name);
   wrtxt(wrtxtbu);
   fseek(ix03file,0L,SEEK_END);
   byte_zeiger = ftell(ix03file);
   rewind(ix03file);
   anzahl_records = byte_zeiger/sizeof(ix03rec);
   anzahl_records--;

   fprintf(fptextk,"KEYWORDS:\n\n");
   for (i=0;i<=anzahl_records;i++)
   {
      fread(&ix03rec,sizeof(ix03rec),1,ix03file);
      byte_zeiger = ix03rec.keywords_rptr * sizeof(one_stichw_rec);
      fseek(fpstichw,byte_zeiger,SEEK_SET);
      fread(&one_stichw_rec,sizeof(one_stichw_rec),1,fpstichw);
      fprintf(fptextk,"%6li: %s\n",i,one_stichw_rec.keywordsfield);
   }
   fprintf(fptextk,"\nEND OF LIST KEYWORDS\n");
}

