#!/bin/awk -f 

#
#   REFERENCES -- bibliographic software
#   Copyright (C) 1995-2006  Volker Kiefel
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
#   USA
#
#
#
# fromcite.awk is a filter to convert a line like
# 
#   This is described in \cite{Mueller98,Hauff02} and has been used by ...
# 
# to
# 
#   This is described in refscite(Mueller98), refscite(Hauff02) and has been used ...
#
# It can be used:
# 
#   awk -f fromcite.awk < input.tex > output.tex
#
#


BEGIN {
   while((getline inp < "/dev/stdin") > 0)
   {
     match(inp,/\\cite{[a-zA-Z0-9\.\,\_]*\}/)
     if (RSTART > 0)
     {
        inp = zeile_bearbeiten(inp)
        print inp
     }
     else 
     {
       print inp
     }
  }
}

function zeile_bearbeiten(ein,  citestr,refnr,neurefnr)
{
   while (match(ein,/\\cite{[a-zA-Z0-9\.\,\_]*\}/))
   {
       citestr = substr(ein,RSTART,RLENGTH)
       refnr = substr(citestr,length("\\cite{")+1,length(citestr)-length("\\cite{")-1)
       neurefnr = refnr_bearbeiten(refnr)       
       altstr = "\\\\cite{" refnr "}"
       
       gsub(altstr,neurefnr,ein)
   }
   return ein
}

function refnr_bearbeiten(ein,   aus,anz,arr,i)
{
   aus = ""
   anz = split(ein,arr,",")
   if (anz==1)
   {
      return "refscite(" ein ")"
   }
   for (i=1;i<=anz;i++)
   {
     aus = aus "refscite(" arr[i] ")"
     if (i < anz)
     {
       aus = aus ", "
     }
   }
   return aus
}

END {
   close("/dev/stdin")
}

# vim:tw=2048
