/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.parameters;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Converters;
import org.picocontainer.Converting;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.NameBinding;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;
import org.picocontainer.injectors.AbstractInjector;
import org.picocontainer.injectors.InjectInto;
import org.picocontainer.parameters.AbstractParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicComponentParameter
extends AbstractParameter
implements Parameter,
Serializable {
    public static final BasicComponentParameter BASIC_DEFAULT = new BasicComponentParameter();
    private Object componentKey;

    public BasicComponentParameter(Object componentKey) {
        this.componentKey = componentKey;
    }

    public BasicComponentParameter() {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Parameter.Resolver resolve(PicoContainer container, ComponentAdapter<?> forAdapter, ComponentAdapter<?> injecteeAdapter, Type expectedType, NameBinding expectedNameBinding, boolean useNames, Annotation binding) {
        void var9_11;
        Class resolvedClassType = null;
        if (!(expectedType instanceof Class)) {
            if (!(expectedType instanceof ParameterizedType)) return new Parameter.NotResolved();
            resolvedClassType = (Class)((ParameterizedType)expectedType).getRawType();
        } else {
            resolvedClassType = (Class)expectedType;
        }
        assert (resolvedClassType != null);
        if (injecteeAdapter == null) {
            ComponentAdapter componentAdapter = this.resolveAdapter(container, forAdapter, resolvedClassType, expectedNameBinding, useNames, binding);
        } else {
            ComponentAdapter<?> componentAdapter = injecteeAdapter;
        }
        void componentAdapter = var9_11;
        return new Parameter.Resolver((ComponentAdapter)componentAdapter, container, expectedType, forAdapter){
            final /* synthetic */ ComponentAdapter val$componentAdapter;
            final /* synthetic */ PicoContainer val$container;
            final /* synthetic */ Type val$expectedType;
            final /* synthetic */ ComponentAdapter val$forAdapter;
            {
                this.val$componentAdapter = componentAdapter;
                this.val$container = picoContainer;
                this.val$expectedType = type;
                this.val$forAdapter = componentAdapter2;
            }

            @Override
            public boolean isResolved() {
                return this.val$componentAdapter != null;
            }

            @Override
            public Object resolveInstance() {
                if (this.val$componentAdapter == null) {
                    return null;
                }
                if (this.val$componentAdapter instanceof DefaultPicoContainer.LateInstance) {
                    return BasicComponentParameter.convert(BasicComponentParameter.this.getConverters(this.val$container), ((DefaultPicoContainer.LateInstance)this.val$componentAdapter).getComponentInstance(), this.val$expectedType);
                }
                return BasicComponentParameter.convert(BasicComponentParameter.this.getConverters(this.val$container), this.val$container.getComponent(this.val$componentAdapter.getComponentKey(), BasicComponentParameter.makeInjectInto(this.val$forAdapter)), this.val$expectedType);
            }

            @Override
            public ComponentAdapter<?> getComponentAdapter() {
                return this.val$componentAdapter;
            }
        };
    }

    private Converters getConverters(PicoContainer container) {
        return container instanceof Converting ? ((Converting)((Object)container)).getConverters() : null;
    }

    private static InjectInto makeInjectInto(ComponentAdapter<?> forAdapter) {
        return new InjectInto(forAdapter.getComponentImplementation(), forAdapter.getComponentKey());
    }

    private static Object convert(Converters converters, Object obj, Type expectedType) {
        if (obj instanceof String && expectedType != String.class) {
            obj = converters.convert((String)obj, expectedType);
        }
        return obj;
    }

    @Override
    public void verify(PicoContainer container, ComponentAdapter<?> forAdapter, Type expectedType, NameBinding expectedNameBinding, boolean useNames, Annotation binding) {
        ComponentAdapter componentAdapter = this.resolveAdapter(container, forAdapter, (Class)expectedType, expectedNameBinding, useNames, binding);
        if (componentAdapter == null) {
            HashSet<Type> set = new HashSet<Type>();
            set.add(expectedType);
            throw new AbstractInjector.UnsatisfiableDependenciesException(forAdapter.getComponentImplementation().getName() + " has unsatisfied dependencies: " + set + " from " + container);
        }
        componentAdapter.verify(container);
    }

    @Override
    public void accept(PicoVisitor visitor) {
        visitor.visitParameter(this);
    }

    protected <T> ComponentAdapter<T> resolveAdapter(PicoContainer container, ComponentAdapter adapter, Class<T> expectedType, NameBinding expectedNameBinding, boolean useNames, Annotation binding) {
        Class<Object> type = expectedType;
        if (type.isPrimitive()) {
            String expectedTypeName = expectedType.getName();
            if (expectedTypeName == "int") {
                type = Integer.class;
            } else if (expectedTypeName == "long") {
                type = Long.class;
            } else if (expectedTypeName == "float") {
                type = Float.class;
            } else if (expectedTypeName == "double") {
                type = Double.class;
            } else if (expectedTypeName == "boolean") {
                type = Boolean.class;
            } else if (expectedTypeName == "char") {
                type = Character.class;
            } else if (expectedTypeName == "short") {
                type = Short.class;
            } else if (expectedTypeName == "byte") {
                type = Byte.class;
            }
        }
        ComponentAdapter result = null;
        if (this.componentKey != null) {
            result = BasicComponentParameter.typeComponentAdapter(container.getComponentAdapter(this.componentKey));
        } else if (adapter == null) {
            result = container.getComponentAdapter(type, (NameBinding)null);
        } else {
            Object found;
            Object excludeKey = adapter.getComponentKey();
            ComponentAdapter<?> byKey = container.getComponentAdapter(expectedType);
            if (byKey != null && !excludeKey.equals(byKey.getComponentKey())) {
                result = BasicComponentParameter.typeComponentAdapter(byKey);
            }
            if (result == null && useNames && (found = container.getComponentAdapter(expectedNameBinding.getName())) != null && this.areCompatible(container, expectedType, (ComponentAdapter)found) && found != adapter) {
                result = found;
            }
            if (result == null) {
                found = binding == null ? container.getComponentAdapters(expectedType) : container.getComponentAdapters(expectedType, binding.annotationType());
                this.removeExcludedAdapterIfApplicable(excludeKey, (List<ComponentAdapter<T>>)found);
                if (found.size() == 0) {
                    result = this.noMatchingAdaptersFound(container, expectedType, expectedNameBinding, binding);
                } else if (found.size() == 1) {
                    result = (ComponentAdapter)found.get(0);
                } else {
                    throw this.tooManyMatchingAdaptersFound(expectedType, (List<ComponentAdapter<T>>)found);
                }
            }
        }
        if (result == null) {
            return null;
        }
        if (!(type.isAssignableFrom(result.getComponentImplementation()) || result.getComponentImplementation() == String.class && this.getConverters(container).canConvert(type))) {
            return null;
        }
        return result;
    }

    private static <T> ComponentAdapter<T> typeComponentAdapter(ComponentAdapter<?> componentAdapter) {
        return componentAdapter;
    }

    private <T> ComponentAdapter<T> noMatchingAdaptersFound(PicoContainer container, Class<T> expectedType, NameBinding expectedNameBinding, Annotation binding) {
        if (container.getParent() != null) {
            if (binding != null) {
                return container.getParent().getComponentAdapter(expectedType, binding.getClass());
            }
            return container.getParent().getComponentAdapter(expectedType, expectedNameBinding);
        }
        return null;
    }

    private <T> AbstractInjector.AmbiguousComponentResolutionException tooManyMatchingAdaptersFound(Class<T> expectedType, List<ComponentAdapter<T>> found) {
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = found.get(i).getComponentImplementation();
        }
        AbstractInjector.AmbiguousComponentResolutionException exception = new AbstractInjector.AmbiguousComponentResolutionException(expectedType, foundClasses);
        return exception;
    }

    private <T> void removeExcludedAdapterIfApplicable(Object excludeKey, List<ComponentAdapter<T>> found) {
        ComponentAdapter<T> exclude = null;
        for (ComponentAdapter<T> work : found) {
            if (!work.getComponentKey().equals(excludeKey)) continue;
            exclude = work;
            break;
        }
        found.remove(exclude);
    }

    private <T> boolean areCompatible(PicoContainer container, Class<T> expectedType, ComponentAdapter found) {
        Class foundImpl = found.getComponentImplementation();
        return expectedType.isAssignableFrom(foundImpl) || foundImpl == String.class && this.getConverters(container) != null && this.getConverters(container).canConvert(expectedType);
    }
}

