/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.unpacker;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.ResourceException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.unpacker.PackResources;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;

public abstract class AbstractPackResources
implements PackResources {
    private final Resources resources;
    private final InstallData installData;

    public AbstractPackResources(Resources resources, InstallData installData) {
        this.installData = installData;
        this.resources = resources;
    }

    @Override
    public InputStream getPackStream(String name) {
        String webDirURL = this.installData.getInfo().getWebDirURL();
        InputStream result = webDirURL == null ? this.getLocalPackStream(name) : this.getWebPackStream(name, webDirURL);
        String className = this.installData.getInfo().getPackDecoderClassName();
        if (className != null) {
            result = this.getDecodingInputStream(result, className);
        }
        return result;
    }

    @Override
    public InputStream getInputStream(String name) {
        return this.resources.getInputStream(name);
    }

    protected InputStream getDecodingInputStream(InputStream in, String className) {
        Object result;
        try {
            Class<?> decoder = Class.forName(className);
            Class[] paramsClasses = new Class[]{InputStream.class};
            Constructor<?> constructor = decoder.getDeclaredConstructor(paramsClasses);
            BufferedInputStream buffer = new BufferedInputStream(in);
            Object[] params = new Object[]{buffer};
            result = constructor.newInstance(params);
        }
        catch (Exception exception) {
            throw new ResourceException("Failed to create stream to decode resource", exception);
        }
        if (!InputStream.class.isInstance(result)) {
            throw new ResourceException("Cannot decode resource: '" + className + "' must be derived from " + InputStream.class.getName());
        }
        return (InputStream)result;
    }

    protected InputStream getLocalPackStream(String name) {
        return this.resources.getInputStream("packs/pack-" + name);
    }

    protected abstract InputStream getWebPackStream(String var1, String var2);

    protected InstallData getInstallData() {
        return this.installData;
    }
}

