/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.beans.Introspector;
import java.io.InputStream;
import java.net.URL;
import java.text.CollationElementIterator;
import java.text.MessageFormat;
import java.text.RuleBasedCollator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class HelpUtilities {
    private static Hashtable tailsPerLocales = new Hashtable();
    private static Hashtable bundles;
    private static ResourceBundle lastBundle;
    private static Locale lastLocale;
    private static final boolean debug = false;

    public static String getHelpSetNameFromBean(Class clazz) {
        String string;
        Object object;
        try {
            object = Introspector.getBeanInfo(clazz);
            string = (String)object.getBeanDescriptor().getValue("helpSetName");
        }
        catch (Exception exception) {
            string = null;
        }
        if (string == null) {
            object = clazz.getName();
            int n = ((String)object).lastIndexOf(".");
            if (n == -1) {
                string = (String)object + "Help.hs";
            } else {
                String string2 = ((String)object).substring(0, n);
                string = string2.replace('.', '/') + "/Help.hs";
            }
        }
        return string;
    }

    public static String getIDStringFromBean(Class clazz) {
        String string;
        Object object;
        try {
            object = Introspector.getBeanInfo(clazz);
            string = (String)object.getBeanDescriptor().getValue("helpID");
        }
        catch (Exception exception) {
            string = null;
        }
        if (string == null) {
            object = clazz.getName();
            string = (String)object + ".topID";
        }
        return string;
    }

    public static String getDefaultQueryEngine() {
        return "com.sun.java.help.search.DefaultSearchEngine";
    }

    public static URL getLocalizedResource(ClassLoader classLoader, String string, String string2, Locale locale) {
        return HelpUtilities.getLocalizedResource(classLoader, string, string2, locale, false);
    }

    public static URL getLocalizedResource(ClassLoader classLoader, String string, String string2, Locale locale, boolean bl) {
        Enumeration enumeration = HelpUtilities.getCandidates(locale);
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = string + string3 + string2;
            URL uRL = classLoader == null ? ClassLoader.getSystemResource(string4) : classLoader.getResource(string4);
            if (uRL == null) continue;
            if (bl) {
                try {
                    InputStream inputStream = uRL.openConnection().getInputStream();
                    if (inputStream == null) continue;
                    int n = inputStream.read();
                    inputStream.close();
                    if (n == -1) continue;
                    return uRL;
                }
                catch (Throwable throwable) {}
                continue;
            }
            return uRL;
        }
        return null;
    }

    public static synchronized Enumeration getCandidates(Locale locale) {
        String string;
        LocalePair localePair = new LocalePair(locale, Locale.getDefault());
        Vector<String> vector = (Vector<String>)tailsPerLocales.get(localePair);
        if (vector != null) {
            HelpUtilities.debug("getCandidates - cached copy");
            return vector.elements();
        }
        String string2 = locale.toString();
        StringBuffer stringBuffer = new StringBuffer("_").append(string2);
        if (string2 == null) {
            stringBuffer.setLength(0);
        }
        vector = new Vector<String>();
        while (stringBuffer.length() != 0) {
            HelpUtilities.debug("  adding ", stringBuffer);
            string = stringBuffer.toString();
            vector.addElement(string);
            int n = string.lastIndexOf(95);
            if (n == -1) continue;
            stringBuffer.setLength(n);
        }
        HelpUtilities.debug("  addign -- null -- ");
        vector.addElement("");
        if (locale != Locale.getDefault()) {
            string = Locale.getDefault().toString();
            StringBuffer stringBuffer2 = new StringBuffer("_").append(string);
            if (string == null) {
                stringBuffer2.setLength(0);
            }
            while (stringBuffer2.length() != 0) {
                HelpUtilities.debug("  adding ", stringBuffer2);
                String string3 = stringBuffer2.toString();
                vector.addElement(string3);
                int n = string3.lastIndexOf(95);
                if (n == -1) continue;
                stringBuffer2.setLength(n);
            }
        }
        tailsPerLocales.put(localePair, vector);
        HelpUtilities.debug("tails is == ", vector);
        return vector.elements();
    }

    public static Locale getLocale(Component component) {
        if (component == null) {
            return Locale.getDefault();
        }
        try {
            return component.getLocale();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            return Locale.getDefault();
        }
    }

    private static synchronized ResourceBundle getBundle(Locale locale) {
        ResourceBundle resourceBundle;
        if (lastLocale == locale) {
            return lastBundle;
        }
        if (bundles == null) {
            bundles = new Hashtable();
        }
        if ((resourceBundle = (ResourceBundle)bundles.get(locale)) == null) {
            try {
                resourceBundle = ResourceBundle.getBundle("javax.help.resources.Constants", locale);
            }
            catch (MissingResourceException missingResourceException) {
                throw new Error("Fatal: Resource for javahelp is missing");
            }
            bundles.put(locale, resourceBundle);
        }
        lastBundle = resourceBundle;
        lastLocale = locale;
        return resourceBundle;
    }

    public static String getString(String string) {
        return HelpUtilities.getString(Locale.getDefault(), string);
    }

    public static String getText(String string) {
        return HelpUtilities.getText(Locale.getDefault(), string, null, null);
    }

    public static String getText(String string, String string2) {
        return HelpUtilities.getText(Locale.getDefault(), string, string2, null);
    }

    public static String getText(String string, String string2, String string3) {
        return HelpUtilities.getText(Locale.getDefault(), string, string2, string3);
    }

    public static String getText(String string, String string2, String string3, String string4) {
        return HelpUtilities.getText(Locale.getDefault(), string, string2, string3, string4);
    }

    public static String getString(Locale locale, String string) {
        ResourceBundle resourceBundle = HelpUtilities.getBundle(locale);
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Localization data for JavaHelp is broken.  Missing " + string + " key.");
        }
    }

    public static String[] getStringArray(Locale locale, String string) {
        ResourceBundle resourceBundle = HelpUtilities.getBundle(locale);
        try {
            return resourceBundle.getStringArray(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Localization data for JavaHelp is broken.  Missing " + string + " key.");
        }
    }

    public static String getText(Locale locale, String string) {
        return HelpUtilities.getText(locale, string, null, null, null);
    }

    public static String getText(Locale locale, String string, String string2) {
        return HelpUtilities.getText(locale, string, string2, null, null);
    }

    public static String getText(Locale locale, String string, String string2, String string3) {
        return HelpUtilities.getText(locale, string, string2, string3, null);
    }

    public static String getText(Locale locale, String string, String string2, String string3, String string4) {
        ResourceBundle resourceBundle = HelpUtilities.getBundle(locale);
        if (string2 == null) {
            string2 = "null";
        }
        if (string3 == null) {
            string3 = "null";
        }
        if (string4 == null) {
            string4 = "null";
        }
        try {
            String string5 = resourceBundle.getString(string);
            String[] stringArray = new String[]{string2, string3, string4};
            MessageFormat messageFormat = new MessageFormat(string5);
            try {
                messageFormat.setLocale(locale);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return messageFormat.format(stringArray);
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Localization data for JavaHelp is broken.  Missing " + string + " key.");
        }
    }

    public static Locale localeFromLang(String string) {
        String string2 = null;
        Locale locale = null;
        if (string == null) {
            return locale;
        }
        int n = string.indexOf("_");
        int n2 = string.indexOf("-");
        if (n == -1 && n2 == -1) {
            String string3 = string;
            String string4 = "";
            locale = new Locale(string3, string4);
        } else {
            if (n == -1 && n2 != -1) {
                n = n2;
            }
            String string5 = string.substring(0, n);
            int n3 = string.indexOf("_", n + 1);
            int n4 = string.indexOf("-", n + 1);
            if (n3 == -1 && n4 == -1) {
                String string6 = string.substring(n + 1);
                locale = new Locale(string5, string6);
            } else {
                if (n3 == -1 && n4 != -1) {
                    n3 = n4;
                }
                String string7 = string.substring(n + 1, n3);
                string2 = string.substring(n3 + 1);
                locale = new Locale(string5, string7, string2);
            }
        }
        return locale;
    }

    public static boolean isStringInString(RuleBasedCollator ruleBasedCollator, String string, String string2) {
        block34: {
            HelpUtilities.debug("isStringInString source=" + string + " targe =" + string2);
            if (string == null || string2 == null) {
                return false;
            }
            if (string.length() == 0 && string2.length() == 0) {
                return true;
            }
            int n = 3;
            boolean bl = false;
            ruleBasedCollator.setDecomposition(2);
            String string3 = ruleBasedCollator.getRules();
            if (string3.startsWith("@")) {
                bl = true;
            }
            CollationElementIterator collationElementIterator = ruleBasedCollator.getCollationElementIterator(string);
            CollationElementIterator collationElementIterator2 = ruleBasedCollator.getCollationElementIterator(string2);
            int n2 = 0;
            int n3 = 0;
            boolean bl2 = true;
            boolean bl3 = true;
            int n4 = 0;
            block9: while (true) {
                boolean bl4;
                block35: {
                    boolean bl5;
                    boolean bl6;
                    int n5;
                    int n6;
                    HelpUtilities.debug("while(true) toffset=" + n4);
                    try {
                        collationElementIterator.setOffset(0);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    n2 = collationElementIterator.next();
                    try {
                        collationElementIterator2.setOffset(n4);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                    }
                    catch (Exception exception) {
                        return false;
                    }
                    n3 = collationElementIterator2.next();
                    if (n3 == -1) break block34;
                    HelpUtilities.debug("sOrder=" + n2 + " tOrder=" + n3);
                    while (n3 != -1) {
                        if (n2 == n3) {
                            try {
                                n4 = collationElementIterator2.getOffset();
                            }
                            catch (NoSuchMethodError noSuchMethodError) {}
                            break;
                        }
                        n6 = CollationElementIterator.primaryOrder(n2);
                        if (n6 == (n5 = CollationElementIterator.primaryOrder(n3))) {
                            try {
                                n4 = collationElementIterator2.getOffset();
                            }
                            catch (NoSuchMethodError noSuchMethodError) {}
                            break;
                        }
                        n3 = collationElementIterator2.next();
                        HelpUtilities.debug("next tOrder=" + n3);
                    }
                    if (n3 == -1) {
                        return false;
                    }
                    bl2 = false;
                    bl3 = false;
                    bl4 = bl6 = ruleBasedCollator.getStrength() >= 1;
                    boolean bl7 = bl5 = ruleBasedCollator.getStrength() >= 2;
                    while (true) {
                        short s;
                        short s2;
                        short s3;
                        if (bl2) {
                            n2 = collationElementIterator.next();
                        } else {
                            bl2 = true;
                        }
                        if (bl3) {
                            n3 = collationElementIterator2.next();
                        } else {
                            bl3 = true;
                        }
                        if (n2 == -1 || n3 == -1) break block35;
                        n6 = CollationElementIterator.primaryOrder(n2);
                        n5 = CollationElementIterator.primaryOrder(n3);
                        if (n2 == n3) {
                            if (bl && n6 != 0 && !bl4) {
                                bl4 = bl6;
                                bl5 = false;
                            }
                            HelpUtilities.debug("No diff at this positon continue");
                            continue;
                        }
                        if (n6 != n5) {
                            if (n2 == 0) {
                                bl3 = false;
                                continue;
                            }
                            if (n3 == 0) {
                                bl2 = false;
                                continue;
                            }
                            if (n6 == 0) {
                                if (bl4) {
                                    collationElementIterator2.next();
                                    n4 = collationElementIterator2.getOffset();
                                    HelpUtilities.debug("Strength is secondary pSOrder === 0");
                                    continue block9;
                                }
                                bl3 = false;
                                continue;
                            }
                            if (n5 == 0) {
                                if (bl4) {
                                    collationElementIterator2.next();
                                    n4 = collationElementIterator2.getOffset();
                                    HelpUtilities.debug("Strength is secondary - pTOrder == 0");
                                    continue block9;
                                }
                                bl2 = false;
                                continue;
                            }
                            collationElementIterator2.next();
                            n4 = collationElementIterator2.getOffset();
                            HelpUtilities.debug("Order are ignorable");
                            continue block9;
                        }
                        if (!bl4) continue;
                        short s4 = CollationElementIterator.secondaryOrder(n2);
                        if (s4 != (s3 = CollationElementIterator.secondaryOrder(n3))) {
                            collationElementIterator2.next();
                            n4 = collationElementIterator2.getOffset();
                            HelpUtilities.debug("Secondary Difference");
                            continue block9;
                        }
                        if (bl5 && (s2 = CollationElementIterator.tertiaryOrder(n2)) != (s = CollationElementIterator.tertiaryOrder(n3))) break;
                    }
                    collationElementIterator2.next();
                    n4 = collationElementIterator2.getOffset();
                    HelpUtilities.debug("Tertiary difference");
                    continue;
                }
                HelpUtilities.debug("One string at end");
                if (n2 == -1) break;
                do {
                    if (CollationElementIterator.primaryOrder(n2) != 0) {
                        collationElementIterator2.next();
                        n4 = collationElementIterator2.getOffset();
                        HelpUtilities.debug("Additional non-ignborable base character in source string - source is greater");
                        continue block9;
                    }
                    if (CollationElementIterator.secondaryOrder(n2) == 0 || !bl4) continue;
                    collationElementIterator2.next();
                    n4 = collationElementIterator2.getOffset();
                    HelpUtilities.debug("Additional secondary elements source is greater");
                    continue block9;
                } while ((n2 = collationElementIterator.next()) != -1);
                break;
            }
            return true;
        }
        return false;
    }

    private static void debug(Object object, Object object2, Object object3) {
    }

    private static void debug(Object object) {
        HelpUtilities.debug(object, "", "");
    }

    private static void debug(Object object, Object object2) {
        HelpUtilities.debug(object, object2, "");
    }

    static {
        lastBundle = null;
        lastLocale = null;
    }

    static class LocalePair {
        Locale locale1;
        Locale locale2;

        LocalePair(Locale locale, Locale locale2) {
            this.locale1 = locale;
            this.locale2 = locale2;
        }

        public int hashCode() {
            return this.locale1.hashCode() + this.locale2.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof LocalePair)) {
                return false;
            }
            LocalePair localePair = (LocalePair)object;
            return this.locale1.equals(localePair.locale1) && this.locale2.equals(localePair.locale2);
        }
    }
}

