/*
 *  Eukleides version 1.5.3
 *  Copyright (c) Christian Obrecht 2004-2010
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <limits.h>
#include "winutils.h"

int main(int argc, char** argv)
{
    char* base;
    char* source;
    char* command;
    int l, n, m;
    unsigned short i;

    if (argc < 2) print_error("Missing filename.");

    base = argv[1];
    l = base_length(base);
    n = l + 14;
    m = 2*n + 14;
    i = 1;
    source = malloc(n);
    command = malloc(m);

    while (i < USHRT_MAX) {
	snprintf(source, n, "%.*s-fig%u.euk", l, base, i);
	if (!exists(source)) break;
	snprintf(command, m, "euktopst -b -o%.*s-fig%u.tex %s",
		 l, base, i, source);
	if (system(command)) exit(EXIT_FAILURE);
	i++;
    }

    if (i == USHRT_MAX) print_error("Too many files to process.");

    return EXIT_SUCCESS;
}
