import javax.swing.*;
/*
 * ProgressGUI.java
 *
 * Created on 6. December 2006, 17:10
 */

/**
 *
 *  The ProgressGUI simply informs the user that CMS4talks is busy.
 *  The user should see that something happens.
 *
 * @author  Olle Nebendahl
 */
public class ProgressGUI extends JDialog {
    
    public JLabel Label1;
    public JLabel Label2;
    public static ProgressGUI current;
    
    /** Creates new form ProgressGUI */
    public ProgressGUI() {
        current=this;
        initComponents();
    }
    
    public ProgressGUI(java.awt.Dialog owner, String title, boolean modal)
    {
        super(owner,modal);
        current=this;
        initComponents();
    }
    
    public ProgressGUI(java.awt.Frame owner, String title, boolean modal)
    {
        super(owner,modal);
        current=this;
        initComponents();
    }
    
 
    /** This method is called from within the constructor to
     * initialize the form.
     */
    private void initComponents() 
    {
        setLocation(Constants.mainWindowCoordinates);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        Label1 = new JLabel();
        Label2 = new JLabel();

        getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));

        setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        setResizable(false);
        jPanel2.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.CENTER));
        jPanel3.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.CENTER));
        
        jPanel2.add(new JLabel("scanning file: "));
        jPanel2.add(Label1);
        
        jPanel3.add(Label2);
        

        getContentPane().add(jPanel2);
        getContentPane().add(jPanel3);

        pack();
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) throws InterruptedException
    {
/*        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new ProgressGUI(new JFrame(),"Olle",true).setVisible(true);
            }
  });*/      
        System.out.println("Start");
        JFrame frame = new JFrame();
        ProgressGUI sg = new ProgressGUI(frame,"Olle",false);
        sg.Label1.setText("Test2");
        sg.Label2.setText("laaaaaanger Test");
        sg.pack();
        sg.setVisible(true);
        frame = null;
        sg.goodbye();
        System.out.println("Stop");        
        
    }
    
    public void goodbye()
    {
        (new GoodByeThread(this)).start();
    }
}

class GoodByeThread extends Thread
{
    ProgressGUI progressGUI;
    GoodByeThread(ProgressGUI pg)
    {
        progressGUI = pg;
    }
    
    public void run()
    {
        try
        {
            sleep(2000);
            progressGUI.setVisible(false);
        }
        catch (InterruptedException e) 
        {
            System.out.println("Interrupted");
        }
    }
}
