(* 2/25/1991 Dan Dill dan@chem.bu.edu *)

Unprotect[System`PSFile]

System`PSFile::usage = "PSFile[-graphics-, \"file\"].  Capture a Mathematica
graphic object in a PostScript file. Quotes are required around the file name
and suffix `.ps' is added.  The graphic object is preprocessed through psfix
to prepend the Mathematica PostScript procedures to the file, so that it may
be printed directly with lpr.  For example,
\n
\n
\t PSFile[myplot, \"p4/myplot\"]
\n
\n
  will convert the Mathematica graphic myplot to the PostScript file myplot.ps
in the subdirectory p4 of the current directory."


System`PSFile::file = "Graphics being processed (with prolog) to file \"`1`\".";

Begin["System`Private`"]
PSFile[g_, f_String] := Block[{filename},
	filename = StringJoin[f, ".ps"];
	Message[PSFile::file, filename];
	Display[StringJoin[
		"! ",
		"psfix",
		" > ",
		filename
		], g
	];
]
End[]

Protect[PSFile]
