%(encoding:utf-8)
\DeclareLanguage{greek}
\DeclareDialect{katharevousa}

\SetLanguageScript{El}

% Properties. 

\AddLanguageProcess{text}
  {beta,sigma,invertediota,apostrophe}

\DeclareLanguageProperty{sigma = lunate}
   {\SetLanguageProcess{sigma}{elllunates}}
\DeclareLanguageProperty{sigma = twoform}
   {\SetLanguageProcess{sigma}{}}
\SetLanguageProcess{sigma}{}

% Just an example for a non valued property:

\DeclareLanguageProperty{invertediota}
   {\SetLanguageProcess{invertediota}{ellinviu}}
\DeclareLanguageProperty{noinvertediota}
   {\SetLanguageProcess{invertediota}{}}
\SetLanguageProcess{invertediota}{}

\DeclareLanguageProperty{beta = oneform}
   {\SetLanguageProcess{beta}{}}
\DeclareLanguageProperty{beta = twoform}
   {\SetLanguageProcess{beta}{ellmedb}}
\SetLanguageProcess{beta}{ellmedb}

\DeclareLanguageProperty{apostrophe = latin}
   {\SetLanguageProcess{apostrophe}{}}
\DeclareLanguageProperty{apostrophe = different}
   {\SetLanguageProcess{apostrophe}{ellpsili}}  % Should not be an input convention?
\SetLanguageProcess{apostrophe}{ellpsili}

\DeclareLanguageProperty{numbersix = stigma}
  {\def\gr@smallstigma{^^^^03db}%  Not used through ocp's.
   \def\gr@stigma{^^^^03da}}    % must be \unichar. To be fixed
\DeclareLanguageProperty{numbersix = oldstigma}
  {\def\gr@smallstigma{^^^^03db}%
   \def\gr@stigma{^^^^03fd}}
\DeclareLanguageProperty{numbersix = sigmatau}
  {\def\gr@smallstigma{στ}%
   \def\gr@stigma{ΣΤ}}
\def\gr@smallstigma{στ}%
\def\gr@stigma{ΣΤ}

\AddLanguageProcess{transcript}{trans}
\SetLanguageProcess{trans}{}

\DeclareLanguageProperty{input = tex}
  {\SetLanguageProcess{trans}{ellintex}}
\DeclareLanguageProperty{input = textilde}
  {\SetLanguageProcess{trans}{grpotilde2uni}}

\DeclareLanguageProperty{accents = monotonic}
  {\let\gr@accents\@firstoftwo
   \def\gr@x{}}
\DeclareLanguageProperty{accents = polytonic}
  {\let\gr@accents\@secondofoftwo
   \def\gr@x{>}}
\let\gr@accents\@secondofoftwo
\def\gr@x{>}

\DeclareLanguageCommand*{\bibname}{names}
  {Βιβλιογραφία}%
\DeclareLanguageCommand*{\prefacename}{names}
  {Πρόλογος}%
\DeclareLanguageCommand*{\appendixname}{names}
  {Παράρτημα}%
\DeclareLanguageCommand*{\listfigurename}{names}
  {Κατάλογος σχημάτων}%
\DeclareLanguageCommand*{\listtablename}{names}
  {Κατάλογος πινάκων}%
\DeclareLanguageCommand*{\partname}{names}
  {Μέρος}%
\DeclareLanguageCommand*{\enclname}{names}
  {Συνημμένα}%

\SetDialect{greek}

\DeclareLanguageCommand*{\refname}{names}
  {\gr@accents{Αναφορές}{>Αναφορ`ες}}%
\DeclareLanguageCommand*{\abstractname}{names}
  {Περίληψη}%
\DeclareLanguageCommand*{\chaptername}{names}
  {Κεφάλαιο}%
\DeclareLanguageCommand*{\contentsname}{names}
  {Περιεχόμενα}%
\DeclareLanguageCommand*{\indexname}{names}
  {Ε\gr@x υρετήριο}%
\DeclareLanguageCommand*{\figurename}{names}
  {\gr@accents{Σχήμα}{Σχ=ημα}}%
\DeclareLanguageCommand*{\tablename}{names}
  {Πίνακας}%
\DeclareLanguageCommand*{\pagename}{names}
  {Σελίδα}%
\DeclareLanguageCommand*{\seename}{names}
  {\gr@accents{βλέπε}{βλέπετ}}%
\DeclareLanguageCommand*{\alsoname}{names}
  {βλέπε \gr@x επίσης}%
\DeclareLanguageCommand*{\ccname}{names}
  {Κοινοποίηση}%
\DeclareLanguageCommand*{\headtoname}{names}
  {\gr@accents{Προς}{Πρ`ος}}%
\DeclareLanguageCommand*{\proofname}{names}
  {\gr@x Απόδειξη}% for AMS-\LaTeX

\DeclareDateFunction{mmmm}{%
  \ifcase\month\or
  \gr@x Ιανουαρίου\or Φεβρουαρίου\or Μαρτίου\or \gr@x Απριλίου\or
  Μαΐου\or \gr@x Ιουνίου\or \gr@x Ιουλίου\or Α\gr@x υγούστου\or
  Σεπτεμβρίου\or \gr@x Οκτωβρίου\or Νοεμβρίου\or Δεκεμβρίου\fi}

\SetDialect{katharevousa}

\DeclareLanguageCommand*{\refname}{names}
  {>Αναφορα`ι}%
\DeclareLanguageCommand*{\abstractname}{names}
  {Περίληψις}%
\DeclareLanguageCommand*{\chaptername}{names}
  {Κεφάλαιον}%
\DeclareLanguageCommand*{\contentsname}{names}
  {Περιεχόμενα}%
\DeclareLanguageCommand*{\indexname}{names}
  {Ε>υρετήριον}%
\DeclareLanguageCommand*{\figurename}{names}
  {Σχ=ημα}%
\DeclareLanguageCommand*{\tablename}{names}
  {Πίναξ}%
\DeclareLanguageCommand*{\pagename}{names}
  {Σελ`ις}%
\DeclareLanguageCommand*{\seename}{names}
  {<όρα}%
\DeclareLanguageCommand*{\alsoname}{names}
  {<όρα >επίσης}%
\DeclareLanguageCommand*{\ccname}{names}
  {Κοινοποίησις}%
\DeclareLanguageCommand*{\headtoname}{names}
  {Πρ`ος}%
\DeclareLanguageCommand*{\proofname}{names}
  {>Απόδειξις}% for AMS-\LaTeX

\DeclareDateFunction{mmmm}{%
  \ifcase\month\or
  >Ιανουαρίου\or Φεβρουαρίου\or Μαρτίου\or >Απριλίου\or
  Μαΐου\or >Ιουνίου\or >Ιουλίου\or Α>υγούστου\or
  Σεπτεμβρίου\or >Οκτωβρίου\or Νοεμβρίου\or Δεκεμβρίου\fi}

\SetLanguage{greek}

\DeclareDateCommand{\today}{<d> <mmmm> <yyyy>}

\DeclareLanguageCommand{\@alph}{layout}[1]{\greeknumber{#1}}
\DeclareLanguageCommand{\@Alph}{layout}[1]{\uppercase{\greeknumber{#1}}}
\DeclareLanguageCommand{\labelitemi}{layout}{--}%
\DeclareLanguageCommand{\labelitemii}{layout}{--}%
\DeclareLanguageCommand{\labelitemiii}{layout}{--}%
\DeclareLanguageCommand{\labelitemiv}{layout}{--}

\newcounter{hundredmillions}
\newcounter{tenmillions}
\newcounter{millions}
\newcounter{hundredthousands}
\newcounter{tenthousands}
\newcounter{thousands}
\newcounter{hundreds}
\newcounter{tens}
\newcounter{units}
\newcounter{belowhundred}
\newcounter{grnumber}
\def\numbersix{^^^^03db}
\def\grnumbertmp#1#2#3{\ifcase\value{#1}\or ρ\or σ\or τ\or υ\or φ\or χ\or ψ\or ω\or =π\else rien\fi%
\ifcase\value{#2}\or ι\or κ\or λ\or μ\or ν\or ξ\or ο\or π\or =χ\else rien\fi%
\ifcase\value{#3}\or α\or \/β\/\or γ\or δ\or ε\or \numbersix\or ζ\or η\or θ\else rien\fi}
\def\greeknumber#1{%
\setcounter{grnumber}{#1}%
\ifthenelse{\value{grnumber} > 999999999}{\typeout{Number too big!}}{%
\ifthenelse{\value{grnumber} > 999999}{^^^^0375^^^^0375\kern.5pt}{\ifthenelse{\value{grnumber} > 999}{^^^^0375\kern.5pt}{}}%
\setcounter{hundredmillions}{\value{grnumber}/100000000}%
\addtocounter{grnumber}{-100000000*\value{hundredmillions}}%
\setcounter{tenmillions}{\value{grnumber}/10000000}%
\addtocounter{grnumber}{-10000000*\value{tenmillions}}%
\setcounter{millions}{\value{grnumber}/1000000}%
\addtocounter{grnumber}{-1000000*\value{millions}}%
\setcounter{hundredthousands}{\value{grnumber}/100000}%
\addtocounter{grnumber}{-100000*\value{hundredthousands}}%
\setcounter{tenthousands}{\value{grnumber}/10000}%
\addtocounter{grnumber}{-10000*\value{tenthousands}}%
\setcounter{thousands}{\value{grnumber}/1000}%
\addtocounter{grnumber}{-1000*\value{thousands}}%
\setcounter{hundreds}{\value{grnumber}/100}%
\addtocounter{grnumber}{-100*\value{hundreds}}%
\setcounter{tens}{\value{grnumber}/10}%
\addtocounter{grnumber}{-10*\value{tens}}%
\setcounter{units}{\value{grnumber}}%
\grnumbertmp{hundredmillions}{tenmillions}{millions}\grnumbertmp{hundredthousands}{tenthousands}{thousands}\grnumbertmp{hundreds}{tens}{units}%
\setcounter{belowhundred}{\value{hundreds}+\value{tens}+\value{units}}%
\ifthenelse{\value{belowhundred}>0}{^^^^0374}{}}}

\DeclareDateFunction{gyyyy}{\greeknumber{\number\year}}
\DeclareDateFunction{gd}{\greeknumber{\number\day}}

\DeclareDateCommand{\greektoday}{<gd> <mmmm> <gyyyy>}

%\AtEndComponent{text}{\greeklccodes\greekmarks}

\endinput
