
# TeX hyphenation patterns for Spanish, v 5.0.

This directory is a permanent place for the latest official release of the hyphenation patterns for the Spanish language, valid for xetex, luatex and pdftex.

The GitHub repository is:

https://github.com/jbezos/tex-hyphen-spanish

They are based on rules, with the help of a dictionary of about 700 000 words, created over 20 years and still expanding.

This project is related to tex-hyphen, the collection of hyphenation patterns for TeX and other systems based on the same algorithm (Mozilla, Kindle, FOP, etc.):

https://github.com/hyphenation/tex-hyphen

Note however the version bundled with tex-hyphen (in CTAN:language/hyph-utf8/) could be outdated.

## Contents

* `hyph-es-generated.tex` is the main file. This is the file to be replaced in order to update the patterns, after removing the suffix `-generated`. Remember you must rebuild the formats (except with   luatex).

* `eshyphexh.tex` provides exceptions for traditional rules with adh, exh, and a few more.

* `division.pdf` is a draft of an article (in Spanish) explaining the rules to be applied and how they are being translated into TeX in a unified set of patterns (somewhat outdated).
 
* `eshyph-make.lua` generates the patterns, with `eshyph.src` for prefixes and special cases.
 
* `eshyph-test.tex` makes a comparison of two hyphenation rules. Use   `hyphen-es-base.tex` for more or less strict syllabic rules. It requires a file `spanish-words.txt` with a list of words (a sample with about 56 000 entries is supplied in the GitHub repository), one per line. You can (should) filter the words. Requires at least luatex 1.10.
 
The sources for the word list include [ispell](https://www.cs.hmc.edu/~geoff/ispell.html), [DRAE-DLE](https://dle.rae.es/), the dictionary by María Moliner, [Fundéu](https://www.fundeu.es/) and personal tools for web crawling, with manual selection of terms.
