/* config.x 2.9.0 92/07/06 - site-specific string constant(s) -*-c-*- */

/*  HOW TO USE THIS FILE
 *
 *  * Copy config.dist to config.c:
 *    You can ediut config.c as much as you like so long as config.dist
 *    remains as DISTributed.
 *  * If your machine/system is not represented then edit config.c to add
 *    a section to the first part describing it as below.
 *  * Set the pathnames in the bottom third to suit your site.
 *
 *  More than one program uses this config file; therefore some of the
 *  constants it defines don't apply to the program you got this file with!
 */

/*
 *  This file comes in 2 parts -- 
 *  (1) conditionals which try to guess
 *  what system this is & set other conditionals (e.g., BSD, 
 *  SHORT_FILENAMES; and
 *  (2) setting various constants (e.g., dir_sep_ch) based on these,
 *  unless they are already set.
 */

/*
 *  Some cpp macros that might want to be set:
 *
 *  BSD
 *    set on BSD-like systems
 *
 *  USG
 *    set on systems based on System III or System IV
 *
 *  SHORT_FILENAMES
 *    There is a foolish limit on the length of filenames.
 *
 *  NO_DOTRC
 *    On single-user systems, there is no reason to have a separate
 *    ~/.progrc file, because all the system's owner's tailoring
 *    foes in the system rc file.
 *
 *  NO_EXEC_USE_SPAWN
 *    On TOS systems (and perhaps MS-DOS?), to create a subprocess
 *    I must use spawnvp() rather than fork() and exec().
 *
 *  NO_ARGV0
 *    It seems that on TOS, argv[0] is likely to have been left NULL.
 *
 *  NEEDPROTO
 *    set on systems which don't have prototypes in the system
 *    header files but for which prototypes are needed -- such as
 *    GNU C on PCC-based systems.  Functions that return int or void
 *    will need declarations to avoid "implicit declaration" warnings.
 *
 *  NO_FLSBUF
 *    set this if (a) NEEDPROTO is set and (b) the stdio macros getc
 *    and putc are *NOT* defined in terms of functions _flsbuf and _filbuf.
 *    This is an unfortunate hack necessary in order to prototype those
 *    two function on PCC-based systems when using GNU C.
 *
 *  NO_EXECVP
 *    There is no standard subroutine execvp (V7, 4.2BSD?)
 *
 *  FANCY_MALLOC
 *    Has a fancy version of malloc that is optional on some System V
 *    systems and standard on Suns.
 */

/*
 *  dir_sep_ch
 *    A character constant.  Names of files are assumed to be formed of
 *    name components separated by this character.
 *
 *  dir_sep_ch2
 *    A character allowed as a synonym for dir_sep_ch
 *    (On gcc/TOS systems, / can be used as a synonym for \.)
 *    If there isn't one, it is undefined.
 *
 *  path_sep_ch
 *  path_sep_ch2
 *    Character constants.  Used to separate directories is a search path.
 *    The second of these used to give the user a choice of characters
 *    and is only for compatability with TOS progs which seem to choose
 *    either comma or semicolon at random.  It is undefined if
 *    only one path-separating character is used.
 *
 *  int absolute_path_p(const char *s)
 *    Macro which returns nonzero if it seems that filename s
 *    is an absolute name, i.e., should not be searched for.
 *    (Assuming s is a correctly-formed name.)
 *    In UNIX, this is a filename starting "/", "./" or "../"; on
 *    MS-DOS, starting "X:" or "\" or ".".
 *    
 */
 

#ifdef sun
/*  Sun workstation, Sun UNIX 3.x or SunOS 4.x  */
#  define BSD
#  define NEEDPROTO
#  define FANCY_MALLOC
#  define default_vfontpath \
	".:vfont:/usr/lib/vfont:/usr/lib/fonts/fixedwidthfonts"
#endif

#ifdef atarist 
/*
 *  Adrian Cox's Atari ST, running gcc
 *  Probably applies to a gcc/MS-DOS system too.
 */
#  define BSD
#  define NO_EXEC_USE_SPAWN
#  define NO_ARGV0
#  define config_rc_dir "C:\\LIB"
#  define dir_sep_ch '\\'
#  define dir_sep_ch2 '/'	/* assume library does translation */
#  define absolute_path_p(s)	\
  	((isalpha(s[0]) && s[1] == ':') \
	 || s[0] == '\\' || s[0] == '/' || s[0] == '.')
#  define path_sep_ch ','	/* allow colons in filenames */
#  define path_sep_ch2 ';'
#  define NO_DOTRC
#  define SHORT_FILENAMES
#endif

#ifdef GEC 
/*
 *  TARDIS, a Sys V.2 box, now deceased
 */
#  define USG
#  define SHORT_FILENAMES
#endif


/*
 *  Default syntax of filenames and searchpaths is UNIX-like:
 */
#ifndef dir_sep_ch
#  define dir_sep_ch 	'/'
#  define absolute_path_p(s) \
	(s[0] == '/' \
	 || (s[0] == '.' && (s[1] == '/' \
			     || (s[1] == '.' && s[2] == '/'))))
#  define path_sep_ch ':'
#endif

#ifdef dir_sep_ch2
#  define isdirsep(x)	((x) == dir_sep_ch || (x) == dir_sep_ch2)
#else
#  define isdirsep(x)	((x) == dir_sep_ch)
#endif

#ifdef path_sep_ch2
#  define ispathsep(x)	((x) == path_sep_ch || (x) == path_sep_ch2)
#else
#  define ispathsep(x)	((x) == path_sep_ch)
#endif

#ifndef vfont_suffix
#  define vfont_suffix	".vfont"
#endif

#ifndef BSD
#  define NO_SIGLIST
#endif

#ifndef config_rc_dir
#  define config_rc_dir 	"/usr/local/lib" 
#endif
/* 
 *  Look for site-wide `rc' files here 
 *  Should not end in slash.
 */

