/*
 *	download.c -- download cms fonts to printer
 *
 *	Written by H. Nagahara on 9/5/90 15:50:53.
 *	Copyright (C) 1990 by ASCII Corporation.  All rights reserved.
 *		SCCS memo: download.c 5.1
 */
#include	<stdio.h>
#include	"config.h"
#include	<string.h>
#if	MSDOS
# include	<malloc.h>
# include	<stdlib.h>
#else
  extern char	*malloc(), *calloc();
#endif

#include	"font.h"
#include	"drive.h"
#include	"lbp.h"

extern struct grif *farload PP((struct font *));

/* font information in the printer */
struct prfont {
    struct prfont	*next;
    char		*name;
    int2		graphset;
    int4		datacount;
    int1		incore;
};

static struct prfont *InPrinter;
static int	flag = FALSE;		/* flag for do download */

/* external function declaration */
#if	PKFONT
extern struct grif	*pkload();	/* PK file load routine in pkload.c */
#endif
extern void		jxlready();
#if	PXLFONT
extern struct grif	*pxlload();
#endif

/* Set downloaded info into fontlist */
int
setdowninfo( f )
struct font	*f;
{
    int		fontsize;
    char	fontname[128];
    struct prfont	*df;

    /* smaller font */
    if( f->prev != NULL )
	if( setdowninfo( f->prev ) )
	    return TRUE;

    /* set myself */
    f->prn = (struct prinfo *)malloc( sizeof(struct prinfo) );
    if( f->prn == NULL )
	return TRUE;
    f->prn->download = FALSE;
    f->prn->prn_no = -1;
    f->prn->graphset = -1;
    f->prn->datacount = 0;
    fontsize = (int)(PRINTER_RES * (double)f->scale / (double)(f->design)
		     * magnification + 0.5);
    sprintf( fontname, "%s-%d.%s", f->info->name, fontsize, "TeX" );
    f->prn->name = malloc( strlen(fontname) + 1 );
    if( f->prn->name == NULL ) {
	free( f->prn );
	f->prn = NULL;
	return TRUE;
    }
    strcpy( f->prn->name, fontname );

    /* search downloaded list */
    for( df = InPrinter; df != NULL; df = df->next ) {
	if( strcmp( df->name, fontname ) == 0 ) {
	    f->prn->download = TRUE;
	    f->prn->graphset = df->graphset;
	    f->prn->datacount = df->datacount;
	    df->incore = TRUE;
	    break;
	}
    }
    
    /* larger font */
    if( f->next != NULL )
	if( setdowninfo( f->next ) )
	    return TRUE;

    return FALSE;
}

#define		BUFLEN		128
/* get downloaded infomation */
int
getdinfo( f )
struct font	*f;
{
    FILE	*dfontfp;	/* downloaded font infomation file */
    struct prfont *fp;		/* printer font info */
    char	lbuf[BUFLEN];
    char	*fontname;
	
    /* setup InPrinter list */
    InPrinter = NULL;
    using_gset = MINUSERGSET - 1;
    if( ! forcedownload ) {
	/* load downloaded font infomation */
#if MSDOS
	dfontfp = fopen( downinfo, "rt" );
#else
	dfontfp = fopen( downinfo, "r" );
#endif
	if( dfontfp != NULL ) {
	    while( fgets( lbuf, BUFLEN, dfontfp ) != NULL ) {
		if( (lbuf[0] == '\0') || (lbuf[0] == '#') )
		    continue;
		/* font name */
		fontname = strtok( lbuf, " \t" );
		fp = (struct prfont *)malloc( sizeof(struct prfont) );
		if( fp == NULL )
		    goto MemError;
		fp->name = malloc( strlen( fontname ) + 1 );
		if( fp->name == NULL ) {
		    free( fp );
		    goto MemError;
		}
		strcpy( fp->name, lbuf );
		/* graphic set # */
		fp->graphset = atoi( strtok(NULL, " \t") );
		if( using_gset < fp->graphset )
		    using_gset = fp->graphset;
		/* data count */
		fp->datacount = (int4)atol( strtok(NULL, " \t") );
		downloadcount += fp->datacount;
		fp->next = InPrinter;
		fp->incore = FALSE;
		InPrinter = fp;
	    }
	    fclose( dfontfp );
	}
    }
    
    /* set downloaded info to fontlist */
    return( setdowninfo( f ) );

  MemError:
    return TRUE;
}

/* put a font named downloaded to printer */
int
putfontd( fp, f )
FILE		*fp;
struct font	*f;
{
    if( f->prev != NULL )
	if( putfontd( fp, f->prev ) )
	    return TRUE;

    if( f->prn->download && (f->type == TFM) ) {
	if( fprintf( fp, "%s\t%d\t%ld\n", f->prn->name,
		     (int)(f->prn->graphset), (int4)(f->prn->datacount) ) == EOF )
	    return TRUE;
    }

    if( f->next != NULL )
	if( putfontd( fp, f->next ) )
	    return TRUE;

    return FALSE;
}
/* write back downloaded font info file */
void
putdinfo( f )
struct font	*f;
{
    FILE	*dfontfp;	/* downloaded font infomation */
    struct prfont	*p, *next;

#if MSDOS
    dfontfp = fopen( downinfo, "wt" );
#else
    dfontfp = fopen( downinfo, "w" );
#endif
    if( dfontfp == NULL ) {
	fprintf( stderr, "%s: warning: cannot open %s\n", progname, downinfo );
 	return;
    }

    if( fprintf( dfontfp, "# font name\tgset\tbytes\n" ) == EOF ) 
	goto Error;

    if( putfontd( dfontfp, f ) )
	goto Error;

    for( p = InPrinter; p != NULL; p = next ) {
	if( !p->incore ) {
	    if( fprintf( dfontfp, "%s\t%d\t%ld\n", p->name, (int)(p->graphset),
		     (int4)(p->datacount) ) < 0 )
		goto Error;
	}
	next = p->next;
	free( p->name );
	free( p );
    }

    fclose( dfontfp );
    return;

  Error:
    fprintf( stderr, "%s: warning: cannot write %s\n", progname, downinfo );
    fclose( dfontfp );
    (void)unlink( downinfo );
}

/* open font grif data */
struct grif *
loadfont( f )
struct font	*f;
{
    int		res;		/* font resolution */
    FILE	*grif;		/* grif file */
    char	grifname[128];	/* grif file name */
    struct grif	*fbuf;		/* font buffer */
    int4	last;		/* pxlfont size */

    res = (int)(PRINTER_RES * (double)f->scale / (double)f->design
		* magnification + 0.51);
    if( verbose )
	fprintf( stderr, "(%s-%d)", f->info->name, res );

#if	MSDOS
#if	FARFONT
    /* check & load far font */
    fbuf = farload( f );
    if( fbuf != NULL )
	return fbuf;
#endif	/* FARFONT */
    res = (int)(PRINTER_RES * (double)f->scale / (double)f->design
		* magnification * 5.0 + 0.51);
#endif	/* MSDOS */

#if	PXLFONT
    /* try to pxl file */
#if MSDOS
    sprintf( grifname, "%s/%d/%.8s.pxl", fontdir, res, f->info->name );
#else
    sprintf( grifname, "%s/%s.%dpxl", fontdir, f->info->name, res * 5);
#endif
    grif = fopen( grifname, "r" );
    if( grif == NULL ) {
#if	MSDOS
	sprintf( grifname, "%s/%d/%.8s.pxl", fontdir, res - 1, f->info->name );
	grif = fopen( grifname, "r" );
	if( grif == NULL ) {
	    sprintf( grifname, "%s/%d/%s.pxl", fontdir, res + 1, f->info->name );
	    grif = fopen( grifname, "r" );
	    if( grif == NULL ) {
#endif
#endif	/* PXLFONT */

#if	PKFONT
	/* try to PK file */
#if MSDOS
	sprintf( grifname, "%s/%d/%.8s.pk", fontdir, res, f->info->name );
#else
	sprintf( grifname, "%s/%s.%dpk", fontdir, f->info->name, res );
#endif
	grif = fopen( grifname, "r" );
	if( grif == NULL ) {
#if	MSDOS
	    sprintf( grifname, "%s/%d/%.8s.pk", fontdir, res - 1, f->info->name );
	    grif = fopen( grifname, "r" );
	    if( grif == NULL ) {
		sprintf( grifname, "%s/%d/%.8s.pk", fontdir, res + 1, f->info->name );
		grif = fopen( grifname, "r" );
		if( grif == NULL ) {
#endif
	    fprintf( stderr, "%s: No font file %s\n", progname, grifname );
	    return NULL;
#if	MSDOS
		}
	    }
#endif
	}
	fbuf = pkload( f, grif, grifname );
#else
	fprintf( stderr, "%s: No font file %s\n", progname, grifname );
	return NULL;
#endif	/* PKFONT */

#if	PXLFONT
#if	MSDOS
	    }
	}
#endif
    }
    else {
	/* found PXL file */
	if( fseek( grif, 0L, 2 ) < 0 )	goto Error;
	last = ftell( grif );
	fbuf = pxlload( f, grif, grifname, 0L, last );
    }
#endif

    /* finish of read grif file */
    fclose( grif );
    return fbuf;

  Error:
    fprintf( stderr, "%s: cannot seek %s\n", progname, grifname );
    return NULL;
}
	
/* release font grif area */
void
freefont( f, p )
struct font	*f;
struct grif	*p;
{
    register int	n;

    for( n = f->info->end - f->info->begin; n >= 0; n-- ) {
	free( (p + n)->bitmap );
    }
    free( p );
}

/* download a font set */
int
downfont( f )
struct font	*f;
{
    struct grif		*fbuf;

    /* download smaller fonts */
    if( f->prev != NULL )
	if( downfont( f->prev ) )
	    return TRUE;

    /* download myself */
    if( !(f->prn->download) && (f->type == TFM) ) {
	fbuf = loadfont( f );	/* expand grif file and make bitmap */
	if( fbuf == NULL )
	    return TRUE;
	if( !flag ) {
	    LBP_sendSOJ( FALSE );
	    flag = TRUE;
	}
	if( LBP_aFont( f, fbuf ) )
	    freefont( f, fbuf );
	else
	    f->gdata.pattern = fbuf;
    }
    else if( (f->type == JFM) && usejxlfont )
	jxlready( f );

    /* download larger fonts */
    if( f->next != NULL )
	if( downfont( f->next ) )
	    return TRUE;
    
    return FALSE;
}

/* download fonts as a printer job */
int
download()
{
    flag = FALSE;
    /* load downinfo from status file */
    if( getdinfo( fontlist ) )
	return TRUE;

    /* download fonts */
    if( downfont( fontlist ) )
	return TRUE;

    /* finish download */
    if( flag ) {
	LBP_sendEOJ();		/* send EndOfJob seq. to printer */
	putdinfo( fontlist );	/* update downinfo file */
    }

    return FALSE;
}
