/*
 *	dosprn.c -- printer handling routine for PC9801
 *
 *	Written by H. Nagahara on 9/5/90 15:50:48.
 *	Copyright (C) 1990 by ASCII Corporation.  All rights reserved.
 *		SCCS memo: dosprn.c 5.1
 */
#include    <stdio.h>
#include    "config.h"
#include    <dos.h>
#include    <varargs.h>

#ifdef	FILTER
#  include	<fcntl.h>
#  include	<io.h>
#endif

#if	PC98
# define	PRNBIOS		0x1a
#endif
#if	J3100
# define	PRNBIOS		0x17
#endif

#define	BUFSIZE		2048

static char		buf[BUFSIZE];
int	lopen(void);
int	lputchar(int);
int	lprintf(char*,...);

/* initialize printer BIOS */
int
lopen()
{
#if	PC98
    union REGS	in, out;
#endif

#ifdef	FILTER
	setmode( fileno(stdout), O_BINARY );
	return 0;
#endif

#if	PC98
    in.h.ah = 0x10;
    int86( PRNBIOS, &in, &out );
    return out.h.al;
#endif

#if	J3100
    return 0;
#endif
}

/* send a byte to printer */
int
lputchar( c )
int	c;
{
    union REGS	in, out;

#ifdef	FILTER
	putchar( c );
	return c;
#endif

#if	PC98
    in.h.ah = 0x11;
    in.h.al = (unsigned char)c;
    int86( PRNBIOS, &in, &out );
    
    if( out.h.ah != 0 )
	return EOF;
    else
	return c;
#endif

#if	J3100
    in.h.ah = 0x84;	/* print without Kanji code conversion */
    in.h.al = (unsigned char)c;
    in.x.dx = 0;	/* device # */
    int86( PRNBIOS, &in, &out );
    
    if( out.h.ah & 0x29 )
	return EOF;
    else
	return c;
#endif
}

/* formatted print out to printer */
int
lprintf( va_alist )
va_dcl
{
    va_list	args;
    char	*fmt;
    int		bytes;
    register int i;

    /* format paramters */
    va_start( args );
    fmt = va_arg( args, char * );
    bytes = vsprintf( buf, fmt, args );

    /* printout string */
    for( i = 0; i < bytes; i++ )
	lputchar( buf[i] );

    return bytes;
}	

#ifdef	STANDALONE
int
main( argc, argv )
int	argc;
char	*argv[];
{
	FILE	*prfile;
	int	gotten;
	int	i;

	if( argc == 1 )
		prfile = stdin;
	else if( argc == 2 ) {
		prfile = fopen( argv[1], "rb" );
		if( prfile == NULL ) {
			fprintf( stderr, "cannot open %s\n", argv[1] );
			exit( 1 );
		}
	}
	else {
		fprintf( stderr, "Usagge: %s <input_file>\n", argv[0] );
		exit( 1 );
	}
	
	(void)lopen();

	while( (gotten = fread( buf, 1, BUFSIZE, prfile )) > 0 ) {
		for( i = 0; i < gotten; i++ )
			(void)lputchar( buf[i] );
	}
	
	return;
}
#endif	/* STANDALONE */
