/*
 *	config.h -- configuration header file for lips3dvi
 *
 *	This file containes compiler & machine dependent macros.
 *	Please edit this file to fit your machine.
 *
 *	Written by H. Nagahara on 9/11/90 19:37:58.
 *	Copyright (C) 1990 by ASCII Corporation.  All rights reserved.
 *		SCCS memo: config.h 5.2
 */
/* select machine */
#define	SUN		1	/* select only one of them */
#define	NEWS		0
#define	PC98		0
#define	J3100		0

#ifdef	MSDOS		/* MS-C defines MSDOS */
# undef	MSDOS
#endif

# define	MSDOS	(PC98 || J3100)
# define	CPU32	!(PC98 || J3100)
# define	CPU16	(PC98 || J3100)
# define	LITTLE	(PC98 || J3100)	/* little indian */
# define	BIG	!(PC98 || J3100)

/* needed file path name */
#if	MSDOS
#define	FONTDIR		"b:/farfonts"		/* font existing dir */
#define	TFMDIR		"b:/farfonts/tfm"	/* TFM existing dir */
#define	DOWNINFO	"a:/tmp/download.fnt"	/* downloaded file name file */
#define	CONFFILE	"a:/tex/lips3dvi.cnf"	/* default configuration file */
#else
#define	FONTDIR		"/usr/local/lib/tex/fonts"
#define	TFMDIR		"/usr/local/lib/tex/fonts"
#define	DOWNINFO	"/var/tmp/.fontinfo"
#define	CONFFILE	"/usr/local/lib/tex/lips3dvi.cnf"
/* below 3 symboles are defined for 'dvipr' & 'dviback' (UNIX only) */
#define	MAINPROG	"/usr/local/lib/tex/lips3dvi"	/* body program path */
#define	LPRCMD		"/usr/ucb/lpr"		/* lpr command */
#define	LPRDEFOPT	"-d"			/* lpr necessarily option */
#define	TMPFNAME	"/var/tmp/lips3dvi"	/* tmp file base name */
#endif

/* support font selection */
#define	PXLFONT		1		/* PXL font support */
#define	PKFONT		1		/* PK font support */
#define	FARFONT		0		/* FAR font support (DOS only) */
	/* search order : FAR -> PXL -> PK */
#define	MICROTEX	0		/* micro TeX output support */

/* JXL font cache size (depend on memory) */
#if	MSDOS
# define CACHE_SIZE	1000	/* font cache size (# of char in cache) */
#else
# define CACHE_SIZE	8000
#endif

/* variable size depending on CPU */
#if	CPU16
typedef	signed char	int1;		/* 1 byte signed */
typedef signed int	int2;		/* 2 bytes signed */
typedef	signed long	int4;		/* 4 bytes signed */
typedef	unsigned char	uint1;		/* 1 byte unsigned */
typedef	unsigned int	uint2;		/* 2 bytes unsigned */
typedef	unsigned long	uint4;		/* 4 bytes unsigned */
#define	MAXINT		32767		/* integer max */
#define	MININT		-32768		/* integer min */
#define	MAXINT2		32767		/* 2 bytes integer max */
#define	MININT2		-32768		/* 2 bytes integer min */
#endif
#if	CPU32
typedef	char		int1;		/* 1 byte signed */
typedef short		int2;		/* 2 bytes signed */
typedef	int		int4;		/* 4 bytes signed */
typedef	unsigned char	uint1;		/* 1 byte unsigned */
typedef	unsigned short	uint2;		/* 2 bytes unsigned */
typedef	unsigned int	uint4;		/* 4 bytes unsigned */
#define	MAXINT		2147483647	/* integer max */
#define	MININT		-2147483648	/* integer min */
#define	MAXINT2		32767		/* 2 bytes integer max */
#define	MININT2		-32768		/* 2 bytes integer min */
#endif

/* CPU byte order */
#if	LITTLE
# define	SWAP		1	/* 1 when CPU is a little indian */
#endif
#if	BIG
# define	SWAP		0	/* 0 when CPU is a big indian */
#endif

/* basic constant : DON'T CHANGE THEM */
#define	PROGID		('l' + 'i' + 'p' + 's' + '3' + 'd' + 'v' + 'i')
#define	TRUE		1
#define	FALSE		0

/* for ANSI prototype declaration (DOS only) */
#if	MSDOS
# define	PP(x)	x	/* enable prototype declaration */
# ifndef	MAKEDECL
#  include	"declears.h"
# endif
#else
# define	PP(x)	()	/* disable prototype declaration */
#endif
