/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */


#define EMIT_1(x1)          fprintf(EX_FP(Ex_PsOutput), x1)
#define EMIT_2(x1,x2)       fprintf(EX_FP(Ex_PsOutput), x1, x2)
#define EMIT_3(x1,x2,x3)    fprintf(EX_FP(Ex_PsOutput), x1, x2, x3)
#define EMIT_4(x1,x2,x3,x4) fprintf(EX_FP(Ex_PsOutput), x1, x2, x3, x4)

/* How long lines generated by this driver should be (rough approx.)
   This is NOT a hard limit, by the way! */
#define PSS_MAXL   77

/* Send a single character. Also increment the column counter. */
#define EMITC(c) {putc(c, EX_FP(Ex_PsOutput)); PssColumn++;}

/* Send a space, but send a new line if maximum line length is exceeded. */
#define EMIT_SPACE_OR_NEWLINE()\
  if(PssColumn > PSS_MAXL) {\
    putc('\n', EX_FP(Ex_PsOutput));\
    PssColumn = 0;\
  } else {\
    if (PssColumn != 0) {EMITC(' ');}\
  }

/* Send a hex number (two digits). */
#define PSS_SEND_HEX(h) EMITC(*(digit+((h>>4)&0xF)));\
  EMITC(*(digit+(h&0xF)));

/* Send an octal number. */
#define PSS_SEND_OCT(n)\
  EMITC('\\' );\
  EMITC(digit[(n&0300)>>6]);\
  EMITC(digit[(n&0070)>>3]);\
  EMITC(digit[(n&0007)   ]);

/* Generate a new line if there are more than c+PssColumn characters on
 * the current line. */
#define PSS_CHECK_FULL_LINE(c)\
  {if (c+PssColumn >= PSS_MAXL) {\
    EMIT_NEW_LINE;\
  }}

/* Send a new line anyway, whether needed or not. */
#define EMIT_NEW_LINE   {putc ('\n', EX_FP(Ex_PsOutput)); PssColumn = 0;}

/* POSITIONING_TESTING does a variety of things I needed when there
   were rule alignment problems. Don't define it until you really looked
   into the sources so you know what it's doing. */
/* #define POSITIONING_TESTING */

#ifdef  POSITIONING_TESTING
#define EMIT_SCC_POSITIONING PositioningSingleCharacterCommand();
#else
#define EMIT_SCC_POSITIONING
#endif

/* Emit single character command. */
#define EMIT_SCC(c)\
  if (PssNeedSpaceMatrix[PssLastThingSent][PSS_LAST_COMMAND])\
    EMIT_SPACE_OR_NEWLINE();\
  PssLastThingSent = PSS_LAST_COMMAND;\
  putc (c, EX_FP(Ex_PsOutput));\
  PssColumn ++;\
  EMIT_SCC_POSITIONING;

/* Next instruction. code: PSS_LAST_*; needed: how much space needed. */
#define PSS_NEXT_INSTRUCTION(code,needed)\
  if (PssNeedSpaceMatrix[PssLastThingSent][code])\
    EMIT_SPACE_OR_NEWLINE();\
  PssLastThingSent = code;\
  PSS_CHECK_FULL_LINE(needed);

#define PSS_LAST_NONE 0
#define PSS_LAST_STRING 1
#define PSS_LAST_NUM 2
#define PSS_LAST_COMMAND 3

/* Add a character to the PssStringBuffer. */
#define PSS_ADD_CHAR(c)  PssStringBuffer[++PssStringIndex] = c;

/* Pss format: free versus continous */
#define PSS_FOR_FREE 0
#define PSS_FOR_CONT 1
