/* Copyright 1988, 1989, 1990 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

/* Maximum font number the driver can handle. */
#define MAX_FONTS 256

#define MAXOPEN 8  /* Limit on number of open font files. */

/* .pxl file stuff */
#define PXLID 1001

/* Initialisations of the PXL[] array. Later the size
 * of the array is dynamically increased if necessary.
 * COL_PXL_INIT: width:  number of columns in bits
 * ROW_PXL_INIT: height: number of rows. */
#define COL_PXL_INIT 400
#define ROW_PXL_INIT 400

/* r: row index in bits, c: column index in bytes. This macro
 * loads the PIX array which is dynamically allocated. */
#define PIX_LOAD(r,c) PIX[((r)*(PixelsMaxCol/8) + (c))]

/* Maximum drift, units is pixel. */
#define MAX_DRIFT 2

/* Maximum dvi file stack size. */
#define  MAX_STACK_SIZE      400

#define  NONEXISTANT     -1	/* Offset for PXL files not found. */

#define  STRSIZE        257

/* tfm file stuff: for built-in fonts we allow characters
   from 0..MAXTFMCHAR-1 */
#define	 MAXTFMCHAR	256

/* Default resolution of printer. */
#define DEFAULT_RES 300

/* Orientation (this should be more general, so the user can
 * download his own matrix). */
#define PORTRAIT_MODE 0
#define LANDSCAPE_MODE 1
#define NO_ORIENTATION 2

/* Maximal length of a \special string. */
#define SPECIAL_LENGTH	512

/* Two codings for the order of output in the PS file generated
 * by the driver. */
#define ORDER_OUTPUT_FORWARD 0
#define ORDER_OUTPUT_REVERSE 1

/* Return codes for Pass0() */
#define PASS0_EOP_FOUND 0       /* Regular end of page */
#define PASS0_POSTAMBLE_FOUND 1  /* Postamble beginning found */

/* Return codes for Pass1() */
#define PASS1_EOP_FOUND 0       /* Regular end of page */
#define PASS1_POSTAMBLE_FOUND 1  /* Postamble beginning found */

/* Return codes of DoSpecial() */
#define DOSPECIAL_RETURN_REGULAR 0

/* String a special must start out with in order to be recognized
 * by this driver. Case sensitive! */
#define DVITPS_SPECIAL "dvitps:"

/* String at the beginning (after %!) which says to which "conforming
 * document" version the output conforms (-C option of the driver) */
#define CONFORMING_DOCUMENT_STRING "PS-Adobe-2.0"

#define DVISTDIN_NO              0
#define DVISTDIN_IS_FILE         1
#define DVISTDIN_USE_TEMP_FILE   2
