# This awk script is used to convert local-defs into
# local-defs.xx

BEGIN	{
	default_index = 0;  # Defaults are stored using this index.
	use_index = 0;	    # Values to be used are stored with this index.
	line_number = 0;
	# Log file business.
	log_file = "local-defs.log";
	printf ("Processing by setup-ld.awk started\n\n") >> log_file;
	}

# Increment line counter every line.
	{
	line_number ++;
	}

# Ignore empty or comment lines.
/^$/ || /^#/ {continue;}

# Record a default value.
/default/ {
	DefaultLeft[default_index] = $2;
	DefaultRight[default_index] = $3;
	DefaultRightLong[default_index] = DefaultRight[default_index];
	for (i=4; i<=NF; i++) {
		new = sprintf ("%s %s", DefaultRightLong[default_index], $i);
		DefaultRightLong[default_index] = new;
	}
	printf ("Default for %s is %s\n", DefaultLeft[default_index], DefaultRight[default_index]) >> log_file;
	if (NF < 3)
		printf ("ERROR in line %d of local-defs: too few fields\n", line_number) >> log_file;
	# Increment index, continue.
	default_index++;
	next;
	}

/end/	{
	# Check first whether for every use value a default value was defined before.
	for (j=0; i<use_index; j++) {
		found = 0;
		for (i=0; i<use_index; i++) {
			if (DefaultLeft[i] == UseLeft[j]) {
				found = 1;
				break;
			}
		}
		if (found == 0)
			printf ("end statement: use value %s with no default\n", UseLeft[j]) >> log_file;
	}
	# Now check every value for which you have a default value
	# whether the default value should be used or whether a new
	# values has been read in below.
	for (i=0; i<default_index; i++) {
		found_use_value = 0;
		for (j=0; j<use_index; j++) {
			if (DefaultLeft[i] == UseLeft[j]) {
				found_use_value = 1;
				break;
			}
		}
		if (found_use_value == 1) {
			use_short = UseRight[j];
			use_long  = UseRightLong[j];
		} else {
			use_short = DefaultRight[i];
			use_long  = DefaultRightLong[i];
		}
		# Now print the stuff for make, then for the C preprocessor.
		printf ("%s = %s\n",            DefaultLeft[i], use_long);
		printf ("#define COND_%s %s\n", DefaultLeft[i], use_short);
	}
	# Reset to start over again.
	default_index = 0;
	use_index = 0;
	next;
}

# Entries to be analyzed now are as follows:
# $1: [x] where x is the installation number.
# $2: kk: kk is what is being defined.
# $3: equal sign
# $4...: what it is initialized to.
/^\[.*\]/ {
	# Strip off the []. 
	number = substr($1, 2, length($1)-2);
	# Is it a match?
	if ( number == InstallationNumber ) {
		UseLeft [use_index] = $2;
		UseRight[use_index] = $4;
		UseRightLong[use_index] = UseRight[use_index];
		for (i=5; i<=NF; i++) {
			new = sprintf ("%s %s", UseRightLong[use_index], $1);
			UseRightLong[use_index] = new;
		}
		printf ("For %s will not use the default but %s\n", UseLeft[use_index], UseRightLong[use_index]) >> log_file;
		use_index++;
	} # endif
	next;
}

# Should never come here.
	{
	printf ("ERROR in line %d of local-defs, should never come here (setup-ld.awk)", line_number) >> log_file;
	}

END	{
	printf ("END processing for host %s reached\n", hostname) >> log_file;
	}
