/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */


#include <stdio.h>
#include "defs.h"
#include "pfd2tfm.h"

extern int Verbose;
extern char * ProgName;

/*
 * Report
 * ******
 * Report on the progress of the program,
 * if Verbose is not set to quiet.
 *
 * s: "report string".
 */
void
Report(s)
     char * s;
{
  if (Verbose == V_QUIET)
    return;
  fprintf (stderr, "====> %s\n", s);
  fflush (stderr);
}

/* This usage text should be up to date always to reflect all options being available. */
char *UsageText[] = {
  "[-q] (quiet)",
  "[-v] (verbose)",
  "[-m MapFileName]",
  "[-p Encoding vector directory]",
  "[-P pltotf search path]",
  NULL
};


/*
 * Usage
 * *****
 * Report how this program can be used and then exit.
 */
void
Usage()
{
  char **ptr;

  fprintf (stderr, "usage of %s (Version %s of %s) is as follows:\n", ProgName, VERSION, DATE);
  for (ptr = &UsageText[0]; *ptr != NULL; ptr++)
    fprintf (stderr, "\t%s\n", *ptr);
  fprintf (stderr, "\t\t\tfile[.dvi] ...\n");
  
  exit(0);
}
