/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

/*
 * This file contains some useful procedures for nybbling and
 * reading single bits from a file.
 */

#include <stdio.h>
#include <strings.h>

FILE * NybbleFile; /* Where we get nybbles from */

int NybbleFileByte; /* byte from the Nybble file */
int NybbleFileFlag; /* 0: get bits 4..7 from file,
		       1: get bits 0..3 (byte has been already read) */

/* Now the same to read single bits from a file: */
FILE * BitlingFile;
int BitlingFileByte;
int BitlingFileFlag; /* 7..0: get bits 7..0 */

/*
 * GetNybble
 * *********
 * Get a nybble from a file. This procedure can be used by one file only,
 * but that causes usually no problems. The initialization is
 * done by calling InitGetNybble().
 */
int
GetNybble()
{
  if (NybbleFileFlag == 0) {
    NybbleFileFlag = 1;
    NybbleFileByte = NoSignExtend (NybbleFile, 1);
    return ((NybbleFileByte >> 4) & 0xF);
  } else {
    NybbleFileFlag = 0;
    return (NybbleFileByte & 0xF);
  }
}

/*
 * GetBit
 * ******
 * Get a nybble from a file. This procedure can be used by one file only,
 * but that causes usually no problems. The initialization is
 * done by calling InitGetNybble().
 */
int
GetBit()
{
  int ret;

  if (BitlingFileFlag == 7)
    BitlingFileByte = NoSignExtend (BitlingFile, 1);
  ret = ((BitlingFileByte >> BitlingFileFlag) & 0x1);
  if (--BitlingFileFlag == -1)
    BitlingFileFlag = 7;
  return (ret);
}

/*
 * InitNybbling
 * ************
 * Initialize the nybbling business.
 *
 * fp: file pointer of file, from which we nybble
 */
InitNybbling(fp)
     FILE * fp;
{
  NybbleFile = fp;
  NybbleFileFlag = 0;
}

/*
 * InitBitling
 * ***********
 * Initialize the reading of single bits from a file.
 *
 * fp: file pointer of file, from which we bittle
 */
InitBitling(fp)
     FILE * fp;
{
  BitlingFile = fp;
  BitlingFileFlag = 7;
}
