/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

#include <stdio.h>
#if SYS_V == 1
#include <string.h>
#else
#include <strings.h>
#endif

#if SYS_V == 1
#define index  strchr
#define rindex strrchr
#endif

extern char *StrcpyAlloc();

/* The name of the program, but only the basename,
   not the full name, if a complete path is given. */
char *ProgNameS;

/* Store temporary files in this directory. */
char *TmpDirForFiles = NULL;

/*
 * Done
 * ****
 * Call this function to report that a program is done, it also exits.
 */
void
Done()
{
  fflush(stdout);
  fprintf (stderr, "%s: done\n", ProgNameS);
  exit (0);
}

/*
 * Fatal
 * *****
 * Report a fatal error, one error message.
 *
 * s: error message.
 */
void
Fatal(s)
     char *s;
{
  fflush (stdout);
  fprintf (stderr, "\n%s: fatal error.\n", ProgNameS);
  fprintf (stderr, "Error message: \"%s\"\n", s);
  exit (1);
}

/*
 * Fatal2
 * ******
 * Fatal error message with one argument in the error message.
 *
 * s1: a string containing one more argument (%s)
 * s2: the argument
 */
void
Fatal2(s1, s2)
     char *s1, *s2;
{
  fflush (stdout);
  fprintf (stderr, "\n%s: fatal error.\n", ProgNameS);
  fprintf (stderr, "Error message: \"");
  fprintf (stderr, s1, s2);
  fprintf (stderr, "\"\n");
  exit (1);
}

/*
 * Fatal3
 * ******
 * Fatal error message with two arguments in the error message.
 * s: main string
 * s1, s2: two arguments
 */
void
Fatal3(s, s1, s2)
     char *s, *s1, *s2;
{
  fflush (stdout);
  fprintf (stderr, "\n%s: fatal error.\n", ProgNameS);
  fprintf (stderr, "Error message: \"");
  fprintf (stderr, s, s1, s2);
  fprintf (stderr, "\"\n");
  exit (1);
}

/*
 * Fatal4
 * ******
 * Fatal error, three arguments in the message text.
 *
 * s: main string
 * s1, s2, s3: three arguments
 */
void
Fatal4(s, s1, s2, s3)
     char *s, *s1, *s2, *s3;
{
  fflush (stdout);
  fprintf (stderr, "\n%s: fatal error.\n", ProgNameS);
  fprintf (stderr, "Error message: \"");
  fprintf (stderr, s, s1, s2, s3);
  fprintf (stderr, "\"\n");
  exit (1);
}

/*
 * Fatal5
 * ******
 * Four arguments in the fatal error message text.
 *
 * s: main string
 * s1, s2, s3, s4: four arguments
 */
void
Fatal5(s, s1, s2, s3, s4)
     char *s, *s1, *s2, *s3, *s4;
{
  fflush (stdout);
  fprintf (stderr, "\n%s: fatal error.\n", ProgNameS);
  fprintf (stderr, "Error message: \"");
  fprintf (stderr, s, s1, s2, s3, s4);
  fprintf (stderr, "\"\n");
  exit (1);
}

/*
 * InitProgName
 * ************
 * Call this routine at the beginning with argv[0] to set up ProgNameS and
 * to set up the directory for all temporary files.
 *
 * argv_zero: the full program name.
 * tmp_dir:  directory for all temporary file names, e.g. "/tmp".
 */
void
InitProgName(argv_zero, tmp_dir)
     char *argv_zero;
     char *tmp_dir;
{
  char *cp;

  if ((cp=rindex(argv_zero, '/')) == NULL)
    ProgNameS = argv_zero;
  else
    ProgNameS = StrcpyAlloc (cp+1);
  if (Strlen(tmp_dir) == 0)
    Fatal ("InitProgName(): tmp_dir is empty.");

  TmpDirForFiles = StrcpyAlloc(tmp_dir);
}

/*
 * NotYet
 * ******
 * Print a message saying that some function is not implemented yet.
 * Generates fatal error.
 *
 * s: message identifying the function.
 */
void
NotYet(s)
     char *s;
{
  Fatal2 ("NotYet(): Function \"%s\" not yet implemented.", s);
}

/*
 * Warning
 * *******
 * A warning message procedure.
 * s: warning message
 */
void
Warning(s)
     char *s;
{
  fflush (stdout);
  fprintf (stderr, "%s: Warning\nWarning message: %s\n", ProgNameS, s);
  fflush (stderr);
}

/*
 * Warning2
 * ********
 * Another warning message procedure.
 *
 * s1: a string containing one more argument (%s).
 * s2: the argument
 */
void
Warning2 (s1, s2)
     char *s1, *s2;
{
  fflush (stdout);
  fprintf (stderr, "\n%s: Warning: ", ProgNameS);
  fprintf (stderr, s1, s2);
  fprintf (stderr, "\n");
  fflush (stderr);
}
