
/*
 * Copyright 1996 Juhana Kouhia (kouhia@nic.funet.fi)
 *
 * texpp -- TeX preprocessor
 * version 1.0
 *
 * TeXPP understand following macros:
 *   \texppbegintt -- begins verbatim \tt mode
 *   \texppendtt -- ends verbatim \tt mode
 *
 * Bug:
 *   The verbatim text can't contain printable string "\texppendtt" since
 *   the verbatim mode ends to that string
 *
 * Usages:
 *   cat in.tex | texpp > out.tex
 *   texpp in.tex > out.tex
 *   texpp in.tex out.tex
 */

#include <stdio.h>
#include <math.h>
#include <string.h>

#define CHARSSAVED 20  /* max length of a macro name */

FILE *in,*out;
char *cs;
int csn;

void ttverbatim()
{
  int c;
  int i;
  char ch;

  csn = 0;
  fprintf(out,"{\n");
  fprintf(out,"\\parindent=0pt\n");
  fprintf(out,"\\myttmode\n\n");
  while((c = getc(in)) != EOF) {
    for(i = 1; i < CHARSSAVED; i++) cs[i-1] = cs[i];
    cs[CHARSSAVED-1] = (char)c; 
    csn++;

    if ((csn >= 11) &&
	(strncmp(&(cs[CHARSSAVED-11]),"\\texppendtt",11) == 0)) { 
      /* if max compared word is longer than 11 chars, then
       * here we flush ..., CS-15, CS-14 out to stdout
       */
      fprintf(out,"}\n");
      return;
    }

    if (csn >= 11) { /* this value is length of max compared word */
      c = cs[CHARSSAVED-11];
      if (c == '\n') {
	fprintf(out,"\n\n");
	c = cs[CHARSSAVED-10];
	if (c == '\n') fprintf(out,"\\hbox{ }\n\n");
      } else if (c == '\\') {
	fprintf(out,"\\char'134");
      } else if (c == '{') {
	fprintf(out,"\\char'173");
      } else if (c == '}') {
	fprintf(out,"\\char'175");
      } else if (c == '_') {
	fprintf(out,"\\_");
      } else if (c == '^') {
	fprintf(out,"\\^{}");
      } else if (c == '$') {
	fprintf(out,"\\$");
      } else if (c == '%') {
	fprintf(out,"\\%%");
      } else if (c == '~') {
	fprintf(out,"\\~{}");
      } else if (c == '#') {
	fprintf(out,"\\#{}");
      } else if (c == '&') {
	fprintf(out,"\\&{}");
      } else if (c == ' ') {
	fprintf(out,"\\ ");
	/* c = getc(in);
	   if (c == '\n') fprintf(out,"%%");
	   ungetc(c,in);
	   */
      } else {
	fprintf(out,"%c",c);
      }
      csn--;
    }
  }
}


main(ac,av)
int ac;
char **av;
{
  int c,f;
  int i;

  cs = (char *)malloc(CHARSSAVED*sizeof(char));
  /* comparison is made with strncmp() and no nuls are needed */
  for(i = 0; i < CHARSSAVED; i++) cs[i] = '\0';
  csn = 0;

  if (ac == 1) {
    in = stdin;
    out = stdout;
  } else if (ac == 2) {
    if ((in = fopen(av[1],"r")) == NULL) {
      fprintf(stderr,"Could not open file %s for reading\n",av[1]);
      exit(-1);
    }
    out = stdout;
  } else if (ac == 3) {
    if ((in = fopen(av[1],"r")) == NULL) {
      fprintf(stderr,"Could not open file %s for reading\n",av[1]);
      exit(-1);
    }
    if ((out = fopen(av[2],"w")) == NULL) {
      fprintf(stderr,"Could not open file %s for writing\n",av[2]);
      exit(-1);
    }
  }


  while((c = getc(in)) != EOF) {
    for(i = 1; i < CHARSSAVED; i++) cs[i-1] = cs[i];
    cs[CHARSSAVED-1] = (char)c; 
    csn++;

    if ((csn >= 13) &&
	(strncmp(&(cs[CHARSSAVED-13]),"\\texppbegintt",13) == 0)) { 
      /* if max compared word is longer than 13 chars, then
       * here we flush ..., CS-15, CS-14 out to stdout
       */
      ttverbatim();
      csn = 0;
    }

    if (csn >= 13) { /* this value is length of max compared word */
      putc((int)cs[CHARSSAVED-13],out);
      csn--;
    }
  }
  for(i = CHARSSAVED-csn; i < CHARSSAVED; i++) putc((int)cs[i],out);
  fclose(out);
}
