/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.probsoln;

import com.dickimawbooks.texparserlib.DoubleParam;
import com.dickimawbooks.texparserlib.EndDeclaration;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.Param;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.Begin;
import com.dickimawbooks.texparserlib.latex.End;
import com.dickimawbooks.texparserlib.latex.probsoln.OnlyProblem;
import com.dickimawbooks.texparserlib.latex.probsoln.OnlySolution;
import com.dickimawbooks.texparserlib.latex.probsoln.Question;
import java.io.IOException;

public class ProbSolnData {
    private String name;
    private String dbLabel;
    private int numArgs = 0;
    private TeXObjectList contents;
    private TeXObjectList defArgs;

    public ProbSolnData(String string, TeXObjectList teXObjectList) {
        this(string, 0, null, teXObjectList, "default");
    }

    public ProbSolnData(String string, TeXObjectList teXObjectList, String string2) {
        this(string, 0, null, teXObjectList, string2);
    }

    public ProbSolnData(String string, int n, TeXObjectList teXObjectList, TeXObjectList teXObjectList2) {
        this(string, n, teXObjectList, teXObjectList2, "default");
    }

    public ProbSolnData(String string, int n, TeXObjectList teXObjectList, TeXObjectList teXObjectList2, String string2) {
        this.setName(string);
        this.numArgs = n;
        this.defArgs = teXObjectList;
        this.contents = teXObjectList2;
        this.dbLabel = string2;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setDataBaseLabel(String string) {
        this.dbLabel = string;
    }

    public String getDataBaseLabel() {
        return this.dbLabel;
    }

    public int getNumArgs() {
        return this.numArgs;
    }

    public TeXObjectList getDefaultArgs() {
        return this.defArgs;
    }

    public TeXObjectList getQuestion(TeXParser teXParser) throws IOException {
        TeXObject[] teXObjectArray = null;
        if (this.numArgs > 0) {
            teXObjectArray = new TeXObject[this.numArgs];
            for (int i = 0; i < this.numArgs; ++i) {
                teXObjectArray[i] = (TeXObject)((TeXObject)this.defArgs.get(i)).clone();
                if (!(teXObjectArray[i] instanceof Group) || teXObjectArray[i] instanceof MathGroup) continue;
                teXObjectArray[i] = ((Group)teXObjectArray[i]).toList();
            }
        }
        TeXObjectList teXObjectList = this.getData(teXParser, teXObjectArray);
        TeXObjectList teXObjectList2 = new TeXObjectList();
        this.getProblem(teXParser, teXObjectList, teXObjectList2, true, false);
        return teXObjectList2;
    }

    public TeXObjectList getAnswer(TeXParser teXParser, boolean bl) throws IOException {
        TeXObject[] teXObjectArray = null;
        if (this.numArgs > 0) {
            teXObjectArray = new TeXObject[this.numArgs];
            for (int i = 0; i < this.numArgs; ++i) {
                teXObjectArray[i] = (TeXObject)((TeXObject)this.defArgs.get(i)).clone();
                if (!(teXObjectArray[i] instanceof Group) || teXObjectArray[i] instanceof MathGroup) continue;
                teXObjectArray[i] = ((Group)teXObjectArray[i]).toList();
            }
        }
        TeXObjectList teXObjectList = (TeXObjectList)this.getData(teXParser, teXObjectArray).clone();
        TeXObjectList teXObjectList2 = new TeXObjectList();
        this.getProblem(teXParser, teXObjectList, teXObjectList2, false, bl);
        return teXObjectList2;
    }

    private void getProblem(TeXParser teXParser, TeXObjectList teXObjectList, TeXObjectList teXObjectList2, boolean bl, boolean bl2) throws IOException {
        this.getProblem(teXParser, teXObjectList, teXObjectList2, bl, bl2, false, false);
    }

    private void getProblem(TeXParser teXParser, TeXObjectList teXObjectList, TeXObjectList teXObjectList2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        boolean bl5 = bl3;
        boolean bl6 = bl4;
        TeXParserListener teXParserListener = teXParser.getListener();
        while (!teXObjectList.isEmpty()) {
            Group group;
            Object object;
            Object object2;
            boolean bl7;
            TeXObject teXObject = teXObjectList.pop();
            boolean bl8 = bl7 = bl && !bl6 || !bl && !bl5;
            if (teXObject instanceof TeXCsRef) {
                teXObject = teXParserListener.getControlSequence(((TeXCsRef)teXObject).getName());
            }
            if (teXObject instanceof Group && !(teXObject instanceof MathGroup)) {
                if (!bl7) continue;
                object2 = teXParserListener.createGroup();
                teXObjectList2.add((TeXObject)object2);
                this.getProblem(teXParser, (Group)teXObject, (TeXObjectList)object2, bl, bl2, bl5, bl6);
                continue;
            }
            if (teXObject instanceof TeXObjectList && !(teXObject instanceof Group)) {
                teXObjectList.addAll(0, (TeXObjectList)teXObject);
                continue;
            }
            if (teXObject instanceof OnlyProblem || teXObject instanceof Question) {
                bl5 = true;
                continue;
            }
            if (teXObject instanceof OnlySolution) {
                bl6 = true;
                continue;
            }
            if (teXObject instanceof EndDeclaration) {
                object2 = ((EndDeclaration)teXObject).getDeclaration(teXParser);
                if (object2 instanceof OnlyProblem || teXObject instanceof Question) {
                    bl5 = false;
                    continue;
                }
                if (object2 instanceof OnlySolution) {
                    bl6 = false;
                    continue;
                }
                if (!bl7) continue;
                teXObjectList2.add(teXObject);
                continue;
            }
            if (teXObject instanceof Begin) {
                object2 = teXObjectList.popArg(teXParser);
                if (object2 instanceof Expandable && (object = ((Expandable)object2).expandfully(teXParser, teXObjectList)) != null) {
                    object2 = object;
                }
                if (((String)(object = object2.toString(teXParser))).equals("onlyproblem") || ((String)object).equals("probsolnquestion")) {
                    bl5 = true;
                    continue;
                }
                if (((String)object).equals("onlysolution")) {
                    bl6 = true;
                    continue;
                }
                if (bl2 && ((String)object).equals("solution") || !bl7) continue;
                teXObjectList2.add(teXObject);
                group = teXParserListener.createGroup();
                teXObjectList2.add(group);
                if (object2 instanceof TeXObjectList) {
                    group.addAll((TeXObjectList)object2);
                    continue;
                }
                group.add((TeXObject)object2);
                continue;
            }
            if (teXObject instanceof End) {
                object2 = teXObjectList.popArg(teXParser);
                if (object2 instanceof Expandable && (object = ((Expandable)object2).expandfully(teXParser, teXObjectList)) != null) {
                    object2 = object;
                }
                if (((String)(object = object2.toString(teXParser))).equals("onlyproblem") || ((String)object).equals("probsolnquestion")) {
                    bl5 = false;
                    continue;
                }
                if (((String)object).equals("onlysolution")) {
                    bl6 = false;
                    continue;
                }
                if (bl2 && ((String)object).equals("solution") || !bl7) continue;
                teXObjectList2.add(teXObject);
                group = teXParserListener.createGroup();
                teXObjectList2.add(group);
                if (object2 instanceof TeXObjectList) {
                    group.addAll((TeXObjectList)object2);
                    continue;
                }
                group.add((TeXObject)object2);
                continue;
            }
            if (!bl7) continue;
            teXObjectList2.add(teXObject);
        }
    }

    public void process(TeXParser teXParser) throws IOException {
        TeXObject[] teXObjectArray = null;
        if (this.numArgs > 0) {
            teXObjectArray = new TeXObject[this.numArgs];
            for (int i = 0; i < this.numArgs; ++i) {
                teXObjectArray[i] = teXParser.popNextArg();
            }
        }
        this.getData(teXParser, teXObjectArray).process(teXParser);
    }

    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject[] teXObjectArray = null;
        if (this.numArgs > 0) {
            teXObjectArray = new TeXObject[this.numArgs];
            for (int i = 0; i < this.numArgs; ++i) {
                teXObjectArray[i] = teXObjectList.popArg(teXParser);
            }
        }
        this.getData(teXParser, teXObjectArray).process(teXParser, teXObjectList);
    }

    private TeXObjectList getData(TeXParser teXParser, TeXObject[] teXObjectArray) throws IOException {
        return this.getData(teXParser, teXObjectArray, this.contents);
    }

    private TeXObjectList getData(TeXParser teXParser, TeXObject[] teXObjectArray, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = teXObjectList.createList();
        for (TeXObject teXObject : teXObjectList) {
            if (teXObject instanceof Param) {
                int n = ((Param)teXObject).getDigit() - 1;
                if (teXObjectArray == null || n >= teXObjectArray.length) {
                    throw new TeXSyntaxException(teXParser, "tex.error.syntax", teXObject.toString(teXParser));
                }
                teXObjectList2.add((TeXObject)teXObjectArray[n].clone());
                continue;
            }
            if (teXObject instanceof DoubleParam) {
                teXObjectList2.add((TeXObject)((DoubleParam)teXObject).next().clone());
                continue;
            }
            if (teXObject instanceof TeXObjectList) {
                teXObjectList2.add(this.getData(teXParser, teXObjectArray, (TeXObjectList)teXObject));
                continue;
            }
            teXObjectList2.add((TeXObject)teXObject.clone());
        }
        return teXObjectList2;
    }

    public String toString() {
        return String.format("ProbSolnData[name=%s,db=%s,args=(n=%d,default=%s),contents=%s]", this.name, this.dbLabel, this.numArgs, this.defArgs, this.contents);
    }
}

