/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.Overwrite;
import com.dickimawbooks.texparserlib.latex.glossaries.AbstractGlsCommand;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossariesSty;
import java.io.IOException;

public class NewAbbreviationStyle
extends AbstractGlsCommand {
    protected Overwrite overwrite;

    public NewAbbreviationStyle(GlossariesSty glossariesSty) {
        this("newabbreviationstyle", Overwrite.FORBID, glossariesSty);
    }

    public NewAbbreviationStyle(String string, Overwrite overwrite, GlossariesSty glossariesSty) {
        super(string, glossariesSty);
        this.overwrite = overwrite;
    }

    @Override
    public Object clone() {
        return new NewAbbreviationStyle(this.getName(), this.getOverwrite(), this.getSty());
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        String string = this.popLabelString(teXParser, teXObjectList);
        TeXObject teXObject = this.popArg(teXParser, teXObjectList);
        TeXObject teXObject2 = this.popArg(teXParser, teXObjectList);
        ControlSequence controlSequence = teXParser.getControlSequence("@glsabbrv@dispstyle@setup@" + string);
        if (controlSequence != null) {
            switch (this.overwrite) {
                case SKIP: {
                    return;
                }
                case FORBID: {
                    throw new LaTeXSyntaxException(teXParser, "glossaries.abbreviation.style.defined", string);
                }
            }
        }
        TeXObjectList teXObjectList2 = teXParser.getListener().createStack();
        teXObjectList2.add(new TeXCsRef("renewcommand"));
        teXObjectList2.add(new TeXCsRef("GlsXtrPostNewAbbreviation"));
        teXObjectList2.add(teXParser.getListener().createGroup());
        teXObjectList2.add(teXObject, true);
        teXParser.putControlSequence(true, new GenericCommand(true, "@glsabbrv@dispstyle@setup@" + string, null, teXObjectList2));
        teXObjectList2 = teXParser.getListener().createStack();
        teXObjectList2.add(new TeXCsRef("renewcommand"));
        teXObjectList2.add(new TeXCsRef("glsxtrinlinefullformat"));
        teXObjectList2.add(new TeXCsRef("glsxtrfullformat"));
        teXObjectList2.add(new TeXCsRef("renewcommand"));
        teXObjectList2.add(new TeXCsRef("Glsxtrinlinefullformat"));
        teXObjectList2.add(new TeXCsRef("Glsxtrfullformat"));
        teXObjectList2.add(new TeXCsRef("renewcommand"));
        teXObjectList2.add(new TeXCsRef("GLSxtrinlinefullformat"));
        teXObjectList2.add(new TeXCsRef("GLSxtrfullformat"));
        teXObjectList2.add(new TeXCsRef("renewcommand"));
        teXObjectList2.add(new TeXCsRef("glsxtrinlinefullplformat"));
        teXObjectList2.add(new TeXCsRef("glsxtrfullplformat"));
        teXObjectList2.add(new TeXCsRef("renewcommand"));
        teXObjectList2.add(new TeXCsRef("Glsxtrinlinefullplformat"));
        teXObjectList2.add(new TeXCsRef("Glsxtrfullplformat"));
        teXObjectList2.add(new TeXCsRef("renewcommand"));
        teXObjectList2.add(new TeXCsRef("GLSxtrinlinefullplformat"));
        teXObjectList2.add(new TeXCsRef("GLSxtrfullplformat"));
        teXObjectList2.add(new TeXCsRef("let"));
        teXObjectList2.add(new TeXCsRef("glsxtrsubsequentfmt"));
        teXObjectList2.add(new TeXCsRef("glsxtrdefaultsubsequentfmt"));
        teXObjectList2.add(new TeXCsRef("let"));
        teXObjectList2.add(new TeXCsRef("Glsxtrsubsequentfmt"));
        teXObjectList2.add(new TeXCsRef("Glsxtrdefaultsubsequentfmt"));
        teXObjectList2.add(new TeXCsRef("let"));
        teXObjectList2.add(new TeXCsRef("GLSxtrsubsequentfmt"));
        teXObjectList2.add(new TeXCsRef("GLSxtrdefaultsubsequentfmt"));
        teXObjectList2.add(new TeXCsRef("let"));
        teXObjectList2.add(new TeXCsRef("glsxtrsubsequentplfmt"));
        teXObjectList2.add(new TeXCsRef("glsxtrdefaultsubsequentplfmt"));
        teXObjectList2.add(new TeXCsRef("let"));
        teXObjectList2.add(new TeXCsRef("Glsxtrsubsequentplfmt"));
        teXObjectList2.add(new TeXCsRef("Glsxtrdefaultsubsequentplfmt"));
        teXObjectList2.add(new TeXCsRef("let"));
        teXObjectList2.add(new TeXCsRef("GLSxtrsubsequentplfmt"));
        teXObjectList2.add(new TeXCsRef("GLSxtrdefaultsubsequentplfmt"));
        teXObjectList2.add(teXObject2, true);
        teXParser.putControlSequence(true, new GenericCommand(true, "@glsabbrv@dispstyle@fmts@" + string, null, teXObjectList2));
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    public Overwrite getOverwrite() {
        return this.overwrite;
    }
}

