/***** Autogenerated from runmath.in; changes will be overwritten *****/

#line 1 "runtimebase.in"
/*****
 * runtimebase.in
 * Andy Hammerlindl  2009/07/28
 *
 * Common declarations needed for all code-generating .in files.
 *
 *****/


#line 1 "runmath.in"
/*****
 * runmath.in
 *
 * Runtime functions for math operations.
 *
 *****/

#line 1 "runtimebase.in"
#include "stack.h"
#include "types.h"
#include "builtin.h"
#include "entry.h"
#include "errormsg.h"
#include "array.h"
#include "triple.h"
#include "callable.h"
#include "opsymbols.h"

using vm::stack;
using vm::error;
using vm::array;
using vm::read;
using vm::callable;
using types::formal;
using types::function;
using camp::triple;

#define PRIMITIVE(name,Name,asyName) using types::prim##Name;
#include <primitives.h>
#undef PRIMITIVE

typedef double real;

void unused(void *);

namespace run {
array *copyArray(array *a);
array *copyArray2(array *a);
array *copyArray3(array *a);

double *copyTripleArray2Components(array *a, size_t &N,
                                   GCPlacement placement=NoGC);
triple *copyTripleArray2C(array *a, size_t &N,
                          GCPlacement placement=NoGC);
}

function *realRealFunction();

#define CURRENTPEN processData().currentpen

#line 12 "runmath.in"
#include <inttypes.h>

#include "mathop.h"
#include "path.h"

#ifdef __CYGWIN__
extern "C" double yn(int, double);
extern "C" double jn(int, double);
extern "C" int __signgam;
#define signgam __signgam
#endif

using namespace camp;

typedef array realarray;
typedef array pairarray;

using types::realArray;
using types::pairArray;

using run::integeroverflow;
using vm::frame;

const char *invalidargument="invalid argument";

extern uint32_t CLZ(uint32_t a);

inline unsigned intbits() {
  static unsigned count=0;
  if(count > 0) return count;
  while((1ULL << count) < Int_MAX)
    ++count;
  ++count;
  return count;
}

static const unsigned char BitReverseTable8[256]=
{
#define R2(n)     n,    n+2*64,    n+1*64,    n+3*64
#define R4(n) R2(n),R2(n+2*16),R2(n+1*16),R2(n+3*16)
#define R6(n) R4(n),R4(n+2*4 ),R4(n+1*4 ),R4(n+3*4 )
R6(0),R6(2),R6(1),R6(3)
};
#undef R2
#undef R4
#undef R6

unsigned long long bitreverse8(unsigned long long a)
{
  return
    (unsigned long long) BitReverseTable8[a]; 
}

unsigned long long bitreverse16(unsigned long long a)
{
  return
    ((unsigned long long) BitReverseTable8[a & 0xff] << 8) | 
    ((unsigned long long) BitReverseTable8[(a >> 8)]);
}

unsigned long long bitreverse24(unsigned long long a)
{
  return
    ((unsigned long long) BitReverseTable8[a & 0xff] << 16) | 
    ((unsigned long long) BitReverseTable8[(a >> 8) & 0xff] << 8) | 
    ((unsigned long long) BitReverseTable8[(a >> 16)]);
}

unsigned long long bitreverse32(unsigned long long a)
{
  return
    ((unsigned long long) BitReverseTable8[a & 0xff] << 24) | 
    ((unsigned long long) BitReverseTable8[(a >> 8) & 0xff] << 16) | 
    ((unsigned long long) BitReverseTable8[(a >> 16) & 0xff] << 8) |
    ((unsigned long long) BitReverseTable8[(a >> 24)]);
}

unsigned long long bitreverse40(unsigned long long a)
{
  return
    ((unsigned long long) BitReverseTable8[a & 0xff] << 32) | 
    ((unsigned long long) BitReverseTable8[(a >> 8) & 0xff] << 24) | 
    ((unsigned long long) BitReverseTable8[(a >> 16) & 0xff] << 16) |
    ((unsigned long long) BitReverseTable8[(a >> 24) & 0xff] << 8) |
    ((unsigned long long) BitReverseTable8[(a >> 32)]);
}

unsigned long long bitreverse48(unsigned long long a)
{
  return
    ((unsigned long long) BitReverseTable8[a & 0xff] << 40) | 
    ((unsigned long long) BitReverseTable8[(a >> 8) & 0xff] << 32) | 
    ((unsigned long long) BitReverseTable8[(a >> 16) & 0xff] << 24) |
    ((unsigned long long) BitReverseTable8[(a >> 24) & 0xff] << 16) |
    ((unsigned long long) BitReverseTable8[(a >> 32) & 0xff] << 8) |
    ((unsigned long long) BitReverseTable8[(a >> 40)]);
}

unsigned long long bitreverse56(unsigned long long a)
{
  return
    ((unsigned long long) BitReverseTable8[a & 0xff] << 48) | 
    ((unsigned long long) BitReverseTable8[(a >> 8) & 0xff] << 40) | 
    ((unsigned long long) BitReverseTable8[(a >> 16) & 0xff] << 32) |
    ((unsigned long long) BitReverseTable8[(a >> 24) & 0xff] << 24) |
    ((unsigned long long) BitReverseTable8[(a >> 32) & 0xff] << 16) |
    ((unsigned long long) BitReverseTable8[(a >> 40) & 0xff] << 8) | 
    ((unsigned long long) BitReverseTable8[(a >> 48)]);
}

unsigned long long bitreverse64(unsigned long long a)
{
  return
    ((unsigned long long) BitReverseTable8[a & 0xff] << 56) | 
    ((unsigned long long) BitReverseTable8[(a >> 8) & 0xff] << 48) | 
    ((unsigned long long) BitReverseTable8[(a >> 16) & 0xff] << 40) |
    ((unsigned long long) BitReverseTable8[(a >> 24) & 0xff] << 32) |
    ((unsigned long long) BitReverseTable8[(a >> 32) & 0xff] << 24) |
    ((unsigned long long) BitReverseTable8[(a >> 40) & 0xff] << 16) | 
    ((unsigned long long) BitReverseTable8[(a >> 48) & 0xff] << 8) |
    ((unsigned long long) BitReverseTable8[(a >> 56)]);
}

#ifndef HAVE_POPCOUNT
// https://graphics.stanford.edu/~seander/bithacks.html#CountBitsSetParallel
#define T unsignedInt
Int popcount(T a)
{
  a=a-((a >> 1) & (T)~(T)0/3);
  a=(a & (T)~(T)0/15*3)+((a >> 2) & (T)~(T)0/15*3);
  a=(a+(a >> 4)) & (T)~(T)0/255*15;
return (T)(a*((T)~(T)0/255)) >> (sizeof(T)-1)*CHAR_BIT;
}
#undef T
#endif

// Return the factorial of a non-negative integer using a lookup table.
Int factorial(Int n)
{
  static Int *table;
  static Int size=0;
  if(size == 0) {
    Int f=1;
    size=2;
    while(f <= Int_MAX/size)
      f *= (size++);
    table=new Int[size];
    table[0]=f=1;
    for(Int i=1; i < size; ++i) {
      f *= i;
      table[i]=f;
    }
  }
  if(n >= size) integeroverflow(0);
  return table[n];
}

static inline Int Round(double x) 
{
  return Int(x+((x >= 0) ? 0.5 : -0.5));
}

inline Int sgn(double x) 
{
  return (x > 0.0 ? 1 : (x < 0.0 ? -1 : 0));
}

static bool initializeRandom=true;

void Srand(Int seed)
{ 
  initializeRandom=false;
#if defined(MIKTEX)
  // MIKTEX-TODO
  srand(unsignedIntcast(seed));
#else
  const int n=256;
  static char state[n];
  initstate(intcast(seed),state,n);
#endif
}  

// Autogenerated routines:



#ifndef NOSYM
#include "runmath.symbols.h"

#endif
namespace run {
#line 192 "runmath.in"
// real ^(real x, Int y);
void gen_runmath0(stack *Stack)
{
  Int y=vm::pop<Int>(Stack);
  real x=vm::pop<real>(Stack);
#line 193 "runmath.in"
  {Stack->push<real>(pow(x,y)); return;}
}

#line 197 "runmath.in"
// pair ^(pair z, Int y);
void gen_runmath1(stack *Stack)
{
  Int y=vm::pop<Int>(Stack);
  pair z=vm::pop<pair>(Stack);
#line 198 "runmath.in"
  {Stack->push<pair>(pow(z,y)); return;}
}

#line 202 "runmath.in"
// Int quotient(Int x, Int y);
void gen_runmath2(stack *Stack)
{
  Int y=vm::pop<Int>(Stack);
  Int x=vm::pop<Int>(Stack);
#line 203 "runmath.in" 
  {Stack->push<Int>(quotient<Int>()(x,y)); return;}
}

#line 207 "runmath.in"
// Int abs(Int x);
void gen_runmath3(stack *Stack)
{
  Int x=vm::pop<Int>(Stack);
#line 208 "runmath.in" 
  {Stack->push<Int>(Abs(x)); return;}
}

#line 212 "runmath.in"
// Int sgn(real x);
void gen_runmath4(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 213 "runmath.in" 
  {Stack->push<Int>(sgn(x)); return;}
}

#line 217 "runmath.in"
// Int rand();
void gen_runmath5(stack *Stack)
{
#line 218 "runmath.in" 
  if(initializeRandom)
    Srand(1);
#if defined(MIKTEX_WINDOWS)
  // MIKTEX-TODO
  {Stack->push<Int>(rand()); return; }
#else
  {Stack->push<Int>(random()); return;}
#endif
}

#line 224 "runmath.in"
// void srand(Int seed);
void gen_runmath6(stack *Stack)
{
  Int seed=vm::pop<Int>(Stack);
#line 225 "runmath.in" 
  Srand(seed);
}

// a random number uniformly distributed in the interval [0,1]
#line 230 "runmath.in"
// real unitrand();
void gen_runmath7(stack *Stack)
{
#line 231 "runmath.in"                         
#if defined(MIKTEX_WINDOWS)
  // MIKTEX-TODO
  {Stack->push<real>(((real)rand()) / RAND_MAX); return; }
#else
  {Stack->push<real>(((real) random())/RANDOM_MAX); return;}
#endif
}

#line 235 "runmath.in"
// Int ceil(real x);
void gen_runmath8(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 236 "runmath.in" 
  {Stack->push<Int>(Intcast(ceil(x))); return;}
}

#line 240 "runmath.in"
// Int floor(real x);
void gen_runmath9(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 241 "runmath.in" 
  {Stack->push<Int>(Intcast(floor(x))); return;}
}

#line 245 "runmath.in"
// Int round(real x);
void gen_runmath10(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 246 "runmath.in" 
  if(validInt(x)) {Stack->push<Int>(Round(x)); return;}
  integeroverflow(0);
}

#line 251 "runmath.in"
// Int Ceil(real x);
void gen_runmath11(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 252 "runmath.in" 
  {Stack->push<Int>(Ceil(x)); return;}
}

#line 256 "runmath.in"
// Int Floor(real x);
void gen_runmath12(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 257 "runmath.in" 
  {Stack->push<Int>(Floor(x)); return;}
}

#line 261 "runmath.in"
// Int Round(real x);
void gen_runmath13(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 262 "runmath.in" 
  {Stack->push<Int>(Round(Intcap(x))); return;}
}

#line 266 "runmath.in"
// real fmod(real x, real y);
void gen_runmath14(stack *Stack)
{
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 267 "runmath.in"
  if (y == 0.0) dividebyzero();
  {Stack->push<real>(fmod(x,y)); return;}
}

#line 272 "runmath.in"
// real atan2(real y, real x);
void gen_runmath15(stack *Stack)
{
  real x=vm::pop<real>(Stack);
  real y=vm::pop<real>(Stack);
#line 273 "runmath.in" 
  {Stack->push<real>(atan2(y,x)); return;}
}

#line 277 "runmath.in"
// real hypot(real x, real y);
void gen_runmath16(stack *Stack)
{
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 278 "runmath.in" 
  {Stack->push<real>(hypot(x,y)); return;}
}

#line 282 "runmath.in"
// real remainder(real x, real y);
void gen_runmath17(stack *Stack)
{
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 283 "runmath.in" 
  {Stack->push<real>(remainder(x,y)); return;}
}

#line 287 "runmath.in"
// real Jn(Int n, real x);
void gen_runmath18(stack *Stack)
{
  real x=vm::pop<real>(Stack);
  Int n=vm::pop<Int>(Stack);
#line 288 "runmath.in"
  {Stack->push<real>(jn(n,x)); return;}
}

#line 292 "runmath.in"
// real Yn(Int n, real x);
void gen_runmath19(stack *Stack)
{
  real x=vm::pop<real>(Stack);
  Int n=vm::pop<Int>(Stack);
#line 293 "runmath.in"
  {Stack->push<real>(yn(n,x)); return;}
}

#line 297 "runmath.in"
// real erf(real x);
void gen_runmath20(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 298 "runmath.in"
  {Stack->push<real>(erf(x)); return;}
}

#line 302 "runmath.in"
// real erfc(real x);
void gen_runmath21(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 303 "runmath.in"
  {Stack->push<real>(erfc(x)); return;}
}

#line 307 "runmath.in"
// Int factorial(Int n);
void gen_runmath22(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
#line 308 "runmath.in"
  if(n < 0) error(invalidargument);
  {Stack->push<Int>(factorial(n)); return;}
}

#line 312 "runmath.in"
// Int choose(Int n, Int k);
void gen_runmath23(stack *Stack)
{
  Int k=vm::pop<Int>(Stack);
  Int n=vm::pop<Int>(Stack);
#line 313 "runmath.in"
  if(n < 0 || k < 0 || k > n) error(invalidargument);
  Int f=1;
  Int r=n-k;
  for(Int i=n; i > r; --i) {
    if(f > Int_MAX/i) integeroverflow(0);
    f=(f*i)/(n-i+1);
  }
  {Stack->push<Int>(f); return;}
}

#line 323 "runmath.in"
// real gamma(real x);
void gen_runmath24(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 324 "runmath.in"
#ifdef HAVE_TGAMMA
  {Stack->push<real>(tgamma(x)); return;}
#else
  real lg = lgamma(x);
  {Stack->push<real>(signgam*exp(lg)); return;}
#endif
}

#line 333 "runmath.in"
// realarray* quadraticroots(real a, real b, real c);
void gen_runmath25(stack *Stack)
{
  real c=vm::pop<real>(Stack);
  real b=vm::pop<real>(Stack);
  real a=vm::pop<real>(Stack);
#line 334 "runmath.in"
  quadraticroots q(a,b,c);
  array *roots=new array(q.roots);
  if(q.roots >= 1) (*roots)[0]=q.t1;
  if(q.roots == 2) (*roots)[1]=q.t2;
  {Stack->push<realarray*>(roots); return;}
}

#line 342 "runmath.in"
// pairarray* quadraticroots(explicit pair a, explicit pair b, explicit pair c);
void gen_runmath26(stack *Stack)
{
  pair c=vm::pop<pair>(Stack);
  pair b=vm::pop<pair>(Stack);
  pair a=vm::pop<pair>(Stack);
#line 343 "runmath.in"
  Quadraticroots q(a,b,c);
  array *roots=new array(q.roots);
  if(q.roots >= 1) (*roots)[0]=q.z1;
  if(q.roots == 2) (*roots)[1]=q.z2;
  {Stack->push<pairarray*>(roots); return;}
}

#line 351 "runmath.in"
// realarray* cubicroots(real a, real b, real c, real d);
void gen_runmath27(stack *Stack)
{
  real d=vm::pop<real>(Stack);
  real c=vm::pop<real>(Stack);
  real b=vm::pop<real>(Stack);
  real a=vm::pop<real>(Stack);
#line 352 "runmath.in"
  cubicroots q(a,b,c,d);
  array *roots=new array(q.roots);
  if(q.roots >= 1) (*roots)[0]=q.t1;
  if(q.roots >= 2) (*roots)[1]=q.t2;
  if(q.roots == 3) (*roots)[2]=q.t3;
  {Stack->push<realarray*>(roots); return;}
}


// Logical operations
#line 363 "runmath.in"
// bool !(bool b);
void gen_runmath28(stack *Stack)
{
  bool b=vm::pop<bool>(Stack);
#line 364 "runmath.in"
  {Stack->push<bool>(!b); return;}
}

#line 369 "runmath.in"
void boolMemEq(stack *Stack)
{
  frame * b=vm::pop<frame *>(Stack);
  frame * a=vm::pop<frame *>(Stack);
#line 370 "runmath.in"
  {Stack->push<bool>(a == b); return;}
}

#line 374 "runmath.in"
void boolMemNeq(stack *Stack)
{
  frame * b=vm::pop<frame *>(Stack);
  frame * a=vm::pop<frame *>(Stack);
#line 375 "runmath.in"
  {Stack->push<bool>(a != b); return;}
}

#line 379 "runmath.in"
void boolFuncEq(stack *Stack)
{
  callable * b=vm::pop<callable *>(Stack);
  callable * a=vm::pop<callable *>(Stack);
#line 380 "runmath.in"
  {Stack->push<bool>(a->compare(b)); return;}
}

#line 384 "runmath.in"
void boolFuncNeq(stack *Stack)
{
  callable * b=vm::pop<callable *>(Stack);
  callable * a=vm::pop<callable *>(Stack);
#line 385 "runmath.in"
  {Stack->push<bool>(!(a->compare(b))); return;}
}


// Bit operations
#line 391 "runmath.in"
// Int AND(Int a, Int b);
void gen_runmath33(stack *Stack)
{
  Int b=vm::pop<Int>(Stack);
  Int a=vm::pop<Int>(Stack);
#line 392 "runmath.in"
  {Stack->push<Int>(a & b); return;}
}

#line 397 "runmath.in"
// Int OR(Int a, Int b);
void gen_runmath34(stack *Stack)
{
  Int b=vm::pop<Int>(Stack);
  Int a=vm::pop<Int>(Stack);
#line 398 "runmath.in"
  {Stack->push<Int>(a | b); return;}
}

#line 402 "runmath.in"
// Int XOR(Int a, Int b);
void gen_runmath35(stack *Stack)
{
  Int b=vm::pop<Int>(Stack);
  Int a=vm::pop<Int>(Stack);
#line 403 "runmath.in"
  {Stack->push<Int>(a ^ b); return;}
}

#line 407 "runmath.in"
// Int NOT(Int a);
void gen_runmath36(stack *Stack)
{
  Int a=vm::pop<Int>(Stack);
#line 408 "runmath.in"
  {Stack->push<Int>(~a); return;}
}

#line 412 "runmath.in"
// Int CLZ(Int a);
void gen_runmath37(stack *Stack)
{
  Int a=vm::pop<Int>(Stack);
#line 413 "runmath.in"
  if((unsigned long long) a > 0xFFFFFFFF)
    {Stack->push<Int>(CLZ((uint32_t) ((unsigned long long) a >> 32))); return;}
  else {
    int bits=intbits();
    if(a != 0) {Stack->push<Int>(bits-32+CLZ((uint32_t) a)); return;}
    {Stack->push<Int>(bits); return;}
  }
}

#line 423 "runmath.in"
// Int popcount(Int a);
void gen_runmath38(stack *Stack)
{
  Int a=vm::pop<Int>(Stack);
#line 424 "runmath.in"
  {Stack->push<Int>(popcount(a)); return;}
}

#line 428 "runmath.in"
// Int CTZ(Int a);
void gen_runmath39(stack *Stack)
{
  Int a=vm::pop<Int>(Stack);
#line 429 "runmath.in"
  {Stack->push<Int>(popcount((a&-a)-1)); return;}
}

// bitreverse a within a word of length bits.
#line 434 "runmath.in"
// Int bitreverse(Int a, Int bits);
void gen_runmath40(stack *Stack)
{
  Int bits=vm::pop<Int>(Stack);
  Int a=vm::pop<Int>(Stack);
#line 435 "runmath.in"
  typedef unsigned long long Bitreverse(unsigned long long a);
  static Bitreverse *B[]={bitreverse8,bitreverse16,bitreverse24,bitreverse32,
                     bitreverse40,bitreverse48,bitreverse56,bitreverse64};
  int maxbits=intbits()-1; // Drop sign bit
#if Int_MAX2 >= 0x7fffffffffffffffLL
  --maxbits;               // Drop extra bit for reserved values
#endif  
  if(bits <= 0 || bits > maxbits || a < 0 ||
     (unsigned long long) a >= (1ULL << bits))
    {Stack->push<Int>(-1); return;}
  unsigned int bytes=(bits+7)/8;
  {Stack->push<Int>(B[bytes-1]((unsigned long long) a) >> (8*bytes-bits)); return;}
}

} // namespace run

namespace trans {

void gen_runmath_venv(venv &ve)
{
#line 192 "runmath.in"
  addFunc(ve, run::gen_runmath0, primReal(), SYM_CARET, formal(primReal(), SYM(x), false, false), formal(primInt(), SYM(y), false, false));
#line 197 "runmath.in"
  addFunc(ve, run::gen_runmath1, primPair(), SYM_CARET, formal(primPair(), SYM(z), false, false), formal(primInt(), SYM(y), false, false));
#line 202 "runmath.in"
  addFunc(ve, run::gen_runmath2, primInt(), SYM(quotient), formal(primInt(), SYM(x), false, false), formal(primInt(), SYM(y), false, false));
#line 207 "runmath.in"
  addFunc(ve, run::gen_runmath3, primInt(), SYM(abs), formal(primInt(), SYM(x), false, false));
#line 212 "runmath.in"
  addFunc(ve, run::gen_runmath4, primInt(), SYM(sgn), formal(primReal(), SYM(x), false, false));
#line 217 "runmath.in"
  addFunc(ve, run::gen_runmath5, primInt(), SYM(rand));
#line 224 "runmath.in"
  addFunc(ve, run::gen_runmath6, primVoid(), SYM(srand), formal(primInt(), SYM(seed), false, false));
#line 229 "runmath.in"
  addFunc(ve, run::gen_runmath7, primReal(), SYM(unitrand));
#line 235 "runmath.in"
  addFunc(ve, run::gen_runmath8, primInt(), SYM(ceil), formal(primReal(), SYM(x), false, false));
#line 240 "runmath.in"
  addFunc(ve, run::gen_runmath9, primInt(), SYM(floor), formal(primReal(), SYM(x), false, false));
#line 245 "runmath.in"
  addFunc(ve, run::gen_runmath10, primInt(), SYM(round), formal(primReal(), SYM(x), false, false));
#line 251 "runmath.in"
  addFunc(ve, run::gen_runmath11, primInt(), SYM(Ceil), formal(primReal(), SYM(x), false, false));
#line 256 "runmath.in"
  addFunc(ve, run::gen_runmath12, primInt(), SYM(Floor), formal(primReal(), SYM(x), false, false));
#line 261 "runmath.in"
  addFunc(ve, run::gen_runmath13, primInt(), SYM(Round), formal(primReal(), SYM(x), false, false));
#line 266 "runmath.in"
  addFunc(ve, run::gen_runmath14, primReal(), SYM(fmod), formal(primReal(), SYM(x), false, false), formal(primReal(), SYM(y), false, false));
#line 272 "runmath.in"
  addFunc(ve, run::gen_runmath15, primReal(), SYM(atan2), formal(primReal(), SYM(y), false, false), formal(primReal(), SYM(x), false, false));
#line 277 "runmath.in"
  addFunc(ve, run::gen_runmath16, primReal(), SYM(hypot), formal(primReal(), SYM(x), false, false), formal(primReal(), SYM(y), false, false));
#line 282 "runmath.in"
  addFunc(ve, run::gen_runmath17, primReal(), SYM(remainder), formal(primReal(), SYM(x), false, false), formal(primReal(), SYM(y), false, false));
#line 287 "runmath.in"
  addFunc(ve, run::gen_runmath18, primReal(), SYM(Jn), formal(primInt(), SYM(n), false, false), formal(primReal(), SYM(x), false, false));
#line 292 "runmath.in"
  addFunc(ve, run::gen_runmath19, primReal(), SYM(Yn), formal(primInt(), SYM(n), false, false), formal(primReal(), SYM(x), false, false));
#line 297 "runmath.in"
  addFunc(ve, run::gen_runmath20, primReal(), SYM(erf), formal(primReal(), SYM(x), false, false));
#line 302 "runmath.in"
  addFunc(ve, run::gen_runmath21, primReal(), SYM(erfc), formal(primReal(), SYM(x), false, false));
#line 307 "runmath.in"
  addFunc(ve, run::gen_runmath22, primInt(), SYM(factorial), formal(primInt(), SYM(n), false, false));
#line 312 "runmath.in"
  addFunc(ve, run::gen_runmath23, primInt(), SYM(choose), formal(primInt(), SYM(n), false, false), formal(primInt(), SYM(k), false, false));
#line 323 "runmath.in"
  addFunc(ve, run::gen_runmath24, primReal(), SYM(gamma), formal(primReal(), SYM(x), false, false));
#line 333 "runmath.in"
  addFunc(ve, run::gen_runmath25, realArray(), SYM(quadraticroots), formal(primReal(), SYM(a), false, false), formal(primReal(), SYM(b), false, false), formal(primReal(), SYM(c), false, false));
#line 342 "runmath.in"
  addFunc(ve, run::gen_runmath26, pairArray(), SYM(quadraticroots), formal(primPair(), SYM(a), false, true), formal(primPair(), SYM(b), false, true), formal(primPair(), SYM(c), false, true));
#line 351 "runmath.in"
  addFunc(ve, run::gen_runmath27, realArray(), SYM(cubicroots), formal(primReal(), SYM(a), false, false), formal(primReal(), SYM(b), false, false), formal(primReal(), SYM(c), false, false), formal(primReal(), SYM(d), false, false));
#line 361 "runmath.in"
  addFunc(ve, run::gen_runmath28, primBoolean(), SYM_LOGNOT, formal(primBoolean(), SYM(b), false, false));
#line 369 "runmath.in"
  REGISTER_BLTIN(run::boolMemEq,"boolMemEq");
#line 374 "runmath.in"
  REGISTER_BLTIN(run::boolMemNeq,"boolMemNeq");
#line 379 "runmath.in"
  REGISTER_BLTIN(run::boolFuncEq,"boolFuncEq");
#line 384 "runmath.in"
  REGISTER_BLTIN(run::boolFuncNeq,"boolFuncNeq");
#line 389 "runmath.in"
  addFunc(ve, run::gen_runmath33, primInt(), SYM(AND), formal(primInt(), SYM(a), false, false), formal(primInt(), SYM(b), false, false));
#line 397 "runmath.in"
  addFunc(ve, run::gen_runmath34, primInt(), SYM(OR), formal(primInt(), SYM(a), false, false), formal(primInt(), SYM(b), false, false));
#line 402 "runmath.in"
  addFunc(ve, run::gen_runmath35, primInt(), SYM(XOR), formal(primInt(), SYM(a), false, false), formal(primInt(), SYM(b), false, false));
#line 407 "runmath.in"
  addFunc(ve, run::gen_runmath36, primInt(), SYM(NOT), formal(primInt(), SYM(a), false, false));
#line 412 "runmath.in"
  addFunc(ve, run::gen_runmath37, primInt(), SYM(CLZ), formal(primInt(), SYM(a), false, false));
#line 423 "runmath.in"
  addFunc(ve, run::gen_runmath38, primInt(), SYM(popcount), formal(primInt(), SYM(a), false, false));
#line 428 "runmath.in"
  addFunc(ve, run::gen_runmath39, primInt(), SYM(CTZ), formal(primInt(), SYM(a), false, false));
#line 433 "runmath.in"
  addFunc(ve, run::gen_runmath40, primInt(), SYM(bitreverse), formal(primInt(), SYM(a), false, false), formal(primInt(), SYM(bits), false, false));
}

} // namespace trans
