/* Show that given exe or dll are 32bit or 64bit */

#include <stdio.h>
#include <string.h>
#include <windows.h>
#include <winnt.h>

int
main(int argc, char **argv)
{
    int j;
    FILE *fp;
    char *p;
    IMAGE_DOS_HEADER image_dos_header;
    IMAGE_FILE_HEADER image_file_header;
    WORD ww;

    if (argc == 1 || (argc == 2 && (!strncmp(argv[1], "-h", 2) ||
        !strncmp(argv[1], "--h", 3)))) {
       printf("Show that given exe or dll are 32bit or 64bit\n");
       printf("Usage: is64bit a.exe b.dll ...\n");
       return 0;
    }

    for (j = 1 ; j < argc; j++) {
       p = strrchr(argv[j], '.');
       if (p == NULL)
          continue;
       p++;

       if (stricmp(p, "dll") && stricmp(p, "exe"))
          continue;

       fp = fopen(argv[j], "rb");
       if (fp == NULL) {
          printf("can't open a file %s\n", argv[j]);
          continue;
       }
 
       fread(&image_dos_header, sizeof(image_dos_header), 1, fp);
       fseek(fp, image_dos_header.e_lfanew + 4, SEEK_SET);
       fread(&image_file_header, sizeof(image_file_header), 1, fp);
       fclose(fp);
       ww = image_file_header.Characteristics;

       if ((ww & IMAGE_FILE_32BIT_MACHINE) &&
          !(ww & IMAGE_FILE_DLL))
          printf("%-32s 32bit EXE\n", argv[j]);
       else if ((ww & IMAGE_FILE_32BIT_MACHINE) &&
               (ww & IMAGE_FILE_DLL))
          printf("%-32s 32bit DLL\n", argv[j]);
       else if ((ww & IMAGE_FILE_LARGE_ADDRESS_AWARE) &&
               !(ww & IMAGE_FILE_DLL))
          printf("%-32s 64bit EXE\n", argv[j]);
       else if ((ww & IMAGE_FILE_LARGE_ADDRESS_AWARE) &&
               (ww & IMAGE_FILE_DLL))
          printf("%-32s 64bit DLL\n", argv[j]);
    }
    return 0;
}
