program TeXShell;

uses
  Forms,
  WinProcs,
  WinTypes,
  Messages,
  SysUtils,
  Frame in 'Frame.pas' {FrameForm},
  Edit in 'Edit.pas' {EditForm},
  Info in 'Info.pas' {InfoDlg},
  CleanUp in 'CleanUp.pas' {CleanUpDlg},
  ImageDlg in 'ImageDlg.pas' {ImageDialog},
  TemplateDlg in 'TemplateDlg.pas' {TemplateDialog},
  EditTemplateDlg in 'EditTemplateDlg.pas' {EditTemplateDialog},
  GreekDlg in 'GreekDlg.pas' {GreekDialog},
  AppearanceDlg in 'AppearanceDlg.pas' {AppearanceDialog},
  DocumentDlg in 'DocumentDlg.pas' {DocumentDialog},
  ProgramsDlg in 'ProgramsDlg.pas' {ProgramsDialog},
  SymbolDlg in 'SymbolDlg.pas' {SymbolDialog},
  MathDlg in 'MathDlg.pas' {MathDialog},
  UserTemplates in 'UserTemplates.pas' {UserTemplatesDialog},
  GraphicsDlg in 'GraphicsDlg.pas' {GraphicsDialog},
  IspellInterface in 'IspellInterface.pas',
  SpellCheckDlg in 'SpellCheckDlg.pas' {SpellCheckDialog},
  OptSpellCheckDlg in 'OptSpellCheckDlg.pas' {OptSpellCheckDialog};

{$R *.RES}
const
    appName = 'TeXShell32';
var i:integer;
    prevInstance: hWnd;
    wndPrevInstance: hWnd;
    copyData: TCopyDataStruct; { use this to send parameters to previous instance }
    strParameter: string;
    pStrParameter: array [0..255] of char;
begin
//  prevInstance := 0;

  { test for main window of previeous instance }
  prevInstance := FindWindow ('TApplication', appName);
  // prevInstance := FindWindow ('TFrameForm', 'TeXShell');

  if prevInstance <> 0 then
  begin { call previous instance }
    if IsIconic (prevInstance) then
      ShowWindow (prevInstance, sw_Restore)
    else
      SetForegroundWindow (prevInstance);
    { send parameters to previous instance }
    wndPrevInstance := FindWindow ('TFrameForm', nil);
    for i := 1 to ParamCount do
    begin
      strParameter    := ParamStr(i);
      StrPCopy (pStrParameter, strParameter);
      copyData.cbData := StrLen(pStrParameter) + 1;
      copyData.lpData := @pStrParameter;
      SendMessage (wndPrevInstance, WM_COPYDATA, Application.Handle, longint(@copyData));
    end;
  end
  else
  begin { start programm }
    { use menu Project|Options|Application to set title }
    Application.Initialize;
    Application.Title := 'TeXShell32';
    Application.CreateForm(TFrameForm, FrameForm);
  Application.CreateForm(TInfoDlg, InfoDlg);
  Application.CreateForm(TCleanUpDlg, CleanUpDlg);
  Application.CreateForm(TImageDialog, ImageDialog);
  Application.CreateForm(TTemplateDialog, TemplateDialog);
  Application.CreateForm(TEditTemplateDialog, EditTemplateDialog);
  Application.CreateForm(TGreekDialog, GreekDialog);
  Application.CreateForm(TAppearanceDialog, AppearanceDialog);
  Application.CreateForm(TDocumentDialog, DocumentDialog);
  Application.CreateForm(TProgramsDialog, ProgramsDialog);
  Application.CreateForm(TSymbolDialog, SymbolDialog);
  Application.CreateForm(TMathDialog, MathDialog);
  Application.CreateForm(TUserTemplatesDialog, UserTemplatesDialog);
  Application.CreateForm(TGraphicsDialog, GraphicsDialog);
  Application.CreateForm(TSpellCheckDialog, SpellCheckDialog);
  Application.CreateForm(TOptSpellCheckDialog, OptSpellCheckDialog);
  wndPrevInstance := FindWindow ('TFrameForm', nil);

   //*DS* restores old window configuration
   (Application.MainForm as TFrameForm).AfterCreate;

    //handle command line parameters
    for i := 1 to ParamCount do
    begin
      strParameter    := ParamStr(i);
      StrPCopy (pStrParameter, strParameter);
      copyData.cbData := StrLen(pStrParameter) + 1;
      copyData.lpData := @pStrParameter;
      SendMessage (wndPrevInstance, WM_COPYDATA, Application.Handle, longint(@copyData));
    end;

    Application.Run;
  end;
end.
