# Rédaction avec LaTeX

The package **formation-latex-ul** provides an introduction to LaTeX
manual (in French) and the support material (slides and exercise
files) for a course. The material was prepared for Université Laval,
Québec, Canada.

## License

Creative Commons Attribution-ShareAlike 4.0 International.

## Version

2024.03

## Author

Vincent Goulet <vincent.goulet@act.ulaval.ca>

## Web page of the project

https://vigou3.gitlab.io/formation-latex-ul

## Source code repository

https://gitlab.com/vigou3/formation-latex-ul

## Contents

- `doc/formation-latex-ul.pdf`: reference manual;
- `doc/formation-latex-ul-diapos.pdf`: slides for a short course based
  on the reference manual;
- `doc/exercice-*.tex`: source files for the exercises;
- other files in `doc/`: support files for the exercises;
- `source/*`: complete sources for the reference manual and the
  slides;
- `CONTRIBUTING.md`: instructions to contribute to the project;
- `LICENSE`: CC BY-SA 4.0 license;
- `NEWS`: version history;
- `README.md`: this file.

## Compilation of the documents

The directory `source/` contains the complete sources to compile the
reference manual and the slides using XeLaTeX on an up-to-date TeX
distribution. Note, however, that the reference manual requires the
non-free [Lucida fonts](https://tug.org/store/lucida/) from TUG.

## Version history

The version history of the project appears in `NEWS` (in French).

## Comments or suggestions

The Gitlab [project repository](https://gitlab.com/vigou3/formation-latex-ul)
is the best place to report bugs or to propose improvements to the 
project.

======================================================================

# Rédaction avec LaTeX

Le paquetage **formation-latex-ul** propose une formation à
l'utilisation de LaTeX développée à l'origine pour la Bibliothèque de
l'[Université Laval](https://www.ulaval.ca).

La formation est formée des éléments suivants:

1. *Rédaction avec LaTeX*, un document de référence de près de
   200 pages;

2. des diapositives pour une formation en classe couvrant grosso modo
   les quatre premiers chapitres du document de référence;

3. les fichiers nécessaires pour compléter certains exercices, ainsi
   qu'un gabarit pour composer les solutions des autres exercices.

Les quatre premiers chapitres du document de référence couverts par
les diapositives traitent des concepts de base de LaTeX: processus
d'édition, compilation, visualisation; séparation du contenu et de
l'apparence du texte; mise en forme du texte; séparation du document
en parties; rudiments du mode mathématique.

Les six autres chapitres du document de référence visent à rendre
l'utilisateur de LaTeX débutant ou intermédiaire autonome dans la
rédaction de documents relativement complexes comportant des tableaux,
des figures, des équations mathématiques élaborées, une bibliographie,
etc.

## Licence

Attribution-Partage dans les mêmes conditions 4.0 International de
Creative Commons

## Version

2024.03

## Auteur

Vincent Goulet <vincent.goulet@act.ulaval.ca>

## Page web du projet

https://vigou3.gitlab.io/formation-latex-ul

## Dépôt du code source

https://gitlab.com/vigou3/formation-latex-ul

## Contenu du paquetage

- `doc/formation-latex-ul.pdf`: ouvrage de référence;
- `doc/formation-latex-ul-diapos.pdf`: diapositives de la formation;
- `doc/exercice-*.tex`: fichiers pour les exercices;
- autres fichiers dans `doc/`: fichiers additionnels pour les
  exercices;
- `source/*`: code source de l'ouvrage de référence et des
  diapositives;
- `CONTRIBUTING.md`: instructions pour contribuer au projet;
- `LICENSE`: license CC BY-SA 4.0;
- `NEWS`: historique des versions;
- `README.md`: le présent fichier.

## Composition des documents

Le dossier `source/` contient tous les fichiers nécessaires pour
composer le document principal et les diapositives avec XeLaTeX à
partir d'une distribution TeX récente et à jour. Toutefois, la
compilation de l'ouvrage de référence requiert les polices de
caractères payantes [Lucida](https://tug.org/store/lucida/) du TeX
User Group. La Bibliothèque de l'Université Laval détient une licence
d'utilisation de cette police. Les étudiants et le personnel de
l'Université peuvent s'en procurer une copie gratuitement en écrivant
à [mailto:lucida@bibl.ulaval.ca].

## Historique des versions

L'historique des versions se trouve dans `NEWS`.

## Commentaires et suggestions

Le [dépôt du projet](https://gitlab.com/vigou3/formation-latex-ul)
dans GitLab demeure le meilleur endroit pour rapporter des bogues ou
pour proposer des améliorations au projet.
