---
title: Gentium - Versions and Changes
fontversion: 7.000
---

## Announcement list

If you would like stay informed of updates to Gentium and other SIL fonts, please subscribe to the [SIL Font News Announcement List](https://groups.google.com/a/groups.sil.org/forum/#!forum/sil-font-news). For more information see [About](about.md).

Our font announcements are also available through X (formerly Twitter) [\@silfonts](https://x.com/silfonts).

## Current versions

The latest version of the fonts is always available from the [Gentium download page](https://software.sil.org/gentium/download/) as a .zip archive for all major platforms.

Gentium is also available through the [TypeTuner Web](https://typetunerweb.languagetechnology.org/ttw/fonts2go.cgi) service, which allows you to choose among the smart font features and download a font with those features preset. This enables them to work in many applications that do not fully support OpenType. **Please note that the version 7 fonts available through TypeTuner Web no longer offer line spacing alternatives (Normal, Tight, Loose). If you need Tight or Loose variants the version 6.200 fonts remain available and support line spacing alternatives.**

## Other Gentium versions and variants

There are many font families based on the Gentium design, as summarized in this table. Current versions are in **bold**. Additional information is provided in later sections.

Font Family | Versions | Status and use
----------- | -------- | ---------------------
**Gentium**|**7.000**|**Current**—recommended for all uses and users
**Gentium Book**|**7.000**|**Current**—slightly heavier-weight family, recommended for all uses and users
Gentium Plus & Gentium Book Plus|1.500–6.200|No longer recommended—please use current version
Gentium Plus Compact & Gentium Book Plus Compact|1.500–6.200|Fonts with reduced default line spacing—no longer recommended
Gentium Plus Literacy & Gentium Book Plus Literacy|1.500–6.200|Literacy variants with alternate a and g forms—no longer recommended
Gentium Plus Lit Comp & Gentium Book Plus Lit Comp|1.500–6.200|Compact literacy variants—no longer recommended
Gentium Plus Lit AmArea & Gentium Book Plus Lit AmArea|1.500–6.200|Literacy variants with AmArea features—no longer recommended
Gentium Plus *special variant* & Gentium Book Plus *special variant*|5.000–6.200|Modified versions for special purposes (AmArea, Mali, Tat)—no longer recommended
Gentium Plus *region subset* & Gentium Book Plus *region subset*|5.000|Subsets for particular regions (Afr, Am, APac, Cyr, CyrE, Eur, Phon, Viet)—no longer recommended
Gentium Basic|1.100–1.102|Limited-character-set version based on version 5—no longer recommended
Gentium & GentiumAlt|1.000–1.030|Obsolete original fonts from 2005—no longer recommended

There are also font families named ‘Gentium *something*’ that were created using [TypeTuner Web](https://scripts.sil.org/ttw/fonts2go.cgi). We have no record or archive of most of these ‘tuned’ fonts, but if you are desperate to find them contact us. We may be able to point you to the distributors of those that we know about.

### *Compact* versions

The Gentium version 7 fonts do not have *Compact* variants. The default line spacing has been reduced to be closer, but not identical, to the previous version’s *Compact* line spacing. Most users should use the version 7 fonts and adjust line spacing explicitly within the application if necessary. If your application does not allow control over line spacing, you can use the [version 6.200 Gentium Plus Compact fonts](https://software.sil.org/lcgfonts/download/), which remain available. **If you need any of the new version 7 features or characters, but also need them supported in a compact version please [contact us](https://software.sil.org/gentium/about/contact/).**

### Special-purpose modified variants

[Modified versions of the Gentium Plus version 6.200 fonts](https://software.sil.org/lcgfonts/download/) are available that have been ‘tuned’ to turn on certain features by default. These are available for some regions and include *Literacy* versions. **These remain at version 6.200 and have not been updated to Gentium version 7. If you need any of the new features or characters in this version, but also need them supported in the special-purpose modified fonts please [contact us](https://software.sil.org/gentium/about/contact/).**

### Version 5 subsets

In the past, special *subset* versions of Gentium Plus version 5 were created for specific uses. Those fonts still work and [remain available](https://software.sil.org/lcgfonts/font-subsets/). These are limited versions of the fonts that support only the characters needed for a particular area or use. Subsets are available for Africa, Americas, Asia/Pacific, Europe/Eurasia, Vietnam, Phonetic, Cyrillic (Basic) and Cyrillic Extended. With the exception of the Phonetic font, the font subsets are intended for orthographic use only. We have not put anything in the other subsets for phonetic, transliteration, or transcription use. For those purposes, use the Phonetic subset. We do not intend to update these fonts, however they may still work. **We do not, however, recommend their use. In almost all cases the standard font is a better choice. Font size is less of a concern than it was years ago, particularly with improved compression technologies such as woff2.** 

## Previous versions archive

Previous versions remain available from our [Previous versions archive](https://software.sil.org/gentium/download/previous-versions).

## Change history

A detailed list of changes for each version of the fonts is on the [Version history page](history.md).
