---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, renvois, référence à un compteur
---

# Comment faire référence à ses propres compteurs ?

Après avoir défini un compteur personnel (avec la commande `\newcounter`), 
il est possible d'y faire référence avec les commandes `\label` et `\ref`. 
Pour cela, il faut l'incrémenter avec la commande `\refstepcounter` au lieu de `\stepcounter`. 
Voici un exemple :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page

  \newcounter{regle}
  \setcounter{regle}{0}

\begin{document}
\section{Grands principes}
\refstepcounter{regle} Règle \theregle : j'ai raison.

\refstepcounter{regle} Règle \theregle : j'ai même 
toujours raison. \label{test}

La règle \ref{test} ne souffre aucune exception.
\end{document}
```

:::{sources}
[Making labels from a counter](faquk:FAQ-labelctr)
:::