/* symlink.h -- this file is part of the SYMLINK Library.

   Copyright (C) 1994, 1995 Ralph Schleicher  */

/* This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef _SYMLINK_H
#define _SYMLINK_H


#include <symlink/cdefs.h>


#define SYMLINK_ATTR_LINK	"SYMLINK.LINK"
#define SYMLINK_SYS_MAX		256

__BEGIN_DECLS

int symlink __PROTO ((const char *old, const char *new));
int _symlink __PROTO ((const char *old, const char *new));
int readlink __PROTO ((const char *name, char *buffer, size_t size));
int _resolvlink __PROTO ((const char *name, char *buffer, size_t size));

__END_DECLS

#ifdef USE_SYMLINK_HEADERS

#ifndef USE_SYMLINK_IO
#define USE_SYMLINK_IO
#endif
#ifndef USE_SYMLINK_STDIO
#define USE_SYMLINK_STDIO
#endif
#ifndef USE_SYMLINK_STAT
#define USE_SYMLINK_STAT
#endif

#endif /* USE_SYMLINK_HEADERS */

#ifdef USE_SYMLINK_IO
#include <symlink/io.h>
#endif
#ifdef USE_SYMLINK_STDIO
#include <symlink/stdio.h>
#endif
#ifdef USE_SYMLINK_STAT
#include <symlink/stat.h>
#endif


#endif /* not _SYMLINK_H */
