/*
ͻ
 What's it called: EPMTeX v3.1 Pro (tex.e)                                  
                                                                            
 What does it do:  The E source code for the EPMTeX enhancements for EPM.   
                                                                            
 Who and When:     Jon Hacker   1/93 - 9/95                                 
                   Joachim Koenen 8/94       (syntax assist)                
                   Thorsten Domsalla 2/93    (menus, batch files)           
                   Rodney Korte 7/93 -6/94                                  
                                                                            
ͼ
*/
/*
  Comments/Questions (by RK):
  - Certainly some of the code could be cleaned up (optimized).  Things get
    pretty bogged down when there are lots of files in the ring.
  - It might be handy to go back to previous errors, not just forward.
    I am definitely *not* up to that task.
  - Why won't the circles stay around? (See procedure tex_find_errors.)
  - Perhaps a "Load all" menu option that scans the current file for
    \input commands and loads those files into the editor would be handy?
*/

/*
Ŀ
  The standard and Pro versions share the same code base.                   
  - We define the Pro variable = 0 to enable the standard features.         
  - We define the Pro variable = 1 to enable the Pro features.              

*/
const EPMTEXPRO = 1

/*
Ŀ
  Current version of EPMTeX package                                         

*/
const PrimVersion = 3.1
compile if EPMTEXPRO = 1
  Version = PrimVersion || ' Pro'
compile else
  Version = PrimVersion || ' Standard'
compile endif

/*
Ŀ
  Include the standard stuff we need since we are compiling separately      
  from epm.ex and extra.ex.                                                 

*/
compile if not defined(SMALL)  -- Being compiled separately
  include 'stdconst.e'
  include 'colors.e'
  define INCLUDING_FILE = 'TEX.E'
  tryinclude 'MYCNF.E'
  compile if not defined(SITE_CONFIG)
    const SITE_CONFIG = 'SITECNF.E'
  compile endif
  compile if SITE_CONFIG
    tryinclude SITE_CONFIG
  compile endif
  compile if not defined(NLS_LANGUAGE)
    const NLS_LANGUAGE = 'ENGLISH'
  compile endif
  include NLS_LANGUAGE'.e'
  compile if not defined(EPM_POINTER)
    const EPM_POINTER = TEXT_POINTER
  compile endif
compile endif


/*
Ŀ
  EPMTeX menu messages - alter these for alternate language support         

*/

const
TEX_BAR__MSG =          'Menus related to TeX support'
TEX_TEX__MSG =          'TeX the current file (or Master file, if applicable)'
TEX_LOCATE_ERROR__MSG = 'Locate next error from LOG file'
TEX_VIEW_LOG__MSG =     'View the LOG file associated with the current file'
TEX_VIEW_DVI__MSG =     'Preview the DVI file associated with the current file'
TEX_PRINT__MSG =        'Print the DVI file associated with the current file'
TEX_DEL_LOG__MSG =      'Delete the LOG file associated with the current file'
TEX_DEL_DVI__MSG =      'Delete the DVI file associated with the current file'
TEX_FORMAT__MSG =       'Format to be used when TeXing'
TEX_ORIENT__MSG =       'Orientation with which to Preview and Print'
TEX_ORIENT_AUTO__MSG=   'Auto select of orientation based on directive in 1st line of file'
TEX_ORIENT_PORT__MSG=   'Force Portrait orientation for Preview and Print'
TEX_ORIENT_LAND__MSG=   'Force Landscape orientation for Preview and Print'
TEX_SETTINGS__MSG=      'Settings to change EPMTeX configuration'
TEX_AUTO_DEL_LOG__MSG = 'Automatic delete of the associated LOG file after View or Print'
TEX_AUTO_SAVE__MSG =    'Automatic smart save of TeX file before TeXing document.'
TEX_MASTER__MSG =       'Enable Master File dependency system.'
TEX_SYNTAX__MSG =       'Global syntax expansion mode (expand on)'
TEX_DEBUG__MSG =        'Verbose mode for troubleshooting TeX commands'
TEX_FORMAT_AUTO__MSG=   'Auto select of format based on directive in 1st line of file'
TEX_ABOUT_BOX__MSG=     'About EPMTeX 'Version


/*
Ŀ
  Define EPMTeX variables and post menu build                               

*/

definit  -- called once at link time
    universal tex_orient,
              tex_auto_log,
              tex_auto_save,
              tex_master,
              tex_debug,
              tex_menuon,
              tex_quickkeys,
              tex_file_types,
              tex_format,
              tex_userfiletypes,
              tex_quickkeys,
              app_hini

    tex_auto_log = queryprofile( app_hini, 'EPMTeX', 'TEX_AUTOLOGDELETE')
    tex_auto_save= queryprofile( app_hini, 'EPMTeX', 'TEX_AUTOSAVE')
    tex_master= queryprofile( app_hini, 'EPMTeX', 'TEX_MASTERFILE')
    tex_debug= queryprofile( app_hini, 'EPMTeX', 'TEX_DEBUG')
    tex_menuon = queryprofile( app_hini, 'EPMTeX', 'TEX_MENUON')
    tex_quickkeys = queryprofile( app_hini, 'EPMTeX', 'TEX_QUICKKEYS')

    TEX_ORIENTATION = queryprofile( app_hini, 'EPMTeX', 'TEX_ORIENTATION')
    if TEX_ORIENTATION = '1' then
        tex_orient = 'Portrait'
    elseif TEX_ORIENTATION = '2' then
        tex_orient = 'Landscape'
    else
        tex_orient = 'Auto'
    endif

    TEX_FORMAT_TO_USE= queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT')
    if TEX_FORMAT_TO_USE = '0' then
        tex_format = 'Auto'
    elseif TEX_FORMAT_TO_USE = '1' then
        tex_format = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_PLAIN')

    elseif TEX_FORMAT_TO_USE = '2' then
        tex_format = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_LATEX')

    elseif TEX_FORMAT_TO_USE = '3' then
        TEX_FORMAT_USER1_MENU_TEXT = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_USER1_MENU_TEXT')
        if TEX_FORMAT_USER1_MENU_TEXT <> '' then
            tex_format = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_USER1')
        else
            sayerror 'USER1 format undefined, defaulting to Auto format'
            tex_format = 'Auto'
        endif
    elseif tex_format = '4' then
        TEX_FORMAT_USER2_MENU_TEXT = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_USER2_MENU_TEXT')
        if TEX_FORMAT_USER2_MENU_TEXT <> '' then
            tex_format = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_USER2')
        else
            sayerror 'USER2 format undefined, defaulting to Auto format'
            tex_format = 'Auto'
        endif
    else
        tex_format = 'Auto'
    endif


-- Add extra user file types
    tex_userfiletypes = queryprofile( app_hini, 'EPMTeX', 'TEX_USERFILETYPES')
    tex_file_types= 'TEX STY LOG AUX '||translate(tex_userfiletypes)

    'PostMe BuildTexMenu'    -- delay creating menu until after the definit

-- If debug mode > 1 then talk
    if tex_debug > 1 then
      sayerror("tex:definit")
    endif


/*
Ŀ
  Call defload and defselect from within tex.e for the standard edition.    
  This is not ideal, because it overrides the existing defload/defselect    
  for epm versions < 6.  For this reason, we also suck in load.e and        
  select.e here for the standard edition.                                   
  For the pro version, the defload/defselect are put in mystuff.e where     
  they behave themselves better.                                            

*/

compile if EPMTEXPRO <> 1
-- for the standard edition only, since EPM < v6.00 doesn't overlay
-- defselect/defload we include the default modules here again as a kludge.
-- make sure needed constants are defined before calling select.e and load.e
  compile if EVERSION < 6
    compile if not defined(INCLUDE_STD_MENUS)
      const INCLUDE_STD_MENUS = 1
    compile endif
    compile if not defined(WANT_EPM_SHELL) or EVERSION < '5.20'
      const WANT_EPM_SHELL = 1
    compile endif
    compile if EVERSION < '5.51' or not defined(INCLUDE_BMS_SUPPORT)
      INCLUDE_BMS_SUPPORT = 0
    compile endif
    include 'select.e'
    include 'load.e'
  compile endif -- EVERSION

-- define the TeX defload procedure for standard version
  defload
    universal tex_debug,
              app_hini

    call texload()
-- If debug mode > 1 then talk
    tex_debug= queryprofile( app_hini, 'EPMTeX', 'TEX_DEBUG')
    if tex_debug > 1 then
      sayerror("tex:defload")
    endif

-- define the TeX defload procedure for standard version
  defselect
    universal tex_debug,
              app_hini

    call texselect()
-- If debug mode > 1 then talk
    tex_debug= queryprofile( app_hini, 'EPMTeX', 'TEX_DEBUG')
    if tex_debug > 1 then
      sayerror("tex:defselect")
    endif

compile endif -- not EPMTEXPRO

/*
Ŀ
  Procedure to setup margins/tabs/menu called by defselect                  

*/
defproc texselect =
    universal tex_file_types,
              tex_debug,
              app_hini

-- If debug mode > 1 then talk
    tex_debug= queryprofile( app_hini, 'EPMTeX', 'TEX_DEBUG')
    if tex_debug > 1 then
       sayerror("tex:texselect")
    endif

-- enable the TeX menu if TeX file loaded
    'PostMe TexMenuEnable'

-- set the TeX margins,tabs,hiliting if TeX file loaded
    call setTexMarginsEnable()

-- load any requested keysets
    call setTexKeySets()

/*
Ŀ
  Procedure to setup margins/tabs/menu called by defload                    

*/
defproc texload =
    universal tex_file_types,
              tex_debug,
              app_hini

-- If debug mode > 1 then talk
    tex_debug= queryprofile( app_hini, 'EPMTeX', 'TEX_DEBUG')
    if tex_debug > 1 then
      sayerror'tex:texload'
    endif

-- enable the TeX menu if TeX file loaded
    'PostMe TexMenuEnable'

-- set the TeX margins,tabs,hiliting if TeX file loaded
    call setTexMarginsEnable()

-- load any requested keysets
    call setTexKeySets()

/*
Ŀ
  Include the TeX keyset and syntax assist functions                        

*/

include 'texkeys.e'


/*
Ŀ
  Define TeX menu system                                                    

*/

defc BuildTexMenu
    universal  defaultmenu,
               tex_quickkeys,
               tex_menuon,
               app_hini

-- load in required environment information to build menu system
-- We build different menus for the standard and Pro versions.
  compile if EPMTEXPRO = 1
    TEX_FORMAT_PLAIN_MENU_TEXT = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_PLAIN_MENU_TEXT')
    TEX_FORMAT_PLAIN__MSG = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_PLAIN__MSG')
    TEX_FORMAT_LATEX_MENU_TEXT = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_LATEX_MENU_TEXT')
    TEX_FORMAT_LATEX__MSG = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_LATEX__MSG')
    TEX_FORMAT_USER1_MENU_TEXT = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_USER1_MENU_TEXT')
    TEX_FORMAT_USER1__MSG = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_USER1__MSG')
    TEX_FORMAT_USER2_MENU_TEXT = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_USER2_MENU_TEXT')
    TEX_FORMAT_USER2__MSG = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_USER2__MSG')
  compile endif

    TEX_USER1_MENU_TEXT = queryprofile( app_hini, 'EPMTeX', 'TEX_USER1_MENU_TEXT')
    TEX_USER1__MSG = queryprofile( app_hini, 'EPMTeX', 'TEX_USER1__MSG')
    TEX_USER2_MENU_TEXT = queryprofile( app_hini, 'EPMTeX', 'TEX_USER2_MENU_TEXT')
    TEX_USER2__MSG = queryprofile( app_hini, 'EPMTeX', 'TEX_USER2__MSG')
    TEX_USER3_MENU_TEXT = queryprofile( app_hini, 'EPMTeX', 'TEX_USER3_MENU_TEXT')
    TEX_USER3__MSG = queryprofile( app_hini, 'EPMTeX', 'TEX_USER3__MSG')
    TEX_USER4_MENU_TEXT = queryprofile( app_hini, 'EPMTeX', 'TEX_USER4_MENU_TEXT')
    TEX_USER4__MSG = queryprofile( app_hini, 'EPMTeX', 'TEX_USER4__MSG')

--  Temporarily delete Help menu so we can put it back later on the end
--  of the menu bar where it belongs!
    deletemenu defaultmenu, HELP_MENU_ID, 0, 0

    buildsubmenu defaultmenu, 9, '~TeX', \1TEX_BAR__MSG, 0,0
      if tex_quickkeys then
        buildmenuitem defaultmenu, 9, 901, '~TeX Document'\9'Sh+F11',      'tex'\1TEX_TEX__MSG, 0,0
        buildmenuitem defaultmenu, 9, 924, 'Locate Next ~Error'\9'Sh+F12', 'tex_locate_error'\1TEX_LOCATE_ERROR__MSG, 0,0
      else
        buildmenuitem defaultmenu, 9, 901, '~TeX Document',      'tex'\1TEX_TEX__MSG, 0,0
        buildmenuitem defaultmenu, 9, 924, 'Locate Next ~Error', 'tex_locate_error'\1TEX_LOCATE_ERROR__MSG, 0,0
      endif -- tex_quickkeys
      buildmenuitem defaultmenu, 9, 902, \0, '', 4, 0
      buildmenuitem defaultmenu, 9, 905, 'View ~LOG File',     'tex_view_log'\1TEX_VIEW_LOG__MSG,  0,0
      buildmenuitem defaultmenu, 9, 903, 'Pre~View Document',  'tex_view_dvi'\1TEX_VIEW_DVI__MSG,  0,0
      buildmenuitem defaultmenu, 9, 904, '~Print Document',    'tex_print'\1TEX_PRINT__MSG,  0,0

      if  TEX_USER1_MENU_TEXT <> '' OR
          TEX_USER2_MENU_TEXT <> '' OR
          TEX_USER3_MENU_TEXT <> '' OR
          TEX_USER4_MENU_TEXT <> '' then
        buildmenuitem defaultmenu, 9, 906, \0, '', 4, 0
      endif

      if TEX_USER1_MENU_TEXT <> '' then
        buildmenuitem defaultmenu, 9, 911, TEX_USER1_MENU_TEXT,'texuser1exec' \1TEX_USER1__MSG, 0,0
      endif
      if TEX_USER2_MENU_TEXT <> '' then
        buildmenuitem defaultmenu, 9, 921, TEX_USER2_MENU_TEXT,'texuser2exec' \1TEX_USER2__MSG, 0,0
      endif
      if TEX_USER3_MENU_TEXT <> '' then
        buildmenuitem defaultmenu, 9, 930, TEX_USER3_MENU_TEXT,'texuser3exec' \1TEX_USER3__MSG, 0,0
      endif
      if TEX_USER4_MENU_TEXT <> '' then
        buildmenuitem defaultmenu, 9, 933, TEX_USER4_MENU_TEXT,'texuser4exec' \1TEX_USER4__MSG, 0,0
      endif

      buildmenuitem defaultmenu, 9, 922, \0, '', 4, 0
      buildmenuitem defaultmenu, 9, 907, 'Delete LO~G File','tex_del_log' \1TEX_DEL_LOG__MSG, 0,0
      buildmenuitem defaultmenu, 9, 908, 'Delete ~DVI File','tex_del_dvi' \1TEX_DEL_DVI__MSG, 0,0
      buildmenuitem defaultmenu, 9, 909, \0, '', 4, 0

    compile if EPMTEXPRO = 1
      buildmenuitem defaultmenu, 9, 910, '~Format', \1TEX_FORMAT__MSG,         17,0
        buildmenuitem defaultmenu, 9, 923, '~Automatic','texformat0' \1TEX_FORMAT_AUTO__MSG,0,0
        buildmenuitem defaultmenu, 9, 917, TEX_FORMAT_PLAIN_MENU_TEXT, 'texformat1' \1TEX_FORMAT_PLAIN__MSG,0,0

-- Must do fancy stuff here to get menu to end in the right place
-- regardless of format definitions

      if TEX_FORMAT_USER2_MENU_TEXT = '' then
        if TEX_FORMAT_USER1_MENU_TEXT = '' then
          buildmenuitem defaultmenu, 9, 918, TEX_FORMAT_LATEX_MENU_TEXT,'texformat2' \1TEX_FORMAT_LATEX__MSG,32768+1,0
        else
          buildmenuitem defaultmenu, 9, 918, TEX_FORMAT_LATEX_MENU_TEXT,'texformat2' \1TEX_FORMAT_LATEX__MSG,0,0
          buildmenuitem defaultmenu, 9, 919, TEX_FORMAT_USER1_MENU_TEXT,'texformat3' \1TEX_FORMAT_USER1__MSG,32768+1,0
        endif
      else
        if TEX_FORMAT_USER1_MENU_TEXT = '' then
          buildmenuitem defaultmenu, 9, 918, TEX_FORMAT_LATEX_MENU_TEXT,'texformat2' \1TEX_FORMAT_LATEX__MSG,0,0
          buildmenuitem defaultmenu, 9, 920, TEX_FORMAT_USER2_MENU_TEXT,'texformat4' \1TEX_FORMAT_USER2__MSG,32768+1,0
        else
          buildmenuitem defaultmenu, 9, 918, TEX_FORMAT_LATEX_MENU_TEXT,'texformat2' \1TEX_FORMAT_LATEX__MSG,0,0
          buildmenuitem defaultmenu, 9, 919, TEX_FORMAT_USER1_MENU_TEXT,'texformat3' \1TEX_FORMAT_USER1__MSG,0,0
          buildmenuitem defaultmenu, 9, 920, TEX_FORMAT_USER2_MENU_TEXT,'texformat4' \1TEX_FORMAT_USER2__MSG,32768+1,0
        endif
      endif

      buildmenuitem defaultmenu, 9, 912, '~Orientation', \1TEX_ORIENT__MSG,17,0
        buildmenuitem defaultmenu, 9, 925, '~Automatic','texorient0' \1TEX_ORIENT_AUTO__MSG,0,0
        buildmenuitem defaultmenu, 9, 926, '~Portrait', 'texorient1' \1TEX_ORIENT_PORT__MSG,0,0
        buildmenuitem defaultmenu, 9, 927, '~Landscape','texorient2' \1TEX_ORIENT_LAND__MSG,32768+1,0
    compile endif -- EPMTEXPRO

    buildmenuitem defaultmenu, 9, 931, '~Settings...', 'tex_settings' \1TEX_SETTINGS__MSG,0,0
    buildmenuitem defaultmenu, 9, 928, \0, '', 4, 0
    buildmenuitem defaultmenu, 9, 929, 'A~bout...','tex_about_box' \1TEX_ABOUT_BOX__MSG, 0,0

    call readd_help_menu();   -- Put Help menu back in

    showmenu defaultmenu

   'PostMe  TexMenuEnable'

/*
Ŀ
   enable the TeX menu only if TeX file loaded                              
   or enable if TEX_MENU_ALWAYS_ON is set                                   

*/
defc TexMenuEnable
    universal  tex_debug,
               tex_file_types,
               tex_menuon,
               app_hini

    tex_menuon = queryprofile( app_hini, 'EPMTeX', 'TEX_MENUON')
    tex_userfiletypes = queryprofile( app_hini, 'EPMTeX', 'TEX_USERFILETYPES')
    tex_file_types= 'TEX STY LOG AUX '||translate(tex_userfiletypes)

    if tex_menuon then
       enabled = 1
    else
       ext = filetype()
       enabled = pos(leftstr(ext,3),tex_file_types)
    endif

--  Change working directory to directory of current file since that is
--  where the .DVI and .LOG files (and any others) should go.
    if enabled then
        n=lastpos('\',.filename)
        dir = substr(.filename,1,n)
--        if tex_debug then sayerror 'Changing directory to 'dir; endif
        call directory(leftstr(dir,length(dir)-1))
    endif

    SetMenuAttribute(9, 16384, enabled)

/*
Ŀ
   set the TeX margins/tabs/hiliting only if TeX file loaded                

*/
defproc setTexMarginsEnable
    universal  tex_debug,
               tex_file_types,
               app_hini

    tex_userfiletypes = queryprofile( app_hini, 'EPMTeX', 'TEX_USERFILETYPES')
    tex_file_types= 'TEX STY LOG AUX '||translate(tex_userfiletypes)
    ext = filetype()
    if pos(leftstr(ext,3), tex_file_types) <> 0 then  -- if TeX file then
                                                      -- set TeX tabs
      tabenable = queryprofile( app_hini, 'EPMTeX', 'TEX_TABENABLE')
      if  tabenable then
          tex_tabs = queryprofile( app_hini, 'EPMTeX', 'TEX_TABS')
          'tabs 'tex_tabs
          if tex_debug > 2 then
            sayerror 'tex tabs 'tex_tabs' set'
          endif
      endif -- tex_tabenable

-- set TeX margins
      if queryprofile( app_hini, 'EPMTeX', 'TEX_MARGINENABLE') then
          tex_margin = queryprofile( app_hini, 'EPMTeX', 'TEX_MARGINL')
          tex_margin = tex_margin' 'queryprofile( app_hini, 'EPMTeX', 'TEX_MARGINR')
          tex_margin = tex_margin' 'queryprofile( app_hini, 'EPMTeX', 'TEX_MARGINP')
          'ma 'tex_margin
          if tex_debug > 2 then
            sayerror 'tex margin 'tex_margin' set'
          endif
      endif  -- tex_marginenable

-- syntax highlighting
    compile if EVERSION >= '6.01b'
      if queryprofile( app_hini, 'EPMTeX', 'TEX_SYNTAXHILITE') then
        if .visible then
          'toggle_parse 1 epmkwds.tex'  -- turns on hilite but beware may be turned off
                                        -- again later if also defined in mystuff.e
        endif
      endif  -- keyword
    compile endif  -- Version

    endif  -- TeX file loaded

/*
Ŀ
  Command definitions                                                       

*/
-----------------------------------------------------------------------------
-- Show the about box

defc tex_about_box

-- Text is limited to 256 chars!  So we can't say as much as we'd like
-- There are 253 chars currently in message (I think)

   call WinMessageBox('About EPMTeX 'Version,

--  Can't fit all of this
--                      'This is the beta version of'\13||
--                      'EPMTeX 'Version' by Jonathan Hacker'\13||
--                      'and Rodney Korte.'\13||

                      'EPMTeX 'Version\13\13||
                      'by    Jonathan Hacker'\13||
                      '&       Rodney Korte'\13\13||
                      'EPMTeX is governed by the'\13||
                      'license agreement included'\13||
                      'with the EPMTeX package.'\13\13||

                      'Questions, comments, problems:'\13||
                      '      hacker@patagonia.bellcore.com'\13||
                      'or   korte@sabine.psu.edu'\13\13||
                      'September 1995',
                      MB_OK+MB_INFORMATION+MB_DEFBUTTON1+MB_MOVEABLE)

-----------------------------------------------------------------------------
-- Create an OS/2 window & execute TeX in it.

defc tex
    universal  tex_file_types,
               tex_auto_save,
               tex_master,
               tex_debug,
               tex_format,
               tex_log_file_line,
               app_hini

-- lockout  if LOG file loaded
tex_userfiletypes = queryprofile( app_hini, 'EPMTeX', 'TEX_USERFILETYPES')
tex_file_types= 'TEX STY LOG AUX '||translate(tex_userfiletypes)
ext = filetype()
enabled = pos(leftstr(ext,3),tex_file_types)

if enabled then

    tex_debug= queryprofile( app_hini, 'EPMTeX', 'TEX_DEBUG')
    TEX_EXEC = queryprofile( app_hini, 'EPMTeX', 'TEX_EXEC')
    TEX_IS_CMD = queryprofile( app_hini, 'EPMTeX', 'TEX_IS_CMD')

    mouse_setpointer WAIT_POINTER

-- If master file system is enabled, then check for master file

    tex_master= queryprofile( app_hini, 'EPMTeX', 'TEX_MASTERFILE')
    if tex_master then  /* master file system enabled */
        master = tex_master_name('TeX Document')

-- Need to change to master file to get Format from first line
-- And TeX in that directory

        if master = '-1' then   -- master file specified but not found on disk
           mouse_setpointer EPM_POINTER
           RETURN
        endif

        if master = '' then  -- no master file specified
            sayerror 'Warning: Master file system: no master file header found in '.filename
            call tex_parse_filename(.filename,dr,dir,stem,ext)
            call tex_check_for_save()
        else   -- a master file is being used
            getfileid working_fid
            call tex_parse_filename(master,dr,dir,stem,ext)
            if tex_file_in_ring(master) then
                getfileid master_fid,master
                activatefile master_fid
                call tex_check_for_save()
            else
                'edit /d' master
                getfileid master_fid
            endif
        endif

-- Here we look for file dependencies in the file to be TeX'd
-- and if dependent files are loaded in the editor
-- they are checked for modification as well.
-- Notes:
--    * we search each line of the file so this can be a real
--      performance bottleneck with large files
--    * nested dependencies more than one level deep are ignored
--
--  There are a number of ways to specify a file in the source file
--  TeX:   \input
--  Latex: \include{}

        getfileid source_fid
        for counter = 1 to .last
            getline line, counter
            parse value line with '\input' dep_fname .
            if dep_fname = '' then
                parse value line with '\include{' dep_fname '}' .
            endif

            if dep_fname <> '' then
-- Translate from unix-style to OS/2-style and add '.tex' extension if missing
               dep_fname = translate(strip(dep_fname),'\','/')
               n = lastpos('\',dep_fname)
               tmp = substr(dep_fname,n+1)
               parse value tmp with  tmpStem '.' tmpExt
               if tmpExt = '' then
                   dep_fname = dep_fname||'.tex'
               endif
               if tex_file_in_ring(dep_fname) = 1 then
                   getfileid dep_fid,dep_fname
                   activatefile dep_fid
                   call tex_check_for_save()
                   activatefile source_fid   /* restore source file */
               endif
            endif
        endfor
    else /* master file system disabled */
        call tex_parse_filename(.filename,dr,dir,stem,ext)
        call tex_check_for_save()
        master = ''
    endif /* tex_master */

-- update and set format to use
    call set_tex_format()
    if tex_format = 'Auto' then
        format = tex_auto_format()
    else
        format = tex_format
        sayerror 'Using the 'format' format as selected.'
    endif


-- Parse TEX_IS_COMMAND to get start options and build command
    command = Tex_Build_Command(TEX_IS_CMD,TEX_EXEC)

-- set directory delimiter - UNIX is default
    if pos('/PC',translate(TEX_IS_CMD)) then
        TeXfilename = dr||dir||stem
    else
        TeXfilename = translate(dr||dir||stem,'/','\')  /* default */
    endif

-- add ^&format if exe, otherwise use &format
    if pos('/EXE',translate(TEX_IS_CMD)) then
        command=command||' "&'||format' 'TeXfilename'"'
    else
        command=command||' "&'||format' 'TeXfilename'"'
    endif

-- We are not getting the correct directory here, even though it should be
-- handled by TexMenuEnable?  This results in .log file being placed in
-- the wrong directory in some cases- the .log file should be in the same
-- directory as the master file.

--  Change working directory to directory of current file since that is
--  where the .DVI and .LOG files (and any others) should go.

    savedir = directory()    -- save directory **

    tstr = dr || leftstr(dir,length(dir)-1)
    if not (savedir = tstr) then
        if tex_debug > 1 then sayerror 'Changing directory to 'tstr; endif
        call directory(tstr)     -- change directory **
    endif

-- launch the TeX command
    if tex_debug then sayerror 'Tex command: start 'command; endif
    'start 'command
    if rc <> 0 then
      call WinMessageBox('Cannot start TeX Program!',
                      'Cannot start TeX Program!'\13\13||
                      'If you have just installed EPMTeX'\13||
                      'then please configure the TeX'\13||
                      'executable entry box in the settings'\13||
                      'notebook.  If you have already done'\13||
                      'this then maybe you made a typo.'\13||
                      'Turn debug level 1 on in the settings'\13||
                      'notebook to see what epmtex is'\13||
                      'trying to do when you TeX.'\13\13,
                      MB_OK+MB_WARNING+MB_DEFBUTTON1+MB_MOVEABLE)

      sayerror"Caution! Could not start TeX. Exited with return code = "rc
    else

-- Remove old LOG file from the ring after successful TeX compilation
        logfile = stem'.log'
        if tex_file_in_ring(logfile) = 1 then
            getfileid log_fid,logfile
            activatefile log_fid
            .modify = 0             -- set this in case user modified file
            'quit'                  -- close the file
            if tex_debug then sayerror 'Old log file removed from ring'; endif
        endif
--      Can't load new log file here unless we wait for TeX to finish
        tex_log_file_line = ''
    endif

    if not (savedir = tstr) then
        call directory(savedir)  -- restore directory **
    endif

-- Change back to file from which we called TeX if we changed it
    if master <> '' then
        activatefile working_fid
    endif

    mouse_setpointer EPM_POINTER

else  /* lockout */
    sayerror 'File loaded is not a TeX file'
endif /* lockout */

------------------------------------------------------------------------------
-- View current TeX file in previewer.

defc tex_view_dvi
    universal  tex_orient,
               tex_auto_log,
               tex_master,
               tex_debug,
               app_hini

-- lockout  if DVI file does not exist
if tex_check_exist('.DVI') =0 then

    tex_auto_log = queryprofile( app_hini, 'EPMTeX', 'TEX_AUTOLOGDELETE')
    tex_debug= queryprofile( app_hini, 'EPMTeX', 'TEX_DEBUG')

    mouse_setpointer WAIT_POINTER

-- If master file system is enabled, then check for master file
    tex_master= queryprofile( app_hini, 'EPMTeX', 'TEX_MASTERFILE')
    if tex_master then  /* master file system enabled */
    master = tex_master_name('Preview Document')
        if master = '-1' then
           mouse_setpointer EPM_POINTER
           RETURN
        endif
        if master = '' then
            call tex_parse_filename(.filename,dr,dir,stem,ext)
        else
            call tex_parse_filename(master,dr,dir,stem,ext)
        endif
    else
       call tex_parse_filename(.filename,dr,dir,stem,ext)
    endif /* master_tex */

    if  tex_auto_log and exist(dr||dir||stem'.log') then
        call tex_delete_log_file(dr||dir||stem'.log')
    endif

    call set_tex_orient()
    if tex_orient = 'Auto' then
        orientation = tex_auto_orient()
    else
        sayerror 'Viewing in 'tex_orient' orientation'
        orientation = tex_orient
    endif

    if orientation = 'Landscape' then
        exec = queryprofile( app_hini, 'EPMTeX', 'TEX_VIEWLA_EXEC')
        isCmd = queryprofile( app_hini, 'EPMTeX', 'TEX_VIEWLA_IS_CMD')
    else
        exec = queryprofile( app_hini, 'EPMTeX', 'TEX_VIEW_EXEC')
        isCmd = queryprofile( app_hini, 'EPMTeX', 'TEX_VIEW_IS_CMD')
    endif

-- Parse IsCmd to get start options and build command
    command = Tex_Build_Command(isCmd, exec)

-- set directory delimiter - OS/2 style is default
    dvifile = dr||dir||stem||'.dvi'
    if pos('/UNIX',translate(isCmd)) then
        dvifile = translate(dvifile,'/','\')
    endif

    command=command' 'dvifile

--  Change working directory to directory of current file since that is
--  where the .DVI and .LOG files (and any others) should go.

    savedir = directory()    -- save directory **
    tstr = dr || leftstr(dir,length(dir)-1)
    if not (savedir = tstr) then
        if tex_debug > 1 then sayerror 'Changing directory to 'tstr; endif
        call directory(tstr)     -- change directory **
    endif

-- launch the preview command
    if tex_debug then sayerror 'Preview command: start 'command; endif
    'start 'command
    if rc <> 0 then
      call WinMessageBox('Cannot start TeX Previewer!',
                      'Cannot start TeX Previewer!'\13\13||
                      'If you have just installed EPMTeX'\13||
                      'then please enter the Previewer'\13||
                      'execute command in the settings'\13||
                      'notebook.  If you have already done'\13||
                      'this then maybe you made a typo.'\13||
                      'Turn debug level 1 on in the settings'\13||
                      'notebook to see what epmtex is'\13||
                      'trying to do when you preview.'\13\13,
                      MB_OK+MB_WARNING+MB_DEFBUTTON1+MB_MOVEABLE)

      sayerror "Caution! Could not start Previewer. Exited with return code = "rc
    endif

    if not (savedir = tstr) then
        call directory(savedir)  -- restore directory **
    endif

    mouse_setpointer EPM_POINTER

else  /* lockout */
    sayerror 'DVI file does not exist, first you must run TeX on the document.'
endif /* lockout */

-----------------------------------------------------------------------------
-- Create an OS/2 window & execute TeX printer driver.

defc tex_print
    universal  tex_orient,
               tex_auto_log,
               tex_master,
               tex_debug,
               app_hini

-- lockout  if DVI file does not exist
if tex_check_exist('.DVI') =0 then

    tex_debug= queryprofile( app_hini, 'EPMTeX', 'TEX_DEBUG')

    mouse_setpointer WAIT_POINTER

-- If master file system is enabled, then check for master file
    tex_master= queryprofile( app_hini, 'EPMTeX', 'TEX_MASTERFILE')
    if tex_master then  /* master file system enabled */
        master = tex_master_name('Print Document')

        if master = '-1' then
           mouse_setpointer EPM_POINTER
           RETURN
        endif

        if master = '' then
            call tex_parse_filename(.filename,dr,dir,stem,ext)
        else
            call tex_parse_filename(master,dr,dir,stem,ext)
        endif
    else
       call tex_parse_filename(.filename,dr,dir,stem,ext)
    endif /* master_tex */

    tex_auto_log = queryprofile( app_hini, 'EPMTeX', 'TEX_AUTOLOGDELETE')
    if  tex_auto_log and exist(dr||dir||stem'.log') then
        call tex_delete_log_file(dr||dir||stem'.log')
    endif

    call set_tex_orient()
    if tex_orient = 'Auto' then
        orientation = tex_auto_orient()
    else
        sayerror 'Printing in 'tex_orient' orientation'
        orientation = tex_orient
    endif

    if orientation = 'Landscape' then
        exec = queryprofile( app_hini, 'EPMTeX', 'TEX_PRINTLA_EXEC')
        isCmd = queryprofile( app_hini, 'EPMTeX', 'TEX_PRINTLA_IS_CMD')
    else
        exec = queryprofile( app_hini, 'EPMTeX', 'TEX_PRINT_EXEC')
        isCmd = queryprofile( app_hini, 'EPMTeX', 'TEX_PRINT_IS_CMD')
    endif

-- Parse IsCmd to get start options and build command
    command = Tex_Build_Command(isCmd, exec)

-- set directory delimiter - OS/2 style is default
    dvifile = dr||dir||stem||'.dvi'
    if pos('/UNIX',translate(isCmd)) then
        dvifile = translate(dvifile,'/','\')
    endif
    command=command' 'dvifile

--  Change working directory to directory of current file since that is
--  where the .DVI and .LOG files (and any others) should go.

    savedir = directory()    -- save directory **

    tstr = dr || leftstr(dir,length(dir)-1)
    if not (savedir = tstr) then
        if tex_debug > 1 then sayerror 'Changing directory to 'tstr; endif
        call directory(tstr)     -- change directory **
    endif

-- launch the print command
    if tex_debug then sayerror 'Print command: start 'command; endif
    'start 'command
    if rc <> 0 then
      call WinMessageBox('Cannot start TeX Print!',
                      'Cannot start TeX Print!'\13\13||
                      'If you have just installed EPMTeX'\13||
                      'then please enter the Print'\13||
                      'execute command in the settings'\13||
                      'notebook.  If you have already done'\13||
                      'this then maybe you made a typo.'\13||
                      'Turn debug level 1 on in the settings'\13||
                      'notebook to see what epmtex is'\13||
                      'trying to do when you print.'\13\13,
                      MB_OK+MB_WARNING+MB_DEFBUTTON1+MB_MOVEABLE)

      sayerror "Caution! Could not start Printer driver. Exited with return code = "rc
    endif

    if not (savedir = tstr) then
        call directory(savedir)  -- restore directory **
    endif

    mouse_setpointer EPM_POINTER

else  /* lockout */
    sayerror 'DVI file does not exist, first you must run TeX on the document.'
endif /* lockout */

-----------------------------------------------------------------------------
-- Load LOG file for current TeX file (or associated master file) if
-- it exists.

defc tex_view_log
    universal  tex_log_file_line,
               tex_log_file_last,
               tex_error_fname,
               tex_master,
               name_count,
               par_count,
               app_hini

-- lockout  if LOG file does not exist
if tex_check_exist('.LOG') = 0 then

    mouse_setpointer WAIT_POINTER

-- If master file system is enabled, then check for master file
    tex_master= queryprofile( app_hini, 'EPMTeX', 'TEX_MASTERFILE')
    if tex_master then  /* master file system enabled */
        master = tex_master_name('View LOG File')
        if master = '-1' then
           mouse_setpointer EPM_POINTER
           RETURN
        endif
        if master = '' then
            call tex_parse_filename(.filename,dr,dir,stem,ext)
        else
            call tex_parse_filename(master,dr,dir,stem,ext)
        endif
    else
        call tex_parse_filename(.filename,dr,dir,stem,ext)
    endif

-- Get rid of old copy in ring if it exists
    logfile = dr||dir||stem||'.log'
    if tex_file_in_ring(logfile) = 1 then
        getfileid log_fid,logfile
        activatefile log_fid
        .modify = 0             -- set this in case user modified file
        'quit'                  -- close the file
    endif

-- This file exists, otherwise we couldn't choose this command from
-- the menu.
    'edit /d' logfile

    tex_log_file_line  = 3
    tex_log_file_last = .last
    tex_error_fname = dr||dir||stem||'.tex'
    name_count = 0
    par_count = 1

    mouse_setpointer EPM_POINTER

else  /* lockout */
    sayerror 'LOG file does not exist, first you must run TeX on the document.'
endif /* lockout */

-----------------------------------------------------------------------------
-- Create an OS/2 window & execute user defined commands.

defc texuser1exec
if tex_check_user_exec(1) then  -- check if user command defined
    EXT = get_tex_user_ext(1)
    if EXT='' then
        call texuserexec(1)  -- execute if no EXT requirement
    elseif not tex_check_exist(EXT) then
        call texuserexec(1)  -- else execute if EXT exists
    else
        sayerror'file type defined for this command does not exist'
    endif
endif /* lockout */

defc texuser2exec
if tex_check_user_exec(2) then  -- check if user command defined
    EXT = get_tex_user_ext(2)
    if EXT='' then
        call texuserexec(2)  -- execute if no EXT requirement
    elseif not tex_check_exist(EXT) = 0 then
        call texuserexec(2)  -- else execute if EXT exists
    else
        sayerror'file type defined for this command does not exist'
    endif
endif /* lockout */

defc texuser3exec
if tex_check_user_exec(3) then  -- check if user command defined
    EXT = get_tex_user_ext(3)
    if EXT='' then
        call texuserexec(3)  -- execute if no EXT requirement
    elseif not tex_check_exist(EXT) = 0 then
        call texuserexec(3)  -- else execute if EXT exists
    else
        sayerror'file type defined for this command does not exist'
    endif
endif /* lockout */

defc texuser4exec
if tex_check_user_exec(4) then  -- check if user command defined
    EXT = get_tex_user_ext(4)
    if EXT='' then
        call texuserexec(4)  -- execute if no EXT requirement
    elseif not tex_check_exist(EXT) = 0 then
        call texuserexec(4)  -- else execute if EXT exists
    else
        sayerror'file type defined for this command does not exist'
    endif
endif /* lockout */


defproc TeXUserExec(num)
    universal  tex_orient,
               tex_master,
               tex_debug,
               app_hini

    mouse_setpointer WAIT_POINTER
    tex_debug= queryprofile( app_hini, 'EPMTeX', 'TEX_DEBUG')

    call set_tex_orient()
    if tex_orient = 'Auto' then
        orientation = tex_auto_orient()
        sayerror 'Doing User'num' defined command in Auto orientation'
    else
        sayerror 'Doing User'num' defined command in 'tex_orient' orientation'
        orientation = tex_orient
    endif

-- based on 'num' load required environment variables
    if num=1 then
        UserMenuText = queryprofile( app_hini, 'EPMTeX', 'TEX_USER1_MENU_TEXT')
        UserExt = queryprofile( app_hini, 'EPMTeX', 'TEX_USER1_EXT')
        if orientation = 'Landscape' then
            exec = queryprofile( app_hini, 'EPMTeX', 'TEX_USER1LA_EXEC')
            isCMD = queryprofile( app_hini, 'EPMTeX', 'TEX_USER1LA_IS_CMD')
        else
            exec = queryprofile( app_hini, 'EPMTeX', 'TEX_USER1_EXEC')
            isCMD = queryprofile( app_hini, 'EPMTeX', 'TEX_USER1_IS_CMD')
        endif
    elseif num=2 then
        UserMenuText = queryprofile( app_hini, 'EPMTeX', 'TEX_USER2_MENU_TEXT')
        UserExt = queryprofile( app_hini, 'EPMTeX', 'TEX_USER2_EXT')
        if orientation = 'Landscape' then
            exec = queryprofile( app_hini, 'EPMTeX', 'TEX_USER2LA_EXEC')
            isCMD = queryprofile( app_hini, 'EPMTeX', 'TEX_USER2LA_IS_CMD')
        else
            exec = queryprofile( app_hini, 'EPMTeX', 'TEX_USER2_EXEC')
            isCMD = queryprofile( app_hini, 'EPMTeX', 'TEX_USER2_IS_CMD')
        endif
    elseif num=3 then
        UserMenuText = queryprofile( app_hini, 'EPMTeX', 'TEX_USER3_MENU_TEXT')
        UserExt = queryprofile( app_hini, 'EPMTeX', 'TEX_USER3_EXT')
        if orientation = 'Landscape' then
            exec = queryprofile( app_hini, 'EPMTeX', 'TEX_USER3LA_EXEC')
            isCMD = queryprofile( app_hini, 'EPMTeX', 'TEX_USER3LA_IS_CMD')
        else
            exec = queryprofile( app_hini, 'EPMTeX', 'TEX_USER3_EXEC')
            isCMD = queryprofile( app_hini, 'EPMTeX', 'TEX_USER3_IS_CMD')
        endif
    else  -- num=4 assumed
        UserMenuText = queryprofile( app_hini, 'EPMTeX', 'TEX_USER4_MENU_TEXT')
        UserExt = queryprofile( app_hini, 'EPMTeX', 'TEX_USER4_EXT')
        if orientation = 'Landscape' then
            exec = queryprofile( app_hini, 'EPMTeX', 'TEX_USER4LA_EXEC')
            isCMD = queryprofile( app_hini, 'EPMTeX', 'TEX_USER4LA_IS_CMD')
        else
            exec = queryprofile( app_hini, 'EPMTeX', 'TEX_USER4_EXEC')
            isCMD = queryprofile( app_hini, 'EPMTeX', 'TEX_USER4_IS_CMD')
        endif
    endif


-- If master file system is enabled, then check for master file
    tex_master= queryprofile( app_hini, 'EPMTeX', 'TEX_MASTERFILE')
    if tex_master then  /* master file system enabled */
        master = tex_master_name(UserMenuText)
        if master = '-1' then
           mouse_setpointer EPM_POINTER
           RETURN
        endif
        if master = '' then
            call tex_parse_filename(.filename,dr,dir,stem,ext)
        else
            call tex_parse_filename(master,dr,dir,stem,ext)
        endif
    else
        call tex_parse_filename(.filename,dr,dir,stem,ext)
    endif /* tex_master */

-- Parse IsCmd to get start options and build command
    command = Tex_Build_Command(isCmd, exec)

-- set directory delimiter - OS/2 style is default
    fname = dr||dir||stem||UserExt
    if pos('/UNIX',translate(isCmd)) then
        fname = translate(fname,'/','\')
    endif
    command=command' 'fname

    if tex_debug then sayerror command; endif

--  Change working directory to directory of current file since that is
--  where the .DVI and .LOG files (and any others) should go.

    savedir = directory()    -- save directory **

    tstr = dr || leftstr(dir,length(dir)-1)
    if not (savedir = tstr) then
        if tex_debug > 1 then sayerror 'Changing directory to 'tstr; endif
        call directory(tstr)     -- change directory **
    endif

-- launch the user defined command
    if tex_debug then sayerror 'User'num' command: start 'command; endif
    'start 'command

    if rc <> 0 then
      call WinMessageBox('Cannot start User'num' command!',
                      'Cannot start User'num' command!'\13\13||
                      'If you have just installed EPMTeX'\13||
                      'then please enter the User'num \13||
                      'execute command in the settings'\13||
                      'notebook.  If you have already done'\13||
                      'this then maybe you made a typo.'\13||
                      'Turn debug level 1 on in the settings'\13||
                      'notebook to see what epmtex is'\13||
                      'trying to do.'\13\13,
                      MB_OK+MB_WARNING+MB_DEFBUTTON1+MB_MOVEABLE)

        sayerror 'Caution! Could not execute User'num' command. Exited with return code = 'rc
    endif

    if not (savedir = tstr) then
        call directory(savedir)  -- restore directory **
    endif

    mouse_setpointer EPM_POINTER

-----------------------------------------------------------------------------
-- Read LOG file and find errors in source code

defc tex_locate_error

-- lockout if LOG file does not exist
if tex_check_exist('.LOG') then
    sayerror 'No LOG file from which to determine errors.'
else
    if tex_more_errors() then  -- lockout if no more errors
        call tex_find_errors()
    else
        sayerror 'No more errors.'
    endif
endif /* lockout */

-----------------------------------------------------------------------------
-- Delete LOG file associated with the master file for the current
-- file, if it exists, or the LOG file for the current file.

defc tex_del_log

-- lockout  if LOG file does not exist
if tex_check_exist('.LOG') = 0 then
    call tex_delete_log_file('')
else
    sayerror'Cannot delete, LOG file does not exist'
endif /* lockout */

-----------------------------------------------------------------------------
-- Delete LOG file associated with the master file for the current
-- file, if it exists, or the LOG file for the current file.

defc tex_del_dvi

-- lockout  if DVI file does not exist
if tex_check_exist('.DVI') = 0 then
    call tex_delete_dvi_file('')
else
    sayerror'Cannot delete, DVI file does not exist'
endif /* lockout */

compile if EPMTEXPRO = 1
-----------------------------------------------------------------------------
-- Calls to change formats --- Pro version only
  defc texformat0   call force_tex_format(0)
  defc texformat1   call force_tex_format(1)
  defc texformat2   call force_tex_format(2)
  defc texformat3   call force_tex_format(3)
  defc texformat4   call force_tex_format(4)

-----------------------------------------------------------------------------
-- Calls to change orientation --- Pro version only

  defc texorient0   call force_tex_orient(0)
  defc texorient1   call force_tex_orient(1)
  defc texorient2   call force_tex_orient(2)
compile endif -- EPMTEXPRO

-----------------------------------------------------------------------------
-- Call epmtex.exe settings app

defc tex_settings
     universal   app_hini

    settings_path = queryprofile( app_hini, 'EPMTeX', 'TEX_WHERE_AM_I')
    'start /n/pm 'settings_path
    if rc <> 0 then
      call WinMessageBox('Cannot find epmtex.exe!',
                      'Cannot locate epmtex.exe!'\13\13||
                      'If you have just installed EPMTeX'\13||
                      'then please first run epmtex.exe'\13||
                      'from the directory where it is '\13||
                      'located to properly initialize the'\13||
                      'EPMTeX database.'\13\13,
                      MB_OK+MB_WARNING+MB_DEFBUTTON1+MB_MOVEABLE)

      sayerror"Caution! Could not start epmtex.exe settings program. Exited with return code = "rc
    endif




-----------------------------------------------------------------------------
-- Toggle EPM syntax expansion flag.
/*
  defc toggle_tex_expand
    universal  expand_on,
               tex_debug

    if expand_on then
      'expand 'OFF__MSG
    else
      'expand 'ON__MSG
    endif
    if tex_debug then sayerror 'expand_on = 'expand_on; endif
*/

-----------------------------------------------------------------------------
-- A scratch function to test new ideas

defc test
    universal  tex_debug,
               app_hini,
               default_font

--    sayerror '.font = '.font' and default_font = 'default_font
--    .font = arg(1)

/*
Ŀ
  Procedure definitions                                                     

*/
-----------------------------------------------------------------------------
-- Force TeX format and save in ini file

defproc force_tex_format =
    universal  tex_debug,
               tex_format,
               app_hini

    setprofile( app_hini, 'EPMTeX', 'TEX_FORMAT', arg(1))
    tex_format = arg(1)

    tex_debug= queryprofile( app_hini, 'EPMTeX', 'TEX_DEBUG')
    if tex_debug > 1  then sayerror 'tex_format() = 'arg(1); endif


-----------------------------------------------------------------------------
-- Set TeX format from ini file

defproc set_tex_format =
    universal  tex_debug,
               tex_format,
               app_hini

    TEX_FORMAT_TO_USE= queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT')
    if TEX_FORMAT_TO_USE = '0' then
        tex_format = 'Auto'
    elseif TEX_FORMAT_TO_USE = '1' then
        tex_format = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_PLAIN')
    elseif TEX_FORMAT_TO_USE = '2' then
       tex_format = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_LATEX')
    elseif TEX_FORMAT_TO_USE = '3' then
        TEX_FORMAT_USER1_MENU_TEXT = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_USER1_MENU_TEXT')
        if TEX_FORMAT_USER1_MENU_TEXT <> '' then
            tex_format = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_USER1')
        else
            sayerror 'USER1 format undefined, defaulting to Auto format'
            tex_format = 'Auto'
        endif
    elseif TEX_FORMAT_TO_USE = '4' then
        TEX_FORMAT_USER2_MENU_TEXT = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_USER2_MENU_TEXT')
        if TEX_FORMAT_USER2_MENU_TEXT <> '' then
            tex_format = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_USER2')
        else
            sayerror 'USER2 format undefined, defaulting to Auto format'
            tex_format = 'Auto'
        endif
    else
        tex_format = 'Auto'
    endif
    return(tex_format)

    if tex_debug > 1  then sayerror 'tex_format() = 'tex_format; endif

-----------------------------------------------------------------------------
-- Force TeX orientation and save in ini file

defproc force_tex_orient =
    universal  tex_debug,
               tex_orient,
               app_hini

    setprofile( app_hini, 'EPMTeX', 'TEX_ORIENTATION', arg(1))
    tex_orient = arg(1)

    tex_debug= queryprofile( app_hini, 'EPMTeX', 'TEX_DEBUG')
    if tex_debug > 1  then sayerror 'tex_orient() = 'arg(1); endif



-----------------------------------------------------------------------------
-- Set TeX orientation from ini file

defproc set_tex_orient =
    universal  tex_debug,
               tex_orient,
               app_hini

    TEX_ORIENTATION = queryprofile( app_hini, 'EPMTeX', 'TEX_ORIENTATION')
    if TEX_ORIENTATION = '1' then
        tex_orient = 'Portrait'
    elseif TEX_ORIENTATION = '2' then
        tex_orient = 'Landscape'
    else
        tex_orient = 'Auto'
    endif
    return(tex_orient)

    if tex_debug > 1 then sayerror 'tex_orient() = 'tex_orient; endif

-----------------------------------------------------------------------------
-- Determine format to use with this file from first line the file.
-- Similar specification as Eberhard Mattes' TEXIT.CMD distributed with emTeX.

defproc tex_auto_orient =
    universal  tex_debug

    orientation = ''
    getline line, 1
    line = translate(line)
    parse value line with '%'  'ORIENTATION' ':' orientation .
    if orientation = '' then
        parse value line with '%'  'ORIENTATION' orientation .
    endif

    if orientation = '' then
        sayerror 'Auto orientation selected: No orientation specified.  Portrait will be used.'
        return 'Portrait'
    elseif orientation = 'PORTRAIT' then
        sayerror 'Auto orientation selected: Portrait orientation will be used.'
        return 'Portrait'
    elseif orientation = 'LANDSCAPE' then
        sayerror 'Auto orientation selected: Landscape orientation will be used.'
        return 'Landscape'
    else
        sayerror 'Auto orientation selected: Orientation 'orientation' not recognized.  Portrait will be used.'
        return 'Portrait'
    endif

-----------------------------------------------------------------------------
-- Determine format to use with this file from first line of the file.
-- Same specification as Eberhard Mattes' TEXIT.CMD distributed with emTeX.

defproc tex_auto_format =
    universal  tex_debug,
               app_hini

    TEX_FORMAT_PLAIN = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_PLAIN')

    format = ''
    getline line, 1
    line = translate(line)
    parse value line with '%'  'FORMAT' ':' format .
    if format = '' then
        parse value line with '%'  'FORMAT' format .
    endif

    if format = '' then
        sayerror 'Auto format select: No format specified.  Plain will be used.'
        return TEX_FORMAT_PLAIN
    else
        sayerror 'Auto format select: The format 'format' will be used.'
        return format
    endif


-----------------------------------------------------------------------------
-- Delete LOG file associated with the master file for the current
-- file, if it exists, or the LOG file for the current file.

defproc tex_delete_log_file(logfile)
    universal  tex_log_file_line,
               tex_master,
               app_hini

    if logfile ='' then
--      If master file system is enabled, then check for master file
        tex_master= queryprofile( app_hini, 'EPMTeX', 'TEX_MASTERFILE')
        if tex_master then  /* master file system enabled */
            master = tex_master_name('Delete LOG File')
            if master = '-1' then
                mouse_setpointer EPM_POINTER
                RETURN
            endif
            if master = '' then
                call tex_parse_filename(.filename,dr,dir,stem,ext)
            else
                call tex_parse_filename(master,dr,dir,stem,ext)
            endif
        else
            call tex_parse_filename(.filename,dr,dir,stem,ext)
        endif /* tex_master */
        logfile = dr||dir||stem||'.log'
    endif /* logfile */

    rc = erasetemp(logfile)
    if rc = 0 then
        sayerror 'File 'logfile' deleted'
    elseif rc = 2 then
        sayerror 'Delete LOG: file 'logfile' could not be found'
    else
        sayerror 'Delete LOG: file 'logfile' could not be deleted'
        beep(1000, 100)
    endif

--  Remove log file from ring also if it is there
    if tex_file_in_ring(logfile) = 1 then
        getfileid log_fid,logfile
        activatefile log_fid
        .modify = 0             -- set this in case user modified file
        'quit'                  -- close the file
    endif


    tex_log_file_line = ''

-----------------------------------------------------------------------------
-- Delete DVI file associated with the master file for the current
-- file, if it exists, or the DVI file for the current file.

defproc tex_delete_dvi_file
    universal  tex_master,
               app_hini

-- If master file system is enabled, then check for master file
    tex_master= queryprofile( app_hini, 'EPMTeX', 'TEX_MASTERFILE')
    if tex_master then  /* master file system enabled */
        master = tex_master_name('Delete DVI File')
        if master = '-1' then
           mouse_setpointer EPM_POINTER
           RETURN
        endif
        if master = '' then
            call tex_parse_filename(.filename,dr,dir,stem,ext)
        else
            call tex_parse_filename(master,dr,dir,stem,ext)
        endif
    else
        call tex_parse_filename(.filename,dr,dir,stem,ext)
    endif /* tex_master */

    dvifile = dr||dir||stem||'.dvi'

    rc = erasetemp(dvifile)
    if rc = 0 then
         sayerror 'File 'dvifile' deleted'
    elseif rc = 2 then
         sayerror 'Delete DVI: file 'dvifile' could not be found'
    else
         sayerror 'Delete DVI: file 'dvifile' could not be deleted'
         beep(1000, 100)
    endif

-----------------------------------------------------------------------------
-- called by mymnuini.e to get which format is chosen
-- called with negative argument to check existence of
-- user defined formats,
-- called with positive argument to see if format is selected

defproc get_tex_format =
    universal  tex_format,
               tex_debug,
               app_hini

    TEX_FORMAT_PLAIN = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_PLAIN')
    TEX_FORMAT_LATEX = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_LATEX')
    TEX_FORMAT_USER1_MENU_TEXT = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_USER1_MENU_TEXT')
    TEX_FORMAT_USER1 = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_USER1')
    TEX_FORMAT_USER2_MENU_TEXT = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_USER2_MENU_TEXT')
    TEX_FORMAT_USER2 = queryprofile( app_hini, 'EPMTeX', 'TEX_FORMAT_USER2')

    if arg(1) < 0 then
        if arg(1) = -3 and TEX_FORMAT_USER1_MENU_TEXT <> '' then return 1
        elseif arg(1) = -4 and TEX_FORMAT_USER2_MENU_TEXT <> '' then return 1
            else return 0
        endif
    else
        call set_tex_format()
        if  (arg(1) = 0 and tex_format ='Auto')         or
            (arg(1) = 1 and translate(tex_format) = translate(TEX_FORMAT_PLAIN))  or
            (arg(1) = 2 and translate(tex_format) = translate(TEX_FORMAT_LATEX))  or
            (arg(1) = 3 and TEX_FORMAT_USER1 <> '' and translate(tex_format) = translate(TEX_FORMAT_USER1)) or
            (arg(1) = 4 and TEX_FORMAT_USER2 <> '' and translate(tex_format) = translate(TEX_FORMAT_USER2)) then
            return 1
        else
            return 0
        endif
    endif

-----------------------------------------------------------------------------
-- called from mymnuini.e to get state of global TeX variable tex_orient
-- called with positive argument to see if this is the one

defproc get_tex_orient =
    universal  tex_orient

    call set_tex_orient()
    if  (arg(1) = 0 and tex_orient ='Auto')        or
        (arg(1) = 1 and tex_orient = 'Portrait')   or
        (arg(1) = 2 and tex_orient = 'Landscape')  then
        return 1
    else
        return 0
    endif

-----------------------------------------------------------------------------
-- called from mymnuini.e to get state of global TeX variable tex_auto_log

defproc get_tex_auto_log =
    universal  tex_auto_log,
               app_hini

    tex_auto_log = queryprofile( app_hini, 'EPMTeX', 'TEX_AUTOLOGDELETE')
    return tex_auto_log

-----------------------------------------------------------------------------
-- called from mymnuini.e to get state of global TeX variable tex_auto_save

defproc get_tex_auto_save =
    universal  tex_auto_save,
               app_hini

    tex_auto_save= queryprofile( app_hini, 'EPMTeX', 'TEX_AUTOSAVE')
    return tex_auto_save

-----------------------------------------------------------------------------
-- called from mymnuini.e to get state of global TeX variable tex_master

defproc get_tex_master =
    universal  tex_master,
               app_hini

    tex_master= queryprofile( app_hini, 'EPMTeX', 'TEX_MASTERFILE')
    return tex_master


-----------------------------------------------------------------------------
-- called from mymnuini.e to get state of global EPM variable expand_on

defproc get_tex_expand_on =
    universal  expand_on

    return expand_on

-----------------------------------------------------------------------------
-- called from mymnuini.e to get state of global TeX variable tex_debug

defproc get_tex_debug =
    universal  tex_debug,
               app_hini

    tex_debug= queryprofile( app_hini, 'EPMTeX', 'TEX_DEBUG')
    return tex_debug

-----------------------------------------------------------------------------
-- Called from mymnuini.e to determine if DVI or LOG file exists for
-- associated master file if it exists, or for current file.
-- Returns 1 if file does not exist, 0 if it does

defproc tex_check_exist(FileExt) =
    universal  tex_master,
               app_hini

-- If master file system is enabled, then check for master file
    tex_master= queryprofile( app_hini, 'EPMTeX', 'TEX_MASTERFILE')
    if tex_master then  /* master file system enabled */
        master = tex_master_name()
        if master = '' then
            fname = .filename
        else
            fname = master
        endif
    else
        fname = .filename
    endif /* tex_master */

    call tex_parse_filename(fname,dr,dir,stem,ext)

    return(not exist(dr||dir||stem||FileExt))

-----------------------------------------------------------------------------
-- called in mymnuini.e to get the value of TEX_USER?_EXT

defproc get_tex_user_ext =
    universal  app_hini

    if arg(1) = 1 then
        return  queryprofile( app_hini, 'EPMTeX', 'TEX_USER1_EXT')
    elseif arg(1) = 2 then
        return  queryprofile( app_hini, 'EPMTeX', 'TEX_USER2_EXT')
    elseif arg(1) = 3 then
        return  queryprofile( app_hini, 'EPMTeX', 'TEX_USER3_EXT')
    elseif arg(1) = 4 then
        return  queryprofile( app_hini, 'EPMTeX', 'TEX_USER4_EXT')
    else
         return ''
    endif

-----------------------------------------------------------------------------
-- called in mymnuini.e to determine if TEX_USER?_EXEC is defined

defproc tex_check_user_exec =
    universal app_hini

    TEX_USER1_EXEC = queryprofile( app_hini, 'EPMTeX', 'TEX_USER1_EXEC')
    TEX_USER2_EXEC = queryprofile( app_hini, 'EPMTeX', 'TEX_USER2_EXEC')
    TEX_USER3_EXEC = queryprofile( app_hini, 'EPMTeX', 'TEX_USER3_EXEC')
    TEX_USER4_EXEC = queryprofile( app_hini, 'EPMTeX', 'TEX_USER4_EXEC')

    if (arg(1) = 1 and TEX_USER1_EXEC <> '')  OR
       (arg(1) = 2 and TEX_USER2_EXEC <> '')  OR
       (arg(1) = 3 and TEX_USER3_EXEC <> '')  OR
       (arg(1) = 4 and TEX_USER4_EXEC <> '') then
        return 1
    else
        return 0
    endif

-----------------------------------------------------------------------------
--  Check to see if current file has been modified.  If it has, save
--  it if auto-save is enabled, otherwise ask user about it.

defproc tex_check_for_save=
    universal  tex_auto_save,
               app_hini

    if .modify then
        tex_auto_save= queryprofile( app_hini, 'EPMTeX', 'TEX_AUTOSAVE')
        if tex_auto_save then
            'Save'
            sayerror 'Saving modified document '.filename' before calling TeX'
            refresh
            delay(10)
        else
            refresh
            if AskYesNo('File '.filename' modified. Save?',1) = 'Y' then
               'Save'
                sayerror 'Saving modified document '.filename
            else
                sayerror 'Will TeX with stale document '.filename
                beep(1000,100)
            endif
        endif
    endif

-----------------------------------------------------------------------------
--  Called with optional argument which should be the Menu item
--    associated with the calling routine.  This is used as caption for
--    message box announcing that specified master file doesn't exist.
--  Extract master file name from first line of file
--  Returns: a) '' if master file is not specified
--           b) master file name with path added on if file exists
--           c) '-1' if arg(1) <> '' AND master file is specified
--              but doesn't exist.  Got it?

defproc tex_master_name
    universal  tex_debug,
               app_hini

    master = ''
    getline line, 1
    parse value line with '%' . 'Master' ':' master .
    if master = '' then
        parse value line with '%' . 'master' ':' master .
        if master = '' then
            parse value line with '%' . 'Master' master .
            if master = '' then
                parse value line with '%' . 'master' master .
            endif
        endif
    endif

    tex_debug= queryprofile( app_hini, 'EPMTeX', 'TEX_DEBUG')
    if tex_debug then
        if master = '' then
            sayerror 'Master file not defined.'
        else
            sayerror 'Master file found to be 'master' from directive.'
        endif
    endif

    if master <> '' then
        tex_parse_filename(.filename,dr,dir,stem,ext)
        master = translate(master,'\','/') -- convert to DOS format
        master = master||'.tex'

--  Now, make the master filename fully qualified.  We assume master is
--  in current directory unless specified name is fully qualified.
--      If only a stem.ext add current drive and dir
        if lastpos('\',master) = 0 then
            master = dr||dir||master
        else
--          if no drive letter add current drive
            if leftstr(master,1) = '\' then
                master = dr||master
            endif
        endif

        if not exist(master) then
--          sayerror 'Caution! Master file 'master' not found!'
--          master = ''
           if arg(1) <> '' then
               rc = WinMessageBox(arg(1),
                                  'The specified master file'\13||
                                  master\13||
                                  'does not exist.'\13||
                                  ''\13||
                                  'Continue processing current file'\13||
                                  'as stand-alone?'\13||
                                  ''\13,
                                  MB_YESNO+MB_WARNING+MB_DEFBUTTON2+MB_MOVEABLE)
               if rc = MBID_NO then
                   master = '-1'
               else
                   master = ''
               endif
           else
               master = ''
           endif
        endif
    endif

    return master

-----------------------------------------------------------------------------
-- Parse a file name:  d:\dir1\dir2\file.ext
--                     \dir1\dir2\file.ext
--                     file.ext
--                     .ext
--                     \dir1\.ext
--                     ...etc,  but NOT d:test2.ext
-- returns  dr      d:
--          dir     \dir1\dir2\    if any of these does not exist,
--          stem    file           a null is returned.
--          ext     ext

defproc tex_parse_filename(fname, var dr, var dir, var stem, var ext)

-- Translate from Unix-style to OS/2-style names
    fname = translate(fname,'\','/')
    n = lastpos('\',fname)
    tmp = substr(fname,n+1)
    parse value tmp with  stem '.' ext
    tmp = substr(fname,1,n)
    n = pos(':',tmp)
    dr = substr(tmp,1,n)
    dir = substr(tmp,n+1)



-----------------------------------------------------------------------------
-- Determine if a file already is in ring.  Decision based on filename
-- only without path, since pfile_exists() doesn't seem to like path info.

defproc tex_file_in_ring(fname)

    tex_parse_filename(fname,dr,dir,stem,ext)

    return pfile_exists(stem||'.'||ext)

-----------------------------------------------------------------------------
-- Called from my mymnuini.e to determine whether or not to disable
-- 'Locate Next Error' menu choice when log file exists
-- Returns 1 if there are more errors, 0 if not.

defproc tex_more_errors
    universal  tex_log_file_line,
               tex_log_file_last

-- First expression is true when there is no log file in ring.
-- Second expression true when there is, but haven't gotten through
-- all errors yet.

    return ( (tex_log_file_line = '') or
            (tex_log_file_line < tex_log_file_last) )

-----------------------------------------------------------------------------
--  Read LOG file and find errors in source code

defproc tex_find_errors
    universal  tex_log_file_line,
               tex_log_file_last,
               tex_error_fname,
               tex_return_to_file,
               tex_file_types,
               tex_debug,
               tex_master,
               name_count,
               par_count,
               EPM_utility_array_ID,
               app_hini

    mouse_setpointer WAIT_POINTER
    tex_debug= queryprofile( app_hini, 'EPMTeX', 'TEX_DEBUG')
    empty = ''
    tex_return_to_file = .filename

-- If master file system is enabled, then check for master file
    tex_master= queryprofile( app_hini, 'EPMTeX', 'TEX_MASTERFILE')
    if tex_master then  /* master file system enabled */
        master = tex_master_name('Locate Next Error')
        if master = '-1' then
           mouse_setpointer EPM_POINTER
           RETURN
        endif
        if master = '' then
            fname = .filename
        else
            fname = master
        endif
    else
        fname = .filename
    endif /* tex master */

    tex_parse_filename(fname,dr,dir,stem,ext)

--  The log file exists, or we would not be able to choose this routine
--  from the menu.
    logfile = dr||dir||stem||'.LOG'
    if tex_file_in_ring(logfile) = 1 then
        getfileid log_fid,logfile
        activatefile log_fid
    else
        'edit /d' logfile
        tex_log_file_line  = 3
        tex_log_file_last = .last
        tex_error_fname = dr||dir||stem||'.tex'
        name_count = 0
        par_count = 1
    endif

    do while (tex_log_file_line < tex_log_file_last)

      getline line, tex_log_file_line

      if leftstr(line,1) = '!' then
          parse value line with '!'error_msg
          do while not (leftstr(line,1) = 'l')
              tex_log_file_line = tex_log_file_line + 1
              getline line, tex_log_file_line
          enddo
          parse value line with 'l.' linenum contexttext
          sayerror 'TeX error msg -> 'error_msg':   'contexttext
          if tex_file_in_ring(tex_error_fname) = 1 then
              if tex_debug then sayerror 'Editing 'tex_error_fname' from ring.'; endif
              getfileid tex_error_fid,tex_error_fname
              activatefile tex_error_fid
          else
-- This file should exist since we 'just' compiled it.
              if tex_debug then sayerror 'Editing 'tex_error_fname' from disk.'; endif
              'edit /d' tex_error_fname
          endif
--  Check to see if this could be the right file. We don't want to bomb out
--  trying to getline after the end of the file.
          if linenum > .last then
             sayerror 'Something is amiss! I''m lost. Apparently the next error is not in this file!'
          else
              getline errorline, linenum
              tex_log_file_line = tex_log_file_line + 1
              if length(contexttext) > 4 then
                  chopum = 4
              else
                  chopum = 1
              endif
              col1 = pos( substr(contexttext,chopum), errorline)
              col2 = col1 + length(contexttext) - chopum + 1
              .line = linenum
              .col  = col2
-- For some reason, the circle disappears half the time!
-- Apparently, there is a refresh or something after the circle.
-- Putting in the refresh below didn't help at all.  Ideas?
--              refresh
              circleit 2,linenum,col1,col2,1
          endif
          mouse_setpointer EPM_POINTER
          RETURN
      else    /* This is not a line starting with '!' */

          do while not ( line = '')

              if tex_debug > 2 then sayerror 'line='line; endif
              left_par =  pos('(',line)
              right_par = pos(')',line)
              if tex_debug > 2 then sayerror 'left_par='left_par'  right_par='right_par; endif
-- EPM5 can only handle lines of 255 chars anyway, so make them 256 if the
-- are 0 to simplify things a bit.
              if left_par = 0 then left_par = 256 endif
              if right_par = 0 then right_par = 256 endif

              if (right_par < left_par) then
                  par_count = par_count - 1
                  if tex_debug > 2 then sayerror 'par_count (decreased) ='par_count; endif
                  if par_count = 0 then
                      if tex_debug > 2 then sayerror 'Erasing name 'name_count' from array'; endif
                      do_array 2, EPM_utility_array_ID, 'tex_fname.'name_count, empty
                      do_array 2, EPM_utility_array_ID, 'tex_par.'name_count, empty
                      name_count = name_count - 1
-- name_count will be 0 when we are finished
                      if name_count > 0 then
                          do_array 3, EPM_utility_array_ID, 'tex_fname.'name_count, tex_error_fname
                          do_array 3, EPM_utility_array_ID, 'tex_par.'name_count, par_count
                          if tex_debug > 2 then sayerror 'Got 'tex_error_fname'('name_count') and par_count='par_count; endif
                      else
                          if tex_debug > 2 then sayerror 'name_count = 0'; endif
                      endif
                  endif
                  if tex_debug > 2 then sayerror 'line=   'line; endif
                  line = substr(line,right_par+1)
                  if tex_debug > 2 then sayerror 'newline='line; endif
              else
                  if not (left_par = 256) then
                      line = substr(line,left_par+1)
                      if tex_extract_fname(line,dr,dir) = 0 then
                          par_count = par_count + 1
                          if tex_debug > 2 then sayerror 'par_count (increased) ='par_count; endif
                      else
                          par_count = 1
                          if tex_debug > 2 then sayerror 'par_count set to 1'; endif
                      endif
                  else
                      line = ''
                  endif
              endif
          enddo  /*  while not (line='')  */
          tex_log_file_line = tex_log_file_line + 1
      endif

    enddo     /*  while (tex_log_file_line < tex_log_file_last)  */

    if not (tex_log_file_line < tex_log_file_last) then
        sayerror 'No more errors.'
        'edit /n' tex_return_to_file
    endif

    mouse_setpointer EPM_POINTER

-----------------------------------------------------------------------------
-- This routine called by tex_find_errors after a left parenth is found
-- to determine whether or not the text following the parenth is a filename.
-- If it is, tex_error_fname is changed to that name, and the routine
-- returns 1.  Otherwise, a 0 is returned.
--
-- The logic goes like this:
--  1) make sure it has a '.' in it
--  2) parse it into pieces before '.' and after '.'
--  3) make sure that the part after has at least 3 characters
--  4) make sure that the part after is one of the defined tex filetypes
--  5) if the above is true the name is fully qualified and placed in
--     tex_error_fname, and is also put into an array.
--  6) take name out of "line"
--  7) return

defproc tex_extract_fname(var line, dr, dir)
    universal  tex_debug,
               tex_error_fname,
               tex_file_types,
               par_count,
               name_count,
               EPM_utility_array_ID,
               app_hini

    flag = 0
    tex_debug= queryprofile( app_hini, 'EPMTeX', 'TEX_DEBUG')

-- If there is no '.' in the line, there cannot be a filename in it
    if not (pos('.',line) = 0) then
        parse value line with tmp1 '.' tmp2
        if tex_debug > 2 then sayerror 'tmp1='tmp1'  tmp2='tmp2; endif
-- If the part after the '.' is less than 3 chars long, it is not a filename
        if (length(tmp2) > 2) then
--          Take first 3 chars after '.' and turn into all uppercase
            tmp2 = translate(leftstr(tmp2,3))
            tmpname = tmp1||'.'||tmp2
-- If the first 3 chars after the '.' are not a tex filetype, discard
            if not (pos(tmp2,tex_file_types) = 0) then
--              Translate from Unix-style to OS/2-style file names
                tex_error_fname = translate(tmpname,'\','/')
--  Now, name the name fully qualified
--              If only a stem.ext
                if lastpos('\',tex_error_fname) = 0 then
                    tex_error_fname = dr||dir||tex_error_fname
                    if tex_debug > 2 then sayerror 'tex_error_fname (again1)='tex_error_fname; endif
                else
--                  if no drive letter
                    if leftstr(tex_error_fname,1) = '\' then
                        tex_error_fname = dr||tex_error_fname
                        if tex_debug > 2 then sayerror 'tex_error_fname (again2)='tex_error_fname; endif
                    endif
                endif
                name_count = name_count + 1
                if tex_debug > 2 then  sayerror 'Putting 'tex_error_fname' on stack with par_count='par_count' at position 'name_count; endif
                do_array 2, EPM_utility_array_ID, 'tex_fname.'name_count, tex_error_fname
                do_array 2, EPM_utility_array_ID, 'tex_par.'name_count, par_count
                flag = 1
-- Take the filename out of line for next loop
                line = substr(line,pos(tmpname,line)+length(tmpname))
            endif
        endif
    endif

    return flag

-----------------------------------------------------------------------------
--  A little procedure to waste time.
--  Too bad there isn't a built-in that doesn't chomp CPU.

defproc delay(time)
    max = time * 500
    for i = 1 to max
      j = i
    endfor

-----------------------------------------------------------------------------
-- A procedure to expand environment variables in user defined constants
--
-- searches for $variable: in user defined constants and expands 'variable'
-- if found

defproc Expand_Env(Input)

   Parse Value Input with Lead_Var '$' Env_Var ':' Trail_Var

   if Env_Var <> '' & LastPos(':',Input) > Pos('$',Input) then
      Output = Lead_Var || Get_Env(Env_Var) || Trail_Var
   else
      Output = Input
   endif

return Output


-----------------------------------------------------------------------------
-- A generic procedure to build the command line options for a shell command
--

defproc Tex_Build_Command(is_cmd, exec)

    universal  tex_debug,
               app_hini

    tex_debug= queryprofile( app_hini, 'EPMTeX', 'TEX_DEBUG')

-- Parse IS_CMD to get start options and build command
    options=translate(is_cmd)

-- expand any environment variables referenced in 'exec'
    command=Expand_Env(exec)

-- set maximized or minimized - default is null
    if pos('/MAX',options) then
        command = '/max '||command
    elseif pos('/MIN',options) then
        command = '/min '||command
    endif

-- set app type - default is null (self-discovery)
    if pos('/PM',options) then
        command = '/pm '||command
    elseif pos('/FS',options) then
        command = '/fs '||command
    elseif pos('/WIN',options) then
        command = '/win '||command
    endif

-- set foreground/background - default is foreground
    if pos('/BG',options) then
        command = '/b '||command
    else
        command = '/f '||command
    endif

-- use command interpreter if batch file - default is to use interpreter
    if pos('/EXE',options) then
        command = '/n '||command
    else
        command = '/c '||command  /* default */
    endif

    if tex_debug > 1 then sayerror 'Tex_Build_Command: 'command; endif

return command



