/*
 * Decompiled with CFR 0.152.
 */
package nts.typo;

import nts.base.Dimen;
import nts.base.Glue;
import nts.base.Num;
import nts.builder.Builder;
import nts.command.CommandBase;
import nts.command.Prim;
import nts.command.Token;
import nts.node.InsertNode;
import nts.node.Insertion;
import nts.node.NodeList;
import nts.node.VBoxNode;
import nts.typo.BuilderPrim;
import nts.typo.TypoCommand;
import nts.typo.VertGroup;

public class InsertPrim
extends BuilderPrim {
    public static final int INTP_FLOATING_PENALTY = CommandBase.newIntParam();

    public void exec(Builder bld, Token src) {
        int outBoxNum;
        int num = Prim.scanRegisterCode();
        if (num == (outBoxNum = CommandBase.getConfig().getIntParam(TypoCommand.INTP_OUTPUT_BOX_NUM))) {
            num = 0;
            CommandBase.error("CantInsertOutbox", this, CommandBase.num(outBoxNum), CommandBase.num(num));
        }
        CommandBase.pushLevel(new InsertGroup(num));
        CommandBase.scanLeftBrace();
    }

    public InsertPrim(String name) {
        super(name);
    }

    public static class InsertGroup
    extends VertGroup {
        private int num;
        private Glue topSkip;
        private Dimen maxDepth;
        private int floatCost;

        public void stop() {
            super.stop();
            this.topSkip = CommandBase.getConfig().getGlueParam(TypoCommand.GLUEP_SPLIT_TOP_SKIP);
            this.maxDepth = CommandBase.getConfig().getDimParam(TypoCommand.DIMP_SPLIT_MAX_DEPTH);
            this.floatCost = CommandBase.getConfig().getIntParam(INTP_FLOATING_PENALTY);
        }

        public void close() {
            super.close();
            NodeList list = this.builder.getList();
            VBoxNode vbox = VBoxNode.packedOf(list);
            Dimen size = vbox.getHeight().plus(vbox.getDepth());
            Builder bld = TypoCommand.getBld();
            bld.addNode(new InsertNode(new Insertion(this.num, list, size, this.topSkip, this.maxDepth, Num.valueOf(this.floatCost))));
            bld.buildPage();
        }

        protected InsertGroup(int num) {
            this.num = num;
        }
    }
}

