/*
 * Decompiled with CFR 0.152.
 */
package nts.tex;

import nts.align.TabMarkToken;
import nts.command.ActiveCharToken;
import nts.command.CharToken;
import nts.command.CtrlSeqToken;
import nts.command.InputLineTokenizer;
import nts.command.LeftBraceToken;
import nts.command.LetterToken;
import nts.command.MacroParamToken;
import nts.command.OtherToken;
import nts.command.RightBraceToken;
import nts.command.SpaceToken;
import nts.command.Token;
import nts.io.CharCode;
import nts.io.Loggable;
import nts.io.Name;
import nts.math.MathShiftToken;
import nts.math.SubMarkToken;
import nts.math.SuperMarkToken;
import nts.tex.TeXTokenMaker;

public class TeXTokenMaker
implements InputLineTokenizer.TokenMaker {
    private static final Token PAR_TOKEN = new CtrlSeqToken("par");
    private Categorizer categorizer;
    private ErrHandler errHandler;
    private final CharToken.Maker TEMP_MAKER = OtherToken.MAKER;
    private final CharToken.Maker INVALID_MAKER;
    private byte[] scanCats;
    private CharToken.Maker[] charTokMakers;

    private void initScanCat(int idx, byte cat) {
        this.scanCats[idx] = cat;
        this.charTokMakers[idx] = null;
    }

    public byte scanCat(CharCode code) {
        return this.scanCats[this.categorizer.catCode(code.toChar())];
    }

    public Token make(Name name) {
        return new CtrlSeqToken(name);
    }

    public Token make(CharCode code) {
        CharToken.Maker maker = this.charTokMakers[this.categorizer.catCode(code.toChar())];
        if (maker != null) {
            return maker.make(code);
        }
        throw new RuntimeException("Invalid category for making a Token");
    }

    public Token makeSpace() {
        return SpaceToken.TOKEN;
    }

    public Token makePar() {
        return PAR_TOKEN;
    }

    static /* synthetic */ ErrHandler access$0(TeXTokenMaker teXTokenMaker) {
        return teXTokenMaker.errHandler;
    }

    public TeXTokenMaker(Categorizer categ, ErrHandler errHand) {
        TeXTokenMaker teXTokenMaker = this;
        if (teXTokenMaker == null) {
            throw null;
        }
        this.INVALID_MAKER = new 1(teXTokenMaker);
        this.scanCats = new byte[16];
        this.charTokMakers = new CharToken.Maker[16];
        this.categorizer = categ;
        this.errHandler = errHand;
        int i = 0;
        while (i <= 15) {
            this.scanCats[i] = 6;
            this.charTokMakers[i] = this.TEMP_MAKER;
            ++i;
        }
        this.initScanCat(0, (byte)0);
        this.initScanCat(5, (byte)3);
        this.initScanCat(9, (byte)5);
        this.initScanCat(10, (byte)2);
        this.initScanCat(14, (byte)4);
        this.scanCats[11] = 1;
        this.charTokMakers[1] = LeftBraceToken.MAKER;
        this.charTokMakers[2] = RightBraceToken.MAKER;
        this.charTokMakers[3] = MathShiftToken.MAKER;
        this.charTokMakers[4] = TabMarkToken.MAKER;
        this.charTokMakers[6] = MacroParamToken.MAKER;
        this.charTokMakers[7] = SuperMarkToken.MAKER;
        this.charTokMakers[8] = SubMarkToken.MAKER;
        this.charTokMakers[11] = LetterToken.MAKER;
        this.charTokMakers[12] = OtherToken.MAKER;
        this.charTokMakers[13] = ActiveCharToken.MAKER;
        this.charTokMakers[15] = this.INVALID_MAKER;
    }

    public static interface Categorizer {
        public int catCode(int var1);
    }

    public static interface ErrHandler {
        public void error(String var1, Loggable[] var2, boolean var3);

        public void fatalError(String var1);
    }
}

