/*
 * Decompiled with CFR 0.152.
 */
package nts.node;

import nts.base.Dimen;
import nts.base.Glue;

public class SizesSummarizer {
    private Dimen height;
    private Dimen body;
    private Dimen depth;
    private Dimen width;
    private Dimen leftX;
    private Dimen[] totalStr = new Dimen[4];
    private Dimen[] totalShr = new Dimen[4];

    public final Dimen getHeight() {
        return this.height;
    }

    public final Dimen getBody() {
        return this.body;
    }

    public final Dimen getDepth() {
        return this.depth;
    }

    public final Dimen getWidth() {
        return this.width;
    }

    public final Dimen getLeftX() {
        return this.leftX;
    }

    public final Dimen getTotalStr(byte ord) {
        return this.totalStr[ord];
    }

    public final Dimen getTotalShr(byte ord) {
        return this.totalShr[ord];
    }

    public final byte maxTotalStr() {
        return this.maxOrd(this.totalStr);
    }

    public final byte maxTotalShr() {
        return this.maxOrd(this.totalShr);
    }

    public final void add(Dimen dim) {
        this.body = this.body.plus(dim);
    }

    public final void setHeight(Dimen h) {
        this.add(this.height);
        this.height = h;
    }

    public final void setDepth(Dimen d) {
        this.add(this.depth);
        this.depth = d;
    }

    public final void setMaxWidth(Dimen w) {
        this.width = this.width.max(w);
    }

    public final void setMaxLeftX(Dimen l) {
        this.leftX = this.leftX.max(l);
    }

    public final void addStretch(Dimen dim, byte ord) {
        this.addOrd(this.totalStr, dim, ord);
    }

    public final void addShrink(Dimen dim, byte ord) {
        this.addOrd(this.totalShr, dim, ord);
    }

    public final void add(Glue glue) {
        this.body = this.body.plus(glue.getDimen());
        this.addStretch(glue.getStretch(), glue.getStrOrder());
        this.addShrink(glue.getShrink(), glue.getShrOrder());
    }

    public final void restrictDepth(Dimen maxDepth) {
        if (this.depth.moreThan(maxDepth)) {
            this.body = this.body.plus(this.depth).minus(maxDepth);
            this.depth = maxDepth;
        }
    }

    private void setZero(Dimen[] total) {
        int i = total.length;
        while (i-- > 0) {
            total[i] = Dimen.ZERO;
        }
    }

    private void addOrd(Dimen[] total, Dimen dim, byte ord) {
        if (!dim.isZero()) {
            total[ord] = total[ord].plus(dim);
        }
    }

    private byte maxOrd(Dimen[] total) {
        byte ord = 3;
        while (ord > 0 && total[ord].isZero()) {
            ord = (byte)(ord - 1);
        }
        return ord;
    }

    public SizesSummarizer() {
        this.height = Dimen.ZERO;
        this.body = Dimen.ZERO;
        this.depth = Dimen.ZERO;
        this.width = Dimen.ZERO;
        this.leftX = Dimen.ZERO;
        this.setZero(this.totalStr);
        this.setZero(this.totalShr);
    }
}

