/*
 * Decompiled with CFR 0.152.
 */
package nts.noad;

import nts.base.Dimen;
import nts.io.CntxLog;
import nts.io.Log;
import nts.noad.CharField;
import nts.noad.Converter;
import nts.noad.Egg;
import nts.noad.EmptyField;
import nts.noad.Field;
import nts.noad.NoadList;
import nts.noad.NoadListField;
import nts.noad.OrdNoad;
import nts.noad.ScriptableNoad;
import nts.noad.StItalNodeEgg;
import nts.noad.StSimpleNodeEgg;
import nts.noad.SubScriptNoad;
import nts.noad.SuperScriptNoad;
import nts.node.Box;
import nts.node.BoxSizes;
import nts.node.IntVKernNode;
import nts.node.Node;
import nts.node.NodeList;
import nts.node.VBoxNode;
import nts.node.VShiftNode;

public class AccentNoad
extends ScriptableNoad {
    protected final CharField accent;
    protected final Field nucleus;

    protected String getDesc() {
        return "accent";
    }

    public boolean isOrdinary() {
        return true;
    }

    protected byte spacingType() {
        return 0;
    }

    public boolean isJustChar() {
        return this.nucleus.isJustChar();
    }

    public void addOn(Log log, CntxLog cntx) {
        log.addEsc(this.getDesc()).add(this.accent);
        this.nucleus.addOn(log, cntx, '.');
    }

    public Egg convert(Converter conv) {
        return this.sharedConvert(conv, EmptyField.FIELD, EmptyField.FIELD);
    }

    public Egg convertWithScripts(Converter conv, Field sup, Field sub) {
        return this.nucleus.isJustChar() ? this.sharedConvert(conv, sup, sub) : super.convertWithScripts(conv, sup, sub);
    }

    private Egg sharedConvert(Converter conv, Field sup, Field sub) {
        if (this.accent.convertedBy(conv) != null) {
            Dimen skew = this.nucleus.skewAmount(conv);
            Node nuclNode = this.nucleus.cleanBox(conv, (byte)1);
            Dimen height = nuclNode.getHeight();
            Dimen width = nuclNode.getWidth();
            Dimen delta = height.min(this.accent.xHeight(conv));
            Box accBox = this.accent.fittingTo(conv, width);
            if (accBox != null) {
                if (!sup.isEmpty() || !sub.isEmpty()) {
                    ScriptableNoad noad = new OrdNoad(this.nucleus);
                    if (!sub.isEmpty()) {
                        noad = new SubScriptNoad(noad, sub);
                    }
                    if (!sup.isEmpty()) {
                        noad = new SuperScriptNoad(noad, sup);
                    }
                    nuclNode = new NoadListField(new NoadList(noad)).cleanBox(conv, (byte)0);
                    delta = delta.plus(nuclNode.getHeight().minus(height));
                    height = nuclNode.getHeight();
                }
                NodeList list = new NodeList(3);
                Dimen shift = width.minus(accBox.getWidth()).halved().plus(skew);
                accBox = accBox.pretendSizesCopy(new BoxSizes(accBox.getHeight(), Dimen.ZERO, accBox.getDepth(), Dimen.ZERO));
                list.append(VShiftNode.shiftingRight(accBox, shift)).append(new IntVKernNode(delta.negative())).append(nuclNode);
                Box box = VBoxNode.packedOf(list);
                if (box.getHeight().lessThan(height)) {
                    NodeList list2 = new NodeList(4);
                    list2.append(new IntVKernNode(height.minus(box.getHeight()))).append(list);
                    box = VBoxNode.packedOf(list2);
                }
                box = box.pretendSizesCopy(new BoxSizes(box.getHeight(), nuclNode.getWidth(), box.getDepth(), nuclNode.getLeftX()));
                return new StSimpleNodeEgg(box, this.spacingType());
            }
        }
        return new StItalNodeEgg(this.nucleus.convertedBy(conv), this.spacingType());
    }

    public AccentNoad(CharField accent, Field nucleus) {
        this.accent = accent;
        this.nucleus = nucleus;
    }
}

